/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Action;
import cds.aladin.Aladin;
import cds.aladin.AladinServer;
import cds.aladin.Calque;
import cds.aladin.ColorMap;
import cds.aladin.ContourPlot;
import cds.aladin.Coord;
import cds.aladin.FrameContour;
import cds.aladin.Plan;
import cds.aladin.PlanFilter;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageRGB;
import cds.aladin.Position;
import cds.aladin.Repere;
import cds.aladin.Save;
import cds.aladin.Server;
import cds.aladin.ServerDialog;
import cds.aladin.Texte;
import cds.aladin.ToolBox;
import cds.aladin.View;
import java.awt.image.IndexColorModel;
import java.io.InputStream;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public final class Command
extends Thread {
    static final long TIMEOUT = 15L;
    static long timeout = 900000L;
    static int DRAWXY = 0;
    static int DRAWRADEC = 1;
    static int drawMode = DRAWXY;
    Aladin a;
    Calque c;
    boolean filterMode = false;
    StringBuffer filterDef = null;
    PlanImage planRGBRef;
    static final String execHelp = "  get servers [target] [radiusUnit] - call image/data servers\n                    (ex: \"get aladin,VizieR(GSC2,USNO2) M99 4'\")\n  load file       - load the file (image, data or script)\n  save file       - save the current view (fits format, after sync.)\n  export nn file  - export the plane number nn (after sync.)\n  backup file     - generate a backup of the Aladin plane stack (after sync.)\n  zoom fct        - change zoom factor on the current view (1/2x, 4x...)\n  reverse [on/off]- (un)reverse the current view\n  flipflop [V|H]  - Vertical (resp. horizontal) pixel image inversion\n  cm {gray|BB|A}  - select the current colormap\n  select nn       - select the plane nn (the bottom plane has number 1)\n  hide [nn]       - hide a plane (the selected plane or the plane number nn)\n  show [nn]       - show a plane (the selected plane or the plane number nn)\n  RGB [n1 n2 [n3|diff]] - create a RGB image from plane number n1, n2 [,n3]\n                    a \"*\" after a plane number specifies the ref plane\n  filter [name] {on|off} - switch on/off the specified filter\n  free [nn]       - free a plane (the selected plane or the plane number nn)\n  ref nn          - set the plane nn as the reference plane\n  reset           - reset the Aladin plane stack\n  grid [on/off]   - (un)activate the coordinate grid\n  reticle [on/off]- (un)activate the reticle\n  scale [on/off]  - (un)activate the scale line\n  draw fct(param) - draw graphical overlays (string(x,y,\"msg\")...)\n  status          - display stack plane status\n  info msg\t - print a message in the status window\n  help            - display this help\n  pause [nn]      - wait nn secondes, 1 by default\n  contour [ nn [nosmooth] [zoom] ] - draw nn isocontours on the\n                    selected plane (default: 4 levels)\n  sync            - wait until all planes are ready\n  timeout nn|off  - set nn minutes as timeout - 15 by default\n  mem             - display the java memory used (after a garbage collector)\n  quit            - stop Aladin";
    private InputStream stream = System.in;
    Stack stackStream = new Stack();

    Command(Aladin aladin) {
        this.a = aladin;
    }

    private void createFilter(String string) {
        PlanFilter planFilter;
        int n = this.a.calque.newPlanFilter(null, string);
        if (n < 0) {
            System.out.println("No more space available on stack, filter could not be created");
        }
        if ((planFilter = (PlanFilter)this.a.calque.plan[n]).isValid()) {
            System.out.println("Filter " + planFilter.label + " created");
        } else {
            System.out.println("Error : Bad filter syntax !");
        }
    }

    protected boolean exec(String string) {
        return this.exec(string, true);
    }

    protected boolean exec(String string, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = stringTokenizer.nextToken();
        String string3 = string.substring(string2.length()).trim();
        this.a.message.hide();
        if (!Aladin.flagLaunch && bl) {
            System.out.println("[" + string + "]...");
        }
        if (string.toLowerCase().startsWith("filter") && string.indexOf("{") >= 0) {
            System.out.println("Enter the constraints for the new filter");
            this.filterMode = true;
            this.filterDef = new StringBuffer();
        }
        if (this.filterMode) {
            this.filterDef.append("\n" + string);
            if (Action.countNbOcc('{', this.filterDef.toString()) <= Action.countNbOcc('}', this.filterDef.toString())) {
                this.filterMode = false;
                this.createFilter(this.filterDef.toString());
                this.a.calque.select.repaint();
                return true;
            }
            if (Action.countNbOcc('\n', this.filterDef.toString()) > 1) {
                System.out.println("Enter other constraints for the new filter");
            }
            return true;
        }
        if (string2.equalsIgnoreCase("reset")) {
            this.a.calque.FreeAll();
        } else if (string2.equalsIgnoreCase("quit")) {
            System.exit(0);
        } else if (string2.equalsIgnoreCase("help")) {
            System.out.println(execHelp);
        } else if (string2.equalsIgnoreCase("get")) {
            this.execGetCmd(string3);
        } else if (string2.equalsIgnoreCase("draw")) {
            this.execDrawCmd(string3);
        } else if (string2.equalsIgnoreCase("status")) {
            this.status();
        } else if (string2.equalsIgnoreCase("info")) {
            this.a.status.setText(string3);
        } else if (string2.equalsIgnoreCase("grid")) {
            boolean bl2 = string3.equals("off") ^ true;
            this.a.calque.setGrid(bl2);
            this.a.calque.repaint();
        } else if (string2.equalsIgnoreCase("pause")) {
            int n;
            try {
                n = Integer.parseInt(string3);
                if (n <= 0) {
                    n = 1;
                }
            }
            catch (Exception exception) {
                n = 1;
            }
            try {
                Thread.sleep(n * 1000);
            }
            catch (Exception exception) {}
        } else if (string2.equalsIgnoreCase("timeout")) {
            int n;
            if (string3.equals("off")) {
                n = 0;
            } else {
                n = -1;
                try {
                    n = Integer.parseInt(string3);
                }
                catch (Exception exception) {
                    n = -1;
                }
            }
            if (n < 0) {
                System.out.println("Timeout error (" + string3 + ") !");
            } else {
                timeout = n * 6000;
            }
        } else if (string2.equalsIgnoreCase("target") || string2.equalsIgnoreCase("reticle")) {
            boolean bl3 = string3.equals("off") ^ true;
            this.a.calque.setReticle(bl3);
            this.a.calque.repaint();
        } else if (string2.equalsIgnoreCase("scale")) {
            boolean bl4 = string3.equals("off") ^ true;
            this.a.calque.setScale(bl4);
            this.a.calque.repaint();
        } else if (string2.equalsIgnoreCase("flipflop")) {
            int n = 0;
            PlanImage planImage = (PlanImage)this.a.calque.getPlanBase();
            if (planImage == null || !planImage.flagOk) {
                System.out.println("No image ready !");
                return true;
            }
            if (string3 == null || string3.equalsIgnoreCase("V") || string3.length() == 0) {
                n = 0;
            } else if (string3.equalsIgnoreCase("H")) {
                n = 1;
            } else if (string3.equalsIgnoreCase("VH") || string3.equalsIgnoreCase("HV")) {
                n = 2;
            } else {
                System.out.println("Bad flipflop argument");
                return true;
            }
            planImage.flip(n);
        } else if (string2.equalsIgnoreCase("reverse")) {
            boolean bl5 = string3.equals("off") ^ true;
            PlanImage planImage = (PlanImage)this.a.calque.getPlanBase();
            if (planImage == null || !planImage.flagOk) {
                System.out.println("No image ready !");
                return true;
            }
            if (planImage.video == 0 && !bl5) {
                return true;
            }
            if (planImage.video == 1 && bl5) {
                return true;
            }
            planImage.video = bl5 ? 1 : 0;
            IndexColorModel indexColorModel = ColorMap.getCM(0, 128, 255, planImage.video == 1, planImage.typeCM);
            planImage.setCM(indexColorModel);
            this.a.calque.zoom.zoomView.setCM(indexColorModel);
        } else if (string2.equalsIgnoreCase("RGB")) {
            stringTokenizer = new StringTokenizer(string3);
            PlanImage planImage = null;
            PlanImage planImage2 = null;
            PlanImage planImage3 = null;
            boolean bl6 = false;
            if (!stringTokenizer.hasMoreTokens()) {
                int n = this.a.calque.plan.length - 1;
                int n2 = 0;
                while (n >= 0) {
                    if (this.a.calque.plan[n].type == 1) {
                        PlanImage planImage4 = (PlanImage)this.a.calque.plan[n];
                        if (planImage4.flagOk && planImage4.error == null && !(planImage4 instanceof PlanImageRGB)) {
                            if (n2 == 0) {
                                planImage = planImage4;
                            } else if (n2 == 1) {
                                planImage2 = planImage4;
                            } else if (n2 == 2) {
                                planImage3 = planImage4;
                                break;
                            }
                            ++n2;
                        }
                    }
                    --n;
                }
            } else {
                try {
                    planImage = this.getRGBPlan(stringTokenizer.nextToken());
                    planImage3 = this.getRGBPlan(stringTokenizer.nextToken());
                    planImage2 = this.getRGBPlan(stringTokenizer.nextToken());
                    if (stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().equals("diff")) {
                        bl6 = true;
                    }
                }
                catch (Exception exception) {}
                if (planImage3 == null && planImage2 == null) {
                    System.out.println("RGB usage error !");
                    return false;
                }
            }
            this.a.calque.newPlanImageRGB(planImage, planImage2, planImage3, this.planRGBRef, bl6);
        } else if (string2.equalsIgnoreCase("cm")) {
            PlanImage planImage = (PlanImage)this.a.calque.getPlanBase();
            if (planImage == null || !planImage.flagOk) {
                System.out.println("No image ready !");
                return true;
            }
            if (string3.equals("gray")) {
                planImage.typeCM = 0;
            } else if (string3.equals("BB")) {
                planImage.typeCM = 1;
            } else if (string3.equals("A")) {
                planImage.typeCM = 2;
            } else {
                System.out.println("Colormap \"" + string3 + "\" unknown");
                return true;
            }
            IndexColorModel indexColorModel = ColorMap.getCM(0, 128, 255, planImage.video == 1, planImage.typeCM);
            planImage.setCM(indexColorModel);
            this.a.calque.zoom.zoomView.setCM(indexColorModel);
        } else if (string2.equalsIgnoreCase("sync")) {
            this.sync();
        } else if (string2.equalsIgnoreCase("free")) {
            int n = string3.length() == 0 ? this.a.calque.getFirstSelected() : this.getNumber(stringTokenizer.nextToken());
            if (n < 0) {
                return true;
            }
            this.a.calque.select.selectPlan(n);
            this.a.calque.FreeSet();
        } else if (string2.equalsIgnoreCase("hide")) {
            int n = string3.length() == 0 ? this.a.calque.getFirstSelected() : this.getNumber(stringTokenizer.nextToken());
            if (n < 0) {
                return true;
            }
            this.a.calque.plan[n].active = false;
            this.a.calque.repaint();
        } else if (string2.equalsIgnoreCase("show")) {
            int n = string3.length() == 0 ? this.a.calque.getFirstSelected() : this.getNumber(stringTokenizer.nextToken());
            if (n < 0) {
                return true;
            }
            this.a.calque.plan[n].active = true;
            this.a.calque.repaint();
        } else if (string2.equalsIgnoreCase("zoom")) {
            if (!this.a.calque.zoom.setZoom(string3)) {
                System.out.println("Zoom factor \"" + string3 + "\" unknown !");
            }
        } else if (string2.equalsIgnoreCase("ref")) {
            int n = this.getNumber(stringTokenizer.nextToken());
            if (n < 0) {
                return true;
            }
            if (!this.a.calque.setPlanRef(n)) {
                System.out.println("Plane number " + string3 + " cannot be a reference plane !");
            } else {
                this.a.calque.repaint();
            }
        } else if (string2.equalsIgnoreCase("select")) {
            int n = this.getNumber(stringTokenizer.nextToken());
            if (n < 0) {
                return true;
            }
            this.a.calque.select.selectPlan(n);
            this.a.calque.repaint();
        } else if (string2.equalsIgnoreCase("backup")) {
            if (this.a.save == null) {
                this.a.save = new Save(this.a);
            }
            this.sync();
            ((Save)this.a.save).save(string3);
        } else if (string2.equalsIgnoreCase("save")) {
            if (this.a.save == null) {
                this.a.save = new Save(this.a);
            }
            this.sync();
            ((Save)this.a.save).saveView(string3);
        } else if (string2.equalsIgnoreCase("export")) {
            int n;
            if (this.a.save == null) {
                this.a.save = new Save(this.a);
            }
            if ((n = this.getNumber(stringTokenizer.nextToken())) < 0) {
                return true;
            }
            this.sync();
            Plan plan = this.a.calque.plan[n];
            if (plan.type == 2) {
                ((Save)this.a.save).saveCatalog(stringTokenizer.nextToken(), plan);
            } else if (plan.type == 1) {
                ((Save)this.a.save).saveImage(stringTokenizer.nextToken(), plan);
            } else {
                System.out.println("Plane number " + n + " free !");
            }
        } else if (string2.equalsIgnoreCase("trace")) {
            int n;
            if (string3.equals("off") || string3.equals("0")) {
                Aladin.levelTrace = 0;
                System.out.println("Trace off");
                return true;
            }
            try {
                n = Integer.parseInt(string3);
                if (n > 3 || n < 0) {
                    n = 1;
                }
            }
            catch (Exception exception) {
                n = 1;
            }
            Aladin.levelTrace = n;
            System.out.println("Trace on (level " + n + ")");
        } else if (string2.equalsIgnoreCase("mem") || string2.equalsIgnoreCase("gc")) {
            System.gc();
            System.out.println("Total memory: " + Runtime.getRuntime().freeMemory() + "/" + Runtime.getRuntime().totalMemory());
        } else if (string2.equalsIgnoreCase("load")) {
            this.a.load(string3);
        } else if (string2.equalsIgnoreCase("ptool")) {
            String string4 = stringTokenizer.nextToken();
            System.out.println("Creating new PlanTool " + string4);
            this.a.calque.newPlanTool(string4);
            this.a.calque.repaint();
        } else if (string2.equalsIgnoreCase("rep")) {
            String string5 = stringTokenizer.nextToken();
            int n = this.getNumber(string5);
            if (n < 0) {
                return true;
            }
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            int n4 = Integer.parseInt(stringTokenizer.nextToken());
            System.out.println("Creating repere (" + n3 + "," + n4 + ") on plan " + string5);
            Repere repere = new Repere(this.a.calque.plan[n], n3, n4);
            this.a.calque.setObjet(repere);
            this.a.calque.repaint();
        } else if (string2.equals("contour")) {
            Object object;
            PlanImage planImage = (PlanImage)this.a.calque.getPlanBase();
            if (planImage == null || !planImage.flagOk) {
                System.out.println("No image ready !");
                return true;
            }
            if (planImage instanceof PlanImageRGB) {
                System.out.println("Can't produce contours on a RGB picture");
                return true;
            }
            int n = 4;
            if (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                try {
                    n = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Incorrect or missing parameter");
                    return true;
                }
            }
            object = new int[n];
            object = FrameContour.generateLevels(n);
            double[] dArray = new double[n];
            int n5 = 0;
            while (n5 < dArray.length) {
                dArray[n5] = (double)object[n5];
                ++n5;
            }
            boolean bl7 = true;
            boolean bl8 = false;
            try {
                String string6 = stringTokenizer.nextToken();
                if (string6.equals("smooth") || string6.equals("nosmooth")) {
                    bl7 = string6.equals("smooth");
                    String string7 = stringTokenizer.nextToken();
                    bl8 = string7.equals("zoom");
                } else {
                    bl8 = string6.equals("zoom");
                }
            }
            catch (Exception exception) {}
            this.a.calque.newPlanContour("Contours", dArray, new ContourPlot(), bl7, 2, bl8, true, null);
        } else if (string2.equals("filter")) {
            String string8 = "Syntax is : filter [filter name] on|off";
            int n = stringTokenizer.countTokens();
            if (n == 1) {
                String string9 = stringTokenizer.nextToken().toLowerCase();
                if (string9.equals("on")) {
                    PlanFilter.activateAllFilters();
                } else if (string9.equals("off")) {
                    PlanFilter.desactivateAllFilters();
                } else {
                    System.out.println("Incorrect parameter \"" + string9 + "\":\n" + string8);
                }
            } else if (n == 2) {
                String string10 = stringTokenizer.nextToken();
                String string11 = stringTokenizer.nextToken().toLowerCase();
                PlanFilter planFilter = null;
                planFilter = PlanFilter.getFilterByName(string10, this.a);
                if (planFilter != null) {
                    if (string11.equals("on")) {
                        planFilter.active = true;
                        planFilter.updateState();
                        this.a.calque.select.repaint();
                    } else if (string11.equals("off")) {
                        planFilter.active = false;
                        planFilter.updateState();
                        this.a.calque.select.repaint();
                    } else {
                        System.out.println("Incorrect parameter \"" + string11 + "\":\n" + string8);
                    }
                } else {
                    System.out.println("Error : the filter " + string10 + " does not exist");
                }
            } else {
                System.out.println("Incorrect number of parameters :\n" + string8);
            }
        } else {
            if (bl) {
                System.out.println("Command \"" + string2 + "\" unknown");
            }
            return false;
        }
        return true;
    }

    protected boolean execDrawCmd(String string) {
        Position position;
        Plan plan;
        block12: {
            plan = null;
            Coord coord = null;
            double d = 0.0;
            double d2 = 0.0;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "(");
            String string2 = stringTokenizer.nextToken();
            String string3 = string.substring(string2.length() + 1, string.length() - 1);
            String[] stringArray = this.getDrawParam(string3);
            if (string2.equalsIgnoreCase("mode")) {
                if (stringArray[0].equalsIgnoreCase("xy")) {
                    drawMode = DRAWXY;
                } else if (stringArray[0].equalsIgnoreCase("radec")) {
                    drawMode = DRAWRADEC;
                } else {
                    System.out.println("Unknown draw mode param (" + stringArray[0] + ")");
                    return false;
                }
                return true;
            }
            int n = this.a.calque.getFirstSelected();
            if ((n < 0 || this.a.calque.plan[n].type != 3) && (n = this.a.calque.newPlanTool("Drawing " + ++ToolBox.NUMBERTOOL)) < 0) {
                return false;
            }
            plan = this.a.calque.plan[n];
            try {
                if (drawMode == DRAWRADEC) {
                    coord = new Coord(String.valueOf(stringArray[0]) + " " + stringArray[1]);
                } else {
                    d = Double.valueOf(stringArray[0]);
                    d2 = Double.valueOf(stringArray[1]);
                }
                if (string2.equalsIgnoreCase("string")) {
                    position = drawMode == DRAWRADEC ? new Texte(plan, coord, stringArray[2]) : new Texte(plan, d, d2, stringArray[2]);
                    break block12;
                }
                if (string2.equalsIgnoreCase("tag")) {
                    position = drawMode == DRAWRADEC ? new Repere(plan, coord) : new Repere(plan, d, d2);
                    break block12;
                }
                System.out.println("Unknown draw command (" + string2 + ")");
                return false;
            }
            catch (Exception exception) {
                System.out.println("Draw command error: " + exception);
                return false;
            }
        }
        plan.pcat.setObjetFast(position);
        this.a.view.repaint();
        return true;
    }

    protected boolean execGetCmd(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        String string2 = "";
        if (!this.splitGetCmd(stringBuffer3, stringBuffer, stringBuffer2, string)) {
            return false;
        }
        String string3 = Server.mefCoord(stringBuffer.toString());
        String string4 = stringBuffer2.toString();
        if (!this.justLocalServer(stringBuffer3)) {
            if (string3.trim().length() == 0) {
                this.a.message.warning("You must specify a target !", 1);
                return false;
            }
            Server.setDefaultTarget(string3);
            if (View.notCoord(string3)) {
                int n = 1;
                Aladin.makeCursor(this.a, n);
                Coord coord = this.a.view.getSimbad(string3);
                n = 0;
                Aladin.makeCursor(this.a, n);
                if (coord == null) {
                    System.out.println("!!! \"" + string3 + "\": unknown astronomical target");
                    this.a.message.warning("\"" + string3 + "\": unknown astronomical target\n" + "Give a Simbad valid identifier or J2000 coordinates.\n \n" + "You can also use the \"Server selector\" window\n" + "by clicking the LOAD button at the top left corner\n" + "of the screen");
                    return false;
                }
            }
        }
        char[] cArray = stringBuffer3.toString().toCharArray();
        int n = 0;
        do {
            StringBuffer stringBuffer5 = new StringBuffer();
            StringBuffer stringBuffer6 = new StringBuffer();
            n = this.getServerInfo(stringBuffer5, stringBuffer6, cArray, n);
            String string5 = stringBuffer5.toString();
            String string6 = stringBuffer6.toString();
            Aladin.trace(2, "execGetCmd(server=[" + string5 + "] criteria=[" + string6 + "] target=[" + string3 + "] radius=[" + string4 + "])");
            int n2 = this.a.dialog.getServer(string5);
            if (n2 >= 0) {
                this.a.dialog.server[n2].flagToFront = false;
                this.a.dialog.server[n2].creatPlane(string3, string4, string6, null, null);
                continue;
            }
            if (stringBuffer4.length() > 0) {
                stringBuffer4.append(", ");
                string2 = "s";
            }
            stringBuffer4.append(string5);
        } while (n < cArray.length);
        if (stringBuffer4.length() > 0) {
            this.a.message.warning("Server" + string2 + " \"" + stringBuffer4 + "\" unknown ! ", 1);
        }
        return true;
    }

    protected boolean execScript(String string) {
        return this.execScript(string, true);
    }

    protected boolean execScript(String string, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() > 0) {
                if (n == 0) {
                    if (!this.exec(string2, bl)) {
                        return false;
                    }
                } else {
                    this.exec(string2, bl);
                }
            }
            ++n;
        }
        return true;
    }

    private boolean extractRadius(StringBuffer stringBuffer, StringBuffer stringBuffer2, String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length - 1;
        while (n > 0 && cArray[n] != ' ') {
            --n;
        }
        if (n == 0) {
            return false;
        }
        String string2 = new String(cArray, n + 1, cArray.length - n - 1);
        if (string2.endsWith("'")) {
            string2 = String.valueOf(string2.substring(0, string2.length() - 1)) + "m";
        } else if (string2.endsWith("\"")) {
            string2 = String.valueOf(string2.substring(0, string2.length() - 1)) + "s";
        }
        if (!(string2.endsWith("arcmin") || string2.endsWith("sec") || string2.endsWith("deg") || string2.endsWith("m") || string2.endsWith("s") || string2.endsWith("d"))) {
            return false;
        }
        stringBuffer.append(String.valueOf(Server.getRadius(string2)));
        stringBuffer2.append(new String(cArray, 0, n));
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private String[] getDrawParam(String var1_1) {
        var2_2 = var1_1.toCharArray();
        var3_3 = 0;
        var4_4 = null;
        var5_5 = new Vector<StringBuffer>(5);
        ** GOTO lbl12
        {
            ++var3_3;
            do {
                if (var3_3 < var2_2.length && (var2_2[var3_3] == ' ' || var2_2[var3_3] == ',')) continue block0;
                var4_4 = new StringBuffer();
                var3_3 = this.getOneDrawParam(var4_4, var2_2, var3_3);
                var5_5.addElement(var4_4);
lbl12:
                // 2 sources

            } while (var3_3 < var2_2.length);
        }
        var6_6 = var5_5.elements();
        var7_7 = new String[var5_5.size()];
        var3_3 = 0;
        while (var6_6.hasMoreElements()) {
            var7_7[var3_3] = new String((StringBuffer)var6_6.nextElement());
            ++var3_3;
        }
        return var7_7;
    }

    private int getNumber(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {}
        if (n < 1 || n > this.a.calque.plan.length) {
            System.out.println("Plane number error !");
            return -1;
        }
        n = Aladin.MAXPLANS - n;
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private int getOneDrawParam(StringBuffer var1_1, char[] var2_2, int var3_3) {
        var4_4 = false;
        var5_5 = false;
        while (var3_3 < var2_2.length) {
            block5: {
                block4: {
                    if (var4_4) break block4;
                    if (var2_2[var3_3] == ',' || var2_2[var3_3] == ' ') break;
                    if (var2_2[var3_3] != '\"') ** GOTO lbl17
                    var4_4 = true;
                    break block5;
                }
                if (var2_2[var3_3] == '\"' && !var5_5) {
                    ++var3_3;
                    break;
                }
                if (var2_2[var3_3] == '\\') {
                    var5_5 = true;
                } else {
                    var5_5 = false;
lbl17:
                    // 2 sources

                    var1_1.append(var2_2[var3_3]);
                }
            }
            ++var3_3;
        }
        return var3_3;
    }

    private PlanImage getRGBPlan(String string) {
        int n;
        boolean bl = false;
        if (string.charAt(0) == '-') {
            return null;
        }
        if (string.charAt(string.length() - 1) == '*') {
            string = string.substring(0, string.length() - 1);
            bl = true;
        }
        if ((n = this.getNumber(string)) < 0 || this.a.calque.plan[n].type != 1 || this.a.calque.plan[n] instanceof PlanImageRGB) {
            return null;
        }
        PlanImage planImage = (PlanImage)this.a.calque.plan[n];
        if (!planImage.flagOk || planImage.error != null) {
            return null;
        }
        if (bl) {
            this.planRGBRef = planImage;
        }
        return planImage;
    }

    private int getServerInfo(StringBuffer stringBuffer, StringBuffer stringBuffer2, char[] cArray, int n) {
        int n2 = n;
        int n3 = 0;
        while (n < cArray.length) {
            if (n3 == 0) {
                if (cArray[n] == '(') {
                    ++n3;
                    stringBuffer.append(new String(cArray, n2, n - n2));
                    n2 = n + 1;
                } else if (cArray[n] == ',') {
                    break;
                }
            } else if (cArray[n] == ')') {
                --n3;
                stringBuffer2.append(new String(cArray, n2, n - n2));
            }
            ++n;
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append(new String(cArray, n2, n - n2));
        }
        if (n < cArray.length && cArray[n] == ',') {
            ++n;
        }
        return n;
    }

    private boolean isSync() {
        if (this.a.dialog == null || this.a.calque == null || this.a.calque.plan[0] == null) {
            return false;
        }
        if (!((AladinServer)this.a.dialog.server[ServerDialog.ALADIN]).isSync()) {
            return false;
        }
        int n = 0;
        while (n < this.a.calque.plan.length) {
            if (this.a.calque.plan[n].type != 0 && this.a.calque.plan[n].error == null && !this.a.calque.plan[n].flagOk) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean justLocalServer(StringBuffer stringBuffer) {
        char[] cArray = stringBuffer.toString().toCharArray();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        int n = 0;
        n = this.getServerInfo(stringBuffer2, stringBuffer3, cArray, n);
        return stringBuffer2.toString().trim().equalsIgnoreCase("Local") && n == cArray.length;
    }

    protected void readFromStream(InputStream inputStream) {
        this.setStream(inputStream);
    }

    private String readLine() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        try {
            do {
                if (this.stream == System.in && this.stream.available() == 0) {
                    Thread.sleep(1000L);
                    continue;
                }
                n = this.stream.read();
                if (this.stream != System.in && n == -1) {
                    this.setStream(null);
                    continue;
                }
                stringBuffer.append((char)n);
            } while (n != 10);
        }
        catch (Exception exception) {
            System.err.println("Pb " + exception);
        }
        return stringBuffer.toString();
    }

    protected void readStandardInput() {
        this.start();
    }

    public void run() {
        this.a.waitDialog();
        System.out.println("The script module is listening...\n   (more info by typing \"help\" at the Aladin prompt)...");
        this.scriptFromInputStream();
    }

    protected void scriptFromInputStream() {
        boolean bl;
        String string = null;
        boolean bl2 = bl = this.stream == System.in;
        if (bl) {
            System.out.print("Aladin> ");
        }
        while ((string = this.readLine()) != null) {
            if (string.trim().length() != 0) {
                if (string.charAt(0) == '#' && !this.filterMode) continue;
                try {
                    this.execScript(string);
                }
                catch (Exception exception) {
                    System.out.println("Error: " + exception);
                    exception.printStackTrace();
                }
            }
            if (!bl) continue;
            if (this.filterMode) {
                System.out.print("Aladin - Filter def.> ");
                continue;
            }
            System.out.print("Aladin> ");
        }
        return;
    }

    synchronized void setStream(InputStream inputStream) {
        if (inputStream == null) {
            inputStream = this.stackStream.empty() ? System.in : this.stackStream.pop();
        } else {
            this.stackStream.push(inputStream);
        }
        this.stream = inputStream;
    }

    private boolean splitGetCmd(StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3, String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length && cArray[n] == ' ') {
            ++n;
        }
        int n2 = 0;
        int n3 = n;
        while (n3 < cArray.length) {
            if (n2 == 0) {
                if (cArray[n3] == '(') {
                    ++n2;
                } else if (cArray[n3] == ' ') {
                    break;
                }
            } else if (cArray[n3] == ')') {
                --n2;
            }
            ++n3;
        }
        String string2 = new String(cArray, n, n3 - n);
        n = n3;
        while (n < cArray.length && cArray[n] == ' ') {
            ++n;
        }
        String string3 = new String(cArray, n, cArray.length - n).trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",(");
        if (this.a.dialog.getServer(stringTokenizer.nextToken()) < 0) {
            if (this.a.calque.isFree()) {
                string3 = string;
                string2 = "Aladin(DSS1),Simbad,VizieR(GSC2.2)";
            } else {
                this.a.view.simbadResolve(string);
                return false;
            }
        }
        stringBuffer.append(string2);
        if (string3.length() == 0) {
            string3 = this.a.dialog.getDefaultTarget();
        } else {
            StringBuffer stringBuffer4 = new StringBuffer();
            if (this.extractRadius(stringBuffer3, stringBuffer4, string3)) {
                string3 = stringBuffer4.toString();
            }
        }
        stringBuffer2.append(string3);
        if (stringBuffer3.length() == 0) {
            stringBuffer3.append(this.a.dialog.getDefaultRadius());
        }
        return true;
    }

    private void status() {
        int n = 0;
        while (n < this.a.calque.plan.length) {
            Plan plan = this.a.calque.plan[n];
            if (plan.type != 0) {
                System.out.println("   " + (this.a.calque.plan.length - n) + ".- " + plan.label + " [" + Plan.Tp[plan.type] + "] " + (plan.active ? "Show " : "Hide ") + (!plan.flagOk ? "Progressing... " : (plan.error != null ? "Error " : "Ok ")) + (plan.selected ? "Selected" : ""));
            }
            ++n;
        }
    }

    private void sync() {
        long l = System.currentTimeMillis();
        while (!this.isSync()) {
            if (timeout > 0L && System.currentTimeMillis() - l > timeout) {
                System.out.println("!!! Time out error (" + timeout / 60000L + " minutes).");
                return;
            }
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
    }
}

