/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Coord;
import cds.aladin.HeaderFits;
import cds.astro.Astroframe;
import java.awt.Dimension;
import java.io.DataInputStream;
import java.util.StringTokenizer;
import java.util.Vector;

public final class Calib
implements Cloneable {
    int aladin;
    double[] xyapoly = new double[10];
    double[] xydpoly = new double[10];
    double[] adypoly = new double[10];
    double[] adxpoly = new double[10];
    double epoch;
    int flagepoc = 0;
    double equinox;
    double alpha;
    double delta;
    double yz;
    double xz;
    double focale;
    double Xorg;
    double Yorg;
    double incX;
    double incY;
    double alphai;
    double deltai;
    double incA;
    double incD;
    double Xcen;
    double Ycen;
    double widtha;
    double widthd;
    int xnpix;
    int ynpix;
    double rota;
    double cdelz;
    double sdelz;
    String type1;
    String type2;
    double[][] CD = new double[2][2];
    double[][] ID = new double[2][2];
    protected int system = 5;
    protected int proj;
    private double deg_to_rad = Math.PI / 180;
    private double rad_to_deg = 57.29577951308232;
    static String[] projection = new String[]{"SINUS", "TANGENTIAL", "ARC", "AITOFF", "ZENITAL_EQUAL_AREA", "STEREOGRAPHIC", "CARTESIAN", "NCP"};

    protected Calib() {
    }

    protected Calib(double d, double d2, double d3, double d4, double d5, double d6, double d7, int n, boolean bl) {
        this.aladin = 0;
        this.xnpix = (int)d5;
        this.ynpix = (int)d5;
        this.Xcen = d3;
        this.Ycen = d4;
        this.alphai = d;
        this.deltai = d2;
        this.cdelz = Math.cos(this.deltai * this.deg_to_rad);
        this.sdelz = Math.sin(this.deltai * this.deg_to_rad);
        double d8 = Math.cos(d7 * this.deg_to_rad);
        double d9 = Math.sin(d7 * this.deg_to_rad);
        this.incA = !bl ? -d6 / d5 : (d6 /= 60.0) / d5;
        this.incD = d6 / d5;
        this.widtha = d6;
        this.widthd = d6;
        this.CD[0][0] = this.incA * d8;
        this.CD[0][1] = this.incA * d9;
        this.CD[1][0] = -this.incD * d9;
        this.CD[1][1] = this.incD * d8;
        double d10 = this.CD[0][0] * this.CD[1][1] - this.CD[0][1] * this.CD[1][0];
        this.ID[0][0] = this.CD[1][1] / d10;
        this.ID[0][1] = -this.CD[0][1] / d10;
        this.ID[1][0] = -this.CD[1][0] / d10;
        this.ID[1][1] = this.CD[0][0] / d10;
        this.rota = d7;
        this.equinox = 2000.0;
        this.epoch = 2000.0;
        this.flagepoc = 0;
        this.proj = n + 1;
        switch (this.proj) {
            case 1: {
                this.type1 = "'RA---SIN'";
                this.type2 = "'DEC--SIN'";
                break;
            }
            case 2: {
                this.type1 = "'RA---TAN'";
                this.type2 = "'DEC--TAN'";
                break;
            }
            case 3: {
                this.type1 = "'RA---ARC'";
                this.type2 = "'DEC--ARC'";
                break;
            }
            case 4: {
                this.type1 = "'RA---AIT'";
                this.type2 = "'DEC--AIT'";
                break;
            }
            case 5: {
                this.type1 = "'RA---ZEA'";
                this.type2 = "'DEC--ZEA'";
                break;
            }
            case 6: {
                this.type1 = "'RA---STG'";
                this.type2 = "'DEC--STG'";
                break;
            }
            case 7: {
                this.type1 = "'RA---CAR'";
                this.type2 = "'DEC--CAR'";
                break;
            }
        }
    }

    protected Calib(double d, double d2, double d3, double d4, int n, int n2, double d5, double d6, double d7, double d8, double d9, double d10, int n3) {
        this.aladin = 0;
        this.xnpix = n;
        this.ynpix = n2;
        this.Xcen = d3;
        this.Ycen = d4;
        this.alphai = d;
        this.deltai = d2;
        this.CD[0][0] = d5;
        this.CD[0][1] = d6;
        this.CD[1][0] = d7;
        this.CD[1][1] = d8;
        this.equinox = d9;
        this.epoch = d10;
        this.proj = n3;
        this.incA = Math.sqrt(this.CD[0][0] * this.CD[0][0] + this.CD[0][1] * this.CD[0][1]) * (this.CD[0][0] / Math.abs(this.CD[0][0]));
        this.incD = Math.sqrt(this.CD[1][0] * this.CD[1][0] + this.CD[1][1] * this.CD[1][1]) * (this.CD[1][1] / Math.abs(this.CD[1][1]));
        this.rota = Math.acos(this.CD[0][0] / this.incA) * 57.29577951308232;
        this.widtha = (double)this.xnpix * Math.abs(this.incA);
        this.widthd = (double)this.ynpix * Math.abs(this.incD);
        this.cdelz = Math.cos(this.deltai * this.deg_to_rad);
        this.sdelz = Math.sin(this.deltai * this.deg_to_rad);
        double d11 = this.CD[0][0] * this.CD[1][1] - this.CD[0][1] * this.CD[1][0];
        this.ID[0][0] = this.CD[1][1] / d11;
        this.ID[0][1] = -this.CD[0][1] / d11;
        this.ID[1][0] = -this.CD[1][0] / d11;
        this.ID[1][1] = this.CD[0][0] / d11;
        switch (this.proj) {
            case 1: {
                this.type1 = "'RA---SIN'";
                this.type2 = "'DEC--SIN'";
                break;
            }
            case 2: {
                this.type1 = "'RA---TAN'";
                this.type2 = "'DEC--TAN'";
                break;
            }
            case 3: {
                this.type1 = "'RA---ARC'";
                this.type2 = "'DEC--ARC'";
                break;
            }
            case 4: {
                this.type1 = "'RA---AIT'";
                this.type2 = "'DEC--AIT'";
                break;
            }
            case 5: {
                this.type1 = "'RA---ZEA'";
                this.type2 = "'DEC--ZEA'";
                break;
            }
            case 6: {
                this.type1 = "'RA---STG'";
                this.type2 = "'DEC--STG'";
                break;
            }
            case 7: {
                this.type1 = "'RA---CAR'";
                this.type2 = "'DEC--CAR'";
                break;
            }
        }
        this.flagepoc = 1;
    }

    protected Calib(HeaderFits headerFits) throws Exception {
        this.aladin = 0;
        this.xnpix = headerFits.getIntFromHeader("NAXIS1  ");
        this.ynpix = headerFits.getIntFromHeader("NAXIS2  ");
        try {
            this.alpha = headerFits.getDoubleFromHeader("PLTRAS  ");
            this.Dss(headerFits);
            return;
        }
        catch (Exception exception) {
            block42: {
                this.Xcen = headerFits.getDoubleFromHeader("CRPIX1  ");
                this.Ycen = headerFits.getDoubleFromHeader("CRPIX2  ");
                this.alphai = headerFits.getDoubleFromHeader("CRVAL1  ");
                this.deltai = headerFits.getDoubleFromHeader("CRVAL2  ");
                try {
                    this.CD[0][0] = headerFits.getDoubleFromHeader("CD1_1    ");
                    this.CD[0][1] = headerFits.getDoubleFromHeader("CD1_2    ");
                    this.CD[1][0] = headerFits.getDoubleFromHeader("CD2_1    ");
                    this.CD[1][1] = headerFits.getDoubleFromHeader("CD2_2    ");
                    this.incA = Math.sqrt(this.CD[0][0] * this.CD[0][0] + this.CD[0][1] * this.CD[0][1]);
                    this.incD = Math.sqrt(this.CD[1][0] * this.CD[1][0] + this.CD[1][1] * this.CD[1][1]);
                    this.rota = Math.acos(this.CD[0][0] / this.incA) * 57.29577951308232;
                }
                catch (Exception exception2) {
                    this.incA = headerFits.getDoubleFromHeader("CDELT1  ");
                    this.incD = headerFits.getDoubleFromHeader("CDELT2  ");
                    try {
                        double d = 0.0;
                        double d2 = 0.0;
                        try {
                            d = headerFits.getDoubleFromHeader("CROTA1  ");
                            d2 = headerFits.getDoubleFromHeader("CROTA2  ");
                        }
                        catch (Exception exception3) {
                            try {
                                d = headerFits.getDoubleFromHeader("CROTA1  ");
                            }
                            catch (Exception exception4) {
                                d2 = headerFits.getDoubleFromHeader("CROTA2  ");
                            }
                        }
                        this.rota = d;
                        if (d == 0.0) {
                            this.rota = d2;
                        } else if (d2 != 0.0) {
                            this.rota = (d + d2) / 2.0;
                        }
                        this.CD[0][0] = this.incA * Math.cos(this.rota / 180.0 * Math.PI);
                        this.CD[0][1] = -this.incD * Math.sin(this.rota / 180.0 * Math.PI);
                        this.CD[1][0] = this.incA * Math.sin(this.rota / 180.0 * Math.PI);
                        this.CD[1][1] = this.incD * Math.cos(this.rota / 180.0 * Math.PI);
                    }
                    catch (Exception exception5) {
                        try {
                            this.CD[0][0] = headerFits.getDoubleFromHeader("PC001001") * this.incA;
                            this.CD[0][1] = headerFits.getDoubleFromHeader("PC001002") * this.incA;
                            this.CD[1][0] = headerFits.getDoubleFromHeader("PC002001") * this.incD;
                            this.CD[1][1] = headerFits.getDoubleFromHeader("PC002002") * this.incD;
                            this.rota = Math.acos(headerFits.getDoubleFromHeader("PC001001")) * 57.29577951308232;
                        }
                        catch (Exception exception6) {
                            this.rota = 0.0;
                            this.CD[0][0] = this.incA;
                            this.CD[0][1] = 0.0;
                            this.CD[1][0] = 0.0;
                            this.CD[1][1] = this.incD;
                            String string = headerFits.getStringFromHeader("ORIGIN  ");
                            if (string == null || !string.startsWith("'DeNIS")) break block42;
                            if (this.CD[0][0] > 0.0) {
                                this.CD[0][0] = -this.CD[0][0];
                            }
                            if (!(this.CD[1][1] > 0.0)) break block42;
                            this.CD[1][1] = -this.CD[1][1];
                        }
                    }
                }
            }
            try {
                this.epoch = headerFits.getDoubleFromHeader("EPOCH   ");
                this.flagepoc = 1;
            }
            catch (Exception exception7) {
                this.epoch = 0.0;
            }
            try {
                this.equinox = headerFits.getDoubleFromHeader("EQUINOX ");
            }
            catch (Exception exception8) {
                try {
                    this.epoch = this.equinox = headerFits.getDoubleFromHeader("EPOCH  ");
                    this.flagepoc = 1;
                }
                catch (Exception exception9) {
                    this.equinox = 2000.0;
                    this.epoch = 2000.0;
                    this.flagepoc = 0;
                }
            }
            this.type1 = headerFits.getStringFromHeader("CTYPE1  ");
            this.type2 = headerFits.getStringFromHeader("CTYPE2  ");
            if (this.type1.startsWith("'DEC")) {
                double d = this.deltai;
                this.deltai = this.alphai;
                this.alphai = d;
                d = this.CD[0][0];
                this.CD[0][0] = this.CD[1][0];
                this.CD[1][0] = d;
                d = this.CD[1][1];
                this.CD[1][1] = this.CD[0][1];
                this.CD[0][1] = d;
                d = this.incA;
                this.incA = this.incD;
                this.incD = d;
            }
            if (this.type1.startsWith("'ELON")) {
                this.system = 4;
            }
            if (this.type1.startsWith("'GLON")) {
                this.system = 2;
            }
            if (this.type1.startsWith("'SLON")) {
                this.system = 3;
            }
            if (this.equinox == 1950.0) {
                this.system = 1;
            }
            try {
                String string = headerFits.getStringFromHeader("RADECSYS");
                if (string.indexOf("ICRS") >= 0) {
                    this.system = 6;
                }
                if (string.indexOf("FK5") >= 0) {
                    this.system = 5;
                }
                if (string.indexOf("FK4") >= 0) {
                    this.system = 1;
                }
            }
            catch (Exception exception10) {}
            this.proj = 0;
            if (this.type1.indexOf("SIN") >= 0) {
                this.proj = 1;
            }
            if (this.type1.indexOf("TAN") >= 0) {
                this.proj = 2;
            }
            if (this.type1.indexOf("COE") >= 0) {
                this.proj = 2;
            }
            if (this.type1.indexOf("ARC") >= 0) {
                this.proj = 3;
            }
            if (this.type1.indexOf("AIT") >= 0) {
                this.proj = 4;
            }
            if (this.type1.indexOf("ZEA") >= 0) {
                this.proj = 5;
            }
            if (this.type1.indexOf("STG") >= 0) {
                this.proj = 6;
            }
            if (this.type1.indexOf("CAR") >= 0) {
                this.proj = 7;
            }
            if (this.type1.indexOf("NCP") >= 0) {
                this.proj = 8;
            }
            if (this.proj == 0) {
                System.err.println("Calib warning:CTYPE " + this.type1 + " is not yet supported " + "by AladinJava, please contact us");
                throw new Exception("CTYPE " + this.type1 + " is not yet supported " + "by AladinJava, please contact us");
            }
            this.widtha = (double)this.xnpix * Math.abs(this.incA);
            this.widthd = (double)this.ynpix * Math.abs(this.incD);
            this.cdelz = Math.cos(this.deltai * this.deg_to_rad);
            this.sdelz = Math.sin(this.deltai * this.deg_to_rad);
            double d = this.CD[0][0] * this.CD[1][1] - this.CD[0][1] * this.CD[1][0];
            this.ID[0][0] = this.CD[1][1] / d;
            this.ID[0][1] = -this.CD[0][1] / d;
            this.ID[1][0] = -this.CD[1][0] / d;
            this.ID[1][1] = this.CD[0][0] / d;
            return;
        }
    }

    protected Calib(DataInputStream dataInputStream) throws Exception {
        int n = 1;
        this.aladin = 1;
        this.equinox = 2000.0;
        String string = dataInputStream.readLine();
        this.epoch = new Double(string);
        this.flagepoc = 1;
        string = dataInputStream.readLine();
        this.focale = new Double(string);
        string = dataInputStream.readLine();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string2 = stringTokenizer.nextToken();
        this.alpha = new Double(string2);
        string2 = stringTokenizer.nextToken();
        this.alpha += new Double(string2) / 60.0;
        string2 = stringTokenizer.nextToken();
        this.alpha += new Double(string2) / 3600.0;
        this.alpha *= 15.0;
        string = dataInputStream.readLine();
        stringTokenizer = new StringTokenizer(string, " ");
        string2 = stringTokenizer.nextToken();
        if (string2.startsWith("-")) {
            n = -1;
        }
        this.delta = new Double(string2);
        if (n == -1) {
            this.delta = -this.delta;
        }
        string2 = stringTokenizer.nextToken();
        this.delta += new Double(string2) / 60.0;
        string2 = stringTokenizer.nextToken();
        this.delta += new Double(string2) / 3600.0;
        if (n == -1) {
            this.delta = -this.delta;
        }
        string = dataInputStream.readLine();
        stringTokenizer = new StringTokenizer(string, " ");
        string2 = stringTokenizer.nextToken();
        this.yz = new Double(string2);
        string2 = stringTokenizer.nextToken();
        this.xz = new Double(string2);
        int n2 = 0;
        while (n2 < 6) {
            dataInputStream.readLine();
            ++n2;
        }
        int n3 = 0;
        while (n3 < 10) {
            string = dataInputStream.readLine();
            stringTokenizer = new StringTokenizer(string, " ");
            string2 = stringTokenizer.nextToken();
            this.adypoly[n3] = new Double(string2);
            string2 = stringTokenizer.nextToken();
            this.adxpoly[n3] = new Double(string2);
            ++n3;
        }
        int n4 = 0;
        while (n4 < 10) {
            string = dataInputStream.readLine();
            stringTokenizer = new StringTokenizer(string, " ");
            string2 = stringTokenizer.nextToken();
            this.xyapoly[n4] = new Double(string2);
            string2 = stringTokenizer.nextToken();
            this.xydpoly[n4] = new Double(string2);
            ++n4;
        }
        string = dataInputStream.readLine();
        stringTokenizer = new StringTokenizer(string, " ");
        string2 = stringTokenizer.nextToken();
        this.incY = new Double(string2);
        string2 = stringTokenizer.nextToken();
        this.incX = new Double(string2);
        string = dataInputStream.readLine();
        stringTokenizer = new StringTokenizer(string, " ");
        string2 = stringTokenizer.nextToken();
        string2 = stringTokenizer.nextToken();
        this.Yorg = new Double(string2);
        string2 = stringTokenizer.nextToken();
        this.Xorg = new Double(string2);
        string = dataInputStream.readLine();
        stringTokenizer = new StringTokenizer(string, " ,=/");
        string2 = stringTokenizer.nextToken();
        string2 = stringTokenizer.nextToken();
        this.alphai = new Double(string2);
        string2 = stringTokenizer.nextToken();
        this.deltai = new Double(string2);
        string2 = stringTokenizer.nextToken();
        string2 = stringTokenizer.nextToken();
        this.widtha = new Double(string2);
        string2 = stringTokenizer.nextToken();
        this.widthd = new Double(string2);
        string = dataInputStream.readLine();
        stringTokenizer = new StringTokenizer(string, " ,=/");
        string2 = stringTokenizer.nextToken();
        string2 = stringTokenizer.nextToken();
        this.xnpix = new Integer(string2);
        string2 = stringTokenizer.nextToken();
        this.ynpix = new Integer(string2);
        this.cdelz = Math.cos(this.delta * this.deg_to_rad);
        this.sdelz = Math.sin(this.delta * this.deg_to_rad);
        this.incA = this.xyapoly[2] * this.incX / this.focale / 1000.0 * this.rad_to_deg;
        this.incD = this.xydpoly[1] * this.incY / this.focale / 1000.0 * this.rad_to_deg;
        Coord coord = new Coord();
        coord.al = this.alphai;
        coord.del = this.deltai;
        this.GetXY(coord);
        this.Xcen = coord.x;
        this.Ycen = coord.y;
    }

    protected void Dss(HeaderFits headerFits) throws Exception {
        int n = 1;
        this.proj = 2;
        this.alpha += (double)headerFits.getIntFromHeader("PLTRAM  ") * 60.0;
        this.alpha += (double)headerFits.getIntFromHeader("PLTRAH  ") * 3600.0;
        this.alpha /= 240.0;
        if (headerFits.getStringFromHeader("PLTDECSN").startsWith("'-")) {
            n = -1;
        }
        this.delta = headerFits.getDoubleFromHeader("PLTDECS ");
        this.delta += (double)headerFits.getIntFromHeader("PLTDECM ") * 60.0;
        this.delta += (double)headerFits.getIntFromHeader("PLTDECD ") * 3600.0;
        this.delta /= 3600.0;
        this.delta *= (double)n;
        this.focale = headerFits.getDoubleFromHeader("PLTSCALE");
        this.focale = 206264.80624709636 / this.focale;
        this.equinox = headerFits.getDoubleFromHeader("EQUINOX ");
        try {
            this.epoch = headerFits.getDoubleFromHeader("EPOCH  ");
        }
        catch (Exception exception) {
            this.epoch = this.equinox;
            this.flagepoc = 0;
        }
        this.xz = headerFits.getDoubleFromHeader("PPO3    ");
        this.xz /= 1000.0;
        this.yz = headerFits.getDoubleFromHeader("PPO6    ");
        this.yz /= 1000.0;
        this.xyapoly[2] = headerFits.getDoubleFromHeader("AMDX1   ");
        this.xydpoly[1] = headerFits.getDoubleFromHeader("AMDY1   ");
        this.xyapoly[1] = headerFits.getDoubleFromHeader("AMDX2   ");
        this.xydpoly[2] = headerFits.getDoubleFromHeader("AMDY2   ");
        this.xyapoly[0] = headerFits.getDoubleFromHeader("AMDX3   ");
        this.xydpoly[0] = headerFits.getDoubleFromHeader("AMDY3   ");
        this.xyapoly[4] = headerFits.getDoubleFromHeader("AMDX4   ");
        this.xydpoly[3] = headerFits.getDoubleFromHeader("AMDY4   ");
        this.xyapoly[5] = headerFits.getDoubleFromHeader("AMDX5   ");
        this.xydpoly[5] = headerFits.getDoubleFromHeader("AMDY5   ");
        this.xyapoly[3] = headerFits.getDoubleFromHeader("AMDX6   ");
        this.xydpoly[4] = headerFits.getDoubleFromHeader("AMDY6   ");
        this.xyapoly[4] = this.xyapoly[4] + headerFits.getDoubleFromHeader("AMDX7   ");
        this.xydpoly[4] = this.xydpoly[4] + headerFits.getDoubleFromHeader("AMDY7   ");
        this.xyapoly[3] = this.xyapoly[3] + headerFits.getDoubleFromHeader("AMDX7   ");
        this.xydpoly[3] = this.xydpoly[3] + headerFits.getDoubleFromHeader("AMDY7   ");
        this.xyapoly[7] = headerFits.getDoubleFromHeader("AMDX8   ");
        this.xydpoly[6] = headerFits.getDoubleFromHeader("AMDY8   ");
        this.xyapoly[9] = headerFits.getDoubleFromHeader("AMDX9   ");
        this.xydpoly[8] = headerFits.getDoubleFromHeader("AMDY9   ");
        this.xyapoly[8] = headerFits.getDoubleFromHeader("AMDX10  ");
        this.xydpoly[9] = headerFits.getDoubleFromHeader("AMDY10  ");
        this.xyapoly[6] = headerFits.getDoubleFromHeader("AMDX11  ");
        this.xydpoly[7] = headerFits.getDoubleFromHeader("AMDY11  ");
        this.xyapoly[7] = this.xyapoly[7] + headerFits.getDoubleFromHeader("AMDX12  ");
        this.xydpoly[6] = this.xydpoly[6] + headerFits.getDoubleFromHeader("AMDY12  ");
        this.xyapoly[8] = this.xyapoly[8] + headerFits.getDoubleFromHeader("AMDX12  ");
        this.xydpoly[9] = this.xydpoly[9] + headerFits.getDoubleFromHeader("AMDY12  ");
        this.xyapoly[0] = this.xyapoly[0] / this.focale;
        this.xydpoly[0] = this.xydpoly[0] / this.focale;
        this.xyapoly[1] = this.xyapoly[1] * -1.0;
        this.xydpoly[1] = this.xydpoly[1] * -1.0;
        this.xyapoly[2] = this.xyapoly[2] * -1.0;
        this.xydpoly[2] = this.xydpoly[2] * -1.0;
        this.xyapoly[3] = this.xyapoly[3] * this.focale;
        this.xydpoly[3] = this.xydpoly[3] * this.focale;
        this.xyapoly[4] = this.xyapoly[4] * this.focale;
        this.xydpoly[4] = this.xydpoly[4] * this.focale;
        this.xyapoly[5] = this.xyapoly[5] * this.focale;
        this.xydpoly[5] = this.xydpoly[5] * this.focale;
        this.xyapoly[6] = this.xyapoly[6] * (-this.focale * this.focale);
        this.xydpoly[6] = this.xydpoly[6] * (-this.focale * this.focale);
        this.xyapoly[7] = this.xyapoly[7] * (-this.focale * this.focale);
        this.xydpoly[7] = this.xydpoly[7] * (-this.focale * this.focale);
        this.xyapoly[8] = this.xyapoly[8] * (-this.focale * this.focale);
        this.xydpoly[8] = this.xydpoly[8] * (-this.focale * this.focale);
        this.xyapoly[9] = this.xyapoly[9] * (-this.focale * this.focale);
        this.xydpoly[9] = this.xydpoly[9] * (-this.focale * this.focale);
        int n2 = 0;
        while (n2 <= 9) {
            int n3 = n2;
            this.xyapoly[n3] = this.xyapoly[n3] / (206264.80624709636 / this.focale);
            int n4 = n2++;
            this.xydpoly[n4] = this.xydpoly[n4] / (206264.80624709636 / this.focale);
        }
        this.incX = headerFits.getDoubleFromHeader("XPIXELSZ");
        this.incY = headerFits.getDoubleFromHeader("YPIXELSZ");
        this.xnpix = headerFits.getIntFromHeader("NAXIS1  ");
        this.ynpix = headerFits.getIntFromHeader("NAXIS2  ");
        this.Xorg = this.incX * (double)headerFits.getIntFromHeader("CNPIX1  ");
        this.Yorg = this.incY * (double)(13999 - headerFits.getIntFromHeader("CNPIX2  ") - this.ynpix);
        this.yz = this.incY * 13999.0 / 1000.0 - this.yz;
        this.cdelz = Math.cos(this.delta * this.deg_to_rad);
        this.sdelz = Math.sin(this.delta * this.deg_to_rad);
        this.aladin = 1;
        this.GetWCS_i();
        double d = this.CD[0][0] * this.CD[1][1] - this.CD[0][1] * this.CD[1][0];
        this.ID[0][0] = this.CD[1][1] / d;
        this.ID[0][1] = -this.CD[0][1] / d;
        this.ID[1][0] = -this.CD[1][0] / d;
        this.ID[1][1] = this.CD[0][0] / d;
        this.incA = Math.sqrt(this.CD[0][0] * this.CD[0][0] + this.CD[0][1] * this.CD[0][1]);
        this.incD = Math.sqrt(this.CD[1][0] * this.CD[1][0] + this.CD[1][1] * this.CD[1][1]);
        this.widtha = (double)this.xnpix * Math.abs(this.incA);
        this.widthd = (double)this.ynpix * Math.abs(this.incD);
        this.cdelz = Math.cos(this.deltai * this.deg_to_rad);
        this.sdelz = Math.sin(this.deltai * this.deg_to_rad);
        this.aladin = 0;
    }

    protected void GetCoord(Coord coord) throws Exception {
        double d = 1.0;
        double d2 = 1.0;
        if (this.aladin == 1) {
            d = (coord.x * this.incX + this.Xorg) / 1000.0;
            d2 = (coord.y * this.incY + this.Yorg) / 1000.0;
            double d3 = (d - this.xz) / this.focale;
            double d4 = (d2 - this.yz) / this.focale;
            double d5 = this.xyapoly[0] + this.xyapoly[1] * d4 + this.xyapoly[2] * d3 + this.xyapoly[3] * d4 * d4 + this.xyapoly[4] * d3 * d3 + this.xyapoly[5] * d4 * d3 + this.xyapoly[6] * d4 * d4 * d4 + this.xyapoly[7] * d3 * d3 * d3 + this.xyapoly[8] * d4 * d4 * d3 + this.xyapoly[9] * d4 * d3 * d3;
            double d6 = this.xydpoly[0] + this.xydpoly[1] * d4 + this.xydpoly[2] * d3 + this.xydpoly[3] * d4 * d4 + this.xydpoly[4] * d3 * d3 + this.xydpoly[5] * d4 * d3 + this.xydpoly[6] * d4 * d4 * d4 + this.xydpoly[7] * d3 * d3 * d3 + this.xydpoly[8] * d4 * d4 * d3 + this.xydpoly[9] * d4 * d3 * d3;
            coord.al = this.alpha + Math.atan(d5 / (this.cdelz - d6 * this.sdelz)) * this.rad_to_deg;
            coord.del = Math.atan(Math.cos((coord.al - this.alpha) * this.deg_to_rad) * (this.sdelz + d6 * this.cdelz) / (this.cdelz - d6 * this.sdelz)) * this.rad_to_deg;
            if (coord.del * this.delta < 0.0 && Math.abs(this.delta) > 87.0) {
                coord.al += 180.0;
                coord.del = -coord.del;
            }
            if (coord.al > 360.0) {
                coord.al -= 360.0;
            }
            if (coord.al < 0.0) {
                coord.al += 360.0;
            }
        } else {
            Astroframe astroframe;
            d = coord.x - this.Xcen + 1.0;
            d2 = (double)this.ynpix - this.Ycen - coord.y;
            double d7 = this.CD[0][0] * d + this.CD[0][1] * d2;
            double d8 = this.CD[1][0] * d + this.CD[1][1] * d2;
            d7 *= this.deg_to_rad;
            d8 *= this.deg_to_rad;
            switch (this.proj) {
                case 1: {
                    coord.del = this.rad_to_deg * Math.asin(d8 * this.cdelz + this.sdelz * Math.sqrt(1.0 - d8 * d8 - d7 * d7));
                    double d9 = d7 / (this.cdelz * Math.sqrt(1.0 - d8 * d8 - d7 * d7) - d8 * this.sdelz);
                    coord.al = this.alphai + this.rad_to_deg * Math.atan(d9);
                    double d10 = this.deltai == 0.0 ? 1.0 : this.deltai / Math.abs(this.deltai);
                    if (!(d10 * d8 - this.cdelz > 0.0)) break;
                    coord.al += 180.0;
                    break;
                }
                case 8: {
                    coord.del = this.rad_to_deg * Math.acos((this.cdelz - d8 * this.sdelz) / Math.cos((coord.al - this.alpha) * this.deg_to_rad));
                    double d11 = d7 / (this.cdelz - d8 * this.sdelz);
                    coord.al = this.alphai + this.rad_to_deg * Math.atan(d11);
                    break;
                }
                case 2: {
                    double d12 = this.cdelz - d8 * this.sdelz;
                    double d13 = Math.atan(d7 / d12);
                    coord.del = 57.29577951308232 * Math.atan(Math.cos(d13) * (this.sdelz + d8 * this.cdelz) / d12);
                    coord.al = this.alphai + d13 * this.rad_to_deg;
                    if (!(coord.del * this.deltai < 0.0) || !(Math.abs(this.deltai) > 87.0)) break;
                    coord.al += 180.0;
                    coord.del = -coord.del;
                    break;
                }
                case 3: {
                    double d14 = Math.sqrt(d7 * d7 + d8 * d8);
                    coord.del = this.rad_to_deg * Math.asin(d8 * this.cdelz * Math.sin(d14) / d14 + this.sdelz * Math.cos(d14));
                    if (d14 < 1.5707963267948966) {
                        coord.al = this.alphai + this.rad_to_deg * Math.asin(Math.sin(d14) * d7 / (d14 * Math.cos(coord.del * this.deg_to_rad)));
                        break;
                    }
                    coord.al = this.alphai + 180.0 - this.rad_to_deg * Math.asin(Math.sin(d14) * d7 / (d14 * Math.cos(coord.del * this.deg_to_rad)));
                    break;
                }
                case 4: {
                    double d15 = 1.0 - d7 * d7 / 16.0 - d8 * d8 / 4.0;
                    if (d15 < 0.5) {
                        coord.del = -32000.0;
                        coord.al = -32000.0;
                        break;
                    }
                    double d16 = Math.sqrt(d15);
                    coord.del = this.rad_to_deg * Math.asin(d8 * d16);
                    coord.al = 2.0 * this.rad_to_deg * Math.atan(d7 * d16 / 2.0 / (2.0 * d16 * d16 - 1.0));
                    break;
                }
                case 5: {
                    double d17 = Math.sqrt(d7 * d7 + d8 * d8) / 2.0;
                    double d18 = 1.5707963267948966 - 2.0 * Math.asin(d17);
                    double d19 = d8 != 0.0 ? Math.atan(-d7 / d8) : Math.atan(-d7);
                    if (d8 < 0.0) {
                        d19 += Math.PI;
                    }
                    coord.del = this.rad_to_deg * Math.asin(this.sdelz * Math.sin(d18) + this.cdelz * Math.cos(d18) * Math.cos(d19));
                    double d20 = Math.sin(d18) * this.cdelz - Math.cos(d18) * this.sdelz * Math.cos(d19);
                    double d21 = -(Math.cos(d18) * Math.sin(d19));
                    coord.al = Math.abs(this.deltai) != 90.0 ? this.alphai + this.rad_to_deg * Math.atan2(d21, d20) : (this.deltai == 90.0 ? this.rad_to_deg * (d19 + Math.PI) : this.rad_to_deg * -d19);
                    if (!(coord.del * coord.del > 8100.0) || !(Math.abs(this.deltai) > 65.0)) break;
                    coord.al = 180.0 - coord.al;
                    coord.del = 2.0 * this.deltai - coord.del;
                    break;
                }
                case 6: {
                    double d22 = Math.sin(1.5707963267948966 - 2.0 * Math.atan(Math.sqrt(d8 * d8 + d7 * d7) / 2.0));
                    coord.del = this.rad_to_deg * Math.asin(this.cdelz * d8 / 2.0 + d22 * (this.sdelz + this.cdelz * d8 / 2.0));
                    double d23 = d22 * (2.0 * this.cdelz - d8 * this.sdelz) - d8 * this.sdelz;
                    coord.al = this.alphai + this.rad_to_deg * Math.atan2(d7 * (1.0 + d22), d23);
                    break;
                }
                case 7: {
                    coord.al = this.alphai + d7 * this.rad_to_deg;
                    coord.del = this.deltai + d8 * this.rad_to_deg;
                    break;
                }
            }
            if (this.equinox != 2000.0) {
                Astroframe astroframe2 = new Astroframe();
                astroframe = new Astroframe(1, this.equinox);
                astroframe.set(coord.al, coord.del);
                astroframe.convert(astroframe2);
                coord.al = astroframe2.getLon();
                coord.del = astroframe2.getLat();
            }
            if (this.system == 2) {
                Astroframe astroframe3 = new Astroframe();
                astroframe = new Astroframe(2, this.equinox);
                astroframe.set(coord.al, coord.del);
                astroframe.convert(astroframe3);
                coord.al = astroframe3.getLon();
                coord.del = astroframe3.getLat();
            }
            if (coord.al > 360.0) {
                coord.al -= 360.0;
            }
            if (coord.al < 0.0) {
                coord.al += 360.0;
            }
        }
    }

    protected double GetEpoch() {
        if (this.flagepoc != 0) {
            return this.epoch;
        }
        return 0.0;
    }

    protected double GetEquinox() {
        return this.equinox;
    }

    protected double[] GetResol() {
        double[] dArray = new double[2];
        dArray[0] = this.incA;
        dArray[0] = this.incD;
        return dArray;
    }

    protected void GetWCS(Vector vector, Vector vector2) throws Exception {
        this.GetWCS_i();
        vector.addElement("NAXIS1  ");
        vector2.addElement(new Integer(this.xnpix).toString());
        vector.addElement("NAXIS2  ");
        vector2.addElement(new Integer(this.ynpix).toString());
        vector.addElement("CRPIX1  ");
        vector2.addElement(new Double(this.Xcen).toString());
        vector.addElement("CRPIX2  ");
        vector2.addElement(new Double(this.Ycen).toString());
        vector.addElement("EQUINOX");
        vector2.addElement(new Double(this.equinox).toString());
        vector.addElement("CRVAL1  ");
        vector2.addElement(new Double(this.alphai).toString());
        vector.addElement("CRVAL2  ");
        vector2.addElement(new Double(this.deltai).toString());
        vector.addElement("CTYPE1  ");
        if (this.aladin == 1) {
            vector2.addElement("'RA---TAN'");
        } else {
            vector2.addElement(this.type1);
        }
        vector.addElement("CTYPE2  ");
        if (this.aladin == 1) {
            vector2.addElement("'DEC--TAN'");
        } else {
            vector2.addElement(this.type2);
        }
        vector.addElement("CD1_1   ");
        vector2.addElement(new Double(this.CD[0][0]).toString());
        vector.addElement("CD1_2   ");
        vector2.addElement(new Double(this.CD[0][1]).toString());
        vector.addElement("CD2_1   ");
        vector2.addElement(new Double(this.CD[1][0]).toString());
        vector.addElement("CD2_2   ");
        vector2.addElement(new Double(this.CD[1][1]).toString());
    }

    protected void GetWCS_i() throws Exception {
        Coord coord = new Coord();
        Coord coord2 = new Coord();
        Coord coord3 = new Coord();
        Coord coord4 = new Coord();
        Coord coord5 = new Coord();
        if (this.aladin == 1) {
            this.Xcen = (double)this.xnpix / 2.0;
            this.Ycen = (double)this.ynpix / 2.0;
            coord.x = this.Xcen;
            coord.y = this.Ycen;
            this.GetCoord(coord);
            this.alphai = coord.al;
            this.deltai = coord.del;
            coord2.x = this.Xcen - (double)this.xnpix / 4.0;
            coord2.y = this.Ycen - (double)this.ynpix / 4.0;
            this.GetCoord(coord2);
            double d = Math.cos(this.deltai / 180.0 * Math.PI);
            double d2 = Math.sin(this.deltai / 180.0 * Math.PI);
            double d3 = Math.sin(coord2.del * Math.PI / 180.0) * d2 + Math.cos(coord2.del * Math.PI / 180.0) * d * Math.cos((coord2.al - this.alphai) * Math.PI / 180.0);
            double d4 = Math.cos(coord2.del * Math.PI / 180.0) * Math.sin((coord2.al - this.alphai) * Math.PI / 180.0) / d3;
            double d5 = Math.sin(coord2.del * Math.PI / 180.0) * d - Math.cos(coord2.del * Math.PI / 180.0) * d2 * Math.cos((coord2.al - this.alphai) * Math.PI / 180.0) / d3;
            this.CD[0][0] = -((double)this.ynpix * d4 + (double)this.xnpix * d5) * 2.0 / (double)this.ynpix / (double)this.xnpix;
            this.CD[0][1] = ((double)this.ynpix * d4 - (double)this.xnpix * d5) * 2.0 / (double)this.xnpix / (double)this.ynpix;
            coord3.x = this.Xcen + (double)this.xnpix / 4.0;
            coord3.y = this.Ycen - (double)this.ynpix / 4.0;
            this.GetCoord(coord3);
            d3 = Math.sin(coord3.del * Math.PI / 180.0) * d2 + Math.cos(coord3.del * Math.PI / 180.0) * d * Math.cos((coord3.al - this.alphai) * Math.PI / 180.0);
            d4 = Math.cos(coord3.del * Math.PI / 180.0) * Math.sin((coord3.al - this.alphai) * Math.PI / 180.0) / d3;
            d5 = Math.sin(coord3.del * Math.PI / 180.0) * d - Math.cos(coord3.del * Math.PI / 180.0) * d2 * Math.cos((coord3.al - this.alphai) * Math.PI / 180.0) / d3;
            double[] dArray = this.CD[0];
            dArray[0] = dArray[0] + ((double)this.ynpix * d4 - (double)this.xnpix * d5) * 2.0 / (double)this.ynpix / (double)this.xnpix;
            double[] dArray2 = this.CD[0];
            dArray2[1] = dArray2[1] + ((double)this.ynpix * d4 + (double)this.xnpix * d5) * 2.0 / (double)this.xnpix / (double)this.ynpix;
            coord4.x = this.Xcen - (double)this.xnpix / 4.0;
            coord4.y = this.Ycen + (double)this.ynpix / 4.0;
            this.GetCoord(coord4);
            d3 = Math.sin(coord4.del * Math.PI / 180.0) * d2 + Math.cos(coord4.del * Math.PI / 180.0) * d * Math.cos((coord4.al - this.alphai) * Math.PI / 180.0);
            d4 = Math.cos(coord4.del * Math.PI / 180.0) * Math.sin((coord4.al - this.alphai) * Math.PI / 180.0) / d3;
            d5 = Math.sin(coord4.del * Math.PI / 180.0) * d - Math.cos(coord4.del * Math.PI / 180.0) * d2 * Math.cos((coord4.al - this.alphai) * Math.PI / 180.0) / d3;
            double[] dArray3 = this.CD[0];
            dArray3[0] = dArray3[0] - ((double)this.ynpix * d4 - (double)this.xnpix * d5) * 2.0 / (double)this.ynpix / (double)this.xnpix;
            double[] dArray4 = this.CD[0];
            dArray4[1] = dArray4[1] - (d4 * (double)this.ynpix + d5 * (double)this.xnpix) * 2.0 / (double)this.xnpix / (double)this.ynpix;
            coord5.x = this.Xcen + (double)this.xnpix / 4.0;
            coord5.y = this.Ycen + (double)this.ynpix / 4.0;
            this.GetCoord(coord5);
            d3 = Math.sin(coord5.del * Math.PI / 180.0) * d2 + Math.cos(coord5.del * Math.PI / 180.0) * d * Math.cos((coord5.al - this.alphai) * Math.PI / 180.0);
            d4 = Math.cos(coord5.del * Math.PI / 180.0) * Math.sin((coord5.al - this.alphai) * Math.PI / 180.0) / d3;
            d5 = Math.sin(coord5.del * Math.PI / 180.0) * d - Math.cos(coord5.del * Math.PI / 180.0) * d2 * Math.cos((coord5.al - this.alphai) * Math.PI / 180.0) / d3;
            double[] dArray5 = this.CD[0];
            dArray5[0] = dArray5[0] + ((double)this.ynpix * d4 + (double)this.xnpix * d5) * 2.0 / (double)this.ynpix / (double)this.xnpix;
            double[] dArray6 = this.CD[0];
            dArray6[1] = dArray6[1] - (d4 * (double)this.ynpix - d5 * (double)this.xnpix) * 2.0 / (double)this.xnpix / (double)this.ynpix;
            double[] dArray7 = this.CD[0];
            dArray7[0] = dArray7[0] * 14.32394487827058;
            double[] dArray8 = this.CD[0];
            dArray8[1] = dArray8[1] * 14.32394487827058;
            this.CD[1][0] = this.CD[0][1];
            this.CD[1][1] = -this.CD[0][0];
            this.equinox = 2000.0;
            this.proj = 2;
        }
    }

    protected void GetXY(Coord coord) {
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 0.03;
        double d4 = 0.03;
        if (this.aladin == 1) {
            double d5 = coord.del * this.deg_to_rad;
            double d6 = (coord.al - this.alpha) * this.deg_to_rad;
            double d7 = Math.sin(d5);
            double d8 = Math.cos(d5);
            double d9 = Math.sin(d6);
            double d10 = Math.cos(d6);
            double d11 = d7 * this.sdelz + d8 * this.cdelz * d10;
            d4 = d8 * d9 / d11;
            d3 = (d7 * this.cdelz - d8 * this.sdelz * d10) / d11;
            d = this.adxpoly[0] + this.adxpoly[1] * d4 + this.adxpoly[2] * d3 + this.adxpoly[3] * d4 * d4 + this.adxpoly[4] * d3 * d3 + this.adxpoly[5] * d3 * d4 + this.adxpoly[6] * d4 * d4 * d4 + this.adxpoly[7] * d3 * d3 * d3 + this.adxpoly[8] * d3 * d4 * d4 + this.adxpoly[9] * d3 * d3 * d4;
            d2 = this.adypoly[0] + this.adypoly[1] * d4 + this.adypoly[2] * d3 + this.adypoly[3] * d4 * d4 + this.adypoly[4] * d3 * d3 + this.adypoly[5] * d3 * d4 + this.adypoly[6] * d4 * d4 * d4 + this.adypoly[7] * d3 * d3 * d3 + this.adypoly[8] * d3 * d4 * d4 + this.adypoly[9] * d3 * d3 * d4;
            d = d * this.focale + this.xz;
            d2 = d2 * this.focale + this.yz;
            coord.x = (d * 1000.0 - this.Xorg) / this.incX;
            coord.y = (d2 * 1000.0 - this.Yorg) / this.incY;
        } else {
            Astroframe astroframe;
            Astroframe astroframe2;
            double d12 = coord.al;
            double d13 = coord.del;
            if (this.equinox != 2000.0) {
                astroframe2 = new Astroframe();
                astroframe = new Astroframe(1, this.equinox);
                astroframe2.set(d12, d13);
                astroframe2.convert(astroframe);
                d12 = astroframe.getLon();
                d13 = astroframe.getLat();
            }
            if (this.system == 2) {
                astroframe2 = new Astroframe();
                astroframe = new Astroframe(2, this.equinox);
                astroframe2.set(d12, d13);
                astroframe2.convert(astroframe);
                d12 = astroframe.getLon();
                d13 = astroframe.getLat();
            }
            double d14 = (d13 - this.deltai) * this.deg_to_rad;
            double d15 = Math.cos(d14);
            double d16 = (d12 - this.alphai) * this.deg_to_rad;
            double d17 = Math.cos(d13 * this.deg_to_rad);
            double d18 = Math.sin(d13 * this.deg_to_rad);
            double d19 = Math.sin(d16);
            double d20 = Math.cos(d16);
            double d21 = d17 * d19;
            double d22 = d18 * this.cdelz - d17 * this.sdelz * d20;
            switch (this.proj) {
                case 1: 
                case 2: 
                case 8: {
                    if (d15 == 0.0) {
                        return;
                    }
                    if (!(d17 * d20 / d15 < 0.0)) break;
                    return;
                }
            }
            switch (this.proj) {
                case 1: {
                    d4 = this.rad_to_deg * d21;
                    d3 = this.rad_to_deg * d22;
                    break;
                }
                case 8: {
                    d4 = this.rad_to_deg * d21;
                    if (this.sdelz == 0.0) {
                        d3 = this.rad_to_deg * d22;
                        break;
                    }
                    d3 = this.rad_to_deg * d22 + this.cdelz / this.sdelz * this.rad_to_deg * (1.0 - Math.sqrt(1.0 - d17 * d17 * d19 * d19 - d18 * d18 * this.cdelz * this.cdelz - d17 * d17 * this.sdelz * this.sdelz * d20 * d20 + 2.0 * d18 * d17 * this.sdelz * this.cdelz * d20));
                    break;
                }
                case 2: {
                    double d23 = d18 * this.sdelz + d17 * this.cdelz * d20;
                    d4 = d21 / d23;
                    d3 = d22 / d23;
                    d4 *= this.rad_to_deg;
                    d3 *= this.rad_to_deg;
                    break;
                }
                case 3: {
                    double d24 = Math.atan(-d17 * d19 / (d18 * this.cdelz - d17 * this.sdelz * d20));
                    if (d18 * this.cdelz - d17 * this.sdelz * d20 > 0.0) {
                        d24 = Math.PI + d24;
                    }
                    double d25 = Math.asin(d18 * this.sdelz + d17 * this.cdelz * d20);
                    d4 = (1.5707963267948966 - d25) * Math.sin(d24);
                    d3 = -(1.5707963267948966 - d25) * Math.cos(d24);
                    d4 *= this.rad_to_deg;
                    d3 *= this.rad_to_deg;
                    break;
                }
                case 4: {
                    if (d12 > 180.0) {
                        d16 -= Math.PI * 2;
                    }
                    double d26 = Math.sqrt(2.0 / (1.0 + d15 * Math.cos(d16 / 2.0)));
                    d4 = 2.0 * d26 * d15 * Math.sin(d16 / 2.0);
                    d3 = d26 * Math.sin(d14);
                    d4 *= this.rad_to_deg;
                    d3 *= this.rad_to_deg;
                    if (!(d16 / 2.0 > Math.PI)) break;
                    d4 = -d4;
                    break;
                }
                case 5: {
                    double d27 = Math.atan(-d17 * d19 / (d18 * this.cdelz - d17 * this.sdelz * d20));
                    if (d18 * this.cdelz - d17 * this.sdelz * d20 > 0.0) {
                        d27 = Math.PI + d27;
                    }
                    double d28 = Math.asin(d18 * this.sdelz + d17 * this.cdelz * d20);
                    double d29 = this.rad_to_deg * Math.sqrt(2.0 * (1.0 - Math.sin(d28)));
                    d4 = d29 * Math.sin(d27);
                    d3 = -d29 * Math.cos(d27);
                    break;
                }
                case 6: {
                    double d30 = 1.0 + d18 * this.sdelz + d17 * this.cdelz * d20;
                    d4 = 2.0 * d21 / d30;
                    d3 = 2.0 * d22 / d30;
                    d4 *= this.rad_to_deg;
                    d3 *= this.rad_to_deg;
                    break;
                }
                case 7: {
                    d4 = d12 - this.alphai;
                    d3 = d13 - this.deltai;
                    break;
                }
            }
            coord.x = this.ID[0][0] * d4 + this.ID[0][1] * d3 + this.Xcen - 1.0;
            coord.y = -(this.ID[1][0] * d4 + this.ID[1][1] * d3) + (double)this.ynpix - this.Ycen;
        }
    }

    protected void GetXYstand(Coord coord) throws Exception {
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 0.03;
        double d4 = 0.03;
        if (this.aladin == 1) {
            double d5 = coord.del * this.deg_to_rad;
            double d6 = (coord.al - this.alpha) * this.deg_to_rad;
            double d7 = Math.sin(d5);
            double d8 = Math.cos(d5);
            double d9 = Math.sin(d6);
            double d10 = Math.cos(d6);
            double d11 = d7 * this.sdelz + d8 * this.cdelz * d10;
            d4 = d8 * d9 / d11;
            d3 = (d7 * this.cdelz - d8 * this.sdelz * d10) / d11;
        } else {
            Astroframe astroframe;
            Astroframe astroframe2;
            double d12 = coord.al;
            double d13 = coord.del;
            coord.dx = coord.x - this.Xcen + 1.0;
            coord.dy = coord.y - this.Ycen;
            if (this.equinox != 2000.0) {
                astroframe2 = new Astroframe();
                astroframe = new Astroframe(1, this.equinox);
                astroframe2.set(d12, d13);
                astroframe2.convert(astroframe);
                d12 = astroframe.getLon();
                d13 = astroframe.getLat();
            }
            if (this.system == 2) {
                astroframe2 = new Astroframe();
                astroframe = new Astroframe(2, this.equinox);
                astroframe2.set(d12, d13);
                astroframe2.convert(astroframe);
                d12 = astroframe.getLon();
                d13 = astroframe.getLat();
            }
            double d14 = (d13 - this.deltai) * this.deg_to_rad;
            double d15 = (d12 - this.alphai) * this.deg_to_rad;
            double d16 = Math.cos(d13 * this.deg_to_rad);
            double d17 = Math.sin(d13 * this.deg_to_rad);
            double d18 = Math.sin(d15);
            double d19 = Math.cos(d15);
            double d20 = d16 * d18;
            double d21 = d17 * this.cdelz - d16 * this.sdelz * d19;
            switch (this.proj) {
                case 1: 
                case 8: {
                    d4 = d20;
                    d3 = d21;
                    break;
                }
                case 2: {
                    double d22 = d17 * this.sdelz + d16 * this.cdelz;
                    d4 = d20 / d22;
                    d3 = d21 / d22;
                    break;
                }
                case 3: {
                    double d23 = Math.atan(d16 * d18 / (d17 * this.cdelz - d16 * this.sdelz * d19));
                    if (d17 * this.cdelz - d16 * this.sdelz * d19 > 0.0) {
                        d23 = Math.PI + d23;
                    }
                    double d24 = Math.asin(d17 * this.sdelz + d16 * this.cdelz * d19);
                    d4 = (1.5707963267948966 - d24) * Math.sin(d23);
                    d3 = -(1.5707963267948966 - d24) * Math.cos(d23);
                    break;
                }
                case 4: {
                    if (d12 > 180.0) {
                        d15 -= Math.PI * 2;
                    }
                    double d25 = Math.cos(d14);
                    double d26 = Math.sqrt(2.0 / (1.0 + d25 * Math.cos(d15 / 2.0)));
                    d4 = 2.0 * d26 * d25 * Math.sin(d15 / 2.0);
                    d3 = d26 * Math.sin(d14);
                    if (!(d15 / 2.0 > Math.PI)) break;
                    d4 = -d4;
                    break;
                }
                case 5: {
                    double d27 = Math.atan(-d16 * d18 / (d17 * this.cdelz - d16 * this.sdelz * d19));
                    if (d17 * this.cdelz - d16 * this.sdelz * d19 > 0.0) {
                        d27 = Math.PI + d27;
                    }
                    double d28 = Math.asin(d17 * this.sdelz + d16 * this.cdelz * d19);
                    double d29 = Math.sqrt(2.0 * (1.0 - Math.sin(d28)));
                    d4 = d29 * Math.sin(d27);
                    d3 = -d29 * Math.cos(d27);
                    break;
                }
                case 6: {
                    double d30 = 1.0 + d17 * this.sdelz + d16 * this.cdelz * d19;
                    d4 = 2.0 * d20 / d30;
                    d3 = 2.0 * d21 / d30;
                    break;
                }
                case 7: {
                    d4 = (d12 - this.alphai) * this.deg_to_rad;
                    d3 = (d13 - this.deltai) * this.deg_to_rad;
                    break;
                }
            }
        }
        coord.xstand = d4;
        coord.ystand = d3;
    }

    protected void SetEquinox(double d) {
        this.equinox = d;
    }

    protected boolean TheSame(Calib calib) {
        if (this.aladin == 1) {
            return false;
        }
        if (this.xnpix != calib.xnpix) {
            return false;
        }
        if (this.ynpix != calib.ynpix) {
            return false;
        }
        if (this.Xcen != calib.Xcen) {
            return false;
        }
        if (this.Ycen != calib.Ycen) {
            return false;
        }
        if (this.alphai != calib.alphai) {
            return false;
        }
        if (this.deltai != calib.deltai) {
            return false;
        }
        if (this.CD[0][0] != calib.CD[0][0]) {
            return false;
        }
        if (this.CD[0][1] != calib.CD[0][1]) {
            return false;
        }
        if (this.CD[1][0] != calib.CD[1][0]) {
            return false;
        }
        if (this.CD[1][1] != calib.CD[1][1]) {
            return false;
        }
        if (this.equinox != calib.equinox) {
            return false;
        }
        return this.proj == calib.proj;
    }

    void cropping(int n, int n2) {
        int n3 = this.xnpix - n;
        int n4 = this.ynpix - n2;
        n3 /= 2;
        n4 /= 2;
        if (this.aladin == 0) {
            this.Xcen -= (double)n3;
            this.Ycen -= (double)n4;
        } else {
            this.Xorg += (double)n3 * this.incX;
            this.Yorg += (double)n4 * this.incY;
        }
        this.xnpix = n;
        this.ynpix = n2;
        this.widtha = (double)this.xnpix * Math.abs(this.incA);
        this.widthd = (double)this.ynpix * Math.abs(this.incD);
    }

    protected Calib flipBU() {
        Calib calib = new Calib();
        try {
            calib = (Calib)this.clone();
        }
        catch (Exception exception) {}
        if (this.aladin == 1) {
            calib.Yorg += (double)this.ynpix * calib.incY;
            calib.incY = -calib.incY;
        } else {
            calib.CD[1][1] = -calib.CD[1][1];
            calib.CD[0][1] = -calib.CD[0][1];
            calib.ID[1][1] = -calib.ID[1][1];
            calib.ID[1][0] = -calib.ID[1][0];
            calib.Ycen = (double)calib.ynpix - calib.Ycen;
        }
        return calib;
    }

    protected Calib flipRL() {
        Calib calib = new Calib();
        try {
            calib = (Calib)this.clone();
        }
        catch (Exception exception) {
            System.out.println("error");
        }
        if (this.aladin == 1) {
            calib.Xorg += (double)this.xnpix * calib.incX;
            calib.incX = -calib.incX;
        } else {
            calib.CD[1][0] = -calib.CD[1][0];
            calib.CD[0][0] = -calib.CD[0][0];
            calib.ID[0][1] = -calib.ID[0][1];
            calib.ID[0][0] = -calib.ID[0][0];
            calib.Xcen = (double)calib.xnpix - calib.Xcen;
        }
        return calib;
    }

    protected Coord getImgCenter() throws Exception {
        Coord coord = new Coord();
        coord.x = this.xnpix / 2;
        coord.y = this.ynpix / 2;
        this.GetCoord(coord);
        return coord;
    }

    protected double getImgHeight() {
        return this.widthd;
    }

    protected Dimension getImgSize() {
        return new Dimension(this.xnpix, this.ynpix);
    }

    protected double getImgWidth() {
        return this.widtha;
    }

    static String[] getProj() {
        return projection;
    }

    protected Coord getProjCenter() throws Exception {
        Coord coord = new Coord();
        coord.x = this.Xcen;
        coord.y = this.Ycen;
        this.GetCoord(coord);
        return coord;
    }

    protected double getProjRot() {
        return this.rota;
    }

    protected boolean getProjSym() {
        return this.incA > 0.0;
    }

    protected int getProjSys() {
        return this.proj - 1;
    }

    protected Calib recalibrate(Coord[] coordArray) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        int n = 0;
        try {
            double d12;
            if (this.aladin == 1) {
                this.GetWCS_i();
                d12 = this.CD[0][0] * this.CD[1][1] - this.CD[0][1] * this.CD[1][0];
                this.ID[0][0] = this.CD[1][1] / d12;
                this.ID[0][1] = -this.CD[0][1] / d12;
                this.ID[1][0] = -this.CD[1][0] / d12;
                this.ID[1][1] = this.CD[0][0] / d12;
                this.incA = Math.sqrt(this.CD[0][0] * this.CD[0][0] + this.CD[0][1] * this.CD[0][1]);
                this.incD = Math.sqrt(this.CD[1][0] * this.CD[1][0] + this.CD[1][1] * this.CD[1][1]);
                this.widtha = (double)this.xnpix * Math.abs(this.incA);
                this.widthd = (double)this.ynpix * Math.abs(this.incD);
                this.cdelz = Math.cos(this.deltai * this.deg_to_rad);
                this.sdelz = Math.sin(this.deltai * this.deg_to_rad);
                this.aladin = 0;
            }
            n = 0;
            while (n < coordArray.length) {
                this.GetXYstand(coordArray[n]);
                d3 += coordArray[n].dx;
                d4 -= coordArray[n].dy;
                d5 += coordArray[n].xstand;
                d6 += coordArray[n].ystand;
                d7 += coordArray[n].dx * coordArray[n].dx + coordArray[n].dy * coordArray[n].dy;
                d8 += coordArray[n].dx * coordArray[n].xstand - coordArray[n].dy * coordArray[n].ystand;
                d9 += -coordArray[n].dx * coordArray[n].ystand - coordArray[n].dy * coordArray[n].xstand;
                ++n;
            }
            double d13 = d5 / (double)coordArray.length;
            double d14 = d6 / (double)coordArray.length;
            double d15 = d8 / (double)coordArray.length;
            double d16 = d9 / (double)coordArray.length;
            double d17 = d3 * d3 * d3 + d3 * (d4 /= (double)coordArray.length) * d4 - (d3 /= (double)coordArray.length) * (d7 /= (double)coordArray.length);
            double d18 = d3 * d3 * d4 + d4 * d4 * d4 - d4 * d7;
            double d19 = -d3 * d3 - d4 * d4 + d7;
            double d20 = -d3 * d3 * d7 - d4 * d4 * d7 + d7 * d7;
            d12 = d3 * d3 * d3 * d3 + 2.0 * d3 * d3 * d4 * d4 + d4 * d4 * d4 * d4 - 2.0 * d3 * d3 * d7 - 2.0 * d4 * d4 * d7 + d7 * d7;
            d = (d13 * d17 + d14 * d18 + d15 * d19) / d12;
            d2 = (-d14 * d17 + d13 * d18 + d16 * d19) / d12;
            d10 = (d15 * d17 + d16 * d18 + d13 * d20) / d12;
            d11 = (-d16 * d17 + d15 * d18 + d14 * d20) / d12;
            double d21 = this.Xcen - (d * d10 - d2 * d11) / (d * d + d2 * d2);
            double d22 = this.Ycen + (d2 * d10 + d * d11) / (d * d + d2 * d2);
            double d23 = d * this.rad_to_deg;
            double d24 = -d2 * this.rad_to_deg;
            double d25 = -d2 * this.rad_to_deg;
            double d26 = -d * this.rad_to_deg;
            double d27 = Math.sqrt(d23 * d23 + d24 * d24) * (d23 / Math.abs(d23));
            double d28 = Math.sqrt(d25 * d25 + d26 * d26) * (d26 / Math.abs(d26));
            double d29 = this.rad_to_deg * Math.acos(d23 / d27);
            Calib calib = new Calib(this.alphai, this.deltai, d21, d22, this.xnpix, this.ynpix, d23, d24, d25, d26, this.equinox, this.epoch, this.proj);
            return calib;
        }
        catch (Exception exception) {
            return this;
        }
    }

    protected Calib resize(int n) {
        if (this.aladin == 1) {
            try {
                this.GetWCS_i();
            }
            catch (Exception exception) {}
        }
        double d = this.Xcen / (double)n;
        double d2 = this.Ycen / (double)n;
        int n2 = this.xnpix / n;
        int n3 = this.ynpix / n;
        double d3 = this.CD[0][0] * (double)n;
        double d4 = this.CD[0][1] * (double)n;
        double d5 = this.CD[1][0] * (double)n;
        double d6 = this.CD[1][1] * (double)n;
        Calib calib = new Calib(this.alphai, this.deltai, d, d2, n2, n3, d3, d4, d5, d6, this.equinox, this.epoch, this.proj);
        return calib;
    }

    protected Calib resize(int n, double d, double d2, int n2, int n3) {
        double d3 = (this.Xcen - d) * (double)n;
        double d4 = (this.Ycen - d2) * (double)n;
        double d5 = this.CD[0][0] / (double)n;
        double d6 = this.CD[0][1] / (double)n;
        double d7 = this.CD[1][0] / (double)n;
        double d8 = this.CD[1][1] / (double)n;
        Calib calib = new Calib(this.alphai, this.deltai, d3, d4, n2 *= n, n3 *= n, d5, d6, d7, d8, this.equinox, this.epoch, this.proj);
        return calib;
    }
}

