/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import java.util.Enumeration;
import java.util.Vector;

public abstract class BasicNode {
    Vector children;
    String name;
    BasicNode father = null;
    int level;
    int x;
    int y;
    boolean isOpen = false;
    boolean isLeaf = false;
    int nbChildren = 0;
    boolean hide = false;
    boolean isSelected = false;
    boolean litup = false;
    boolean framed = false;

    BasicNode() {
        this("");
    }

    BasicNode(BasicNode basicNode) {
        this.name = basicNode.name;
        this.isLeaf = basicNode.isLeaf;
        this.hide = basicNode.hide;
        this.children = new Vector();
    }

    BasicNode(String string) {
        this.name = string;
        this.children = new Vector();
    }

    BasicNode(String string, boolean bl, boolean bl2) {
        this(string);
        this.isOpen = bl;
        this.isLeaf = bl2;
    }

    public BasicNode addChild(BasicNode basicNode) {
        basicNode.father = this;
        this.children.addElement(basicNode);
        ++this.nbChildren;
        return basicNode;
    }

    public BasicNode addChild(String string) {
        BasicNode basicNode = this.createNode(string);
        basicNode.father = this;
        this.children.addElement(basicNode);
        ++this.nbChildren;
        return basicNode;
    }

    public BasicNode addChild(String string, boolean bl, boolean bl2) {
        BasicNode basicNode = this.createNode(string);
        basicNode.isOpen = bl;
        basicNode.isLeaf = bl2;
        basicNode.father = this;
        this.children.addElement(basicNode);
        ++this.nbChildren;
        return basicNode;
    }

    public void changeState() {
        this.isOpen ^= true;
    }

    public abstract BasicNode createNode(String var1);

    public BasicNode getChild(String string) {
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            BasicNode basicNode = (BasicNode)enumeration.nextElement();
            if (!basicNode.name.equals(string)) continue;
            return basicNode;
        }
        return null;
    }

    public Enumeration getChildren() {
        return this.children.elements();
    }

    public BasicNode getChildrenAt(int n) {
        return (BasicNode)this.children.elementAt(n);
    }

    public BasicNode getParent() {
        return this.father;
    }

    public boolean isLastChild() {
        if (this.father == null) {
            return false;
        }
        BasicNode basicNode = this.father.lastChild();
        return basicNode != null && basicNode.equals(this);
    }

    public boolean isSelected() {
        if (!this.isLeaf) {
            return false;
        }
        return this.isSelected;
    }

    public BasicNode lastChild() {
        if (this.nbChildren > 0) {
            return (BasicNode)this.children.elementAt(this.children.size() - 1);
        }
        return null;
    }

    public void openChildren() {
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            BasicNode basicNode = (BasicNode)enumeration.nextElement();
            basicNode.isOpen = true;
        }
    }

    public void removeAllChild() {
        this.children.removeAllElements();
        this.nbChildren = 0;
    }

    public boolean removeChild(BasicNode basicNode) {
        int n = this.children.indexOf(basicNode);
        if (n >= 0) {
            this.children.removeElementAt(n);
            --this.nbChildren;
            return true;
        }
        return false;
    }
}

