/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Glu;
import cds.aladin.MetaDataTree;
import cds.aladin.PlanImage;
import cds.aladin.Server;
import cds.aladin.TreeView;
import cds.aladin.View;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import java.util.Vector;

public final class AladinServer
extends Server
implements Runnable {
    static final String NOM = "Aladin";
    static final String INFO = "The Aladin image database (CDS/Strasbourg) - DSS1/DSS2/MAMA/2MASS";
    static final String IMAGE_METHODE = "Step 2: pick up one of these images, and SUBMIT again";
    static final int MAXLINE = 7;
    List aladinchoix;
    ScrollPane scrollTree;
    MetaDataTree tree;
    Vector vqual;
    Vector vresol;
    boolean enableOtherImage;
    CheckboxGroup fmt;
    Panel qual;
    Panel pjpg;
    Thread thread;
    static String[] ACOLOR = new String[]{"J", "F", "E", "EJ", "V", "O", "R", "I", "S", "SR", "ER", "U", "B", "N"};
    static String[] COLOR = new String[]{"Blue", "Red", "Red", "Equ. blue", "Visible", "Blue", "Red", "InfraRed", "Short red", "Short red", "Equ. red", "UV", "Blue", "Red/IR"};
    static String lastQual = "";
    static boolean flagContWhichQual = false;
    String targetT;
    String criteriaT;
    String labelT;
    String originT;
    boolean sync = true;
    static String otarget = null;
    static FileDialog fd = null;

    protected AladinServer(Aladin aladin, Label label) {
        this.aladin = aladin;
        this.status = label;
        this.type = 0;
        this.nom = NOM;
        this.info = INFO;
        this.setLayout(null);
        this.setFont(Aladin.PLAIN);
        int n = 25;
        Label label2 = new Label("Aladin image database");
        label2.setFont(Aladin.LLITALIC);
        label2.setBounds(140, n, 300, 15);
        this.add(label2);
        Label label3 = new Label("Step 1: Specify a target and press SUBMIT");
        label3.setBounds(150, n += 30, 400, 19);
        this.add(label3);
        Panel panel = this.targetPanel(35, "(\"05 47 17.0 -51 04 03\" or \"M99\" => Simbad resolver )", true, 5);
        panel.setBounds(10, n += 20, 450, 50);
        this.add(panel);
        Label label4 = new Label(IMAGE_METHODE);
        label4.setBounds(50, n += 60, 400, 19);
        n += 20;
        this.add(label4);
        Label label5 = new Label("SURVEY   ORIGIN   COLOR        SIZE               COMMENT     ");
        label5.setFont(Aladin.COURIER);
        label5.setForeground(Color.white);
        label5.setBackground(Color.gray);
        label5.setBounds(10, n, 455, 15);
        this.add(label5);
        this.scrollTree = new ScrollPane(0);
        this.scrollTree.setBounds(10, n += 15, 455, 180);
        this.add(this.scrollTree);
        this.tree = new MetaDataTree(aladin, this.scrollTree);
        this.scrollTree.add(this.tree);
        this.aladinchoix = new List(7, true);
        this.aladinchoix.setFont(Aladin.COURIER);
        this.aladinchoix.setBounds(10, n, 455, 180);
        n += 175;
        this.aladinchoix.setBackground(Color.white);
        this.fmt = new CheckboxGroup();
        this.pjpg = new Panel();
        this.pjpg.setLayout(new FlowLayout(0));
        String string = "JPEG";
        String string2 = "MRCOMP";
        String string3 = "FITS";
        this.pjpg.add(new Label("Get in:"));
        this.pjpg.add(new Checkbox(string, true, this.fmt));
        this.pjpg.add(new Checkbox(string3, false, this.fmt));
        this.pjpg.setFont(Aladin.PLAIN);
        this.pjpg.setBounds(100, n, 400, 30);
        this.add(this.pjpg);
        this.enableOtherImage(false);
    }

    protected static String blankToUnderline(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == ' ') {
                cArray[n] = 95;
            }
            ++n;
        }
        return new String(cArray);
    }

    static String change2FITS(String string) {
        int n = string.indexOf("JPEG");
        if (n < 0) {
            return string;
        }
        return String.valueOf(string.substring(0, n)) + "FITS" + string.substring(n + 4, string.length());
    }

    protected int creatAladinPlane(String string, String string2, String string3, String string4, String string5, String string6) {
        URL uRL;
        if (string2 == null) {
            string2 = "JPEG";
        }
        if (string3 == null) {
            string3 = "FULL";
        }
        String string7 = String.valueOf(Glu.quote(string)) + " " + Glu.quote(string2) + " " + Glu.quote(string3);
        if (string4 != null && string4.length() > 0) {
            string7 = String.valueOf(string7) + " " + Glu.quote(string4);
        }
        if ((uRL = this.aladin.glu.getURL(Glu.debugTag("Image"), string7)) == null) {
            this.aladin.message.warning("Unknown server error", 1);
            return -1;
        }
        if (!this.verif(1, string, string4, String.valueOf(PlanImage.getFmt(string2)) + "/" + PlanImage.getRes(string3))) {
            return -1;
        }
        if (string5 == null) {
            string5 = AladinServer.getPlanLabel(string3, string4);
        }
        if (string6 == null) {
            string6 = string4.indexOf("MAMA") >= 0 ? "MAMA scan by CAI/Paris - data online provided by CDS" : (string4.indexOf("DSS2") >= 0 ? "DSS2 by STScI - data online provided by CDS" : (string4.indexOf("2MASS") >= 0 ? "2MASS by UMass/IRSA - data online provided by CDS" : "DSS1 by STScI - data online provided by CDS"));
        }
        return this.aladin.calque.newPlanImage(uRL, 0, string5, string, string4, string6, PlanImage.getFmt(string2), PlanImage.getRes(string3), false, null);
    }

    protected int creatPlane(String string, String string2, String string3, String string4, String string5) {
        String string6 = null;
        String string7 = null;
        String string8 = null;
        if (string3 != null) {
            this.targetT = string;
            this.criteriaT = string3;
            this.originT = string5;
            this.labelT = string4;
            this.thread = new Thread(this);
            this.setSync(false);
            this.thread.start();
            return 0;
        }
        return this.creatAladinPlane(string, string6, string7, string8, string4, string5);
    }

    private void deselect() {
        int n = this.aladinchoix.countItems();
        while (n >= 0) {
            this.aladinchoix.deselect(n);
            --n;
        }
    }

    protected void enableOtherImage(boolean bl) {
        if (bl != this.enableOtherImage) {
            this.enableOtherImage = bl;
        }
    }

    protected static String fixChar(String string, int n) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray2[n2] = n2 < cArray.length ? cArray[n2] : 32;
            ++n2;
        }
        return new String(cArray2);
    }

    int getFormat() {
        if (this.fmt != null && this.fmt.getCurrent().getLabel().indexOf("FITS") >= 0) {
            return 2;
        }
        if (this.fmt != null && this.fmt.getCurrent().getLabel().indexOf("MRC") >= 0) {
            return 5;
        }
        return 1;
    }

    protected static String getPlanLabel(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[3];
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n2 = 0;
        while (n2 < 3) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        if (stringArray[0].indexOf("2MASS") >= 0) {
            stringArray[2] = stringArray[0];
            stringArray[0] = null;
        }
        if (n == 3) {
            stringBuffer.append("Pl-");
        } else if (n == 2) {
            stringBuffer.append("Lw-");
        }
        if (stringArray[2].equals("STScI") || stringArray[2].equals("STSCI")) {
            stringBuffer.append("DSS1.");
        } else if (!stringArray[2].startsWith("___")) {
            stringBuffer.append(String.valueOf(stringArray[2]) + ".");
        }
        stringBuffer.append(stringArray[1]);
        if (stringArray[0] != null) {
            stringBuffer.append("." + stringArray[0]);
        }
        return stringBuffer.toString();
    }

    protected static String getPlanLabel(String string, String string2) {
        return AladinServer.getPlanLabel(PlanImage.getRes(string), string2);
    }

    private String getTarget(String string) {
        Coord coord;
        try {
            coord = !View.notCoord(string) ? new Coord(string) : this.aladin.view.getSimbad(string);
        }
        catch (Exception exception) {
            return null;
        }
        return coord.getSexa(":");
    }

    protected synchronized boolean isSync() {
        return this.sync;
    }

    public boolean keyDown(Event event, int n) {
        if (event.target instanceof TextField && this.enableOtherImage) {
            if (this.aladinchoix.countItems() > 0) {
                this.aladinchoix.clear();
            }
            this.enableOtherImage(false);
        }
        return super.keyDown(event, n);
    }

    protected void memoTarget(String string) {
        otarget = string;
    }

    protected void reset() {
        if (this.aladinchoix.countItems() > 0) {
            this.aladinchoix.clear();
            int n = 0;
            while (n < 7) {
                this.aladinchoix.addItem(" ");
                ++n;
            }
        }
        this.tree.clear();
        this.enableOtherImage(false);
        super.reset();
    }

    public void run() {
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            URL uRL = this.aladin.glu.getURL("DefQual", String.valueOf(Glu.quote(this.targetT)) + " " + Glu.quote(this.criteriaT));
            DataInputStream dataInputStream = new DataInputStream(uRL.openStream());
            string = dataInputStream.readLine();
            string2 = dataInputStream.readLine();
            string3 = dataInputStream.readLine();
        }
        catch (Exception exception) {}
        if (string == null) {
            this.aladin.message.warning("No such aladin image (" + this.criteriaT + ") for target \"" + this.targetT + "\".", 1);
        } else {
            this.creatAladinPlane(this.targetT, string3, string2, string, this.labelT, this.originT);
        }
        this.setSync(true);
    }

    private synchronized void setSync(boolean bl) {
        this.sync = bl;
    }

    protected void setTarget(String string) {
        if (otarget != null && !otarget.equals(string)) {
            this.reset();
        }
        super.setTarget(string);
    }

    public void submit() {
        Frame frame = this.getFrame(this);
        Object var2_2 = null;
        int n = 0;
        Vector<String> vector = new Vector<String>(5);
        String string = null;
        String string2 = this.getTarget();
        this.memoTarget(string2);
        if (PlanImage.isSolar(string2)) {
            this.creatAladinPlane(string2, null, null, null, string2, "CDS joke");
            return;
        }
        if (!this.enableOtherImage) {
            Object object;
            Object object2;
            this.waitCursor();
            try {
                if (this.aladinchoix.countItems() > 0) {
                    this.aladinchoix.clear();
                }
                URL uRL = this.aladin.glu.getURL(Glu.debugTag("Qualifier"), Glu.quote(string2), false, false);
                object2 = new DataInputStream(uRL.openStream());
                while ((string = ((DataInputStream)object2).readLine()) != null) {
                    ++n;
                    vector.addElement(string);
                }
            }
            catch (Exception exception) {}
            this.defaultCursor();
            if (n == 0) {
                this.aladin.message.warning(" Target not found or aladin server error");
                return;
            }
            this.vqual = new Vector(n + 2);
            this.vresol = new Vector(n + 2);
            flagContWhichQual = false;
            int n2 = 0;
            while (n2 < n) {
                String string3;
                string = (String)vector.elementAt(n2);
                object2 = new StringTokenizer(string, " ");
                object = String.valueOf(((StringTokenizer)object2).nextToken()) + " " + ((StringTokenizer)object2).nextToken() + " " + ((StringTokenizer)object2).nextToken();
                String string4 = string3 = ((StringTokenizer)object2).hasMoreTokens() ? ((StringTokenizer)object2).nextToken() : "FULL,PLATE";
                if (string3.indexOf("STAND") >= 0 || string3.indexOf("standalone") >= 0) {
                    this.vqual.addElement(object);
                    this.vresol.addElement("STAND");
                    this.aladinchoix.addItem(String.valueOf(AladinServer.whichQual((String)object)) + "  " + this.whichSize((String)object, "STAND"));
                }
                if (string3.indexOf("FULL") >= 0) {
                    this.vqual.addElement(object);
                    this.vresol.addElement("FULL");
                    this.aladinchoix.addItem(String.valueOf(AladinServer.whichQual((String)object)) + "  " + this.whichSize((String)object, "FULL") + "  full resolution");
                }
                if (string3.indexOf("LOW") >= 0) {
                    this.vqual.addElement(object);
                    this.vresol.addElement("LOW");
                    this.aladinchoix.addItem(String.valueOf(AladinServer.whichQual((String)object)) + "  " + this.whichSize((String)object, "LOW") + "  low resolution");
                }
                if (string3.indexOf("PLATE") >= 0) {
                    this.vqual.addElement(object);
                    this.vresol.addElement("PLATE");
                    this.aladinchoix.addItem(String.valueOf(AladinServer.whichQual((String)object)) + "  " + this.whichSize((String)object, "PLATE") + "  global plate");
                }
                ++n2;
            }
            if (n2 == 0) {
                this.aladin.message.warning("Aladin server error");
                return;
            }
            try {
                object = new URL("http://aladin.u-strasbg.fr/cgi-bin/nph-HTTP.cgi?out=qualifier&position=" + URLEncoder.encode(TreeView.getDeciCoord(this.getTarget(string2))) + "&radius=0&mode=xml_votable_idha");
                object2 = ((URL)object).openStream();
            }
            catch (IOException iOException) {
                System.out.println("Error while creating stream");
                object2 = null;
            }
            if (object2 != null) {
                this.aladin.treeView.updateTree((InputStream)object2, this.tree, this, string2);
            }
            this.enableOtherImage(true);
        } else {
            int n3 = this.getFormat();
            int[] nArray = this.aladinchoix.getSelectedIndexes();
            if (nArray.length == 0) {
                this.aladin.message.warning("You have to select an image in the list");
                return;
            }
            this.waitCursor();
            int n4 = 0;
            while (n4 < nArray.length) {
                int n5 = nArray[n4];
                String string5 = (String)this.vqual.elementAt(n5);
                int n6 = PlanImage.getRes((String)this.vresol.elementAt(n5));
                this.creatAladinPlane(string2, PlanImage.getFormat(n3), PlanImage.getResolution(n6), string5, null, null);
                ++n4;
            }
            this.deselect();
            this.defaultCursor();
        }
    }

    static String whichQual(String string) {
        boolean bl = flagContWhichQual && string.equals(lastQual);
        flagContWhichQual = true;
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() < 3) {
            return string;
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        stringBuffer.append(AladinServer.fixChar(bl ? "   \"" : string2, 6));
        stringBuffer.append(AladinServer.fixChar(bl ? "    \"   \"" : "  " + (string4.equals("MAMA") ? "MAMA/CAI" : (string4.equalsIgnoreCase("STSCI") ? "DSS1/STScI" : (string4.equalsIgnoreCase("DSS2") ? "DSS2/STScI" : (string2.equalsIgnoreCase("2MASS") ? "UMass/IRSA" : string4)))), 12));
        if (string2.equalsIgnoreCase("2MASS") || string2.equalsIgnoreCase("EROSI")) {
            stringBuffer.append(AladinServer.fixChar("  " + string3, 12));
        } else {
            int n = 0;
            while (n < ACOLOR.length) {
                if (ACOLOR[n].equals(string3)) break;
                ++n;
            }
            if (n < ACOLOR.length) {
                stringBuffer.append(AladinServer.fixChar(bl ? "  \"  \"" : "  " + string3 + " (" + COLOR[n] + ")", 12));
            } else {
                stringBuffer.append(AladinServer.fixChar(bl ? "  \"" : "  " + string3, 12));
            }
        }
        lastQual = string;
        return stringBuffer.toString();
    }

    static String whichQualifier(String string) {
        flagContWhichQual = false;
        return AladinServer.whichQual(string);
    }

    String whichSize(String string, String string2) {
        String string3 = string.indexOf("2MASS") >= 0 ? "~8.5x17'" : (string2.startsWith("STAND") ? "-" : (string.indexOf("STScI") > 0 || string.indexOf("STSCI") > 0 ? (string2.equals("PLATE") ? "~7.7x7.7deg" : (string2.equals("LOW") ? "~1.5x1.5deg" : "~14.1x14.1'")) : (string.indexOf("MAMA") > 0 ? (string2.equals("PLATE") ? "~6.1x6.1deg" : "~11.5x11.5'") : (string.indexOf("DSS2") > 0 ? (string2.equals("PLATE") ? "~6.5x6.5deg" : "~12.9x12.9'") : "-"))));
        return AladinServer.fixChar(string3, 11);
    }
}

