/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.AladinServer;
import cds.aladin.Calque;
import cds.aladin.Command;
import cds.aladin.CreatObj;
import cds.aladin.FilterProperties;
import cds.aladin.FrameCM;
import cds.aladin.FrameContour;
import cds.aladin.FrameNewCalib;
import cds.aladin.FrameRGB;
import cds.aladin.Glu;
import cds.aladin.Help;
import cds.aladin.Localisation;
import cds.aladin.Logo;
import cds.aladin.Message;
import cds.aladin.Mesure;
import cds.aladin.MyButton;
import cds.aladin.MyFrame;
import cds.aladin.MyLabel;
import cds.aladin.NotePad;
import cds.aladin.Plan;
import cds.aladin.PlanField;
import cds.aladin.PlanImage;
import cds.aladin.Printer;
import cds.aladin.Properties;
import cds.aladin.Save;
import cds.aladin.ServerDialog;
import cds.aladin.Source;
import cds.aladin.Split;
import cds.aladin.Status;
import cds.aladin.Target;
import cds.aladin.ToolBox;
import cds.aladin.TreeView;
import cds.aladin.View;
import cds.tools.ExtApp;
import com.jvt.applets.PlotVOApplet;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.accessibility.Accessible;
import org.astrogrid.aceclient.AladinAceClient;

public class Aladin
extends Applet
implements ExtApp {
    static final boolean LSCREEN = Toolkit.getDefaultToolkit().getScreenSize().width > 1000;
    protected static final String TITRE = "A.V.O demonstration prototype";
    protected static final String VERSION = "v0.920";
    protected static String currentVersion = null;
    protected static final boolean MRDECOMP = false;
    protected static int MAXPLANS = LSCREEN ? 14 : 7;
    protected static final int SIZE = 12;
    static final String ICON = "icon.gif";
    static final String WELCOME = "Bienvenue sur A.V.O demonstration prototype - " + Aladin.getReleaseNumber();
    static final String COPYRIGHT = "CDS - ESO - AstroGrid - ST-ECF - UMAN/Jodrell Bank -  CNRSDR01";
    static final Color BKGD = Color.lightGray;
    static Color LGRAY;
    static Color BLUE;
    static Color MAXBLUE;
    static String HOME;
    static String APPLETSERVER;
    static String HOSTSERVER;
    static boolean JAVABEFORE118;
    static boolean NETWORK;
    static boolean CONSOLE;
    static boolean BOF;
    static boolean FLAGLINKS;
    static String ALAGLU;
    static Font BOLD;
    static Font PLAIN;
    static Font ITALIC;
    static int SSIZE;
    static Font SBOLD;
    static Font SPLAIN;
    static Font SITALIC;
    static int LSIZE;
    static Font LPLAIN;
    static Font LBOLD;
    static Font LITALIC;
    static Font LLITALIC;
    static Font COURIER;
    static Font BCOURIER;
    static Aladin aladin;
    View view;
    Status status;
    Split split;
    MyLabel urlStatus;
    Mesure mesure;
    ToolBox toolbox;
    Calque calque;
    Target target;
    Localisation localisation;
    Logo logo;
    Help help;
    ServerDialog dialog;
    TreeView treeView;
    Properties properties;
    FilterProperties filterProperties;
    FrameCM frameCM;
    FrameRGB frameRGB;
    FrameContour frameContour;
    NotePad pad;
    Command command = null;
    FrameNewCalib frameNewCalib = null;
    Glu glu;
    Message message;
    CardLayout cardView;
    CreatObj co;
    Object save = null;
    Panel bigView;
    Panel mesurePanel;
    MyButton bext;
    Vector vButton;
    Container myParent = null;
    Dimension dimOrigSize = null;
    static String error;
    static boolean STANDALONE;
    static String CGIPATH;
    static final int MAXLEVELTRACE = 3;
    static int levelTrace;
    boolean flagLoad = false;
    static MyFrame f;
    boolean msgOn = true;
    static boolean test;
    static boolean flagLaunch;
    static boolean script;
    static boolean inHelp;
    static boolean flagReseau;
    static int iv;
    static long speed;
    static final long slownessThreshold = 800L;
    static boolean isSlow;
    boolean print = false;
    static Applet extApplet;
    static final String AUTEURS = "   \"Aladin for AVO\"\n \n   It is a prototype\n   to demonstrate the European Virtual Observatory :\n \n   Partners:\n   .CDS: Aladin program core - Image server - Science cases\n   .ESO: SED facilities - GOODS images\n   .AstroGrid: ACE facilities - Sciences cases\n   .ST-ECF: Science cases\n   .UMAN/Jodrell Bank: Radio images\n   .Terapix: Sextractor provided for ACE";
    static final int GETHEIGHT = 15;
    static final String MLOAD = "Load...";
    static final String MSAVE = "Save...";
    static final String MTREE = "Tree...";
    static final String MPLUGIN = "Plugins...";
    static final String MLINK = "Links...";
    static final String MHELP = "Help...";
    static final String MDCH1 = "Detach";
    static final String MDCH2 = "Undetach";
    static final String MPRINT = "Print...";
    static final String MQUIT = "Quit";
    static final String FORM = "Open the image/catalog/FoV server window...";
    static final String TREE = "Open the session tree window...";
    static final String VOPLOT = "VOplot (IUCAA): 2D drawer for selected objects...";
    static final String SED = "SED (ESO): Spectral Energy Distribution drawer for selected objects...";
    static final String ACE = "ACE (AstroGrid): Remote object extraction on current image...";
    static final String HELP = "Interactive Help mode (on/off)";
    static final String FAQ = "Get the Aladin FAQ";
    static final String MAN = "Get the Aladin Manual";
    static final String ABOUT = "About \"A.V.O demonstration prototype\"";
    static final String[] SMLOAD;
    static final String[] SMPLUGIN;
    static final String[] SMHELP;
    static final String[] MENU;
    static final String[] MENUS;
    static final String[] MENUA;
    static final String[] MENUA1;
    static final String[] MENUD;
    static final String MENUHEXT = " \n- LOCAL : access to your own data. Images has to be FITS with the WCS field. Tables has to be in ASCII, either in Tab-Separated-Value with the two first column with RA and DEC in J2000 decimal degrees, or in XML Astrores. See the FAQ to have more detail";
    static final String[] MENUH;
    static final int DEFAULT = 0;
    static final int WAIT = 1;
    static final int HAND = 2;
    static final int CROSSHAIR = 3;
    static final int MOVE = 4;
    static final int RESIZE = 5;
    static final int TEXT = 6;
    ExtApp extApp = null;
    String ooid = null;
    String[] olistOid = null;
    private static Hashtable imageCache;

    static {
        APPLETSERVER = null;
        HOSTSERVER = null;
        JAVABEFORE118 = false;
        NETWORK = true;
        CONSOLE = true;
        BOF = false;
        FLAGLINKS = true;
        ALAGLU = "AlaGlu.dic";
        STANDALONE = false;
        CGIPATH = null;
        levelTrace = 0;
        test = false;
        flagLaunch = false;
        script = false;
        inHelp = false;
        flagReseau = false;
        iv = 0;
        speed = -1L;
        extApplet = null;
        SMLOAD = new String[]{FORM, TREE};
        SMPLUGIN = new String[]{SED, VOPLOT, ACE};
        SMHELP = new String[]{HELP, FAQ, MAN, ABOUT};
        MENU = new String[]{MLOAD, MSAVE, MLINK, MPLUGIN, MPRINT, MHELP, MDCH1, MQUIT};
        MENUS = new String[]{MLOAD, MSAVE, MPLUGIN, MPRINT, MHELP, MQUIT};
        MENUA = new String[]{MLOAD, MLINK, MPLUGIN, MHELP, MDCH1};
        MENUA1 = new String[]{MLOAD, MPLUGIN, MHELP, MDCH1};
        MENUD = new String[]{"Access to the images, catalogs, FoV", "Save images and data on the local disk", "Available plugins", "Print the current view", "Produce an HTML page with original image links", "Help information", "Create windows outside the web browser", "Authors, contributors and copyrights", "Quit Aladin"};
        MENUH = new String[]{"!Button ``Open the image/catalog/FoV server window...''\nBy clicking on this sub-menu, you open a new window allowing you to choose a specific server, either for images or for data.\n \n- ALADIN image server: these images come from several surveys (POSI, POSII, SERC, ESO) and have been digitized either by the Space Telescope Science Institute (STScI) and/or by the Centre d'Analyse des Images (CAI/MAMA).\n \n- VIZIER : gives you access to more than 2000 astronomical catalogs and tables, logs of missions with images and spectra.\n \n- SIMBAD : the well--known astronomical database.\n \n- NED : the well--known extragalactic database.\n \n- FOV : Fields of View of several instruments\n", "!Button ``Save...''\nBy clicking this button you can store data and images on your local disk.\nYou have three possibilities:\n \n- Backup the stack: generate a unique file containing all current data, graphics and images. The format is Aladin proprietary (AJ format). This feature is typically used to work without network, or to continue a previous work.\n \n- Export some planes: to allow you to choose individually the planes of the stack that you want to export in order to reuse them in other applications. The tables and catalogs are exported in ASCII Tab-Separated-Value format with a short header. The images are exported in 8bits FITS with the WCS header fields.\n \n- Export the current view: to allow you to export the current view with the overlays to an image file in BMP 24bits format.\n \n- Get image links: to allow you to retrieve the original images directly from the image servers.\n \nYou can reload from the files with the Button ``Load...'' - sub-menu ``Local'', or directly at the startup in the command line.\n", "!Button ``Plugins...''\nGive access to the plug-ins compatible with Aladinsuch as SED (ESO), ACE (AstroGrid), VOPlot (IUCAA)", "!Button ``Links...''\nProduce a HTML page with the list of image urls in order to allow you to retrieve the original images directly from the image servers.", "!Button ``Print...''\nAllows you to print the current view.\nThe printer has to be PostsScript compatible", "", "!Button ``Detach''\nAllows you to run Aladin outside the Web browser window. In this way the size of the Aladin window can be adjusted to the size of the screen.\n \nWARNING: for Netscape 3.0 (and previous versions), iconifying the Web Browser will stop Aladin.", "!Button ``Quit''\nAllows you to quit Aladin"};
        imageCache = null;
    }

    public boolean action(Event event, Object object) {
        String string;
        try {
            string = (String)object;
        }
        catch (Exception exception) {
            return true;
        }
        if (!(flagReseau || NETWORK || string.equals(MQUIT))) {
            flagReseau = true;
            Aladin.aladin.message.warning("I cannot find the network !\nLocal features availabled only !");
            return true;
        }
        if (string.equals(FORM)) {
            if (this.dialog == null) {
                this.message.warning("Form not yet ready\nPlease try again in few seconds");
                return true;
            }
            this.dialog.toFront();
            this.dialog.show();
        } else if (string.equals(TREE)) {
            if (this.treeView == null) {
                this.message.warning("Frame not yet ready\nPlease try again in few seconds");
                return true;
            }
            this.treeView.toFront();
            this.treeView.show();
        } else if (string.equals(MDCH1)) {
            Aladin.makeAdd(f, this, "Center");
            f.pack();
            f.show();
            this.bext.setLabel(MDCH2);
            this.bext.pop();
        } else if (string.equals(HELP) || string.equals(MHELP)) {
            this.setHelp(inHelp ^= true);
            this.cardView.show(this.bigView, inHelp ? "Help" : "View");
        } else if (string.equals(MSAVE)) {
            this.save();
        } else if (string.equals(MDCH2)) {
            this.unDetach();
        } else if (string.equals(FAQ)) {
            this.glu.showDocument("Aladin.java.getFAQ", "");
        } else if (string.equals(MAN)) {
            this.glu.showDocument("Aladin.java.getManual.pdf", "");
        } else if (string.equals(MPRINT)) {
            this.printer();
        } else if (string.equals(ABOUT)) {
            this.info();
        } else if (string.equals(MLINK)) {
            this.saveHTML();
        } else if (string.equals(SED)) {
            this.startSED();
        } else if (string.equals(VOPLOT)) {
            this.startVOPlot();
        } else if (string.equals(ACE)) {
            this.startACE();
        } else if (string.equals(MQUIT)) {
            if (this.print) {
                this.message.warning("You are printing\nwait a few seconds !");
                return true;
            }
            if (flagLaunch) {
                f.dispose();
            } else {
                System.exit(0);
            }
        }
        return true;
    }

    protected void callbackSelectExtApp(String[] stringArray, int n) {
        int n2;
        if (this.olistOid != null && this.olistOid.length == n) {
            n2 = 0;
            while (n2 < n) {
                if (this.olistOid[n2] != stringArray[n2]) break;
                ++n2;
            }
            if (n2 == n) {
                return;
            }
        }
        String[] stringArray2 = new String[n];
        n2 = 0;
        while (n2 < n) {
            stringArray2[n2] = stringArray[n2];
            ++n2;
        }
        this.olistOid = stringArray2;
        System.out.println("call extApp select");
        this.extApp.selectVOTableObject(stringArray2);
    }

    protected void callbackShowExtApp(String string) {
        if (this.ooid != null && this.ooid.equals(string)) {
            return;
        }
        this.ooid = string;
        String[] stringArray = new String[]{string};
        this.extApp.showVOTableObject(stringArray);
    }

    protected void creatFonts() {
        String string = "SansSerif";
        Aladin.trace(1, "Creating Fonts");
        BOLD = new Font(string, 1, 12);
        PLAIN = new Font(string, 0, 12);
        ITALIC = new Font(string, 2, 12);
        SSIZE = 10;
        SBOLD = new Font(string, 1, SSIZE);
        SPLAIN = new Font(string, 0, SSIZE);
        SITALIC = new Font(string, 2, SSIZE);
        LSIZE = 14;
        LPLAIN = new Font(string, 0, LSIZE);
        LBOLD = new Font(string, 1, LSIZE);
        LITALIC = new Font(string, 2, LSIZE);
        LLITALIC = new Font(string, 1, 18);
        COURIER = new Font("Monospaced", 0, 12);
        BCOURIER = new Font("Monospaced", 1, 12);
    }

    protected void endMsg() {
        this.cardView.show(this.bigView, "View");
        this.msgOn = false;
        this.setHelp(false);
    }

    public String execCommand(String string) {
        this.waitDialog();
        try {
            this.command.execScript(string);
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception);
            return "Error: " + exception;
        }
        return null;
    }

    public AppletContext getAppletContext() {
        if (extApplet != null) {
            return extApplet.getAppletContext();
        }
        return super.getAppletContext();
    }

    public URL getCodeBase() {
        if (extApplet != null) {
            return extApplet.getCodeBase();
        }
        return super.getCodeBase();
    }

    protected Frame getFrame(Component component) {
        while (component != null && !(component instanceof Frame)) {
            component = component.getParent();
        }
        return (Frame)component;
    }

    protected Image getImagette(String string) {
        Image image;
        if (imageCache == null) {
            imageCache = new Hashtable(10);
        }
        if ((image = (Image)imageCache.get(string)) != null) {
            if (image instanceof Image) {
                return image;
            }
            return null;
        }
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/" + string);
            byte[] byArray = PlanImage.streamReadFully(inputStream);
            if (byArray.length == 0) {
                throw new Exception(String.valueOf(string) + " unreachable");
            }
            Image image2 = Toolkit.getDefaultToolkit().createImage(byArray);
            PlanImage.waitImage(this, image2);
            imageCache.put(string, image2);
            inputStream.close();
            return image2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            imageCache.put(string, "");
            return null;
        }
    }

    public String getParameter(String string) {
        if (extApplet != null) {
            return extApplet.getParameter(string);
        }
        return super.getParameter(string);
    }

    private String[] getPopupMenu(String string) {
        if (string == MLOAD) {
            return SMLOAD;
        }
        if (string == MPLUGIN) {
            return SMPLUGIN;
        }
        if (string == MHELP) {
            return SMHELP;
        }
        return null;
    }

    protected static String getReleaseNumber() {
        return VERSION.substring(0, VERSION.indexOf(46) + 2);
    }

    protected static long getSpeed() {
        long l = System.currentTimeMillis();
        Vector vector = new Vector();
        int n = 0;
        while (n < 30000) {
            vector.addElement(new Vector(30));
            Vector vector2 = (Vector)vector.elementAt(n);
            ++n;
        }
        long l2 = System.currentTimeMillis();
        vector = null;
        return l2 - l;
    }

    public String getTarget(String string) {
        int n = 0;
        while (n < this.calque.plan.length) {
            if (this.calque.plan[n].flagOk && this.calque.plan[n].label.equals(string)) {
                if (!(this.calque.plan[n] instanceof PlanField)) break;
                return ((PlanField)this.calque.plan[n]).getCenter();
            }
            ++n;
        }
        return null;
    }

    public boolean handleEvent(Event event) {
        if (inHelp) {
            System.out.println("***" + event);
        }
        if (this.flagLoad) {
            return true;
        }
        return super.handleEvent(event);
    }

    protected boolean hasExtApp() {
        return this.extApp != null;
    }

    public void hide() {
        if (flagLaunch && extApplet == null) {
            f.dispose();
        } else {
            super.hide();
        }
    }

    private void info() {
        this.message.info(AUTEURS);
    }

    public void init() {
        if (!STANDALONE) {
            String string;
            String string2;
            int n;
            String[] stringArray = new String[]{"-c", "-rm", "-server", "-source", "img", "-fov", "-aladin.resolution", "-aladin.zoom", "script"};
            String string3 = this.getParameter("-trace");
            if (string3 != null) {
                levelTrace = 3;
            }
            if ((n = (string2 = this.getCodeBase().toString()).indexOf("//")) > 0 && (n = (string2 = string2.substring(n + 2)).indexOf(47)) > 0) {
                HOSTSERVER = string2 = string2.substring(0, n);
                if (!string2.equals("aladin.u-strasbg.fr") && !string2.equals("aladin")) {
                    APPLETSERVER = string2;
                }
            }
            CGIPATH = String.valueOf(String.valueOf(this.getCodeBase()));
            try {
                string = this.getParameter("cgi");
                if (string != null) {
                    CGIPATH = "http://" + HOSTSERVER + string;
                }
            }
            catch (Exception exception) {}
            string = null;
            try {
                string = this.getParameter("-load");
            }
            catch (Exception exception) {}
            if (string != null) {
                if (!this.flagLoad) {
                    URL uRL = null;
                    String string4 = "";
                    Aladin.trace(1, "init loading");
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        String string5 = this.getParameter(stringArray[n2]);
                        if (string5 != null) {
                            string4 = String.valueOf(string4) + "&" + stringArray[n2] + "=" + URLEncoder.encode(string5);
                        }
                        ++n2;
                    }
                    try {
                        uRL = new URL(String.valueOf(CGIPATH) + "/nph-aladin.pl?frame=launching" + string4);
                    }
                    catch (Exception exception) {
                        System.out.println("Pb :" + exception);
                    }
                    this.getAppletContext().showDocument(uRL);
                }
                this.flagLoad = true;
                return;
            }
        }
        this.suiteInit();
    }

    public Insets insets() {
        return new Insets(3, 8, 1, 7);
    }

    public static Aladin launch() {
        return Aladin.launch("-noconsole");
    }

    public static Aladin launch(Applet applet) {
        return Aladin.launch(null, applet);
    }

    public static Aladin launch(String string) {
        return Aladin.launch("-noconsole", null);
    }

    public static Aladin launch(String string, Applet applet) {
        String[] stringArray;
        extApplet = applet;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n = stringTokenizer.countTokens();
            stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = new String(stringTokenizer.nextToken());
                ++n2;
            }
        } else {
            stringArray = new String[]{};
        }
        flagLaunch = true;
        Aladin.main(stringArray);
        return aladin;
    }

    protected void load(String string) {
        this.waitDialog();
        this.dialog.server[ServerDialog.LOCAL].creatPlane(null, null, string, null, null);
    }

    public void loadVOTable(ExtApp extApp, InputStream inputStream) {
        this.extApp = extApp;
        this.calque.newPlanCatalog(inputStream);
    }

    public static void main(String[] stringArray) {
        if (extApplet == null) {
            STANDALONE = true;
        }
        f = new MyFrame(TITRE);
        f.move(50, 50);
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equals("-h")) {
                Aladin.usage();
                System.exit(0);
            }
            if (stringArray[n2].equals("-test")) {
                test = true;
                n = n2 + 1;
            }
            if (stringArray[n2].equals("-trace")) {
                levelTrace = 1;
                n = n2 + 1;
            }
            if (stringArray[n2].equals("-script")) {
                script = true;
                n = n2 + 1;
            }
            if (stringArray[n2].equals("-local")) {
                NETWORK = false;
                n = n2 + 1;
            }
            if (stringArray[n2].equals("-noconsole")) {
                CONSOLE = false;
                n = n2 + 1;
            }
            if (stringArray[n2].equals("-bof")) {
                BOF = true;
                n = n2 + 1;
            }
            ++n2;
        }
        if (extApplet == null) {
            Aladin.setAladinHome();
        }
        aladin = new Aladin();
        f.setLayout(new BorderLayout(0, 0));
        Aladin.makeAdd(f, aladin, "Center");
        aladin.init();
        if (!script) {
            f.pack();
            f.show();
        } else {
            f.show();
            ((Component)f).hide();
            if (!flagLaunch) {
                System.out.println("   .Scripting Mode => no graphic interface !");
            }
        }
        while (n < stringArray.length) {
            aladin.load(stringArray[n++]);
        }
    }

    protected static void makeAdd(Container container, Component component, String string) {
        try {
            container.add(component, string);
        }
        catch (Error error) {
            container.add(string, component);
        }
    }

    protected static void makeCursor(Component component, int n) {
        if (inHelp) {
            n = 2;
        }
        while (component != null && !(component instanceof Frame)) {
            component = component.getParent();
        }
        if (component == null) {
            return;
        }
        ((Frame)component).setCursor(n == 1 ? 3 : (n == 2 ? 12 : (n == 3 ? 1 : (n == 4 ? 13 : (n == 5 ? 8 : (n == 6 ? 2 : 0))))));
    }

    public boolean mouseExit(Event event, int n, int n2) {
        this.localisation.setPanelText();
        return true;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        if (inHelp) {
            this.help.setDefault();
        } else {
            this.status.setText("");
        }
        return true;
    }

    protected int numJVMVersion(String string) {
        if (string == null || string.length() < 5) {
            return 0;
        }
        char[] cArray = string.toCharArray();
        int n = (cArray[0] - 48) * 100 + (cArray[2] - 48) * 10 + (cArray[4] - 48);
        return n;
    }

    protected int numVersion(String string) {
        if (string == null || string.length() < 6) {
            return 0;
        }
        char[] cArray = string.toCharArray();
        if (cArray[0] != 'v' || cArray[2] != '.') {
            return 0;
        }
        int n = (cArray[1] - 48) * 100 + (cArray[3] - 48) * 10 + (cArray[4] - 48);
        return n;
    }

    private void printer() {
        new Printer(this);
    }

    private void save() {
        try {
            Class<?> clazz = Class.forName("cds.aladin.Save");
            Class<?> clazz2 = this.getClass();
            Boolean bl = new Boolean(true);
            Constructor<?> constructor = clazz.getDeclaredConstructor(clazz2, Boolean.TYPE);
            Object obj = constructor.newInstance(this, bl);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    protected void saveHTML() {
        String string;
        Object object;
        StringBuffer stringBuffer = null;
        int n = 0;
        int n2 = this.calque.plan.length - 1;
        while (n2 >= 0) {
            object = this.calque.plan[n2];
            if (((Plan)object).type == 1 && ((Plan)object).flagOk && ((Plan)object).error == null && ((Plan)object).u != null) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                } else {
                    stringBuffer.append("&");
                }
                string = ((Plan)object).u.toString();
                String string2 = PlanImage.getFormat(((PlanImage)object).fmt);
                if (((PlanImage)object).orig == 0 && ((PlanImage)object).fmt == 1) {
                    string = AladinServer.change2FITS(string);
                    string2 = "FITS";
                }
                stringBuffer.append("A" + n + "=" + URLEncoder.encode(((Plan)object).label) + "&D" + n + "=" + URLEncoder.encode(((Plan)object).from) + "&U" + n + "=" + URLEncoder.encode(string) + "&R" + n + "=" + URLEncoder.encode(string2));
                ++n;
            }
            --n2;
        }
        if (stringBuffer == null) {
            this.message.warning("There is no image\nin the stack");
            return;
        }
        object = STANDALONE ? "http://aladin.u-strasbg.fr/java" : CGIPATH;
        string = String.valueOf(object) + "/nph-aladin.pl?frame=save&" + stringBuffer;
        Aladin.trace(2, string);
        this.glu.showDocument("Http", string, true);
    }

    public void selectVOTableObject(String[] stringArray) {
        this.olistOid = stringArray;
        this.calque.view.selectSourcesByOID(stringArray);
    }

    protected static void setAladinHome() {
        String string = System.getProperty("path.separator");
        String string2 = System.getProperty("file.separator");
        HOME = "." + string2;
        String string3 = System.getProperty("java.class.path");
        if (string3 == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, string);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.endsWith(String.valueOf(string2) + "Aladin.jar")) {
                string4 = string4.substring(0, string4.lastIndexOf(string2));
            } else if (string4.endsWith("Aladin.jar")) {
                string4 = ".";
            }
            String string5 = string4.endsWith(string2) ? "" : string2;
            File file = new File(String.valueOf(string4) + string5 + ALAGLU);
            if (!file.canRead()) continue;
            HOME = String.valueOf(string4) + string5;
            return;
        }
    }

    protected void setButtonMode(boolean bl) {
        if (!STANDALONE) {
            return;
        }
        Enumeration enumeration = this.vButton.elements();
        while (enumeration.hasMoreElements()) {
            MyButton myButton = (MyButton)enumeration.nextElement();
            if (!myButton.text.equals(MSAVE) && !myButton.text.equals(MPRINT)) continue;
            myButton.enable(bl);
        }
    }

    protected synchronized void setCurrentVersion(String string) {
        currentVersion = string;
        if (STANDALONE) {
            this.testVersion();
        }
    }

    synchronized void setFlagPrint(boolean bl) {
        this.print = bl;
    }

    protected void setHelp(boolean bl) {
        if (bl) {
            this.localisation.setPanelPos();
            this.help.setDefault();
            Aladin.makeCursor(this, 2);
        } else {
            Aladin.makeCursor(this, 0);
        }
        if (!this.msgOn) {
            Enumeration enumeration = this.vButton.elements();
            while (enumeration.hasMoreElements()) {
                MyButton myButton = (MyButton)enumeration.nextElement();
                myButton.enable(bl ^ true);
            }
        }
        if (this.calque.isFree()) {
            this.setButtonMode(false);
        }
        this.msgOn = false;
    }

    public void setLocation(int n, int n2) {
        System.out.println("Aladin setLocation(x=" + n + " y=" + n2 + ")");
        super.setLocation(n, n2);
    }

    public void setLocation(Point point) {
        System.out.println("Aladin setLocation(p=" + point.x + "," + point.y + ")");
        super.setLocation(point);
    }

    public void show() {
        if (flagLaunch && extApplet == null) {
            f.pack();
            f.show();
        } else {
            super.show();
        }
    }

    public void showVOTableObject(String[] stringArray) {
        Source[] sourceArray = this.calque.getSources(stringArray);
        if (sourceArray.length == 0) {
            this.ooid = null;
            this.calque.view.hideSource();
        } else {
            this.ooid = sourceArray[0].getOID();
            this.calque.view.showSource(sourceArray[0]);
        }
    }

    public void start() {
        if (this.flagLoad) {
            super.stop();
            return;
        }
        super.start();
    }

    private void startACE() {
        System.out.println("Starting ACE...");
        try {
            PlanImage planImage = (PlanImage)this.calque.getPlanBase();
            if (planImage == null) {
                this.message.warning(" No image ");
            }
            String string = planImage.u.toString();
            if (planImage.orig == 0 && planImage.fmt == 1) {
                string = AladinServer.change2FITS(string);
            }
            System.out.println("Url for AladinAceClient: " + string);
            new AladinAceClient(new URL(string), this);
        }
        catch (Exception exception) {
            System.err.println("Error: " + exception);
        }
    }

    private void startSED() {
        if (!this.calque.view.hasSelectedObjet()) {
            Aladin.aladin.message.warning(" No selected objects in the view ");
            return;
        }
        System.out.println("Starting SED...");
    }

    private void startVOPlot() {
        if (!this.calque.view.hasSelectedObjet()) {
            Aladin.aladin.message.warning(" No selected objects in the view ");
            return;
        }
        System.out.println("Starting VOPlot...");
        try {
            this.save = new Save(this, true);
            String string = ((Save)this.save).writeSelectedObjectInVOTable();
            ((Save)this.save).dispose();
            System.out.println(string);
            this.extApp = PlotVOApplet.launch();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            this.extApp.loadVOTable(this, byteArrayInputStream);
        }
        catch (Exception exception) {
            System.err.println("Error: " + exception);
        }
    }

    protected void suiteInit() {
        int n;
        Accessible accessible;
        Object object;
        Aladin.makeCursor(this, 1);
        LGRAY = new Color(229, 229, 229);
        BLUE = new Color(204, 204, 255);
        MAXBLUE = new Color(153, 153, 255);
        this.setLayout(new BorderLayout(0, 0));
        this.setBackground(BKGD);
        if (!flagLaunch) {
            System.out.println("\nAladin for AVO (v0.920) is starting" + (test ? " in test mode" : "") + "...");
        }
        if (!STANDALONE && extApplet == null) {
            f = new MyFrame(this, TITRE);
        }
        this.creatFonts();
        this.testReseau();
        this.co = new CreatObj(this);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(15, 0));
        Aladin.makeAdd(panel, this.localisation, "Center");
        Aladin.makeAdd(panel, this.target, "East");
        Aladin.trace(1, "Updating the cross object references");
        this.calque.setView(this.view);
        this.calque.setTarget(this.target);
        this.toolbox.init(this.calque);
        Aladin.trace(1, "Creating the Menu");
        if (STANDALONE) {
            Aladin.MENUH[0] = String.valueOf(MENUH[0]) + MENUHEXT;
        }
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 0));
        int n2 = 0;
        while (n2 < MENU.length) {
            block21: {
                block20: {
                    int n3;
                    block22: {
                        block19: {
                            if (!STANDALONE) break block19;
                            n3 = 0;
                            while (n3 < MENUS.length && !MENU[n2].equals(MENUS[n3])) {
                                ++n3;
                            }
                            if (n3 < MENUS.length) break block20;
                            break block21;
                        }
                        if (!FLAGLINKS) break block22;
                        n3 = 0;
                        while (n3 < MENUA.length && !MENU[n2].equals(MENUA[n3])) {
                            ++n3;
                        }
                        if (n3 < MENUA.length) break block20;
                        break block21;
                    }
                    n3 = 0;
                    while (n3 < MENUA1.length && !MENU[n2].equals(MENUA1[n3])) {
                        ++n3;
                    }
                    if (n3 >= MENUA1.length) break block21;
                }
                boolean bl = (MENU[n2].equals(MSAVE) || MENU[n2].equals(MLINK) || MENU[n2].equals(MPRINT)) ^ true;
                MyButton myButton = new MyButton(this, MENU[n2], MENUD[n2], MENUH[n2], bl);
                if (!MENU[n2].equals(MHELP) && n2 < MENU.length - 1) {
                    this.vButton.addElement(myButton);
                }
                if (MENU[n2].equals(MDCH1)) {
                    this.bext = myButton;
                }
                if ((object = this.getPopupMenu(MENU[n2])) != null) {
                    accessible = new PopupMenu();
                    n = 0;
                    while (n < ((String[])object).length) {
                        ((Menu)accessible).add(new MenuItem(object[n]));
                        ++n;
                    }
                    myButton.add((PopupMenu)accessible);
                    myButton.setAlwaysUp(true);
                }
                if (extApplet == null || n2 < MENU.length - 2) {
                    panel2.add(myButton);
                }
            }
            ++n2;
        }
        Aladin.trace(1, "Creating the main interface");
        panel2.setFont(LBOLD);
        this.cardView = new CardLayout();
        this.bigView = new Panel();
        this.bigView.setLayout(this.cardView);
        this.bigView.add("View", this.view);
        this.bigView.add("Help", this.help);
        Panel panel3 = new Panel();
        panel3.setLayout(new BorderLayout(0, 2));
        Aladin.makeAdd(panel3, panel2, "North");
        Aladin.makeAdd(panel3, panel, "South");
        Panel panel4 = new Panel();
        panel4.setLayout(new BorderLayout());
        Aladin.makeAdd(panel4, this.logo, "West");
        Aladin.makeAdd(panel4, panel3, "Center");
        object = new Panel();
        ((Container)object).setLayout(new BorderLayout(5, 0));
        Aladin.makeAdd((Container)object, this.toolbox, "West");
        Aladin.makeAdd((Container)object, this.calque, "Center");
        accessible = new Panel();
        ((Container)((Object)accessible)).setLayout(new BorderLayout());
        Aladin.makeAdd((Container)((Object)accessible), this.status, "Center");
        Aladin.makeAdd((Container)((Object)accessible), this.split, "East");
        this.mesurePanel = new Panel();
        this.mesurePanel.setLayout(new BorderLayout(0, 2));
        Aladin.makeAdd(this.mesurePanel, (Component)((Object)accessible), "North");
        Aladin.makeAdd(this.mesurePanel, this.mesure, "Center");
        Aladin.makeAdd(this.mesurePanel, this.urlStatus, "South");
        this.setLayout(new BorderLayout(5, 0));
        Aladin.makeAdd(this, panel4, "North");
        Aladin.makeAdd(this, (Component)object, "East");
        Aladin.makeAdd(this, this.bigView, "Center");
        Aladin.makeAdd(this, this.mesurePanel, "South");
        n = this.co.creatLastObj() ? 1 : 0;
        this.msgOn = true;
        this.help.setText(n != 0 ? this.logo.inProgress() : this.logo.Help());
        this.cardView.show(this.bigView, "Help");
        if (!STANDALONE && this.extApp == null) {
            this.dimOrigSize = new Dimension(this.size());
            this.myParent = this.getParent();
        }
        speed = Aladin.getSpeed();
        boolean bl = isSlow = !STANDALONE && speed > 800L;
        if (isSlow) {
            Aladin.trace(1, "Slow JVM detected");
        }
        Date date = new Date();
        String string = "\nThe HTTP requests will be resolved ";
        string = String.valueOf(string) + (!STANDALONE ? "remotely by the applet server GLU system." : (Glu.GLUFILTER != null ? "by " + Glu.GLUFILTER + "." : "by the inside JAVA GLU resolver."));
        String string2 = System.getProperty("os.name");
        String string3 = System.getProperty("os.arch");
        String string4 = System.getProperty("os.version");
        String string5 = System.getProperty("java.version");
        String string6 = System.getProperty("java.vendor");
        this.glu.log("Start", String.valueOf(STANDALONE ? "standalone " : "applet ") + VERSION + " perf=" + speed + " java=" + string5 + "/" + string6 + " syst=" + string2 + "/" + string3 + "/" + string4);
        if (!flagLaunch) {
            System.out.println("Your JVM release is java " + string5 + " by " + string6);
            System.out.println("Your java machine performance is " + speed + " (lower is better)" + string);
        }
        boolean bl2 = JAVABEFORE118 = this.numJVMVersion(string5) < 118;
        if (STANDALONE && CONSOLE) {
            this.command.readStandardInput();
        }
    }

    private void testReseau() {
        if (!NETWORK || !STANDALONE) {
            return;
        }
        Aladin.trace(1, "Network test");
        NETWORK = false;
        try {
            InetAddress.getAllByName("aladin.u-strasbg.fr");
            NETWORK = true;
        }
        catch (Exception exception) {
            System.err.println("Network not ready : " + exception);
        }
    }

    protected void testVersion() {
        int n = this.numVersion(currentVersion);
        if (n == 0) {
            return;
        }
        int n2 = this.numVersion(VERSION);
    }

    static final void trace(int n, String string) {
        if (levelTrace >= n) {
            switch (n) {
                case 1: {
                    System.out.println("." + string + "...");
                    break;
                }
                case 2: {
                    System.out.println("- " + string);
                    break;
                }
                case 3: {
                    System.out.println("*** " + string);
                    break;
                }
            }
        }
    }

    protected void unDetach() {
        f.remove(this);
        f.dispose();
        Aladin.makeAdd(this.myParent, this, "Center");
        this.resize(this.dimOrigSize);
        this.myParent.show();
        this.bext.setLabel(MDCH1);
        this.bext.pop();
    }

    private static void usage() {
        System.out.println("Usage: Aladin [-local] [-script] [-trace] [filenames...]\n       Aladin -h\n\n       -local: without Internet access\n       -script: no graphical interface displayed (for script mode only)\n       -trace: trace mode for debugging purpose\n\n   The files specified in the command line can be :\n       - FITS images: \"fits\" or \"fits.gz\" or \"hfits\" extension\n       - Aladin Java backup : \"aj\" extension\n       - XML or TSV catalogs: the default.\n\n   Aladin is waiting script commands from standard input. Type\n   \"help\" to have the command list.\n\n   Aladin can be also started as an applet at this following\n   address: http://aladin.u-strasbg.fr/Aladin. It could be\n   launched with a starting configuration (\"script\" parameter name).\n   For instance: ...?script=get+aladin,vizier(usno2)+m1;grid+on\n\n   Aladin has been developped by P.Fernique - Centre de Donnees\n   astronomiques de Strasbourg - (C) 1998-2003 ULP/CNRS\n   Send questions and comments at question@simbad.u-strasbg.fr");
    }

    protected void waitDialog() {
        while (this.dialog == null || this.calque == null || this.calque.plan[0] == null) {
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
    }
}

