/*
 * Decompiled with CFR 0.152.
 */
package installer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;

public class VariableGridLayout
implements LayoutManager2,
Serializable {
    public static final int FIXED_NUM_ROWS = 1;
    public static final int FIXED_NUM_COLUMNS = 2;
    private int mode;
    private int size;
    private int hgap;
    private int vgap;
    private transient int nrows = -1;
    private transient int ncols = -1;
    private transient int[] row_heights = null;
    private transient int[] col_widths = null;

    public VariableGridLayout(int n, int n2, int n3, int n4) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("illegal mode; value is " + n);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("size cannot be zero or less; value is " + n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("hgap cannot be negative; value is " + n3);
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("vgap cannot be negative; value is " + n4);
        }
        this.mode = n;
        this.size = n2;
        this.hgap = n3;
        this.vgap = n4;
    }

    public VariableGridLayout(int n, int n2) {
        this(n, n2, 0, 0);
    }

    public VariableGridLayout() {
        this(1, 1, 0, 0);
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void addLayoutComponent(Component component, Object object) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getLayoutSize(container, 2);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getLayoutSize(container, 0);
    }

    public Dimension maximumLayoutSize(Container container) {
        return this.getLayoutSize(container, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            double d;
            int n2;
            int n3 = container.getComponentCount();
            if (n3 == 0) {
                return;
            }
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n5 < this.nrows) {
                n2 = 0;
                while (n2 < this.ncols) {
                    if (n6 >= n3) break;
                    Dimension dimension = container.getComponent(n6).getPreferredSize();
                    this.row_heights[n5] = Math.max(this.row_heights[n5], dimension.height);
                    this.col_widths[n2] = Math.max(this.col_widths[n2], dimension.width);
                    ++n2;
                    ++n6;
                }
                n4 += this.row_heights[n5];
                ++n5;
            }
            n2 = 0;
            int n7 = 0;
            while (n7 < this.ncols) {
                n2 += this.col_widths[n7];
                ++n7;
            }
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            int n8 = dimension.height - insets.top - insets.bottom - (this.nrows - 1) * this.vgap;
            int n9 = dimension.width - insets.left - insets.right - (this.ncols - 1) * this.hgap;
            if (n4 != n8) {
                d = (double)n8 / (double)n4;
                n = 0;
                while (n < this.nrows) {
                    this.row_heights[n] = (int)((double)this.row_heights[n] * d);
                    ++n;
                }
            }
            if (n2 != n9) {
                d = (double)n9 / (double)n2;
                n = 0;
                while (n < this.ncols) {
                    this.col_widths[n] = (int)((double)this.col_widths[n] * d);
                    ++n;
                }
            }
            int n10 = 0;
            int n11 = insets.top;
            n = 0;
            while (n10 < this.nrows) {
                int n12 = 0;
                int n13 = insets.left;
                while (n12 < this.ncols) {
                    if (n < n3) {
                        container.getComponent(n).setBounds(n13, n11, this.col_widths[n12], this.row_heights[n10]);
                    }
                    n13 += this.col_widths[n12] + this.hgap;
                    ++n12;
                    ++n;
                }
                n11 += this.row_heights[n10] + this.vgap;
                ++n10;
            }
        }
    }

    public void invalidateLayout(Container container) {
        int n = container.getComponentCount();
        int n2 = this.nrows;
        int n3 = this.ncols;
        if (this.mode == 1) {
            this.nrows = this.size;
            this.ncols = (n + this.nrows - 1) / this.nrows;
        } else {
            this.ncols = this.size;
            this.nrows = (n + this.ncols - 1) / this.ncols;
        }
        if (n2 != this.nrows) {
            this.row_heights = new int[this.nrows];
        }
        if (n3 != this.ncols) {
            this.col_widths = new int[this.ncols];
        }
    }

    public int getRows() {
        return this.nrows;
    }

    public int getColumns() {
        return this.ncols;
    }

    public String toString() {
        return this.getClass().getName() + "[mode=" + this.mode + ",size=" + this.size + ",hgap=" + this.hgap + ",vgap=" + this.vgap + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getLayoutSize(Container container, int n) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n2;
            int n3;
            int n4 = container.getComponentCount();
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            while (n7 < this.nrows) {
                n3 = 0;
                n2 = 0;
                while (n2 < this.ncols) {
                    if (n8 >= n4) break;
                    switch (n) {
                        case 0: {
                            n3 = Math.max(n3, container.getComponent((int)n8).getMinimumSize().height);
                            break;
                        }
                        case 1: {
                            n3 = Math.max(n3, container.getComponent((int)n8).getMaximumSize().height);
                            break;
                        }
                        default: {
                            n3 = Math.max(n3, container.getComponent((int)n8).getPreferredSize().height);
                        }
                    }
                    ++n2;
                    ++n8;
                }
                n5 += n3;
                ++n7;
            }
            n3 = 0;
            while (n3 < this.ncols) {
                n2 = 0;
                int n9 = 0;
                while (n9 < this.nrows) {
                    int n10 = n9 * this.ncols + n3;
                    if (n10 >= n4) break;
                    switch (n) {
                        case 0: {
                            n2 = Math.max(n2, container.getComponent((int)n10).getMinimumSize().width);
                            break;
                        }
                        case 1: {
                            n2 = Math.max(n2, container.getComponent((int)n10).getMaximumSize().width);
                            break;
                        }
                        default: {
                            n2 = Math.max(n2, container.getComponent((int)n10).getPreferredSize().width);
                        }
                    }
                    ++n9;
                }
                n6 += n2;
                ++n3;
            }
            Insets insets = container.getInsets();
            return new Dimension(n6 + insets.left + insets.right + (this.ncols - 1) * this.hgap, n5 + insets.top + insets.bottom + (this.nrows - 1) * this.vgap);
        }
    }
}

