/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.InvalidHeaderException;

public class TarHeader {
    public static final int NAMELEN = 100;
    public static final int MODELEN = 8;
    public static final int UIDLEN = 8;
    public static final int GIDLEN = 8;
    public static final int CHKSUMLEN = 8;
    public static final int SIZELEN = 12;
    public static final int MAGICLEN = 8;
    public static final int MODTIMELEN = 12;
    public static final int UNAMELEN = 32;
    public static final int GNAMELEN = 32;
    public static final int DEVLEN = 8;
    public static final byte LF_OLDNORM = 0;
    public static final byte LF_NORMAL = 48;
    public static final byte LF_LINK = 49;
    public static final byte LF_SYMLINK = 50;
    public static final byte LF_CHR = 51;
    public static final byte LF_BLK = 52;
    public static final byte LF_DIR = 53;
    public static final byte LF_FIFO = 54;
    public static final byte LF_CONTIG = 55;
    public static final String TMAGIC = "ustar";
    public static final String GNU_TMAGIC = "ustar  ";
    public StringBuffer name;
    public int mode;
    public int userId;
    public int groupId;
    public long size;
    public long modTime;
    public int checkSum;
    public byte linkFlag;
    public StringBuffer linkName;
    public StringBuffer magic = new StringBuffer("ustar");
    public StringBuffer userName;
    public StringBuffer groupName;
    public int devMajor;
    public int devMinor;

    public TarHeader() {
        this.name = new StringBuffer();
        this.linkName = new StringBuffer();
        String string = System.getProperty("user.name", "");
        if (string.length() > 31) {
            string = string.substring(0, 31);
        }
        this.userId = 0;
        this.groupId = 0;
        this.userName = new StringBuffer(string);
        this.groupName = new StringBuffer("");
    }

    public Object clone() {
        TarHeader tarHeader = null;
        try {
            tarHeader = (TarHeader)super.clone();
            tarHeader.name = this.name == null ? null : new StringBuffer(this.name.toString());
            tarHeader.mode = this.mode;
            tarHeader.userId = this.userId;
            tarHeader.groupId = this.groupId;
            tarHeader.size = this.size;
            tarHeader.modTime = this.modTime;
            tarHeader.checkSum = this.checkSum;
            tarHeader.linkFlag = this.linkFlag;
            tarHeader.linkName = this.linkName == null ? null : new StringBuffer(this.linkName.toString());
            tarHeader.magic = this.magic == null ? null : new StringBuffer(this.magic.toString());
            tarHeader.userName = this.userName == null ? null : new StringBuffer(this.userName.toString());
            tarHeader.groupName = this.groupName == null ? null : new StringBuffer(this.groupName.toString());
            tarHeader.devMajor = this.devMajor;
            tarHeader.devMinor = this.devMinor;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return tarHeader;
    }

    public String getName() {
        return this.name.toString();
    }

    public static long parseOctal(byte[] byArray, int n, int n2) throws InvalidHeaderException {
        long l = 0L;
        boolean bl = true;
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            if (byArray[n4] == 0) break;
            if (byArray[n4] == 32 || byArray[n4] == 48) {
                if (!bl) {
                    if (byArray[n4] == 32) break;
                }
            } else {
                bl = false;
                l = (l << 3) + (long)(byArray[n4] - 48);
            }
            ++n4;
        }
        return l;
    }

    public static StringBuffer parseName(byte[] byArray, int n, int n2) throws InvalidHeaderException {
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            if (byArray[n4] == 0) break;
            stringBuffer.append((char)byArray[n4]);
            ++n4;
        }
        return stringBuffer;
    }

    public static int getNameBytes(StringBuffer stringBuffer, byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2 && n3 < stringBuffer.length()) {
            byArray[n + n3] = (byte)stringBuffer.charAt(n3);
            ++n3;
        }
        while (n3 < n2) {
            byArray[n + n3] = 0;
            ++n3;
        }
        return n + n2;
    }

    public static int getOctalBytes(long l, byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        int n3 = n2 - 1;
        byArray[n + n3] = 0;
        byArray[n + --n3] = 32;
        --n3;
        if (l == 0L) {
            byArray[n + n3] = 48;
            --n3;
        } else {
            long l2 = l;
            while (n3 >= 0 && l2 > 0L) {
                byArray[n + n3] = (byte)(48 + (byte)(l2 & 7L));
                l2 >>= 3;
                --n3;
            }
        }
        while (n3 >= 0) {
            byArray[n + n3] = 32;
            --n3;
        }
        return n + n2;
    }

    public static int getLongOctalBytes(long l, byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2 + 1];
        TarHeader.getOctalBytes(l, byArray2, 0, n2 + 1);
        System.arraycopy(byArray2, 0, byArray, n, n2);
        return n + n2;
    }

    public static int getCheckSumOctalBytes(long l, byte[] byArray, int n, int n2) {
        TarHeader.getOctalBytes(l, byArray, n, n2);
        byArray[n + n2 - 1] = 32;
        byArray[n + n2 - 2] = 0;
        return n + n2;
    }
}

