/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.Install;
import installer.InstallThread;
import installer.OperatingSystem;
import installer.Progress;
import installer.VariableGridLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SwingInstall
extends JFrame {
    Install installer = new Install();
    OperatingSystem.OSTask[] osTasks = OperatingSystem.getOperatingSystem().getOSTasks(this.installer);
    String appName = this.installer.getProperty("app.name");
    String appVersion = this.installer.getProperty("app.version");
    JLabel caption;
    ChooseDirectory chooseDirectory;
    SelectComponents selectComponents;
    SwingProgress progress;
    JButton cancelButton;
    JButton prevButton;
    JButton nextButton;
    Component[] pages;
    int currentPage;
    private static final int PADDING = 12;

    public SwingInstall() {
        this.setTitle(this.appName + " " + this.appVersion + " installer");
        JPanel jPanel = new JPanel(new WizardLayout());
        this.setContentPane(jPanel);
        this.caption = new JLabel();
        this.caption.setFont(new Font("SansSerif", 1, 18));
        ActionHandler actionHandler = new ActionHandler();
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setRequestFocusEnabled(false);
        this.cancelButton.addActionListener(actionHandler);
        this.prevButton = new JButton("Previous");
        this.prevButton.setRequestFocusEnabled(false);
        this.prevButton.addActionListener(actionHandler);
        this.nextButton = new JButton();
        this.nextButton.setRequestFocusEnabled(false);
        this.nextButton.addActionListener(actionHandler);
        jPanel.add(this.caption);
        jPanel.add(this.cancelButton);
        jPanel.add(this.prevButton);
        jPanel.add(this.nextButton);
        String string = OperatingSystem.getOperatingSystem().getClass().getName();
        String string2 = "done-" + string.substring(string.indexOf(36) + 1) + ".html";
        Component[] componentArray = new Component[6];
        componentArray[0] = new TextPanel(this.installer.getProperty("app.readme"));
        componentArray[1] = new TextPanel(this.installer.getProperty("app.license"));
        this.chooseDirectory = new ChooseDirectory();
        componentArray[2] = this.chooseDirectory;
        this.selectComponents = new SelectComponents();
        componentArray[3] = this.selectComponents;
        this.progress = new SwingProgress();
        componentArray[4] = this.progress;
        componentArray[5] = new TextPanel(string2);
        this.pages = componentArray;
        int n = 0;
        while (n < this.pages.length) {
            jPanel.add(this.pages[n]);
            ++n;
        }
        this.pageChanged();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowHandler());
        Dimension dimension = this.getToolkit().getScreenSize();
        this.pack();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
    }

    void install() {
        Object object;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        JPanel jPanel = this.selectComponents.comp;
        Vector vector2 = this.selectComponents.filesets;
        int n2 = 0;
        while (n2 < jPanel.getComponentCount()) {
            if (((JCheckBox)jPanel.getComponent(n2)).getModel().isSelected()) {
                n += this.installer.getIntegerProperty("comp." + vector2.elementAt(n2) + ".real-size");
                vector.addElement(this.installer.getProperty("comp." + vector2.elementAt(n2) + ".fileset"));
            }
            ++n2;
        }
        String string = this.chooseDirectory.installDir.getText();
        Map map = this.chooseDirectory.osTaskDirs;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            object = (OperatingSystem.OSTask)iterator.next();
            String string2 = ((JTextField)map.get(object)).getText();
            if (string2 != null && string2.length() != 0) {
                ((OperatingSystem.OSTask)object).setEnabled(true);
                ((OperatingSystem.OSTask)object).setDirectory(string2);
                continue;
            }
            ((OperatingSystem.OSTask)object).setEnabled(false);
        }
        object = new InstallThread(this.installer, this.progress, string, this.osTasks, n, vector);
        this.progress.setThread((InstallThread)object);
        ((Thread)object).start();
    }

    private void pageChanged() {
        switch (this.currentPage) {
            case 0: {
                this.caption.setText("Installing " + this.appName);
                this.nextButton.setText("Next");
                this.prevButton.setEnabled(false);
                break;
            }
            case 1: {
                this.caption.setText(this.installer.getProperty("app.license.title"));
                this.nextButton.setText("Next");
                this.prevButton.setEnabled(true);
                break;
            }
            case 2: {
                this.caption.setText("Specify where " + this.appName + " is to be installed");
                this.nextButton.setText("Next");
                this.prevButton.setEnabled(true);
                break;
            }
            case 3: {
                this.caption.setText("Choose components to install");
                this.nextButton.setText("Install");
                this.prevButton.setEnabled(true);
                break;
            }
            case 4: {
                this.caption.setText("Installing " + this.appName);
                this.nextButton.setText("Finish");
                this.prevButton.setEnabled(false);
                this.nextButton.setEnabled(false);
                this.install();
                break;
            }
            case 5: {
                this.caption.setText("Installation complete");
                this.nextButton.setText("Finish");
                this.prevButton.setEnabled(false);
                this.nextButton.setEnabled(true);
            }
        }
        this.getRootPane().invalidate();
        this.getRootPane().validate();
    }

    class SwingProgress
    extends JPanel
    implements Progress {
        JProgressBar progress = new JProgressBar();
        InstallThread thread;

        SwingProgress() {
            super(new BorderLayout());
            this.progress.setStringPainted(true);
            this.add("North", this.progress);
        }

        public void setMaximum(int n) {
            SwingUtilities.invokeLater(new Runnable(this, n){
                private final /* synthetic */ int val$max;
                private final /* synthetic */ SwingProgress this$1;
                {
                    this.this$1 = swingProgress;
                    this.val$max = n;
                }

                public void run() {
                    this.this$1.progress.setMaximum(this.val$max);
                }
            });
        }

        public void advance(int n) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(this, n){
                    private final /* synthetic */ int val$value;
                    private final /* synthetic */ SwingProgress this$1;
                    {
                        this.this$1 = swingProgress;
                        this.val$value = n;
                    }

                    public void run() {
                        this.this$1.progress.setValue(this.this$1.progress.getValue() + this.val$value);
                    }
                });
                Thread.yield();
            }
            catch (Exception exception) {}
        }

        public void done() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ SwingProgress this$1;
                {
                    this.this$1 = swingProgress;
                }

                public void run() {
                    ++SwingProgress.access$200((SwingProgress)this.this$1).currentPage;
                    SwingInstall.access$000(SwingProgress.access$200(this.this$1));
                }
            });
        }

        public void error(String string) {
            SwingUtilities.invokeLater(new Runnable(this, string){
                private final /* synthetic */ String val$message;
                private final /* synthetic */ SwingProgress this$1;
                {
                    this.this$1 = swingProgress;
                    this.val$message = string;
                }

                public void run() {
                    SwingProgress.access$200(this.this$1).dispose();
                    JOptionPane.showMessageDialog(null, this.val$message, "Installation aborted", 0);
                    System.exit(1);
                }
            });
        }

        public void setThread(InstallThread installThread) {
            this.thread = installThread;
        }

        static /* synthetic */ SwingInstall access$200(SwingProgress swingProgress) {
            return swingProgress.SwingInstall.this;
        }
    }

    class SelectComponents
    extends JPanel
    implements ActionListener {
        JPanel comp = this.createCompPanel();
        JLabel sizeLabel;
        Vector filesets;

        SelectComponents() {
            super(new BorderLayout());
            this.add("North", this.comp);
            this.sizeLabel = new JLabel("", 2);
            this.add("South", this.sizeLabel);
            this.updateSize();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.updateSize();
        }

        private JPanel createCompPanel() {
            Object object;
            this.filesets = new Vector();
            int n = SwingInstall.this.installer.getIntegerProperty("comp.count");
            JPanel jPanel = new JPanel(new GridLayout(n, 1));
            String string = OperatingSystem.getOperatingSystem().getClass().getName();
            string = string.substring(string.indexOf(36) + 1);
            int n2 = 0;
            while (n2 < n) {
                object = SwingInstall.this.installer.getProperty("comp." + n2 + ".os");
                if (object == null || string.equals(object)) {
                    JCheckBox jCheckBox = new JCheckBox(SwingInstall.this.installer.getProperty("comp." + n2 + ".name") + " (" + SwingInstall.this.installer.getProperty("comp." + n2 + ".disk-size") + "Kb)");
                    jCheckBox.getModel().setSelected(true);
                    jCheckBox.addActionListener(this);
                    jCheckBox.setRequestFocusEnabled(false);
                    this.filesets.addElement(new Integer(n2));
                    jPanel.add(jCheckBox);
                }
                ++n2;
            }
            object = jPanel.getPreferredSize();
            ((Dimension)object).width = Integer.MAX_VALUE;
            jPanel.setMaximumSize((Dimension)object);
            return jPanel;
        }

        private void updateSize() {
            int n = 0;
            int n2 = 0;
            while (n2 < this.filesets.size()) {
                if (((JCheckBox)this.comp.getComponent(n2)).getModel().isSelected()) {
                    n += SwingInstall.this.installer.getIntegerProperty("comp." + this.filesets.elementAt(n2) + ".disk-size");
                }
                ++n2;
            }
            this.sizeLabel.setText("Estimated disk usage of selected components: " + n + "Kb");
        }
    }

    class ChooseDirectory
    extends JPanel {
        JTextField installDir;
        Map osTaskDirs = new HashMap();

        ChooseDirectory() {
            super(new BorderLayout());
            JPanel jPanel = new JPanel(new VariableGridLayout(2, 3, 12, 12));
            this.installDir = this.addField(jPanel, "Install program in:", OperatingSystem.getOperatingSystem().getInstallDirectory(SwingInstall.this.appName, SwingInstall.this.appVersion));
            int n = 0;
            while (n < SwingInstall.this.osTasks.length) {
                OperatingSystem.OSTask oSTask = SwingInstall.this.osTasks[n];
                String string = oSTask.getLabel();
                if (string != null) {
                    JTextField jTextField = this.addField(jPanel, string, oSTask.getDirectory());
                    this.osTaskDirs.put(oSTask, jTextField);
                }
                ++n;
            }
            this.add("North", jPanel);
        }

        private JTextField addField(JPanel jPanel, String string, String string2) {
            JTextField jTextField = new JTextField(string2);
            jPanel.add(new JLabel(string, 4));
            Box box = new Box(1);
            box.add(Box.createGlue());
            Dimension dimension = jTextField.getPreferredSize();
            dimension.width = Integer.MAX_VALUE;
            jTextField.setMaximumSize(dimension);
            box.add(jTextField);
            box.add(Box.createGlue());
            jPanel.add(box);
            JButton jButton = new JButton("Choose...");
            jButton.setRequestFocusEnabled(false);
            jButton.addActionListener(new ActionHandler(jTextField));
            jPanel.add(jButton);
            return jTextField;
        }

        class ActionHandler
        implements ActionListener {
            JTextField field;

            ActionHandler(JTextField jTextField) {
                this.field = jTextField;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                File file = new File(this.field.getText());
                JFileChooser jFileChooser = new JFileChooser(file.getParent());
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setSelectedFile(file);
                if (jFileChooser.showOpenDialog(SwingInstall.this) == 0) {
                    this.field.setText(jFileChooser.getSelectedFile().getPath());
                }
            }
        }
    }

    class TextPanel
    extends JPanel {
        TextPanel(String string) {
            super(new BorderLayout());
            JEditorPane jEditorPane = new JEditorPane();
            try {
                jEditorPane.setPage(this.getClass().getResource(string));
            }
            catch (Exception exception) {
                jEditorPane.setText("Error loading '" + string + "'");
                exception.printStackTrace();
            }
            jEditorPane.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(jEditorPane);
            Dimension dimension = new Dimension();
            dimension.width = 450;
            dimension.height = 200;
            jScrollPane.setPreferredSize(dimension);
            this.add("Center", jScrollPane);
        }
    }

    class WizardLayout
    implements LayoutManager {
        WizardLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = new Dimension();
            Dimension dimension2 = SwingInstall.this.caption.getPreferredSize();
            dimension.width = dimension2.width;
            int n = 0;
            while (n < SwingInstall.this.pages.length) {
                Dimension dimension3 = SwingInstall.this.pages[n].getPreferredSize();
                dimension.width = Math.max(dimension3.width, dimension.width);
                dimension.height = Math.max(dimension3.height, dimension.height);
                ++n;
            }
            dimension.width += 24;
            dimension.height += 24;
            dimension.height += SwingInstall.this.nextButton.getPreferredSize().height;
            dimension.height += dimension2.height;
            return dimension;
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            Dimension dimension = container.getSize();
            Dimension dimension2 = SwingInstall.this.caption.getPreferredSize();
            SwingInstall.this.caption.setBounds(12, 12, dimension2.width, dimension2.height);
            Dimension dimension3 = SwingInstall.this.cancelButton.getPreferredSize();
            dimension3.width = Math.max(dimension3.width, SwingInstall.this.prevButton.getPreferredSize().width);
            dimension3.width = Math.max(dimension3.width, SwingInstall.this.nextButton.getPreferredSize().width);
            SwingInstall.this.cancelButton.setBounds(12, dimension.height - dimension3.height - 12, dimension3.width, dimension3.height);
            SwingInstall.this.prevButton.setBounds(dimension.width - dimension3.width * 2 - 6 - 12, dimension.height - dimension3.height - 12, dimension3.width, dimension3.height);
            SwingInstall.this.nextButton.setBounds(dimension.width - dimension3.width - 12, dimension.height - dimension3.height - 12, dimension3.width, dimension3.height);
            Rectangle rectangle = new Rectangle();
            rectangle.x = 12;
            rectangle.y = 24 + dimension2.height;
            rectangle.width = dimension.width - rectangle.x - 12;
            rectangle.height = dimension.height - dimension3.height - rectangle.y - 24;
            int n = 0;
            while (n < SwingInstall.this.pages.length) {
                Component component = SwingInstall.this.pages[n];
                component.setBounds(rectangle);
                component.setVisible(n == SwingInstall.this.currentPage);
                ++n;
            }
        }
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == SwingInstall.this.cancelButton) {
                System.exit(0);
            } else if (object == SwingInstall.this.prevButton) {
                --SwingInstall.this.currentPage;
                SwingInstall.this.pageChanged();
            } else if (object == SwingInstall.this.nextButton) {
                if (SwingInstall.this.currentPage == SwingInstall.this.pages.length - 1) {
                    System.exit(0);
                } else {
                    ++SwingInstall.this.currentPage;
                    SwingInstall.this.pageChanged();
                }
            }
        }
    }
}

