/*
 * Decompiled with CFR 0.152.
 */
package voi.vowrite;

import java.io.PrintStream;
import voi.vowrite.VOTable;
import voi.vowrite.VOTableCoosys;
import voi.vowrite.VOTableDefinitions;
import voi.vowrite.VOTableField;
import voi.vowrite.VOTableInfo;
import voi.vowrite.VOTableLink;
import voi.vowrite.VOTableMax;
import voi.vowrite.VOTableMin;
import voi.vowrite.VOTableOption;
import voi.vowrite.VOTableParam;
import voi.vowrite.VOTableResource;
import voi.vowrite.VOTableTable;
import voi.vowrite.VOTableValues;
import voi.vowrite.xmlEncodeString;

public class VOTableStreamWriter {
    private PrintStream _prnStream;
    private int resSpaceCnt;
    private int tableSpaceCnt;
    private xmlEncodeString[] xmlString;
    private final int _numOfXmlStrings = 4;

    public VOTableStreamWriter(PrintStream printStream) {
        this._prnStream = printStream;
        this.xmlString = new xmlEncodeString[4];
        int n = 0;
        while (n < 4) {
            this.xmlString[n] = new xmlEncodeString();
            ++n;
        }
        this.xmlString[0].toReplace = (char)38;
        this.xmlString[0].withReplace = "&amp;";
        this.xmlString[1].toReplace = (char)60;
        this.xmlString[1].withReplace = "&lt;";
        this.xmlString[2].toReplace = (char)62;
        this.xmlString[2].withReplace = "&gt;";
        this.xmlString[3].toReplace = (char)34;
        this.xmlString[3].withReplace = "&quot;";
    }

    public void writeVOTable(VOTable vOTable) {
        if (vOTable == null) {
            return;
        }
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\"?>");
        stringBuffer.append("\n<!DOCTYPE VOTABLE SYSTEM \"http://us-vo.org/xml/VOTable.dtd\">");
        stringBuffer.append("\n<VOTABLE  ");
        if (null != vOTable.getID() && vOTable.getID().length() > 0) {
            stringBuffer.append("ID=\"");
            stringBuffer.append(this.xmlEncoder(vOTable.getID()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTable.getVersion() && vOTable.getVersion().length() > 0) {
            stringBuffer.append("version=\"");
            stringBuffer.append(this.xmlEncoder(vOTable.getVersion()));
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        if (null != vOTable.getDescription() && vOTable.getDescription().length() > 0) {
            stringBuffer.append("\n   <DESCRIPTION>\n   ");
            stringBuffer.append(this.xmlEncoder(vOTable.getDescription()));
            stringBuffer.append("\n   </DESCRIPTION>");
        }
        if (null != vOTable.getDefinitions()) {
            this.appendDefinitions(vOTable, stringBuffer, n + 1);
        }
        if (vOTable.getNumOfInfo() > 0) {
            int n2 = vOTable.getNumOfInfo();
            int n3 = 0;
            while (n3 < n2) {
                VOTableInfo vOTableInfo = vOTable.getInfo(n3);
                this.appendInfo(vOTableInfo, stringBuffer, n + 1);
                ++n3;
            }
        }
        this._prnStream.print(stringBuffer);
    }

    private void appendCoosys(VOTableCoosys vOTableCoosys, StringBuffer stringBuffer, int n) {
        if (vOTableCoosys == null) {
            return;
        }
        stringBuffer.append("\n");
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("   ");
            ++n2;
        }
        stringBuffer.append("<COOSYS ");
        if (null != vOTableCoosys.getID() && vOTableCoosys.getID().length() > 0) {
            stringBuffer.append("ID=\"");
            stringBuffer.append(this.xmlEncoder(vOTableCoosys.getID()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableCoosys.getEquinox() && vOTableCoosys.getEquinox().length() > 0) {
            stringBuffer.append("equinox=\"");
            stringBuffer.append(this.xmlEncoder(vOTableCoosys.getEquinox()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableCoosys.getEpoch() && vOTableCoosys.getEpoch().length() > 0) {
            stringBuffer.append("epoch=\"");
            stringBuffer.append(this.xmlEncoder(vOTableCoosys.getEpoch()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableCoosys.getSystem() && vOTableCoosys.getSystem().length() > 0) {
            stringBuffer.append("system=\"");
            stringBuffer.append(this.xmlEncoder(vOTableCoosys.getSystem()));
            stringBuffer.append("\"");
        }
        stringBuffer.append("/>");
    }

    private void appendInfo(VOTableInfo vOTableInfo, StringBuffer stringBuffer, int n) {
        if (vOTableInfo == null) {
            return;
        }
        stringBuffer.append("\n");
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("   ");
            ++n2;
        }
        stringBuffer.append("<INFO ");
        if (null != vOTableInfo.getID() && vOTableInfo.getID().length() > 0) {
            stringBuffer.append("ID=\"");
            stringBuffer.append(this.xmlEncoder(vOTableInfo.getID()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableInfo.getName() && vOTableInfo.getName().length() > 0) {
            stringBuffer.append("name=\"");
            stringBuffer.append(this.xmlEncoder(vOTableInfo.getName()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableInfo.getValue() && vOTableInfo.getValue().length() > 0) {
            stringBuffer.append("value=\"");
            stringBuffer.append(this.xmlEncoder(vOTableInfo.getValue()));
            stringBuffer.append("\"");
        }
        stringBuffer.append("/>");
    }

    private void appendParam(VOTableParam vOTableParam, StringBuffer stringBuffer, int n) {
        int n2;
        if (vOTableParam == null) {
            return;
        }
        stringBuffer.append("\n");
        int n3 = 0;
        while (n3 < n) {
            stringBuffer.append("   ");
            ++n3;
        }
        stringBuffer.append("<PARAM ");
        if (null != vOTableParam.getId() && vOTableParam.getId().length() > 0) {
            stringBuffer.append("ID=\"");
            stringBuffer.append(this.xmlEncoder(vOTableParam.getId()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableParam.getUnit() && vOTableParam.getUnit().length() > 0) {
            stringBuffer.append("unit=\"");
            stringBuffer.append(this.xmlEncoder(vOTableParam.getUnit()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableParam.getDataType() && vOTableParam.getDataType().length() > 0) {
            stringBuffer.append("datatype=\"");
            stringBuffer.append(this.xmlEncoder(vOTableParam.getDataType()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableParam.getPrecision() && vOTableParam.getPrecision().length() > 0) {
            stringBuffer.append("precision=\"");
            stringBuffer.append(this.xmlEncoder(vOTableParam.getPrecision()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableParam.getWidth() && vOTableParam.getWidth().length() > 0) {
            stringBuffer.append("width=\"");
            stringBuffer.append(this.xmlEncoder(vOTableParam.getWidth()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableParam.getRef() && vOTableParam.getRef().length() > 0) {
            stringBuffer.append("ref=\"");
            stringBuffer.append(this.xmlEncoder(vOTableParam.getRef()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableParam.getName() && vOTableParam.getName().length() > 0) {
            stringBuffer.append("name=\"");
            stringBuffer.append(this.xmlEncoder(vOTableParam.getName()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableParam.getUcd() && vOTableParam.getUcd().length() > 0) {
            stringBuffer.append("ucd=\"");
            stringBuffer.append(this.xmlEncoder(vOTableParam.getUcd()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableParam.getValue() && vOTableParam.getValue().length() > 0) {
            stringBuffer.append("value=\"");
            stringBuffer.append(this.xmlEncoder(vOTableParam.getValue()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableParam.getArraySize() && vOTableParam.getArraySize().length() > 0) {
            stringBuffer.append("arraysize=\"");
            stringBuffer.append(this.xmlEncoder(vOTableParam.getArraySize()));
            stringBuffer.append("\"");
        }
        boolean bl = false;
        if (null != vOTableParam.getDescription() && vOTableParam.getDescription().length() > 0) {
            stringBuffer.append(">");
            stringBuffer.append("\n");
            int n4 = 0;
            while (n4 <= n) {
                stringBuffer.append("   ");
                ++n4;
            }
            stringBuffer.append("<DESCRIPTION>");
            stringBuffer.append(this.xmlEncoder(vOTableParam.getDescription()));
            stringBuffer.append("\n");
            n2 = 0;
            while (n2 <= n) {
                stringBuffer.append("   ");
                ++n2;
            }
            stringBuffer.append("</DESCRIPTION>");
            bl = true;
        }
        if (null != vOTableParam.getValues()) {
            if (!bl) {
                stringBuffer.append(">");
            }
            VOTableValues vOTableValues = vOTableParam.getValues();
            this.appendValues(vOTableValues, stringBuffer, n + 1);
            bl = true;
        }
        if (vOTableParam.getNumOfLink() > 0) {
            if (!bl) {
                stringBuffer.append(">");
            }
            int n5 = vOTableParam.getNumOfLink();
            n2 = 0;
            while (n2 < n5) {
                VOTableLink vOTableLink = vOTableParam.getLink(n2);
                this.appendLink(vOTableLink, stringBuffer, n + 1);
                ++n2;
            }
            bl = true;
        }
        if (!bl) {
            stringBuffer.append("/>");
        } else {
            stringBuffer.append("\n");
            int n6 = 0;
            while (n6 < n) {
                stringBuffer.append("   ");
                ++n6;
            }
            stringBuffer.append("</PARAM>");
        }
    }

    private void appendLink(VOTableLink vOTableLink, StringBuffer stringBuffer, int n) {
        if (vOTableLink == null) {
            return;
        }
        stringBuffer.append("\n");
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("   ");
            ++n2;
        }
        stringBuffer.append("<LINK ");
        if (null != vOTableLink.getId() && vOTableLink.getId().length() > 0) {
            stringBuffer.append("ID=\"");
            stringBuffer.append(this.xmlEncoder(vOTableLink.getId()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableLink.getContentRole() && vOTableLink.getContentRole().length() > 0) {
            stringBuffer.append("content-role=\"");
            stringBuffer.append(this.xmlEncoder(vOTableLink.getContentRole()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableLink.getContentType() && vOTableLink.getContentType().length() > 0) {
            stringBuffer.append("content-type=\"");
            stringBuffer.append(this.xmlEncoder(vOTableLink.getContentType()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableLink.getTitle() && vOTableLink.getTitle().length() > 0) {
            stringBuffer.append("title=\"");
            stringBuffer.append(this.xmlEncoder(vOTableLink.getTitle()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableLink.getValue() && vOTableLink.getValue().length() > 0) {
            stringBuffer.append("value=\"");
            stringBuffer.append(this.xmlEncoder(vOTableLink.getValue()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableLink.getHref() && vOTableLink.getHref().length() > 0) {
            stringBuffer.append("href=\"");
            stringBuffer.append(this.xmlEncoder(vOTableLink.getHref()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableLink.getGref() && vOTableLink.getGref().length() > 0) {
            stringBuffer.append("gref=\"");
            stringBuffer.append(this.xmlEncoder(vOTableLink.getGref()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableLink.getAction() && vOTableLink.getAction().length() > 0) {
            stringBuffer.append("action=\"");
            stringBuffer.append(this.xmlEncoder(vOTableLink.getAction()));
            stringBuffer.append("\"");
        }
        stringBuffer.append("/>");
    }

    private void appendValues(VOTableValues vOTableValues, StringBuffer stringBuffer, int n) {
        int n2;
        if (vOTableValues == null) {
            return;
        }
        stringBuffer.append("\n");
        int n3 = 0;
        while (n3 < n) {
            stringBuffer.append("   ");
            ++n3;
        }
        stringBuffer.append("<VALUES  ");
        if (null != vOTableValues.getId() && vOTableValues.getId().length() > 0) {
            stringBuffer.append("ID=\"");
            stringBuffer.append(this.xmlEncoder(vOTableValues.getId()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableValues.getType() && vOTableValues.getType().length() > 0) {
            stringBuffer.append("type=\"");
            stringBuffer.append(this.xmlEncoder(vOTableValues.getType()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableValues.getNull() && vOTableValues.getNull().length() > 0) {
            stringBuffer.append("null=\"");
            stringBuffer.append(this.xmlEncoder(vOTableValues.getNull()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableValues.getInvalid() && vOTableValues.getInvalid().length() > 0) {
            stringBuffer.append("invalid=\"");
            stringBuffer.append(this.xmlEncoder(vOTableValues.getInvalid()));
            stringBuffer.append("\"");
        }
        boolean bl = false;
        if (null != vOTableValues.getMin()) {
            stringBuffer.append(">");
            this.appendMin(vOTableValues, stringBuffer, n + 1);
            bl = true;
        }
        if (null != vOTableValues.getMax()) {
            if (!bl) {
                stringBuffer.append(">");
            }
            this.appendMax(vOTableValues, stringBuffer, n + 1);
            bl = true;
        }
        if (vOTableValues.getNumOfOptions() > 0) {
            if (!bl) {
                stringBuffer.append(">");
            }
            n2 = vOTableValues.getNumOfOptions();
            int n4 = 0;
            while (n4 < n2) {
                VOTableOption vOTableOption = vOTableValues.getOptions(n4);
                this.appendOptions(vOTableOption, stringBuffer, n + 1);
                ++n4;
            }
            bl = true;
        }
        if (!bl) {
            stringBuffer.append("/>");
        } else {
            stringBuffer.append("\n");
            n2 = 0;
            while (n2 < n) {
                stringBuffer.append("   ");
                ++n2;
            }
            stringBuffer.append("</VALUES>");
        }
    }

    private void appendMin(VOTableValues vOTableValues, StringBuffer stringBuffer, int n) {
        if (vOTableValues == null) {
            return;
        }
        stringBuffer.append("\n");
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("   ");
            ++n2;
        }
        stringBuffer.append("<MIN ");
        VOTableMin vOTableMin = vOTableValues.getMin();
        if (null != vOTableMin.getValue() && vOTableMin.getValue().length() > 0) {
            stringBuffer.append("value=\"");
            stringBuffer.append(this.xmlEncoder(vOTableMin.getValue()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableMin.getInclusive() && vOTableMin.getInclusive().length() > 0) {
            stringBuffer.append("inclusive=\"");
            stringBuffer.append(this.xmlEncoder(vOTableMin.getInclusive()));
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        stringBuffer.append(this.xmlEncoder(vOTableMin.getContent()));
        stringBuffer.append("\n");
        int n3 = 0;
        while (n3 < n) {
            stringBuffer.append("   ");
            ++n3;
        }
        stringBuffer.append("</MIN>");
    }

    private void appendMax(VOTableValues vOTableValues, StringBuffer stringBuffer, int n) {
        if (vOTableValues == null) {
            return;
        }
        stringBuffer.append("\n");
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("   ");
            ++n2;
        }
        stringBuffer.append("<MAX ");
        VOTableMax vOTableMax = vOTableValues.getMax();
        if (null != vOTableMax.getValue() && vOTableMax.getValue().length() > 0) {
            stringBuffer.append("value=\"");
            stringBuffer.append(this.xmlEncoder(vOTableMax.getValue()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableMax.getInclusive() && vOTableMax.getInclusive().length() > 0) {
            stringBuffer.append("inclusive=\"");
            stringBuffer.append(this.xmlEncoder(vOTableMax.getInclusive()));
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        stringBuffer.append(this.xmlEncoder(vOTableMax.getContent()));
        stringBuffer.append("\n");
        int n3 = 0;
        while (n3 < n) {
            stringBuffer.append("   ");
            ++n3;
        }
        stringBuffer.append("</MAX>");
    }

    private void appendOptions(VOTableOption vOTableOption, StringBuffer stringBuffer, int n) {
        int n2;
        if (vOTableOption == null) {
            return;
        }
        stringBuffer.append("\n");
        int n3 = 0;
        while (n3 < n) {
            stringBuffer.append("   ");
            ++n3;
        }
        stringBuffer.append("<OPTION ");
        if (null != vOTableOption.getName() && vOTableOption.getName().length() > 0) {
            stringBuffer.append("name=\"");
            stringBuffer.append(this.xmlEncoder(vOTableOption.getName()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableOption.getValue() && vOTableOption.getValue().length() > 0) {
            stringBuffer.append("value=\"");
            stringBuffer.append(this.xmlEncoder(vOTableOption.getValue()));
            stringBuffer.append("\"");
        }
        boolean bl = false;
        if (vOTableOption.getNumOfOptions() > 0) {
            stringBuffer.append(">");
            n2 = vOTableOption.getNumOfOptions();
            int n4 = 0;
            while (n4 < n2) {
                VOTableOption vOTableOption2 = vOTableOption.getOptions(n4);
                this.appendOptions(vOTableOption2, stringBuffer, n + 1);
                ++n4;
            }
            bl = true;
        }
        if (!bl) {
            stringBuffer.append("/>");
        } else {
            stringBuffer.append("\n");
            n2 = 0;
            while (n2 < n) {
                stringBuffer.append("   ");
                ++n2;
            }
            stringBuffer.append("</OPTION>");
        }
    }

    private void appendDefinitions(VOTable vOTable, StringBuffer stringBuffer, int n) {
        Object object;
        int n2;
        int n3;
        if (vOTable == null) {
            return;
        }
        VOTableDefinitions vOTableDefinitions = vOTable.getDefinitions();
        if (vOTableDefinitions == null) {
            return;
        }
        stringBuffer.append("\n");
        int n4 = 0;
        while (n4 < n) {
            stringBuffer.append("   ");
            ++n4;
        }
        stringBuffer.append("<DEFINITIONS>");
        if (vOTableDefinitions.getNumOfCoosys() > 0) {
            n3 = vOTableDefinitions.getNumOfCoosys();
            n2 = 0;
            while (n2 < n3) {
                object = vOTableDefinitions.getCOOSYS(n2);
                this.appendCoosys((VOTableCoosys)object, stringBuffer, n + 1);
                ++n2;
            }
        }
        if (vOTableDefinitions.getNumOfParam() > 0) {
            n3 = vOTableDefinitions.getNumOfParam();
            n2 = 0;
            while (n2 < n3) {
                object = vOTableDefinitions.getParam(n2);
                this.appendParam((VOTableParam)object, stringBuffer, n + 1);
                ++n2;
            }
        }
        stringBuffer.append("\n");
        n3 = 0;
        while (n3 < n) {
            stringBuffer.append("   ");
            ++n3;
        }
        stringBuffer.append("</DEFINITIONS>");
    }

    public void writeResource(VOTableResource vOTableResource) {
        Object object;
        int n;
        int n2;
        if (vOTableResource == null) {
            return;
        }
        ++this.resSpaceCnt;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        int n3 = 0;
        while (n3 < this.resSpaceCnt) {
            stringBuffer.append("   ");
            ++n3;
        }
        stringBuffer.append("<RESOURCE  ");
        if (null != vOTableResource.getName() && vOTableResource.getName().length() > 0) {
            stringBuffer.append("name=\"");
            stringBuffer.append(this.xmlEncoder(vOTableResource.getName()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableResource.getId() && vOTableResource.getId().length() > 0) {
            stringBuffer.append("ID=\"");
            stringBuffer.append(this.xmlEncoder(vOTableResource.getId()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableResource.getType() && vOTableResource.getType().length() > 0) {
            stringBuffer.append("type=\"");
            stringBuffer.append(this.xmlEncoder(vOTableResource.getType()));
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        if (null != vOTableResource.getDescription() && vOTableResource.getDescription().length() > 0) {
            stringBuffer.append("\n");
            n2 = 0;
            while (n2 <= this.resSpaceCnt) {
                stringBuffer.append("   ");
                ++n2;
            }
            stringBuffer.append("<DESCRIPTION>");
            stringBuffer.append(this.xmlEncoder(vOTableResource.getDescription()));
            stringBuffer.append("\n");
            n = 0;
            while (n <= this.resSpaceCnt) {
                stringBuffer.append("   ");
                ++n;
            }
            stringBuffer.append("</DESCRIPTION>");
        }
        if (vOTableResource.getNumOfInfo() > 0) {
            n2 = vOTableResource.getNumOfInfo();
            n = 0;
            while (n < n2) {
                object = vOTableResource.getInfo(n);
                this.appendInfo((VOTableInfo)object, stringBuffer, this.resSpaceCnt + 1);
                ++n;
            }
        }
        if (vOTableResource.getNumOfCoosys() > 0) {
            n2 = vOTableResource.getNumOfCoosys();
            n = 0;
            while (n < n2) {
                object = vOTableResource.getCOOSYS(n);
                this.appendCoosys((VOTableCoosys)object, stringBuffer, this.resSpaceCnt + 1);
                ++n;
            }
        }
        if (vOTableResource.getNumOfParam() > 0) {
            n2 = vOTableResource.getNumOfParam();
            n = 0;
            while (n < n2) {
                object = vOTableResource.getParam(n);
                this.appendParam((VOTableParam)object, stringBuffer, this.resSpaceCnt + 1);
                ++n;
            }
        }
        if (vOTableResource.getNumOfLink() > 0) {
            n2 = vOTableResource.getNumOfLink();
            n = 0;
            while (n < n2) {
                object = vOTableResource.getLink(n);
                this.appendLink((VOTableLink)object, stringBuffer, this.resSpaceCnt + 1);
                ++n;
            }
        }
        this._prnStream.print(stringBuffer);
    }

    public void writeTable(VOTableTable vOTableTable) {
        Object object;
        int n;
        int n2;
        if (vOTableTable == null) {
            return;
        }
        this.tableSpaceCnt = this.resSpaceCnt + 1;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        int n3 = 0;
        while (n3 < this.tableSpaceCnt) {
            stringBuffer.append("   ");
            ++n3;
        }
        stringBuffer.append("<TABLE ");
        if (null != vOTableTable.getId() && vOTableTable.getId().length() > 0) {
            stringBuffer.append("ID=\"");
            stringBuffer.append(this.xmlEncoder(vOTableTable.getId()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableTable.getName() && vOTableTable.getName().length() > 0) {
            stringBuffer.append("name=\"");
            stringBuffer.append(this.xmlEncoder(vOTableTable.getName()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableTable.getRef() && vOTableTable.getRef().length() > 0) {
            stringBuffer.append("ref=\"");
            stringBuffer.append(this.xmlEncoder(vOTableTable.getRef()));
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        if (null != vOTableTable.getDescription() && vOTableTable.getDescription().length() > 0) {
            stringBuffer.append("\n");
            n2 = 0;
            while (n2 <= this.tableSpaceCnt) {
                stringBuffer.append("   ");
                ++n2;
            }
            stringBuffer.append("<DESCRIPTION>");
            stringBuffer.append(this.xmlEncoder(vOTableTable.getDescription()));
            stringBuffer.append("\n");
            n = 0;
            while (n <= this.tableSpaceCnt) {
                stringBuffer.append("   ");
                ++n;
            }
            stringBuffer.append("</DESCRIPTION>");
        }
        if (vOTableTable.getNumOfField() > 0) {
            n2 = vOTableTable.getNumOfField();
            n = 0;
            while (n < n2) {
                object = vOTableTable.getField(n);
                this.appendField((VOTableField)object, stringBuffer, this.tableSpaceCnt + 1);
                ++n;
            }
        }
        if (vOTableTable.getNumOfLink() > 0) {
            n2 = vOTableTable.getNumOfLink();
            n = 0;
            while (n < n2) {
                object = vOTableTable.getLink(n);
                this.appendLink((VOTableLink)object, stringBuffer, this.tableSpaceCnt + 1);
                ++n;
            }
        }
        stringBuffer.append("\n");
        ++this.tableSpaceCnt;
        n2 = 0;
        while (n2 < this.tableSpaceCnt) {
            stringBuffer.append("   ");
            ++n2;
        }
        stringBuffer.append("<DATA>");
        stringBuffer.append("\n");
        ++this.tableSpaceCnt;
        n = 0;
        while (n < this.tableSpaceCnt) {
            stringBuffer.append("   ");
            ++n;
        }
        stringBuffer.append("<TABLEDATA>");
        this._prnStream.print(stringBuffer);
    }

    private void appendField(VOTableField vOTableField, StringBuffer stringBuffer, int n) {
        Object object;
        int n2;
        int n3;
        if (vOTableField == null) {
            return;
        }
        stringBuffer.append("\n");
        int n4 = 0;
        while (n4 < n) {
            stringBuffer.append("   ");
            ++n4;
        }
        stringBuffer.append("<FIELD ");
        if (null != vOTableField.getId() && vOTableField.getId().length() > 0) {
            stringBuffer.append("ID=\"");
            stringBuffer.append(this.xmlEncoder(vOTableField.getId()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableField.getUnit() && vOTableField.getUnit().length() > 0) {
            stringBuffer.append("unit=");
            String string = vOTableField.getUnit();
            if (string.charAt(0) != '\"') {
                stringBuffer.append("\"");
                stringBuffer.append(this.xmlEncoder(string));
            } else {
                stringBuffer.append("\"");
                stringBuffer.append(this.xmlEncoder(string.substring(1, string.length() - 1)));
            }
            stringBuffer.append("\"  ");
        }
        if (null != vOTableField.getDataType() && vOTableField.getDataType().length() > 0) {
            stringBuffer.append("datatype=\"");
            stringBuffer.append(this.xmlEncoder(vOTableField.getDataType()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableField.getPrecision() && vOTableField.getPrecision().length() > 0) {
            stringBuffer.append("precision=\"");
            stringBuffer.append(this.xmlEncoder(vOTableField.getPrecision()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableField.getWidth() && vOTableField.getWidth().length() > 0) {
            stringBuffer.append("width=\"");
            stringBuffer.append(this.xmlEncoder(vOTableField.getWidth()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableField.getRef() && vOTableField.getRef().length() > 0) {
            stringBuffer.append("ref=\"");
            stringBuffer.append(this.xmlEncoder(vOTableField.getRef()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableField.getName() && vOTableField.getName().length() > 0) {
            stringBuffer.append("name=\"");
            stringBuffer.append(this.xmlEncoder(vOTableField.getName()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableField.getUcd() && vOTableField.getUcd().length() > 0) {
            stringBuffer.append("ucd=\"");
            stringBuffer.append(this.xmlEncoder(vOTableField.getUcd()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableField.getArraySize() && vOTableField.getArraySize().length() > 0) {
            stringBuffer.append("arraysize=\"");
            stringBuffer.append(this.xmlEncoder(vOTableField.getArraySize()));
            stringBuffer.append("\"  ");
        }
        if (null != vOTableField.getType() && vOTableField.getType().length() > 0) {
            stringBuffer.append("type=\"");
            stringBuffer.append(this.xmlEncoder(vOTableField.getType()));
            stringBuffer.append("\"");
        }
        boolean bl = false;
        if (null != vOTableField.getDescription() && vOTableField.getDescription().length() > 0) {
            stringBuffer.append("> \n");
            n3 = 0;
            while (n3 <= n) {
                stringBuffer.append("   ");
                ++n3;
            }
            stringBuffer.append("<DESCRIPTION>");
            stringBuffer.append(this.xmlEncoder(vOTableField.getDescription()));
            stringBuffer.append("\n");
            n2 = 0;
            while (n2 <= n) {
                stringBuffer.append("   ");
                ++n2;
            }
            stringBuffer.append("</DESCRIPTION>");
            bl = true;
        }
        if (vOTableField.getNumOfValues() > 0) {
            stringBuffer.append(">");
            n3 = vOTableField.getNumOfValues();
            n2 = 0;
            while (n2 < n3) {
                object = vOTableField.getValues(n2);
                this.appendValues((VOTableValues)object, stringBuffer, n + 1);
                ++n2;
            }
            bl = true;
        }
        if (vOTableField.getNumOfLink() > 0) {
            if (!bl) {
                stringBuffer.append(">");
            }
            n3 = vOTableField.getNumOfLink();
            n2 = 0;
            while (n2 < n3) {
                object = vOTableField.getLink(n2);
                this.appendLink((VOTableLink)object, stringBuffer, n + 1);
                ++n2;
            }
            bl = true;
        }
        if (!bl) {
            stringBuffer.append("/>");
        } else {
            stringBuffer.append("\n");
            n3 = 0;
            while (n3 < n) {
                stringBuffer.append("   ");
                ++n3;
            }
            stringBuffer.append("</FIELD>");
        }
    }

    public void addRow(String[] stringArray, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        int n3 = 0;
        while (n3 < this.tableSpaceCnt) {
            stringBuffer.append("   ");
            ++n3;
        }
        stringBuffer.append("<TR>");
        int n4 = 0;
        while (n4 < n) {
            stringBuffer.append("\n");
            n2 = 0;
            while (n2 <= this.tableSpaceCnt) {
                stringBuffer.append("   ");
                ++n2;
            }
            stringBuffer.append("<TD>");
            stringBuffer.append(this.xmlEncoder(stringArray[n4]));
            stringBuffer.append("</TD>");
            ++n4;
        }
        stringBuffer.append("\n");
        n2 = 0;
        while (n2 < this.tableSpaceCnt) {
            stringBuffer.append("   ");
            ++n2;
        }
        stringBuffer.append("</TR>");
        this._prnStream.print(stringBuffer);
    }

    public void endTable() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        int n = 0;
        while (n < this.tableSpaceCnt) {
            stringBuffer.append("   ");
            ++n;
        }
        stringBuffer.append("</TABLEDATA>");
        --this.tableSpaceCnt;
        stringBuffer.append("\n");
        int n2 = 0;
        while (n2 < this.tableSpaceCnt) {
            stringBuffer.append("   ");
            ++n2;
        }
        stringBuffer.append("</DATA>");
        --this.tableSpaceCnt;
        stringBuffer.append("\n");
        int n3 = 0;
        while (n3 < this.tableSpaceCnt) {
            stringBuffer.append("   ");
            ++n3;
        }
        stringBuffer.append("</TABLE>");
        this._prnStream.print(stringBuffer);
    }

    public void endResource() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        int n = 0;
        while (n < this.resSpaceCnt) {
            stringBuffer.append("   ");
            ++n;
        }
        stringBuffer.append("</RESOURCE>");
        --this.resSpaceCnt;
        this._prnStream.print(stringBuffer);
    }

    public void endVOTable() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n</VOTABLE>\n");
        this._prnStream.print(stringBuffer);
        this._prnStream.flush();
    }

    public String xmlEncoder(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        int n = 0;
        while (n < string.length()) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.xmlString.length) {
                if (string.charAt(n) == this.xmlString[n2].toReplace) {
                    bl = true;
                    stringBuffer.append(this.xmlString[n2].withReplace);
                    break;
                }
                ++n2;
            }
            if (!bl) {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

