/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import com.jvt.applets.PlotVOApplet;
import com.jvt.utils.JVTUtil;
import com.jvt.votable.PlotColumn;
import com.jvt.votable.PlotData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import ptolemy.gui.CloseListener;
import ptolemy.gui.Query;
import ptolemy.gui.QueryListener;
import ptolemy.plot.ColumnExprParser;

public class PlotTransformerDialog
extends JDialog {
    public Component _contents;
    protected String _buttonPressed = "";
    private static String[] _buttons = new String[]{"Add", "Close", "Help"};
    private boolean _doneHandleClosing = false;
    private JOptionPane _optionPane;
    private JTextArea _messageArea;
    private PlotVOApplet _pva = null;
    private PlotData _pd = null;
    private Query _wideQuery;
    private JTable _table;
    private JScrollPane _scrollPane;
    private JPanel _transPanel;
    private static final int MAX_COL_DIGITS = 3;
    private static final String ORIGINAL_COLS_IN_VOTABLE = "Original";
    private static final short ERROR_NO_COL_NAME = 1;
    private static final short ERROR_COL_EXISTS = 2;
    private static final int DIALOGBOX_HEIGHT = 350;
    private static final int DIALOGBOX_WIDTH = 600;
    private static final String[] errorMessages;
    private static final String[] availableFunctions;

    public PlotTransformerDialog(Frame owner, PlotVOApplet pva) {
        super(owner, "Create new virtual columns", true);
        this.init(pva);
        this.addPanel(owner);
    }

    private void addPanel(Frame owner) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this._transPanel);
        this._contents = this._transPanel;
        this._wideQuery.requestFocus();
        this._optionPane = new JOptionPane(panel, 3, 1, null, _buttons, _buttons[0]);
        this._optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (PlotTransformerDialog.this.isVisible() && e.getSource() == PlotTransformerDialog.this._optionPane && (prop.equals("value") || prop.equals("inputValue"))) {
                    Object value = PlotTransformerDialog.this._optionPane.getValue();
                    if (value == JOptionPane.UNINITIALIZED_VALUE) {
                        return;
                    }
                    PlotTransformerDialog.this._optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                    if (value instanceof String) {
                        PlotTransformerDialog.this._buttonPressed = (String)value;
                    }
                    if (_buttons[0].equals(PlotTransformerDialog.this._buttonPressed)) {
                        if (!PlotTransformerDialog.this.applyChanges()) {
                            return;
                        }
                        PlotTransformerDialog.this._transPanel.removeAll();
                        PlotTransformerDialog.this.createColumnsTable();
                        PlotTransformerDialog.this._transPanel.invalidate();
                        PlotTransformerDialog.this._transPanel.validate();
                        return;
                    }
                    if (_buttons[2].equals(PlotTransformerDialog.this._buttonPressed)) {
                        JOptionPane.showMessageDialog(null, availableFunctions, "Help for creating new virtual columns", 1);
                        return;
                    }
                    ((Component)PlotTransformerDialog.this).setVisible(false);
                    PlotTransformerDialog.this._handleClosing();
                }
            }
        });
        this.getContentPane().add(this._optionPane);
        this.pack();
        this.setResizable(false);
        if (owner != null) {
            this.setLocationRelativeTo(owner);
        } else {
            Toolkit tk = Toolkit.getDefaultToolkit();
            ((Component)this).setLocation((tk.getScreenSize().width - this.getSize().width) / 2, (tk.getScreenSize().height - this.getSize().height) / 2);
        }
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                PlotTransformerDialog.this._handleClosing();
            }
        });
        ((Component)this).setSize(600, 350);
        ((Component)this).setVisible(true);
    }

    private void _handleClosing() {
        if (this._contents instanceof CloseListener && !this._doneHandleClosing) {
            this._doneHandleClosing = true;
            ((CloseListener)((Object)this._contents)).windowClosed(this, this._buttonPressed);
        }
    }

    private void init(PlotVOApplet pva) {
        this._pva = pva;
        this._pd = pva.getPlotData();
        this._transPanel = new JPanel();
        this.createColumnsTable();
    }

    private void createColumnsTable() {
        try {
            Vector<String> columnNames = new Vector<String>();
            columnNames.add("Column Id");
            columnNames.add("Column Name");
            columnNames.add("UCD");
            columnNames.add("Expression");
            Vector colInfo = new Vector();
            for (int i = 0; i < this._pd.getNumOfPlotColumns(); ++i) {
                Vector<String> row = new Vector<String>();
                row.add(String.valueOf(String.valueOf(new StringBuffer("$").append(i + 1))));
                PlotColumn pc = this._pd.getPlotColumn(i);
                row.add(pc.getName());
                row.add(pc.getUCD());
                String expr = pc.getExpression();
                if (expr == null || expr.trim().length() <= 0) {
                    expr = ORIGINAL_COLS_IN_VOTABLE;
                }
                row.add(expr);
                colInfo.add(row);
            }
            this._table = new JTable(colInfo, columnNames);
            this._table.setPreferredScrollableViewportSize(new Dimension(200, 160));
            this._scrollPane = new JScrollPane(this._table);
            this._scrollPane.setRequestFocusEnabled(false);
            this._transPanel.setLayout(new BorderLayout());
            this._transPanel.add((Component)this._scrollPane, "North");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this._wideQuery = new Query();
        this._wideQuery.requestFocus();
        this._transPanel.add((Component)this._wideQuery, "South");
        this._wideQuery.requestFocus();
        this._wideQuery.setTextWidth(20);
        String name = "";
        this._wideQuery.addLine("name", "Enter column name", name, "New column name");
        String expression = "";
        this._wideQuery.addLine("expr", "Enter expression", expression, "Expression for the new Column (e.g ($1+$2)*$3)");
        String unit = "";
        this._wideQuery.addLine("unit", "Enter unit", unit, "Unit (e.g deg)");
        this._wideQuery.addQueryListener(new QueryListener(){

            public void changed(String name) {
            }
        });
    }

    public static boolean addColumn(PlotVOApplet pva, String name, String unit, String expression) {
        PlotData pd = pva.getPlotData();
        PlotColumn newPC = new PlotColumn();
        int errorCode = PlotTransformerDialog.checkColNameValid(pd, name);
        if (errorCode > 0) {
            JOptionPane.showMessageDialog(null, errorMessages[errorCode], "Error", 0);
            return false;
        }
        newPC.setUnit(unit);
        newPC.setName(name);
        newPC.setDatatype("double");
        try {
            if (expression != null && expression.trim().length() <= 0) {
                JOptionPane.showMessageDialog(null, errorMessages[3], "Error", 0);
                boolean bl = false;
                return bl;
            }
            expression = expression.trim();
            newPC.setExpression(expression);
            ColumnExprParser cep = new ColumnExprParser(pd);
            if (!cep.parseAndEvaluate(expression, newPC)) {
                if (cep.getErrorCode() == 4) {
                    String colNumStr = cep.getColumnNumber();
                    JOptionPane.showMessageDialog(null, String.valueOf(String.valueOf(new StringBuffer("Invalid column number : $").append(colNumStr).append(". Please check the expression."))), "Error", 0);
                } else {
                    JOptionPane.showMessageDialog(null, errorMessages[cep.getErrorCode()], "Error", 0);
                }
                boolean bl = false;
                return bl;
            }
            newPC.setUserCreated(true);
            pd.addPlotColumn(newPC);
            pva.setPlotData(pd, false);
            JOptionPane.showMessageDialog(null, String.valueOf(String.valueOf(new StringBuffer("Created column '").append(newPC.getName()).append("' successfully."))), "Success", 1);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, errorMessages[5], "Error", 0);
            boolean bl = false;
            return bl;
        }
        return true;
    }

    private boolean applyChanges() {
        JVTUtil.showWaitCursor(this);
        boolean isSucessfulAdditon = PlotTransformerDialog.addColumn(this._pva, this._wideQuery.getStringValue("name"), this._wideQuery.getStringValue("unit"), this._wideQuery.getStringValue("expr"));
        JVTUtil.showDefaultCursor(this);
        return isSucessfulAdditon;
    }

    private void printColData(PlotColumn pc) {
        Double[] d = pc.getData();
        System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pc.getName()))).append(" data length = ").append(d.length))));
        for (int i = 0; i < d.length; ++i) {
            System.out.println(d[i].toString());
        }
        System.out.flush();
    }

    public static int checkColNameValid(PlotData pd, String name) {
        if (name == null || name.trim().length() <= 0) {
            return 1;
        }
        for (int i = 0; i < pd.getNumOfPlotColumns(); ++i) {
            if (!name.equals(pd.getPlotColumn(i).getName())) continue;
            return 2;
        }
        return 0;
    }

    static {
        MAX_COL_DIGITS = 3;
        ORIGINAL_COLS_IN_VOTABLE = ORIGINAL_COLS_IN_VOTABLE;
        ERROR_NO_COL_NAME = 1;
        ERROR_COL_EXISTS = (short)2;
        DIALOGBOX_HEIGHT = 350;
        DIALOGBOX_WIDTH = 600;
        errorMessages = new String[]{"", "No Column name. Please enter a column name.", "Column name already exists. Please enter another name.", "No expression entered. Please enter an expression.", "Invalid column number. Please enter a correct expression.", "Exception while parsing expression. Please check that the expression is correct."};
        availableFunctions = new String[]{" ", "Operators available for use in the Transformation Dialog Box    ", " ", "       ' + ',  ' - ',  ' * ',  ' / '  ", " ", "Functions available for use in the Transformation Dialog Box    ", " ", "       log(a)                          ln(a)", "       sqrt(a)                        pow(a,b)", "       dexp(a)                       exp(a)", "       cos(a)                         acos(a)", "       sin(a)                          asin(a)", "       tan(a)                          atan(a)", "       toradians(a)              todegrees(a)", " ", "For example, $1 + sin((3.14 * $2) / $2)", " "};
    }
}

