/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import com.jvt.applets.PlotButtons;
import com.jvt.applets.PlotVOApplet;
import com.jvt.statistics.StatsCalculator;
import com.jvt.utils.JVTUtil;
import com.jvt.votable.PlotColumn;
import com.jvt.votable.PlotData;
import com.jvt.votable.PlotFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import ptolemy.gui.CloseListener;
import ptolemy.gui.Query;
import ptolemy.plot.BoxPlot;
import ptolemy.plot.PlotBox;

public class PlotStatisticsDialog
extends JDialog {
    private Component _contents;
    private PlotVOApplet _pva;
    private PlotButtons _btns;
    private PlotData _pd;
    public static final String FILTER_LABEL = "filter";
    public static final String CALCULATE_LABEL = "Calculate";
    public static final String CLOSE_LABEL = "Close";
    public static final String BOXPLOT_LABEL = "Box Plot";
    private JPanel _basic;
    private JPanel _advanced;
    private JTabbedPane _tabbedBase;
    private JOptionPane _optionPane;
    private String _buttonPressed = "";
    private static Object[] _buttons;
    private boolean _doneHandleClosing = false;
    private String _selectedX;
    private String _selectedY;
    private String _selectedFilter;
    private Query _resultBasic = new Query();
    private Query _resultAdv = new Query();
    private JComboBox _filterCol = new JComboBox();
    private JComboBox _xCol = new JComboBox();
    private JComboBox _yCol = new JComboBox();
    private JComboBox _zCol = new JComboBox();
    private JComboBox _filterColB = new JComboBox();
    private JComboBox _xColB = new JComboBox();
    private JComboBox _yColB = new JComboBox();
    private JLabel _lblFilter = new JLabel("filter");
    private JLabel _lblX = new JLabel("X");
    private JLabel _lblY = new JLabel("Y");
    private JLabel _lblZ = new JLabel("Z");
    private JLabel _lblFilterB = new JLabel("filter");
    private JLabel _lblXB = new JLabel("X");
    private JLabel _lblYB = new JLabel("Y");
    private JPanel _panFilterlbl = new JPanel();
    private JPanel _panXlbl = new JPanel();
    private JPanel _panYlbl = new JPanel();
    private JPanel _panZlbl = new JPanel();
    private JPanel _panFilterCol = new JPanel();
    private JPanel _panXCol = new JPanel();
    private JPanel _panYCol = new JPanel();
    private JPanel _panZCol = new JPanel();
    private JPanel _panFilterlblB = new JPanel();
    private JPanel _panXlblB = new JPanel();
    private JPanel _panYlblB = new JPanel();
    private JPanel _panFilterColB = new JPanel();
    private JPanel _panXColB = new JPanel();
    private JPanel _panYColB = new JPanel();
    private JTextField _obsrvTxt = new JTextField("", 10);
    private JTextField _rangeTxt = new JTextField("", 10);
    private JTextField _minTxt = new JTextField("", 10);
    private JTextField _maxTxt = new JTextField("", 10);
    private JTextField _meanTxt = new JTextField("", 10);
    private JTextField _varTxt = new JTextField("", 10);
    private JTextField _stdevTxt = new JTextField("", 10);
    private JTextField _skewTxt = new JTextField("", 10);
    private JTextField _kurtTxt = new JTextField("", 10);
    private double[] X_X;
    private double[] X_Y;
    private double[] XY_X;
    private double[] XY_Y;
    private double[] XYZ_X;
    private double[] XYZ_Y;
    private double[] XYZ_Z;
    private ArrayList _dax1 = new ArrayList();
    private ArrayList _day1 = new ArrayList();
    private ArrayList _dax2 = new ArrayList();
    private ArrayList _dax3 = new ArrayList();
    private ArrayList _day2 = new ArrayList();
    private ArrayList _day3 = new ArrayList();
    private ArrayList _daz3 = new ArrayList();
    private String _filter;
    private String _colX;
    private String _colY;
    private String _colZ;
    private boolean _histogram;
    private double[] _xRange;
    private double[] _yRange = new double[2];
    private double _minX;
    private double _maxX;
    private double _minY;
    private double _maxY;
    private JRadioButton _entireData;
    private JRadioButton _plotData;
    private JRadioButton _selectedData;
    private ButtonGroup _radioButtonGroup;
    private JPanel _radioButtonsPanel;
    private static final String ENTIRE_DATA_LABEL = "Entire Data";
    private static final String PLOT_DATA_LABEL = "Only Plot Data";
    private static final String SELECTED_DATA_LABEL = "Only Selected Point Data";
    private Double[] dataX;
    private Double[] dataY;
    private Double[] dataZ;
    private ArrayList selectedIndexs;
    protected final PlotBox _plot;

    public PlotStatisticsDialog(PlotBox plot, Frame owner, PlotVOApplet pa, PlotButtons butt) {
        super(owner, "Plot Statistics", true);
        this._plot = plot;
        this._pva = pa;
        this._btns = butt;
        this.init(this._plot, this._pva);
        this.addPanel(owner);
    }

    public void init(PlotBox _plot, PlotVOApplet _pva) {
        this._basic = new JPanel();
        this._advanced = new JPanel();
        this._tabbedBase = new JTabbedPane();
        JPanel _colsBasic = new JPanel();
        JPanel _funcsBasic = new JPanel();
        JPanel _colsAdv = new JPanel();
        JPanel _funcsAdv = new JPanel();
        JPanel _resultBasicY = new JPanel();
        JPanel _panE = new JPanel();
        JPanel _panX = new JPanel();
        JPanel _panY = new JPanel();
        JPanel _panEXY = new JPanel();
        JLabel _X = new JLabel("X ");
        JLabel _Y = new JLabel("Y ");
        String[] fields = _pva.getColumnNames();
        this._selectedX = this._btns.getSelectedXColumn();
        this._selectedY = this._btns.getSelectedYColumn();
        for (int i = 0; i < _pva.getNumOfColumns(); ++i) {
            this._xCol.addItem(fields[i]);
            this._yCol.addItem(fields[i]);
            this._zCol.addItem(fields[i]);
            this._xColB.addItem(fields[i]);
            this._yColB.addItem(fields[i]);
            if (this._selectedX.equals(fields[i])) {
                this._xCol.setSelectedIndex(i);
                this._xColB.setSelectedIndex(i);
            }
            if (!this._selectedY.equals(fields[i])) continue;
            this._yCol.setSelectedIndex(i);
            this._yColB.setSelectedIndex(i);
        }
        this._xCol.addActionListener(new ComboListener());
        this._xColB.addActionListener(new ComboListener());
        this._yCol.addActionListener(new ComboListener());
        this._yColB.addActionListener(new ComboListener());
        String[] filters = _pva.getFilterNames();
        this._selectedFilter = this._btns.getSelectedFilter();
        for (int i = 0; i < filters.length; ++i) {
            this._filterCol.addItem(filters[i]);
            this._filterColB.addItem(filters[i]);
            if (!this._selectedFilter.equals(filters[i])) continue;
            this._filterCol.setSelectedIndex(i);
            this._filterColB.setSelectedIndex(i);
        }
        this._filterCol.addActionListener(new ComboListener());
        this._filterColB.addActionListener(new ComboListener());
        this._xCol.setMaximumRowCount(6);
        this._yCol.setMaximumRowCount(6);
        this._zCol.setMaximumRowCount(6);
        this._filterCol.setMaximumRowCount(6);
        this._filterColB.setMaximumRowCount(6);
        this._xColB.setMaximumRowCount(6);
        this._yColB.setMaximumRowCount(6);
        this._panFilterlblB.add(this._lblFilterB);
        this._panXlblB.add(this._lblXB);
        this._panYlblB.add(this._lblYB);
        this._panFilterColB.add(this._filterColB);
        this._panXColB.add(this._xColB);
        this._panYColB.add(this._yColB);
        _colsBasic.setLayout(new FlowLayout(1, 2, 2));
        _colsBasic.add(this._panFilterlblB);
        _colsBasic.add(this._panFilterColB);
        _colsBasic.add(this._panXlblB);
        _colsBasic.add(this._panXColB);
        _colsBasic.add(this._panYlblB);
        _colsBasic.add(this._panYColB);
        this._resultBasic.setTextWidth(9);
        this._resultBasic.addLine("obsrv", "No of observations", "");
        this._resultBasic.addLine("rang", "Range ", "");
        this._resultBasic.addLine("min", "Minimum ", "");
        this._resultBasic.addLine("max", "Maximum ", "");
        this._resultBasic.addLine("mean", "Mean ", "");
        this._resultBasic.addLine("var", "Variance ", "");
        this._resultBasic.addLine("stdev", "Standard deviation ", "");
        this._resultBasic.addLine("skew", "Skew ", "");
        this._resultBasic.addLine("kurt", "Kurtosis ", "");
        _resultBasicY.setLayout(new BoxLayout(_resultBasicY, 1));
        _resultBasicY.add(this._obsrvTxt);
        _resultBasicY.add(this._rangeTxt);
        _resultBasicY.add(this._minTxt);
        _resultBasicY.add(this._maxTxt);
        _resultBasicY.add(this._meanTxt);
        _resultBasicY.add(this._varTxt);
        _resultBasicY.add(this._stdevTxt);
        _resultBasicY.add(this._skewTxt);
        _resultBasicY.add(this._kurtTxt);
        _funcsBasic.setLayout(new FlowLayout(1, 1, 3));
        _funcsBasic.add(this._resultBasic);
        _funcsBasic.add(_resultBasicY);
        _panX.add(_X);
        _panX.setPreferredSize(new Dimension(20, 20));
        _panY.add(_Y);
        _panY.setPreferredSize(new Dimension(230, 20));
        _panEXY.setLayout(new FlowLayout(2, 0, 3));
        _panEXY.setPreferredSize(new Dimension(400, 25));
        _panEXY.add(_panX);
        _panEXY.add(_panY);
        this.setModal(true);
        this._basic.setLayout(new BorderLayout());
        this._basic.add((Component)_colsBasic, "North");
        this._basic.add((Component)_panEXY, "Center");
        this._basic.add((Component)_funcsBasic, "South");
        this._panFilterlbl.add(this._lblFilter);
        this._panXlbl.add(this._lblX);
        this._panYlbl.add(this._lblY);
        this._panZlbl.add(this._lblZ);
        this._panFilterCol.add(this._filterCol);
        this._panXCol.add(this._xCol);
        this._panYCol.add(this._yCol);
        this._panZCol.add(this._zCol);
        _colsAdv.setLayout(new FlowLayout(1, 2, 2));
        _colsAdv.add(this._panFilterlbl);
        _colsAdv.add(this._panFilterCol);
        _colsAdv.add(this._panXlbl);
        _colsAdv.add(this._panXCol);
        _colsAdv.add(this._panYlbl);
        _colsAdv.add(this._panYCol);
        _colsAdv.add(this._panZlbl);
        _colsAdv.add(this._panZCol);
        this._resultAdv.addLine("cor", "Linear correlation of X & Y", "");
        this._resultAdv.addLine("signi", "   - Significance(t)", "");
        this._resultAdv.addLine("prob", "   - Probablity", "");
        this._resultAdv.addLine("rnk", "Rank Correlation of X & Y", "");
        this._resultAdv.addLine("signir", "    - Significance(t)", "");
        this._resultAdv.addLine("probr", "    - Probablity", "");
        this._resultAdv.addLine("par", "Partial correlation of X, Y & Z", "");
        _funcsAdv.add(this._resultAdv);
        this._advanced.setLayout(new BorderLayout());
        this._advanced.add((Component)_colsAdv, "North");
        this._advanced.add((Component)_funcsAdv, "Center");
        this._tabbedBase.addTab("Basic Functions", this._basic);
        this._tabbedBase.addTab("Advanced Functions", this._advanced);
    }

    private JPanel addRadioButtonsPanel() {
        this._radioButtonsPanel = new JPanel();
        this._entireData = new JRadioButton(ENTIRE_DATA_LABEL, false);
        this._radioButtonsPanel.add(this._entireData);
        this._plotData = new JRadioButton(PLOT_DATA_LABEL, true);
        this._radioButtonsPanel.add(this._plotData);
        this._selectedData = new JRadioButton(SELECTED_DATA_LABEL, false);
        this._radioButtonsPanel.add(this._selectedData);
        this._radioButtonGroup = new ButtonGroup();
        this._radioButtonGroup.add(this._entireData);
        this._radioButtonGroup.add(this._plotData);
        this._radioButtonGroup.add(this._selectedData);
        return this._radioButtonsPanel;
    }

    private void addPanel(Frame owner) {
        final PlotStatisticsDialog plotStatisticsDialog = this;
        PlotStatisticsDialog._buttons[0] = CALCULATE_LABEL;
        PlotStatisticsDialog._buttons[1] = CLOSE_LABEL;
        PlotStatisticsDialog._buttons[2] = BOXPLOT_LABEL;
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this._tabbedBase);
        panel.add(this.addRadioButtonsPanel());
        this._contents = this._tabbedBase;
        this._optionPane = new JOptionPane(panel, 1, 0, null, _buttons, _buttons[0]);
        this._optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (PlotStatisticsDialog.this.isVisible() && e.getSource() == PlotStatisticsDialog.this._optionPane && (prop.equals("value") || prop.equals("inputValue"))) {
                    Object value = PlotStatisticsDialog.this._optionPane.getValue();
                    if (value == JOptionPane.UNINITIALIZED_VALUE) {
                        return;
                    }
                    PlotStatisticsDialog.this._optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                    if (value instanceof String) {
                        PlotStatisticsDialog.this._buttonPressed = (String)value;
                    }
                    if (_buttons[0].equals(PlotStatisticsDialog.this._buttonPressed) && PlotStatisticsDialog.this._plotData.isSelected()) {
                        PlotStatisticsDialog.this.apply();
                        return;
                    }
                    if (_buttons[0].equals(PlotStatisticsDialog.this._buttonPressed) && PlotStatisticsDialog.this._entireData.isSelected()) {
                        PlotStatisticsDialog.this.apply();
                        return;
                    }
                    if (_buttons[0].equals(PlotStatisticsDialog.this._buttonPressed) && PlotStatisticsDialog.this._selectedData.isSelected()) {
                        PlotStatisticsDialog.this.apply();
                        return;
                    }
                    if (_buttons[2].equals(PlotStatisticsDialog.this._buttonPressed)) {
                        PlotStatisticsDialog.this.apply();
                        try {
                            String plotInfo = "";
                            if (PlotStatisticsDialog.this._entireData.isSelected()) {
                                plotInfo = PlotStatisticsDialog.this._entireData.getText();
                            } else if (PlotStatisticsDialog.this._plotData.isSelected()) {
                                plotInfo = PlotStatisticsDialog.this._plotData.getText();
                            } else if (PlotStatisticsDialog.this._selectedData.isSelected()) {
                                plotInfo = PlotStatisticsDialog.this._selectedData.getText();
                            }
                            BoxPlot boxPlot = new BoxPlot(plotStatisticsDialog, PlotStatisticsDialog.this.getQuantiles(), plotInfo);
                            ((Component)boxPlot).setVisible(true);
                            return;
                        }
                        catch (Exception ex) {
                            System.out.println("Error in showing Box Plot.");
                            return;
                        }
                    }
                    ((Component)PlotStatisticsDialog.this).setVisible(false);
                    PlotStatisticsDialog.this._handleClosing();
                }
            }
        });
        this.getContentPane().add(this._optionPane);
        this.pack();
        this.setResizable(false);
        if (owner != null) {
            this.setLocationRelativeTo(owner);
        } else {
            Toolkit tk = Toolkit.getDefaultToolkit();
            ((Component)this).setLocation((tk.getScreenSize().width - this.getSize().width) / 2, (tk.getScreenSize().height - this.getSize().height) / 2);
        }
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                PlotStatisticsDialog.this._handleClosing();
            }
        });
        this.apply();
        ((Component)this).setVisible(true);
    }

    public String getSelXCol() {
        return (String)this._xCol.getSelectedItem();
    }

    public String getSelYCol() {
        return (String)this._yCol.getSelectedItem();
    }

    public String getSelZCol() {
        return (String)this._zCol.getSelectedItem();
    }

    public String getSelFilter() {
        return (String)this._filterCol.getSelectedItem();
    }

    public void apply() {
        JVTUtil.showWaitCursor(this);
        try {
            this._xRange = this._plot.getXRange();
            this._yRange = this._plot.getYRange();
            this._minX = this._xRange[0];
            this._maxX = this._xRange[1];
            this._minY = this._yRange[0];
            this._maxY = this._yRange[1];
            if (this._btns.isLogX()) {
                this._minX = Math.pow(10.0, this._minX);
                this._maxX = Math.pow(10.0, this._maxX);
            }
            if (this._btns.isLogY()) {
                this._minY = Math.pow(10.0, this._minY);
                this._maxY = Math.pow(10.0, this._maxY);
            }
            this._filter = this.getSelFilter();
            this._colX = this.getSelXCol();
            this._colY = this.getSelYCol();
            this._colZ = this.getSelZCol();
            this._histogram = this._pva.isHistogram();
            this._pd = this._pva.getPlotData();
            StatsCalculator stat = new StatsCalculator();
            this.fillArrays();
            DecimalFormat format1 = new DecimalFormat("0.000E0");
            DecimalFormat format2 = new DecimalFormat("0.###");
            this._resultBasic.set("obsrv", JVTUtil.applyProperFormat(stat.findnoofobservations(this.X_X), format2, format1));
            this._resultBasic.set("rang", JVTUtil.applyProperFormat(stat.findrange(this.X_X), format2, format1));
            this._resultBasic.set("min", JVTUtil.applyProperFormat(stat.findmin(this.X_X), format2, format1));
            this._resultBasic.set("max", JVTUtil.applyProperFormat(stat.findmax(this.X_X), format2, format1));
            this._resultBasic.set("mean", JVTUtil.applyProperFormat(stat.findmean(this.X_X), format2, format1));
            this._resultBasic.set("var", JVTUtil.applyProperFormat(stat.findvariance(this.X_X), format2, format1));
            this._resultBasic.set("stdev", JVTUtil.applyProperFormat(stat.findstddev(this.X_X), format2, format1));
            this._resultBasic.set("skew", JVTUtil.applyProperFormat(stat.findskew(this.X_X), format2, format1));
            this._resultBasic.set("kurt", JVTUtil.applyProperFormat(stat.findkurtosis(this.X_X), format2, format1));
            this._obsrvTxt.setText(JVTUtil.applyProperFormat(stat.findnoofobservations(this.X_Y), format2, format1));
            this._rangeTxt.setText(JVTUtil.applyProperFormat(stat.findrange(this.X_Y), format2, format1));
            this._minTxt.setText(JVTUtil.applyProperFormat(stat.findmin(this.X_Y), format2, format1));
            this._maxTxt.setText(JVTUtil.applyProperFormat(stat.findmax(this.X_Y), format2, format1));
            this._meanTxt.setText(JVTUtil.applyProperFormat(stat.findmean(this.X_Y), format2, format1));
            this._varTxt.setText(JVTUtil.applyProperFormat(stat.findvariance(this.X_Y), format2, format1));
            this._stdevTxt.setText(JVTUtil.applyProperFormat(stat.findstddev(this.X_Y), format2, format1));
            this._skewTxt.setText(JVTUtil.applyProperFormat(stat.findskew(this.X_Y), format2, format1));
            this._kurtTxt.setText(JVTUtil.applyProperFormat(stat.findkurtosis(this.X_Y), format2, format1));
            double result = stat.findlinearcorrelation(this.XY_X, this.XY_Y);
            this._resultAdv.set("cor", JVTUtil.applyProperFormat(result, format2, format1));
            result = stat.findt_linear(this.XY_X, this.XY_Y);
            this._resultAdv.set("signi", JVTUtil.applyProperFormat(result, format2, format1));
            result = stat.findlinearcorprob(this.XY_X, this.XY_Y);
            int errorNum = stat.getErrorNum();
            if (errorNum != 0) {
                this._resultAdv.set("prob", "Error");
            } else {
                this._resultAdv.set("prob", JVTUtil.applyProperFormat(result, format2, format1));
            }
            result = stat.findrankcorrelation(this.XY_X, this.XY_Y);
            this._resultAdv.set("rnk", JVTUtil.applyProperFormat(result, format2, format1));
            result = stat.findt_rank(this.XY_X, this.XY_Y);
            this._resultAdv.set("signir", JVTUtil.applyProperFormat(result, format2, format1));
            result = stat.findrankcorprob(this.XY_X, this.XY_Y);
            errorNum = stat.getErrorNum();
            if (errorNum != 0) {
                this._resultAdv.set("probr", "Error");
            } else {
                this._resultAdv.set("probr", JVTUtil.applyProperFormat(result, format2, format1));
            }
            result = stat.findpartialcorrelation(this.XYZ_X, this.XYZ_Y, this.XYZ_Z);
            this._resultAdv.set("par", JVTUtil.applyProperFormat(result, format2, format1));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        JVTUtil.showDefaultCursor(this);
    }

    private DoubleArrayList getQuantiles() {
        this.fillArrays();
        this.sort_X_X();
        DoubleArrayList dataList = new DoubleArrayList();
        for (int i = 0; i < this.X_X.length; ++i) {
            dataList.add(this.X_X[i]);
        }
        DoubleArrayList percentagesList = new DoubleArrayList();
        percentagesList.add(0.25);
        percentagesList.add(0.5);
        percentagesList.add(0.75);
        DoubleArrayList boxPlotValuesList = Descriptive.quantiles(dataList, percentagesList);
        if (this.X_X.length > 0) {
            boxPlotValuesList.add(this.X_X[0]);
            boxPlotValuesList.add(this.X_X[this.X_X.length - 1]);
            return boxPlotValuesList;
        }
        return null;
    }

    void sort_X_X() {
        for (int i = 0; i < this.X_X.length - 1; ++i) {
            for (int j = i + 1; j < this.X_X.length; ++j) {
                if (!(this.X_X[i] > this.X_X[j])) continue;
                double temp = this.X_X[i];
                this.X_X[i] = this.X_X[j];
                this.X_X[j] = temp;
            }
        }
    }

    public void fillArrays() {
        int i;
        int indexCount;
        boolean[] filterData = new boolean[]{};
        this._dax1.clear();
        this._day1.clear();
        this._dax2.clear();
        this._dax3.clear();
        this._day2.clear();
        this._day3.clear();
        this._daz3.clear();
        if (this._entireData.isSelected() || this._plotData.isSelected()) {
            this.dataX = new Double[0];
            this.dataY = new Double[0];
            this.dataZ = new Double[0];
            for (indexCount = 0; indexCount < this._pd.getNumOfPlotColumns(); ++indexCount) {
                PlotColumn pc = this._pd.getPlotColumn(indexCount);
                if (this._colX.equals(pc.getName())) {
                    this.dataX = pc.getData();
                }
                if (this._colY.equals(pc.getName())) {
                    this.dataY = pc.getData();
                }
                if (!this._colZ.equals(pc.getName())) continue;
                this.dataZ = pc.getData();
            }
        }
        if (this._selectedData.isSelected() && !this._histogram) {
            this.selectedIndexs = this._pva.getSelectedPointsIndex();
            this.dataX = new Double[this.selectedIndexs.size()];
            this.dataY = new Double[this.selectedIndexs.size()];
            this.dataZ = new Double[this.selectedIndexs.size()];
            for (indexCount = 0; indexCount < this.selectedIndexs.size(); ++indexCount) {
                for (int columnCount = 0; columnCount < this._pd.getNumOfPlotColumns(); ++columnCount) {
                    Integer index = (Integer)this.selectedIndexs.get(indexCount);
                    int rowindex = index;
                    PlotColumn pc = this._pd.getPlotColumn(columnCount);
                    if (this._colX.equals(pc.getName())) {
                        this.dataX[indexCount] = pc.getData(rowindex);
                    }
                    if (this._colY.equals(pc.getName())) {
                        this.dataY[indexCount] = pc.getData(rowindex);
                    }
                    if (!this._colZ.equals(pc.getName())) continue;
                    this.dataZ[indexCount] = pc.getData(rowindex);
                }
            }
        }
        if ("All".equals(this._filter)) {
            if (this._entireData.isSelected()) {
                this.filter1(this.dataX, this.dataY, this.dataZ, filterData, false);
            } else if (this._plotData.isSelected() && !this._histogram) {
                this.filter2(this.dataX, this.dataY, this.dataZ, filterData, false);
            } else if (this._plotData.isSelected() && this._histogram || this._selectedData.isSelected() && this._histogram) {
                this.filter3(this.dataX, this.dataY, this.dataZ, filterData, false);
            } else if (this._selectedData.isSelected() && !this._histogram) {
                this.filter1(this.dataX, this.dataY, this.dataZ, filterData, false);
            }
        } else {
            for (i = 0; i < this._pd.getNumOfFilters(); ++i) {
                PlotFilter pf = this._pd.getPlotFilter(i);
                if (!this._filter.equals(pf.getName())) continue;
                filterData = pf.getData();
                break;
            }
            if (this._entireData.isSelected()) {
                this.filter1(this.dataX, this.dataY, this.dataZ, filterData, true);
            } else if (this._plotData.isSelected() && !this._histogram) {
                this.filter2(this.dataX, this.dataY, this.dataZ, filterData, true);
            } else if (this._plotData.isSelected() && this._histogram || this._selectedData.isSelected() && this._histogram) {
                this.filter3(this.dataX, this.dataY, this.dataZ, filterData, true);
            } else if (this._selectedData.isSelected() && !this._histogram) {
                this.filter1(this.dataX, this.dataY, this.dataZ, filterData, true);
            }
        }
        this.X_X = new double[this._dax1.size()];
        this.X_Y = new double[this._day1.size()];
        for (i = 0; i < this._dax1.size(); ++i) {
            this.X_X[i] = (Double)this._dax1.get(i);
        }
        for (i = 0; i < this._day1.size(); ++i) {
            this.X_Y[i] = (Double)this._day1.get(i);
        }
        this.XY_X = new double[this._dax2.size()];
        this.XY_Y = new double[this._day2.size()];
        for (i = 0; i < this._dax2.size(); ++i) {
            this.XY_X[i] = (Double)this._dax2.get(i);
            this.XY_Y[i] = (Double)this._day2.get(i);
        }
        this.XYZ_X = new double[this._dax3.size()];
        this.XYZ_Y = new double[this._day3.size()];
        this.XYZ_Z = new double[this._daz3.size()];
        for (i = 0; i < this._dax3.size(); ++i) {
            this.XYZ_X[i] = (Double)this._dax3.get(i);
            this.XYZ_Y[i] = (Double)this._day3.get(i);
            this.XYZ_Z[i] = (Double)this._daz3.get(i);
        }
    }

    public void filter3(Double[] dataX, Double[] dataY, Double[] dataZ, boolean[] _filter, boolean isFilter) {
        for (int i = 0; i < dataX.length; ++i) {
            if ((!isFilter || !_filter[i]) && isFilter) continue;
            if (dataY[i] != null && dataY[i] >= this._minY && dataY[i] <= this._maxY) {
                this._day1.add(dataY[i]);
            }
            if (dataX[i] == null || !(dataX[i] >= this._minX) || !(dataX[i] <= this._maxX)) continue;
            this._dax1.add(dataX[i]);
            if (dataY[i] == null) continue;
            this._dax2.add(dataX[i]);
            this._day2.add(dataY[i]);
            if (dataZ[i] == null) continue;
            this._dax3.add(dataX[i]);
            this._day3.add(dataY[i]);
            this._daz3.add(dataZ[i]);
        }
    }

    public void filter2(Double[] dataX, Double[] dataY, Double[] dataZ, boolean[] _filter, boolean isFilter) {
        for (int i = 0; i < dataX.length; ++i) {
            if ((!isFilter || !_filter[i]) && isFilter || dataX[i] == null || !(dataX[i] >= this._minX) || !(dataX[i] <= this._maxX) || dataY[i] == null || !(dataY[i] >= this._minY) || !(dataY[i] <= this._maxY)) continue;
            this._dax1.add(dataX[i]);
            this._day1.add(dataY[i]);
            this._dax2.add(dataX[i]);
            this._day2.add(dataY[i]);
            if (dataZ[i] == null) continue;
            this._dax3.add(dataX[i]);
            this._day3.add(dataY[i]);
            this._daz3.add(dataZ[i]);
        }
    }

    public void filter1(Double[] dataX, Double[] dataY, Double[] dataZ, boolean[] _filter, boolean isFilter) {
        for (int i = 0; i < dataX.length; ++i) {
            if ((!isFilter || !_filter[i]) && isFilter) continue;
            if (dataY[i] != null) {
                this._day1.add(dataY[i]);
            }
            if (dataX[i] == null) continue;
            this._dax1.add(dataX[i]);
            if (dataY[i] == null) continue;
            this._dax2.add(dataX[i]);
            this._day2.add(dataY[i]);
            if (dataZ[i] == null) continue;
            this._dax3.add(dataX[i]);
            this._day3.add(dataY[i]);
            this._daz3.add(dataZ[i]);
        }
    }

    protected void _handleClosing() {
        if (this._contents instanceof CloseListener && !this._doneHandleClosing) {
            this._doneHandleClosing = true;
            ((CloseListener)((Object)this._contents)).windowClosed(this, this._buttonPressed);
        }
    }

    public void restore() {
        this._plot.repaint();
    }

    static {
        FILTER_LABEL = FILTER_LABEL;
        CALCULATE_LABEL = CALCULATE_LABEL;
        CLOSE_LABEL = CLOSE_LABEL;
        BOXPLOT_LABEL = BOXPLOT_LABEL;
        _buttons = new Object[3];
        ENTIRE_DATA_LABEL = ENTIRE_DATA_LABEL;
        PLOT_DATA_LABEL = PLOT_DATA_LABEL;
        SELECTED_DATA_LABEL = SELECTED_DATA_LABEL;
    }

    class ComboListener
    implements ActionListener {
        ComboListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == PlotStatisticsDialog.this._xCol) {
                PlotStatisticsDialog.this._xColB.setSelectedItem(PlotStatisticsDialog.this._xCol.getSelectedItem());
            }
            if (event.getSource() == PlotStatisticsDialog.this._xColB) {
                PlotStatisticsDialog.this._xCol.setSelectedItem(PlotStatisticsDialog.this._xColB.getSelectedItem());
            }
            if (event.getSource() == PlotStatisticsDialog.this._yCol) {
                PlotStatisticsDialog.this._yColB.setSelectedItem(PlotStatisticsDialog.this._yCol.getSelectedItem());
            }
            if (event.getSource() == PlotStatisticsDialog.this._yColB) {
                PlotStatisticsDialog.this._yCol.setSelectedItem(PlotStatisticsDialog.this._yColB.getSelectedItem());
            }
            if (event.getSource() == PlotStatisticsDialog.this._filterCol) {
                PlotStatisticsDialog.this._filterColB.setSelectedItem(PlotStatisticsDialog.this._filterCol.getSelectedItem());
            }
            if (event.getSource() == PlotStatisticsDialog.this._filterColB) {
                PlotStatisticsDialog.this._filterCol.setSelectedItem(PlotStatisticsDialog.this._filterColB.getSelectedItem());
            }
        }
    }
}

