/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import com.jvt.utils.JVTUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ptolemy.gui.ComponentDialog;
import ptolemy.gui.Query;
import ptolemy.gui.QueryListener;
import ptolemy.plot.AdvancedHistogramFormatter;
import ptolemy.plot.AdvancedPlotFormatter;
import ptolemy.plot.Histogram;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;
import ptolemy.plot.PlotPoint;

public class PlotFormatter
extends JPanel {
    protected final PlotBox _plot;
    private Query _wideQuery;
    private Query _narrowQuery;
    private String _originalTitle;
    private String _originalXLabel;
    private String _originalYLabel;
    private String _originalMarks;
    private String _originalXTicksSpec;
    private String _originalYTicksSpec;
    private double[] _originalXRange;
    private double[] _originalYRange;
    private Vector[] _originalXTicks;
    private Vector[] _originalYTicks;
    private boolean _originalGrid;
    private boolean _originalStems;
    private boolean _originalColor;
    private boolean _originalXLog;
    private boolean _originalYLog;
    private boolean _yIncremented;
    private boolean[][] _originalConnected;
    private PlotPoint[][] _originalPoints;
    private double _originalXTickDist;
    private double _originalYTickDist;
    private double _originalBinWidth;
    private AdvancedPlotFormatter _advancedPlotFormatter;
    private AdvancedHistogramFormatter _advancedHistogramFormatter;

    public PlotFormatter(PlotBox plot) {
        int i;
        Vector labels;
        Vector positions;
        StringBuffer buffer;
        this._plot = plot;
        String[] minmax = new String[2];
        this.setLayout(new BorderLayout());
        this._wideQuery = new Query();
        this.add((Component)this._wideQuery, "West");
        this._narrowQuery = new Query();
        this.add((Component)this._narrowQuery, "East");
        this._wideQuery.setTextWidth(20);
        this._originalTitle = plot.getTitle();
        this._wideQuery.addLine("title", "Title", this._originalTitle);
        this._originalXLabel = plot.getXLabel();
        this._wideQuery.addLine("xlabel", "X Label", this._originalXLabel);
        this._originalYLabel = plot.getYLabel();
        this._wideQuery.addLine("ylabel", "Y Label", this._originalYLabel);
        this._originalXRange = plot.getXRange();
        minmax = JVTUtil.setNoDecimalDigits(this._originalXRange);
        this._wideQuery.addLine("xrange", "X Range", String.valueOf(String.valueOf(new StringBuffer("").append(minmax[0]).append(", ").append(minmax[1]))));
        this._originalYRange = plot.getYRange();
        this._originalYTickDist = plot.getYTickSpacing();
        minmax = JVTUtil.setNoDecimalDigits(this._originalYRange);
        this._wideQuery.addLine("yrange", "Y Range", String.valueOf(String.valueOf(new StringBuffer("").append(minmax[0]).append(", ").append(minmax[1]))));
        String[] marks = new String[]{"none", "pixels", "points", "dots", "various"};
        this._originalMarks = "none";
        if (plot instanceof Plot) {
            this._originalMarks = ((Plot)plot).getMarksStyle();
            this._wideQuery.addRadioButtons("marks", "Marks", marks, this._originalMarks);
        }
        this._originalXTicks = plot.getXTicks();
        this._originalXTicksSpec = "";
        if (this._originalXTicks != null) {
            buffer = new StringBuffer();
            positions = this._originalXTicks[0];
            labels = this._originalXTicks[1];
            for (i = 0; i < labels.size(); ++i) {
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                buffer.append(labels.elementAt(i).toString());
                buffer.append(" ");
                buffer.append(positions.elementAt(i).toString());
            }
            this._originalXTicksSpec = buffer.toString();
        }
        this._originalYTicks = plot.getYTicks();
        this._originalYTicksSpec = "";
        if (this._originalYTicks != null) {
            buffer = new StringBuffer();
            positions = this._originalYTicks[0];
            labels = this._originalYTicks[1];
            for (i = 0; i < labels.size(); ++i) {
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                buffer.append(labels.elementAt(i).toString());
                buffer.append(" ");
                buffer.append(positions.elementAt(i).toString());
            }
            this._originalYTicksSpec = buffer.toString();
        }
        if (plot instanceof Histogram) {
            this._originalBinWidth = ((Histogram)plot).getBinWidth();
            this._wideQuery.addLine("binwidth", "Bin Width", "".concat(String.valueOf(String.valueOf(this._originalBinWidth))));
            this._yIncremented = ((Histogram)plot).isYIncremented();
            this._narrowQuery.addCheckBox("yinc", "Incremented Y", this._yIncremented);
        }
        this._originalGrid = plot.getGrid();
        this._narrowQuery.addCheckBox("grid", "Grid", this._originalGrid);
        this._originalStems = false;
        this._originalConnected = null;
        if (plot instanceof Plot) {
            this._originalStems = ((Plot)plot).getImpulses();
            this._narrowQuery.addCheckBox("stems", "Impulses", this._originalStems);
            this._saveConnected();
            this._narrowQuery.addCheckBox("connected", "Connect", ((Plot)plot).getConnected());
        }
        this._originalColor = plot.getColor();
        this._narrowQuery.addCheckBox("color", "Use Color", this._originalColor);
        this._wideQuery.addQueryListener(new QueryListener(){

            public void changed(String name) {
                String range = new String();
                String tickDistance = new String();
                String spec = new String();
                double tickWidth = 0.0;
                double tick = 0.0;
                if (!(name.equals("title") || name.equals("xlabel") || name.equals("ylabel"))) {
                    if (name.equals("xrange")) {
                        if (tickWidth > 0.0) {
                            double xmin = Double.parseDouble(range.substring(0, range.indexOf(44)));
                            double xmax = Double.parseDouble(range.substring(range.indexOf(44) + 1));
                            spec = "";
                            for (tick = xmin; tick < xmax; tick += tickWidth) {
                                spec = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(spec))).append(tick).append(" ").append(tick).append(", ")));
                            }
                            PlotFormatter.this._plot.read("XTicks: ".concat(String.valueOf(String.valueOf(spec))));
                        }
                        PlotFormatter.this._plot.read("XRange: ".concat(String.valueOf(String.valueOf(range))));
                    } else if (name.equals("xticks")) {
                        spec = PlotFormatter.this._wideQuery.stringValue("xticks").trim();
                        PlotFormatter.this._plot.read("XTicks: ".concat(String.valueOf(String.valueOf(spec))));
                        if (spec.equals("")) {
                            PlotFormatter.this._narrowQuery.setEnabled("xlog", true);
                        } else {
                            PlotFormatter.this._narrowQuery.setBoolean("xlog", false);
                            PlotFormatter.this._narrowQuery.setEnabled("xlog", false);
                        }
                    } else if (name.equals("yrange")) {
                        PlotFormatter.this._plot.read("YRange: ".concat(String.valueOf(String.valueOf(PlotFormatter.this._wideQuery.stringValue("yrange")))));
                        String yrange = PlotFormatter.this._wideQuery.stringValue("yrange");
                        range = yrange.substring(0, yrange.lastIndexOf(44));
                        tickDistance = yrange.substring(yrange.lastIndexOf(44) + 1);
                        tickWidth = Double.parseDouble(tickDistance);
                        if (tickWidth > 0.0) {
                            double ymin = Double.parseDouble(range.substring(0, range.indexOf(44)));
                            double ymax = Double.parseDouble(range.substring(range.indexOf(44) + 1));
                            spec = "";
                            for (tick = ymin; tick < ymax; tick += tickWidth) {
                                spec = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(spec))).append(tick).append(" ").append(tick).append(", ")));
                            }
                            PlotFormatter.this._plot.read("YTicks: ".concat(String.valueOf(String.valueOf(spec))));
                        }
                        PlotFormatter.this._plot.read("YRange: ".concat(String.valueOf(String.valueOf(range))));
                    } else if (name.equals("yticks")) {
                        spec = PlotFormatter.this._wideQuery.stringValue("yticks").trim();
                        PlotFormatter.this._plot.read("YTicks: ".concat(String.valueOf(String.valueOf(spec))));
                        if (spec.equals("")) {
                            PlotFormatter.this._narrowQuery.setEnabled("ylog", true);
                        } else {
                            PlotFormatter.this._narrowQuery.setBoolean("ylog", false);
                            PlotFormatter.this._narrowQuery.setEnabled("ylog", false);
                        }
                    } else if (name.equals("marks")) {
                        ((Plot)PlotFormatter.this._plot).setMarksStyle(PlotFormatter.this._wideQuery.stringValue("marks"));
                    }
                }
                PlotFormatter.this._plot.repaint();
            }
        });
        this._narrowQuery.addQueryListener(new QueryListener(){

            public void changed(String name) {
                if (name.equals("grid")) {
                    PlotFormatter.this._plot.setGrid(PlotFormatter.this._narrowQuery.booleanValue("grid"));
                } else if (name.equals("stems")) {
                    ((Plot)PlotFormatter.this._plot).setImpulses(PlotFormatter.this._narrowQuery.booleanValue("stems"));
                    PlotFormatter.this._plot.repaint();
                } else if (name.equals("color")) {
                    PlotFormatter.this._plot.setColor(PlotFormatter.this._narrowQuery.booleanValue("color"));
                } else if (name.equals("xlog")) {
                    PlotFormatter.this._plot.setXLog(PlotFormatter.this._narrowQuery.booleanValue("xlog"));
                } else if (name.equals("ylog")) {
                    PlotFormatter.this._plot.setYLog(PlotFormatter.this._narrowQuery.booleanValue("ylog"));
                } else if (name.equals("connected")) {
                    PlotFormatter.this._setConnected(PlotFormatter.this._narrowQuery.booleanValue("connected"));
                }
                PlotFormatter.this._plot.repaint();
            }
        });
    }

    public void apply() {
        try {
            this._plot.setTitle(this._wideQuery.getStringValue("title"));
            this._plot.setXLabel(this._wideQuery.getStringValue("xlabel"));
            this._plot.setYLabel(this._wideQuery.getStringValue("ylabel"));
            this._plot.read("XRange: ".concat(String.valueOf(String.valueOf(this._wideQuery.getStringValue("xrange")))));
            this._plot.read("YRange: ".concat(String.valueOf(String.valueOf(this._wideQuery.getStringValue("yrange")))));
            this._plot.setGrid(this._narrowQuery.getBooleanValue("grid"));
            this._plot.setColor(this._narrowQuery.getBooleanValue("color"));
            if (this._plot instanceof Plot) {
                Plot cplot = (Plot)this._plot;
                cplot.setMarksStyle(this._wideQuery.getStringValue("marks"));
                cplot.setImpulses(this._narrowQuery.getBooleanValue("stems"));
                this._setConnected(this._narrowQuery.getBooleanValue("connected"));
            }
            if (this._plot instanceof Histogram) {
                System.out.println("BinWidth changed , new BinWidth : ".concat(String.valueOf(String.valueOf(this._wideQuery.getDoubleValue("binwidth")))));
                if (this._originalBinWidth != this._wideQuery.getDoubleValue("binwidth")) {
                    this._plot.redrawHistogram(this._wideQuery.getDoubleValue("binwidth"));
                }
                ((Histogram)this._plot).setYIncremented(this._narrowQuery.getBooleanValue("yinc"));
            }
        }
        catch (NumberFormatException ex) {
            System.out.println("Error parsing expression");
        }
        catch (Exception ex) {
            System.out.println("Error applying changes.");
        }
        this._plot.repaint();
    }

    public void openModal() {
        JPanel advancedPanel;
        String[] buttons = new String[]{"Apply", "Cancel"};
        Container toplevel = this._plot.getTopLevelAncestor();
        Frame frame = null;
        if (toplevel instanceof Frame) {
            frame = (Frame)toplevel;
        }
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("Simple", this);
        if (!(this._plot instanceof Histogram)) {
            advancedPanel = new JPanel();
            advancedPanel.setBorder(null);
            this._advancedPlotFormatter = new AdvancedPlotFormatter((Plot)this._plot);
            advancedPanel.add(this._advancedPlotFormatter);
            jTabbedPane.addTab("Advanced", advancedPanel);
        } else {
            advancedPanel = new JPanel();
            advancedPanel.setBorder(null);
            this._advancedHistogramFormatter = new AdvancedHistogramFormatter(this._plot);
            advancedPanel.add(this._advancedHistogramFormatter);
            jTabbedPane.addTab("Advanced", advancedPanel);
        }
        jTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                if (PlotFormatter.this._plot instanceof Plot) {
                    PlotFormatter.this._advancedPlotFormatter.initializeMarkerStylesComboBox();
                    PlotFormatter.this._advancedPlotFormatter.refresh();
                } else if (PlotFormatter.this._plot instanceof Histogram) {
                    PlotFormatter.this._advancedHistogramFormatter.refresh();
                }
            }
        });
        ComponentDialog dialog = new ComponentDialog(frame, "Set plot format", jTabbedPane, buttons);
        if (dialog.buttonPressed().equals("Apply")) {
            JVTUtil.showWaitCursor(this);
            this.apply();
        } else {
            this.restore();
            if (this._plot instanceof Histogram) {
                this._advancedHistogramFormatter.cancel();
            } else {
                this._advancedPlotFormatter.cancel();
            }
        }
    }

    public void restore() {
        this._plot.setTitle(this._originalTitle);
        this._plot.setXLabel(this._originalXLabel);
        this._plot.setYLabel(this._originalYLabel);
        this._plot.setXRange(this._originalXRange[0], this._originalXRange[1]);
        this._plot.setYRange(this._originalYRange[0], this._originalYRange[1]);
        this._plot.setGrid(this._originalGrid);
        this._plot.setColor(this._originalColor);
        if (this._plot instanceof Plot) {
            Plot cplot = (Plot)this._plot;
            cplot.setMarksStyle(this._originalMarks);
            cplot.setImpulses(this._originalStems);
            this._restoreConnected();
        }
        this._plot.repaint();
    }

    private void _saveConnected() {
        Vector points = ((Plot)this._plot)._points;
        this._originalConnected = new boolean[points.size()][];
        this._originalPoints = new PlotPoint[points.size()][];
        for (int dataset = 0; dataset < points.size(); ++dataset) {
            Vector pts = (Vector)points.elementAt(dataset);
            this._originalConnected[dataset] = new boolean[pts.size()];
            this._originalPoints[dataset] = new PlotPoint[pts.size()];
            for (int i = 0; i < pts.size(); ++i) {
                PlotPoint pt = (PlotPoint)pts.elementAt(i);
                this._originalConnected[dataset][i] = pt.connected;
                this._originalPoints[dataset][i] = pt;
            }
        }
    }

    private void _setConnected(boolean value) {
        Vector points = ((Plot)this._plot)._points;
        ((Plot)this._plot).setConnected(value);
        boolean[][] result = new boolean[points.size()][];
        for (int dataset = 0; dataset < points.size(); ++dataset) {
            Vector pts = (Vector)points.elementAt(dataset);
            result[dataset] = new boolean[pts.size()];
            boolean first = true;
            for (int i = 0; i < pts.size(); ++i) {
                PlotPoint pt = (PlotPoint)pts.elementAt(i);
                pt.connected = value && !first;
                first = false;
            }
        }
    }

    private void _restoreConnected() {
        for (int dataset = 0; dataset < this._originalPoints.length; ++dataset) {
            for (int i = 0; i < this._originalPoints[dataset].length; ++i) {
                PlotPoint pt = this._originalPoints[dataset][i];
                pt.connected = this._originalConnected[dataset][i];
            }
        }
    }
}

