/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import com.jvt.applets.PlotVOApplet;
import com.jvt.utils.JVTUtil;
import com.jvt.votable.PlotColumn;
import com.jvt.votable.PlotData;
import com.jvt.votable.PlotFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import ptolemy.gui.CloseListener;
import ptolemy.gui.Query;
import ptolemy.gui.QueryListener;
import ptolemy.plot.ColumnExprParser;

public class PlotFilterDialog
extends JDialog {
    public Component _contents;
    protected String _buttonPressed = "";
    private static String[] _buttons = new String[]{"Add", "Close", "Help"};
    private boolean _doneHandleClosing = false;
    private JOptionPane _optionPane;
    private JTextArea _messageArea;
    private PlotVOApplet _pva = null;
    private PlotData _pd = null;
    private Query _wideQuery;
    private JTable _colTable;
    private JTable _filterTable;
    private JScrollPane _scrollPaneCol;
    private JScrollPane _scrollPaneFilter;
    private JPanel _transPanel;
    private static final int DIALOGBOX_HEIGHT = 450;
    private static final int DIALOGBOX_WIDTH = 600;
    private static final String[] availableFunctions;
    private static final String[] errorMessages;

    public PlotFilterDialog(Frame owner, PlotVOApplet pva) {
        super(owner, "Create new data subsets ", true);
        this.init(pva);
        this.addPanel(owner);
        this._wideQuery.requestFocus();
    }

    private void addPanel(Frame owner) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this._transPanel);
        this._contents = this._transPanel;
        this._wideQuery.requestFocus();
        this._optionPane = new JOptionPane(panel, 3, 0, null, _buttons, _buttons[0]);
        this._optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (PlotFilterDialog.this.isVisible() && e.getSource() == PlotFilterDialog.this._optionPane && (prop.equals("value") || prop.equals("inputValue"))) {
                    Object value = PlotFilterDialog.this._optionPane.getValue();
                    if (value == JOptionPane.UNINITIALIZED_VALUE) {
                        return;
                    }
                    PlotFilterDialog.this._optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                    if (value instanceof String) {
                        PlotFilterDialog.this._buttonPressed = (String)value;
                    }
                    if (_buttons[0].equals(PlotFilterDialog.this._buttonPressed)) {
                        if (!PlotFilterDialog.this.applyChanges()) {
                            return;
                        }
                        PlotFilterDialog.this._transPanel.removeAll();
                        PlotFilterDialog.this.createFiltersTable();
                        PlotFilterDialog.this._transPanel.invalidate();
                        PlotFilterDialog.this._transPanel.validate();
                        return;
                    }
                    if (_buttons[2].equals(PlotFilterDialog.this._buttonPressed)) {
                        JOptionPane.showMessageDialog(null, availableFunctions, "Help for creating data subsets", 1);
                        return;
                    }
                    ((Component)PlotFilterDialog.this).setVisible(false);
                    PlotFilterDialog.this._handleClosing();
                }
            }
        });
        this.getContentPane().add(this._optionPane);
        this.pack();
        this.setResizable(false);
        if (owner != null) {
            this.setLocationRelativeTo(owner);
        } else {
            Toolkit tk = Toolkit.getDefaultToolkit();
            ((Component)this).setLocation((tk.getScreenSize().width - this.getSize().width) / 2, (tk.getScreenSize().height - this.getSize().height) / 2);
        }
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                PlotFilterDialog.this._handleClosing();
            }
        });
        ((Component)this).setSize(600, 450);
        ((Component)this).setVisible(true);
    }

    private void _handleClosing() {
        if (this._contents instanceof CloseListener && !this._doneHandleClosing) {
            this._doneHandleClosing = true;
            ((CloseListener)((Object)this._contents)).windowClosed(this, this._buttonPressed);
        }
    }

    private void init(PlotVOApplet pva) {
        this._pva = pva;
        this._pd = pva.getPlotData();
        this._transPanel = new JPanel();
        this.createFiltersTable();
    }

    private void createFiltersTable() {
        try {
            Vector<String> columnNames = new Vector<String>();
            columnNames.add("Column Id");
            columnNames.add("Column Name");
            columnNames.add("UCD");
            columnNames.add("Expression");
            Vector allRows = new Vector();
            for (int i = 0; i < this._pd.getNumOfPlotColumns(); ++i) {
                Vector<String> row = new Vector<String>();
                row.add(String.valueOf(String.valueOf(new StringBuffer("$").append(i + 1))));
                PlotColumn pc = this._pd.getPlotColumn(i);
                row.add(pc.getName());
                row.add(pc.getUCD());
                String expr = pc.getExpression();
                if (expr == null || expr.trim().length() <= 0) {
                    expr = "Original";
                }
                row.add(expr);
                allRows.add(row);
            }
            Vector<String> filterNames = new Vector<String>();
            String[] filters = new String[this._pd.getNumOfFilters() + 1];
            filterNames.add("Data Subset Name");
            filterNames.add("Condition");
            filters[0] = "All";
            Vector allFilters = new Vector();
            Vector<String> defaultFilter = new Vector<String>();
            defaultFilter.add("All");
            defaultFilter.add("");
            allFilters.add(defaultFilter);
            for (int i = 0; i < this._pd.getNumOfFilters(); ++i) {
                Vector<String> row = new Vector<String>();
                PlotFilter pc = this._pd.getPlotFilter(i);
                row.add(pc.getName());
                filters[i + 1] = pc.getName();
                String expr = pc.getExpression();
                row.add(expr);
                allFilters.add(row);
            }
            this._filterTable = new JTable(allFilters, filterNames);
            this._filterTable.setPreferredScrollableViewportSize(new Dimension(150, 100));
            this._scrollPaneFilter = new JScrollPane(this._filterTable);
            this._scrollPaneFilter.setRequestFocusEnabled(false);
            this._colTable = new JTable(allRows, columnNames);
            this._colTable.setPreferredScrollableViewportSize(new Dimension(200, 160));
            this._scrollPaneCol = new JScrollPane(this._colTable);
            this._scrollPaneCol.setRequestFocusEnabled(false);
            this._transPanel.setLayout(new BorderLayout(0, 10));
            this._transPanel.add((Component)this._scrollPaneCol, "North");
            this._transPanel.add((Component)this._scrollPaneFilter, "Center");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this._wideQuery = new Query();
        this._transPanel.add((Component)this._wideQuery, "South");
        this._wideQuery.setTextWidth(20);
        String name = "";
        this._wideQuery.addLine("name", "Enter data subset name", name);
        String expression = "";
        this._wideQuery.addLine("expr", "Enter expression", expression);
        this._wideQuery.addQueryListener(new QueryListener(){

            public void changed(String name) {
            }
        });
        this._wideQuery.requestFocus();
    }

    public static boolean addFilter(PlotVOApplet pva, String colName, String expression) {
        PlotFilter newPC = new PlotFilter();
        int errorCode = PlotFilterDialog.checkFilterNameValid(pva, colName);
        if (errorCode > 0) {
            JOptionPane.showMessageDialog(null, errorMessages[errorCode], "Error", 0);
            return false;
        }
        newPC.setName(colName);
        try {
            if (expression != null && expression.trim().length() <= 0) {
                JOptionPane.showMessageDialog(null, errorMessages[3], "Error", 0);
                boolean bl = false;
                return bl;
            }
            expression = expression.trim();
            newPC.setExpression(expression);
            PlotData pd = pva.getPlotData();
            ColumnExprParser cep = new ColumnExprParser(pd);
            if (!cep.parseAndEvaluate(expression, newPC)) {
                if (cep.getErrorCode() == 4) {
                    String colNumStr = cep.getColumnNumber();
                    JOptionPane.showMessageDialog(null, String.valueOf(String.valueOf(new StringBuffer("Invalid column number : $").append(colNumStr).append(". Please check the expression."))), "Error", 0);
                } else {
                    JOptionPane.showMessageDialog(null, errorMessages[cep.getErrorCode()], "Error", 0);
                }
                boolean bl = false;
                return bl;
            }
            newPC.setUserCreated(true);
            pd.addPlotFilter(newPC);
            pva.setPlotData(pd, true);
            JOptionPane.showMessageDialog(null, String.valueOf(String.valueOf(new StringBuffer("Created data subset '").append(newPC.getName()).append("' successfully."))), "Success", 1);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, errorMessages[5], "Error", 0);
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
    }

    private boolean applyChanges() {
        JVTUtil.showWaitCursor(this);
        boolean isSuccessfulAddition = PlotFilterDialog.addFilter(this._pva, this._wideQuery.getStringValue("name"), this._wideQuery.getStringValue("expr"));
        JVTUtil.showDefaultCursor(this);
        return isSuccessfulAddition;
    }

    private static int checkFilterNameValid(PlotVOApplet pva, String name) {
        if (name == null || name.trim().length() <= 0) {
            return 1;
        }
        PlotData pd = pva.getPlotData();
        for (int i = 0; i < pd.getNumOfFilters(); ++i) {
            if (!name.equals(pd.getPlotFilter(i).getName())) continue;
            return 2;
        }
        if ("All".equals(name)) {
            return 6;
        }
        return 0;
    }

    static {
        DIALOGBOX_HEIGHT = 450;
        DIALOGBOX_WIDTH = 600;
        availableFunctions = new String[]{" ", "Operators available for use in the Create new data subsets Dialog Box    ", " ", "       ' + ' ,  ' - ',  ' * ',  ' / ' , ' < ', ' <= ', ' > ', ' >= ', ' == '(EQUAL TO),", "' != ' (NOT EQUAL TO), ' && ' (AND), ' || ' (OR), ' ! ' (NOT EQUAL TO)                 ", " ", "Functions available for use in the Transformation Dialog Box    ", " ", "       log(a)                          ln(a)", "       sqrt(a)                        pow(a,b)", "       dexp(a)                       exp(a)", "       cos(a)                         acos(a)", "       sin(a)                          asin(a)", "       tan(a)                          atan(a)", "       toradians(a)              todegrees(a)", " ", "For example, $1 > 30 && ($2 < 100 || $3 >= 90) ", " "};
        errorMessages = new String[]{"", "No filter name. Please enter a filter name.", "Filter name already exists. Please enter another name.", "No expression entered. Please enter an expression.", "Invalid column number. Please enter a correct expression.", "Exception while parsing expression. Please check that the expression is correct.", "Please enter another filter name."};
    }
}

