/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import com.jvt.applets.PlotButtons;
import com.jvt.applets.PlotVOApplet;
import com.jvt.votable.PlotColumn;
import com.jvt.votable.PlotData;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import ptolemy.gui.CloseListener;

public class PlotErrorBarsDialogBox
extends JDialog {
    public Component contents;
    protected String _buttonPressed = "";
    private static String[] _buttons = new String[]{"Close", "Apply", "Help"};
    private boolean _doneHandleClosing = false;
    private JOptionPane _optionPane;
    private PlotVOApplet _pva = null;
    private PlotData _pd = null;
    private PlotButtons _pb = null;
    private JPanel _panel;
    private JPanel _mainPanel;
    private JPanel _columnPanel;
    private JPanel _errorUpperPanel;
    private JPanel _errorLowerPanel;
    private JPanel _errorbarInformationPanel;
    private JPanel _showErrorBarPanel;
    private JLabel _yColumn;
    private JLabel _upperError;
    private JLabel _lowerError;
    private JLabel _yColumnName;
    private JLabel _errorbarInformation;
    private JComboBox _cmbYcolumn;
    private JComboBox _cmbErrorUpper;
    private JComboBox _cmbErrorLower;
    private JCheckBox _showErrorBars = null;
    public static final int dialogboxHeight = 275;
    public static final int dialogboxWidth = 450;
    private int _rowIndexLowerError = -1;
    private int _rowIndexUpperError = -1;
    private PlotColumn _pc;
    private static final String[] errorBarInformation;

    public PlotErrorBarsDialogBox(Frame owner, PlotVOApplet pva, PlotButtons pb) {
        this.setTitle("Specify the Error Bars for the Plot");
        this.setModal(true);
        this._pb = pb;
        this.init(pva);
        this.addPanel();
    }

    private void addPanel() {
        this._panel = new JPanel();
        this._panel.setLayout(new BoxLayout(this._panel, 1));
        this._panel.add(this.createPanel());
        this._optionPane = new JOptionPane(this._panel, 1, 1, null, _buttons, _buttons[0]);
        this._optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (PlotErrorBarsDialogBox.this.isVisible() && e.getSource() == PlotErrorBarsDialogBox.this._optionPane && (prop.equals("value") || prop.equals("inputValue"))) {
                    Object value = PlotErrorBarsDialogBox.this._optionPane.getValue();
                    if (value == JOptionPane.UNINITIALIZED_VALUE) {
                        return;
                    }
                    PlotErrorBarsDialogBox.this._optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                    if (value instanceof String) {
                        PlotErrorBarsDialogBox.this._buttonPressed = (String)value;
                    }
                    if (_buttons[1].equals(PlotErrorBarsDialogBox.this._buttonPressed)) {
                        if (PlotErrorBarsDialogBox.this._showErrorBars.isSelected()) {
                            PlotErrorBarsDialogBox.this._pc.setShowErrorBar(true);
                        } else {
                            PlotErrorBarsDialogBox.this._pc.setShowErrorBar(false);
                        }
                        PlotErrorBarsDialogBox.this._pc.setUpperYErrorBarColumnIndex(PlotErrorBarsDialogBox.this._cmbErrorUpper.getSelectedIndex());
                        PlotErrorBarsDialogBox.this._pc.setLowerYErrorBarColumnIndex(PlotErrorBarsDialogBox.this._cmbErrorLower.getSelectedIndex());
                        PlotErrorBarsDialogBox.this._pva.drawPlot(true, true);
                    } else if (_buttons[2].equals(PlotErrorBarsDialogBox.this._buttonPressed)) {
                        JOptionPane.showMessageDialog(null, errorBarInformation, "Help for creating error Bars", 1);
                        return;
                    }
                    ((Component)PlotErrorBarsDialogBox.this).setVisible(false);
                    PlotErrorBarsDialogBox.this._handleClosing();
                }
            }
        });
        this.getContentPane().add(this._optionPane);
        this.pack();
        this.setResizable(false);
        ((Component)this).setSize(450, 275);
        Toolkit tk = Toolkit.getDefaultToolkit();
        ((Component)this).setLocation((tk.getScreenSize().width - this.getSize().width) / 2, (tk.getScreenSize().height - this.getSize().height) / 2);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                PlotErrorBarsDialogBox.this._handleClosing();
            }
        });
        ((Component)this).setVisible(true);
    }

    protected void _handleClosing() {
        if (this.contents instanceof CloseListener && !this._doneHandleClosing) {
            this._doneHandleClosing = true;
            ((CloseListener)((Object)this.contents)).windowClosed(this, this._buttonPressed);
        }
    }

    private void init(PlotVOApplet pva) {
        this._pva = pva;
    }

    private JPanel createPanel() {
        this._pd = this._pva.getPlotData();
        this._pc = this._pd.getPlotColumn(this._pb.getSelectedYIndex());
        String selectYColumn = this._pb.getSelectedYColumn();
        this._yColumn = new JLabel(" The Selected Y column   : ");
        this._yColumnName = new JLabel(selectYColumn);
        this._errorbarInformation = new JLabel("The Error Bars are calculated and drawn relative to the Y-Column");
        this._upperError = new JLabel("Upper Limit Of Error Bar");
        this._lowerError = new JLabel("Lower Limit Of Error Bar");
        this._cmbErrorUpper = new JComboBox();
        this._cmbErrorLower = new JComboBox();
        String[] fields = this._pva.getColumnNames();
        for (int i = 0; i < this._pva.getNumOfColumns(); ++i) {
            String fieldName = fields[i];
            String errorUpperColumn = "E".concat(String.valueOf(String.valueOf(selectYColumn)));
            String errorLowerColumn = "e".concat(String.valueOf(String.valueOf(selectYColumn)));
            this._cmbErrorUpper.addItem(fields[i]);
            this._cmbErrorLower.addItem(fields[i]);
            if (this._pc.getShowErrorBar()) continue;
            if (fieldName.equals(errorUpperColumn)) {
                this._rowIndexUpperError = i;
            }
            if (!fieldName.equals(errorLowerColumn)) continue;
            this._rowIndexLowerError = i;
        }
        if (!this._pc.getShowErrorBar()) {
            if (this._rowIndexUpperError == -1 && this._rowIndexLowerError > -1) {
                this._rowIndexUpperError = this._rowIndexLowerError;
            }
            if (this._rowIndexLowerError == -1 && this._rowIndexUpperError > -1) {
                this._rowIndexLowerError = this._rowIndexUpperError;
            }
            if (this._rowIndexLowerError == -1 && this._rowIndexUpperError == -1) {
                this._rowIndexLowerError = 0;
                this._rowIndexUpperError = 0;
            }
        }
        if (this._pc.getShowErrorBar()) {
            this._showErrorBars = new JCheckBox("Show Error Bar", true);
            this._cmbErrorUpper.setSelectedIndex(this._pc.getUpperYErrorBarColumnIndex());
            this._cmbErrorLower.setSelectedIndex(this._pc.getLowerYErrorBarColumnIndex());
        } else {
            this._showErrorBars = new JCheckBox("Show Error Bar   ", false);
            this._cmbErrorUpper.setSelectedIndex(this._rowIndexLowerError);
            this._cmbErrorLower.setSelectedIndex(this._rowIndexLowerError);
        }
        this._mainPanel = new JPanel();
        this._mainPanel.setLayout(new FlowLayout(0));
        this._columnPanel = new JPanel();
        this._errorbarInformationPanel = new JPanel();
        this._errorUpperPanel = new JPanel();
        this._errorLowerPanel = new JPanel();
        this._showErrorBarPanel = new JPanel();
        this._columnPanel.add(this._yColumn);
        this._columnPanel.add(this._yColumnName);
        this._errorbarInformationPanel.add(this._errorbarInformation);
        this._errorUpperPanel.add(this._upperError);
        this._errorUpperPanel.add(this._cmbErrorUpper);
        this._errorLowerPanel.add(this._lowerError);
        this._errorLowerPanel.add(this._cmbErrorLower);
        this._showErrorBarPanel.add(this._showErrorBars);
        this._mainPanel.add(this._columnPanel);
        this._mainPanel.add(this._errorbarInformationPanel);
        this._mainPanel.add(this._errorUpperPanel);
        this._mainPanel.add(this._errorLowerPanel);
        this._mainPanel.add(this._showErrorBarPanel);
        return this._mainPanel;
    }

    static {
        dialogboxHeight = 275;
        dialogboxWidth = 450;
        errorBarInformation = new String[]{"The Error Bars are calculated and drawn relative to the Y-Column.\n\nFor any Y-Column ABC the error values should be specified in the column E_ABC(upper case) \nor e_ABC(lower case).\nIf e_ABC contains the error then the error bar is drawn between \nABC - e_ABC (the lower limit of the error bar) and ABC + e_ABC (the upper limit of the error bar). \n\nFor e.g.\n If the Y Coordinate = 31,Upper limit of errorbar = 1 and lower limit = 2. \nThen Error Bar is drawn parellel to the Y-axis from Y-column value 32(31+1) to \nY-column value 29(31-2).\n\nThe user can also specify any column as the error column."};
    }
}

