/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import com.jvt.applets.PlotButtons;
import com.jvt.applets.PlotVOApplet;
import com.jvt.utils.JVTUtil;
import com.jvt.votable.DataDisplayColumn;
import com.jvt.votable.PlotColumn;
import com.jvt.votable.PlotData;
import com.jvt.votable.PlotFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ptolemy.gui.CloseListener;

public class PlotDataDisplayDialog
extends JFrame
implements ListSelectionListener {
    public Component contents;
    protected String _buttonPressed = "";
    private static final String _TRUE = "T";
    private static final String _FALSE = "F";
    private static String[] _buttons;
    private boolean _doneHandleClosing = false;
    private JOptionPane _optionPane;
    private PlotVOApplet _pva = null;
    private PlotData _pd = null;
    private PlotButtons _pb = null;
    private JTable _dataTable;
    private JTable _metadataTable;
    private JScrollPane _dataScrollPane;
    private JScrollPane _metadataScrollPane;
    private JPanel _dataPanel;
    private JPanel _metadataPanel;
    private JPanel _panel;
    private JPanel _dataDisplayPanel;
    private JPanel _votableDisplayPanel;
    private JLabel _tableData = new JLabel("Table Data : ");
    private JLabel _lblDlgDesc = new JLabel("Display VOPlot meta-data and data in table format.");
    private JLabel _tableMetaData = new JLabel("Table MetaData : ");
    private int _verticalscrollbar = 22;
    private int _horizontalscrollbar = 32;
    private JRadioButton _entireData;
    private JRadioButton _selectedData;
    private JRadioButton _highlightedData;
    private ButtonGroup _radioButtonGroup;
    private JPanel _radioButtonsPanel;
    private boolean _isDataSelected = false;
    private static final String ENTIRE_DATA_LABEL = "Show all";
    private static final String SELECTED_DATA_LABEL = "Show selected";
    private static final String HIGHLIGHTED_DATA_LABEL = "Show highlighted (from external application)";
    DecimalFormat _fmt1;
    DecimalFormat _fmt2;
    public static final int AUTO_RESIZE_OFF = 0;
    public static final int dialogboxHeight = 550;
    public static final int dialogboxWidth = 800;
    int[] _selectedIndexs;
    HashSet _selectedPointIndexs = new HashSet();
    String[] oids;

    public PlotDataDisplayDialog(Frame owner, PlotVOApplet pva, PlotButtons pb) {
        try {
            this.setTitle("Display VOTable Data in Tabular format");
            this._pb = pb;
            this.init(pva);
            this.addPanel();
            ((Frame)this).setIconImage(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource(String.valueOf(String.valueOf(JVTUtil.SMALL_IMAGE_PATH)).concat("voplotlogo.gif"))));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addPanel() {
        this._panel = new JPanel();
        this._panel.setLayout(new BoxLayout(this._panel, 1));
        this._panel.add(this._dataDisplayPanel);
        this._optionPane = new JOptionPane(this._panel, 1, 1, null, _buttons, _buttons[0]);
        this._optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (PlotDataDisplayDialog.this.isVisible() && e.getSource() == PlotDataDisplayDialog.this._optionPane && (prop.equals("value") || prop.equals("inputValue"))) {
                    Object value = PlotDataDisplayDialog.this._optionPane.getValue();
                    if (value == JOptionPane.UNINITIALIZED_VALUE) {
                        return;
                    }
                    PlotDataDisplayDialog.this._optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                    if (value instanceof String) {
                        PlotDataDisplayDialog.this._buttonPressed = (String)value;
                    }
                    if (_buttons[1].equals(PlotDataDisplayDialog.this._buttonPressed)) {
                        String[] oids = new String[PlotDataDisplayDialog.this._selectedPointIndexs.size()];
                        int count = 0;
                        for (int iDataColumn = 0; iDataColumn < PlotDataDisplayDialog.this._pd.getNumOfDataDisplayColumns(); ++iDataColumn) {
                            if (iDataColumn != PlotDataDisplayDialog.this._pd.getObjectIDColumnIndex()) continue;
                            DataDisplayColumn ddc = PlotDataDisplayDialog.this._pd.getDataDisplayColumn(iDataColumn);
                            Iterator oidsIterator = PlotDataDisplayDialog.this._selectedPointIndexs.iterator();
                            while (oidsIterator.hasNext()) {
                                String oid;
                                Integer indexValue = (Integer)oidsIterator.next();
                                int index = indexValue;
                                oids[count] = oid = ddc.getData(index);
                                ++count;
                            }
                        }
                        PlotDataDisplayDialog.this._pva.addToSelectedPoints(oids, false);
                        PlotDataDisplayDialog.this._pva.selectPoints(oids);
                        return;
                    }
                    ((Component)PlotDataDisplayDialog.this).setVisible(false);
                    JVTUtil.SHOW_DATA = true;
                    PlotDataDisplayDialog.this._handleClosing();
                }
            }
        });
        this.getContentPane().add(this._optionPane);
        this.pack();
        this.setResizable(false);
        ((Component)this).setSize(800, 550);
        Toolkit tk = Toolkit.getDefaultToolkit();
        ((Component)this).setLocation((tk.getScreenSize().width - this.getSize().width) / 2, (tk.getScreenSize().height - this.getSize().height) / 2);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JVTUtil.SHOW_DATA = true;
                PlotDataDisplayDialog.this._handleClosing();
            }
        });
        ((Component)this).setVisible(true);
    }

    private JPanel addRadioButtonsPanel() {
        this._radioButtonsPanel = new JPanel();
        this._entireData = new JRadioButton(ENTIRE_DATA_LABEL, false);
        this._radioButtonsPanel.add(this._entireData);
        this._selectedData = new JRadioButton(SELECTED_DATA_LABEL, false);
        this._radioButtonsPanel.add(this._selectedData);
        this._highlightedData = new JRadioButton(HIGHLIGHTED_DATA_LABEL, false);
        if (this._pva.isAladinInvoked()) {
            this._radioButtonsPanel.add(this._highlightedData);
        }
        if (this._isDataSelected) {
            this._selectedData.setSelected(true);
        } else {
            this._entireData.setSelected(true);
        }
        this._entireData.addActionListener(new RadioListener());
        this._selectedData.addActionListener(new RadioListener());
        this._highlightedData.addActionListener(new RadioListener());
        this._radioButtonGroup = new ButtonGroup();
        this._radioButtonGroup.add(this._entireData);
        this._radioButtonGroup.add(this._selectedData);
        this._radioButtonGroup.add(this._highlightedData);
        return this._radioButtonsPanel;
    }

    protected void _handleClosing() {
        if (this.contents instanceof CloseListener && !this._doneHandleClosing) {
            this._doneHandleClosing = true;
            ((CloseListener)((Object)this.contents)).windowClosed(this, this._buttonPressed);
        }
    }

    private void init(PlotVOApplet pva) {
        this._pva = pva;
        this._pd = pva.getPlotData();
        JVTUtil.SHOW_DATA = false;
        this._selectedIndexs = null;
        ArrayList selectedPoints = this._pva.getSelectedPointsIndex();
        this._isDataSelected = selectedPoints != null && selectedPoints.size() > 0;
        this._dataPanel = new JPanel();
        this._metadataPanel = new JPanel();
        this._dataDisplayPanel = new JPanel();
        this._fmt1 = new DecimalFormat("0.0000");
        this._fmt2 = new DecimalFormat("0.0000E0");
        try {
            Vector<String> metaDataRows;
            Vector<String> metaDataColumnNames = new Vector<String>();
            metaDataColumnNames.add("Name");
            metaDataColumnNames.add("Data Type");
            metaDataColumnNames.add("Unit");
            metaDataColumnNames.add("UCD");
            Vector metaDataAllRows = new Vector();
            for (int iPlotColumn = 0; iPlotColumn < this._pd.getNumOfPlotColumns(); ++iPlotColumn) {
                metaDataRows = new Vector<String>();
                PlotColumn pc = this._pd.getPlotColumn(iPlotColumn);
                metaDataRows.add(pc.getName());
                metaDataRows.add(pc.getDatatype());
                metaDataRows.add(pc.getUnit());
                metaDataRows.add(pc.getUCD());
                metaDataAllRows.add(metaDataRows);
            }
            for (int iDataColumn = 0; iDataColumn < this._pd.getNumOfDataDisplayColumns(); ++iDataColumn) {
                if (iDataColumn == this._pd.getObjectIDColumnIndex()) continue;
                metaDataRows = new Vector();
                DataDisplayColumn ddc = this._pd.getDataDisplayColumn(iDataColumn);
                metaDataRows.add(ddc.getName());
                metaDataRows.add(ddc.getDatatype());
                metaDataRows.add(ddc.getUnit());
                metaDataRows.add(ddc.getUCD());
                metaDataAllRows.add(metaDataRows);
            }
            for (int iFilterColumn = 0; iFilterColumn < this._pd.getNumOfFilters(); ++iFilterColumn) {
                metaDataRows = new Vector();
                PlotFilter pf = this._pd.getPlotFilter(iFilterColumn);
                metaDataRows.add(pf.getName());
                metaDataRows.add(pf.getDatatype());
                metaDataRows.add(pf.getUnit());
                metaDataRows.add(pf.getUCD());
                metaDataAllRows.add(metaDataRows);
            }
            this._metadataTable = new JTable(metaDataAllRows, metaDataColumnNames);
            this._metadataTable.setPreferredScrollableViewportSize(new Dimension(600, 93));
            this._metadataScrollPane = new JScrollPane(this._metadataTable, this._verticalscrollbar, this._horizontalscrollbar);
            this._metadataScrollPane.setRequestFocusEnabled(false);
            this._metadataPanel.setLayout(new BorderLayout());
            JPanel lblpanel = new JPanel(new BorderLayout());
            lblpanel.add((Component)this._lblDlgDesc, "Center");
            lblpanel.add((Component)this._tableMetaData, "South");
            this._metadataPanel.add((Component)lblpanel, "North");
            this._metadataPanel.add((Component)this._metadataScrollPane, "Center");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this._dataDisplayPanel.add(this._metadataPanel);
        this._dataScrollPane = new JScrollPane(null, this._verticalscrollbar, this._horizontalscrollbar);
        if (this._isDataSelected) {
            this.viewSelectiveData(this._pva.getSelectedPointsIndex());
        } else {
            this.showEntireData();
        }
        this._dataDisplayPanel.add(this._dataPanel);
        this._dataDisplayPanel.add(this.addRadioButtonsPanel());
    }

    private void showEntireData() {
        try {
            Vector columnNames = new Vector();
            columnNames = this.generateColumnNames();
            Vector allRows = new Vector();
            for (int iRowNumber = 0; iRowNumber < this._pd.getNumOfRows(); ++iRowNumber) {
                Vector<String> row = new Vector<String>();
                row.add(this.generateSerialNumber(iRowNumber + 1));
                for (int iPlotColumn = 0; iPlotColumn < this._pd.getNumOfPlotColumns(); ++iPlotColumn) {
                    PlotColumn pc = this._pd.getPlotColumn(iPlotColumn);
                    int datatype = pc.getDatatypeIntegerFormat();
                    Double colData = pc.getData(iRowNumber);
                    this.appendData(colData, datatype, row);
                }
                for (int iDataColumn = 0; iDataColumn < this._pd.getNumOfDataDisplayColumns(); ++iDataColumn) {
                    if (iDataColumn == this._pd.getObjectIDColumnIndex()) continue;
                    DataDisplayColumn ddc = this._pd.getDataDisplayColumn(iDataColumn);
                    row.add(ddc.getData(iRowNumber));
                }
                for (int iFilterColumn = 0; iFilterColumn < this._pd.getNumOfFilters(); ++iFilterColumn) {
                    PlotFilter pf = this._pd.getPlotFilter(iFilterColumn);
                    if (pf.getData(iRowNumber)) {
                        row.add(_TRUE);
                        continue;
                    }
                    row.add(_FALSE);
                }
                allRows.add(row);
            }
            this._dataTable = new JTable(allRows, columnNames);
            ListSelectionModel tableListener = this._dataTable.getSelectionModel();
            this._dataTable.setSelectionModel(tableListener);
            this._dataTable.setPreferredScrollableViewportSize(new Dimension(600, 196));
            tableListener.addListSelectionListener(this);
            this._dataTable.setAutoResizeMode(0);
            this._dataScrollPane.setViewportView(this._dataTable);
            this._dataPanel.setLayout(new BorderLayout());
            this._dataPanel.add((Component)this._tableData, "North");
            this._dataPanel.add((Component)this._dataScrollPane, "Center");
            this._dataDisplayPanel.add(this._dataPanel);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String generateSerialNumber(int rowNumber) {
        String count = String.valueOf(String.valueOf(rowNumber)).concat("");
        return count;
    }

    private Vector generateColumnNames() {
        Vector<String> columnNames = new Vector<String>();
        try {
            columnNames.add("Sr No.");
            for (int iPlotColumn = 0; iPlotColumn < this._pd.getNumOfPlotColumns(); ++iPlotColumn) {
                PlotColumn pc = this._pd.getPlotColumn(iPlotColumn);
                columnNames.add(pc.getName());
            }
            for (int iDataColumn = 0; iDataColumn < this._pd.getNumOfDataDisplayColumns(); ++iDataColumn) {
                if (iDataColumn == this._pd.getObjectIDColumnIndex()) continue;
                DataDisplayColumn ddc = this._pd.getDataDisplayColumn(iDataColumn);
                columnNames.add(ddc.getName());
            }
            for (int iFilterColumn = 0; iFilterColumn < this._pd.getNumOfFilters(); ++iFilterColumn) {
                PlotFilter pf = this._pd.getPlotFilter(iFilterColumn);
                columnNames.add(pf.getName());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return columnNames;
    }

    private void viewSelectiveData(ArrayList selectedIndexs) {
        try {
            int rowindex = 0;
            Vector columnNames = new Vector();
            columnNames = this.generateColumnNames();
            Vector allRows = new Vector();
            for (int iselectedRowCount = 0; iselectedRowCount < selectedIndexs.size(); ++iselectedRowCount) {
                Vector<String> row = new Vector<String>();
                Integer index = (Integer)selectedIndexs.get(iselectedRowCount);
                if (index == null) break;
                rowindex = index;
                row.add(this.generateSerialNumber(rowindex + 1));
                for (int iPlotColumn = 0; iPlotColumn < this._pd.getNumOfPlotColumns(); ++iPlotColumn) {
                    PlotColumn pc = this._pd.getPlotColumn(iPlotColumn);
                    int datatype = pc.getDatatypeIntegerFormat();
                    this.appendData(pc.getData(rowindex), datatype, row);
                }
                for (int iDataColumn = 0; iDataColumn < this._pd.getNumOfDataDisplayColumns(); ++iDataColumn) {
                    if (iDataColumn == this._pd.getObjectIDColumnIndex()) continue;
                    DataDisplayColumn ddc = this._pd.getDataDisplayColumn(iDataColumn);
                    row.add(ddc.getData(rowindex));
                }
                for (int iFilterColumn = 0; iFilterColumn < this._pd.getNumOfFilters(); ++iFilterColumn) {
                    PlotFilter pf = this._pd.getPlotFilter(iFilterColumn);
                    if (pf.getData(rowindex)) {
                        row.add(_TRUE);
                        continue;
                    }
                    row.add(_FALSE);
                }
                allRows.add(row);
            }
            this._dataTable = new JTable(allRows, columnNames);
            this._dataTable.setPreferredScrollableViewportSize(new Dimension(600, 196));
            this._dataTable.setAutoResizeMode(0);
            this._dataScrollPane.setViewportView(this._dataTable);
            this._dataPanel.setLayout(new BorderLayout());
            this._dataPanel.add((Component)this._tableData, "North");
            this._dataPanel.add((Component)this._dataScrollPane, "Center");
            this._dataDisplayPanel.add(this._dataPanel);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void appendData(Double colData, int datatype, Vector row) {
        if (colData == null) {
            row.add("");
        } else if (7 == datatype) {
            double check = colData;
            String value = JVTUtil.applyProperFormat(check, this._fmt1, this._fmt2);
            row.add(value);
        } else {
            row.add(JVTUtil.getInOriginalFormat(colData, datatype));
        }
    }

    public void valueChanged(ListSelectionEvent listselectionevent) {
        this._selectedPointIndexs.clear();
        this._selectedIndexs = this._dataTable.getSelectedRows();
        for (int i = 0; i < this._selectedIndexs.length; ++i) {
            Integer index = new Integer(this._selectedIndexs[i]);
            this._selectedPointIndexs.add(index);
        }
    }

    static {
        _TRUE = _TRUE;
        _FALSE = _FALSE;
        _buttons = new String[]{"Close", "Select Points On Plot"};
        ENTIRE_DATA_LABEL = ENTIRE_DATA_LABEL;
        SELECTED_DATA_LABEL = SELECTED_DATA_LABEL;
        HIGHLIGHTED_DATA_LABEL = HIGHLIGHTED_DATA_LABEL;
        AUTO_RESIZE_OFF = 0;
        dialogboxHeight = 550;
        dialogboxWidth = 800;
    }

    class RadioListener
    implements ActionListener {
        RadioListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (PlotDataDisplayDialog.this._pva.getPlotData() != null) {
                if (PlotDataDisplayDialog.this._entireData.isSelected()) {
                    PlotDataDisplayDialog.this.showEntireData();
                } else if (PlotDataDisplayDialog.this._selectedData.isSelected()) {
                    PlotDataDisplayDialog.this.viewSelectiveData(PlotDataDisplayDialog.this._pva.getSelectedPointsIndex());
                } else if (PlotDataDisplayDialog.this._highlightedData.isSelected()) {
                    PlotDataDisplayDialog.this.viewSelectiveData(PlotDataDisplayDialog.this._pva.getHighlightedPointsIndex());
                }
            }
        }
    }
}

