/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import com.jvt.applets.PlotButtons;
import com.jvt.applets.PlotVOApplet;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import ptolemy.plot.Histogram;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;
import ptolemy.plot.PlotFilterData;
import ptolemy.plot.PlotInfo;
import ptolemy.plot.PlotPoints;

public class PlotBoxProperties
implements Serializable {
    private PlotBox pb;
    private PlotVOApplet pva;
    private PlotButtons buttons;
    private String Title;
    private String XLabel;
    private String YLabel = new String();
    private int NoPlots;
    private int NoCols;
    private int noPlotsAsYet;
    private int NoFils = 0;
    private String Marks = new String("dots");
    private boolean Grid;
    private boolean Colors = true;
    private boolean Overlay;
    private boolean Histogram = false;
    private boolean Impulses;
    private boolean Connected = false;
    private int Height;
    private int Width = 0;
    private double[] XRange;
    private double[] YRange = new double[]{-1.0, 1.0};
    private Vector[] XTicks;
    private Vector[] YTicks;
    private Color Background;
    private Color Foreground;
    private double BinWidth = -1.0;
    private boolean dataGiven;
    private ArrayList _plotInfo = new ArrayList();
    private ArrayList _plotPoints = new ArrayList();
    private ArrayList _plotFilterData = new ArrayList();

    public int getPlotInfoSize() {
        return this._plotInfo.size();
    }

    public void setPlotBoxProperties(PlotVOApplet _pva, PlotBox _pb, PlotButtons _buttons) {
        this.pb = _pb;
        this.pva = _pva;
        this.buttons = _buttons;
        this.Title = this.pb.getTitle();
        this.XLabel = this.pb.getXLabel();
        this.YLabel = this.pb.getYLabel();
        this.NoPlots = this.pva.getNumPlots();
        this.Grid = this.pb.getGrid();
        this.Colors = this.pb.getColor();
        this.Overlay = this.pva.toOverlay();
        this.Histogram = this.pva.isHistogram();
        this.Height = this.pva.getAppletHeight();
        this.Width = this.pva.getAppletWidth();
        this.XRange = this.pb.getXRange();
        this.YRange = this.pb.getYRange();
        this.XTicks = this.pb.getXTicks();
        this.YTicks = this.pb.getYTicks();
        this.Background = this.pva.getBackColor();
        this.Foreground = this.pva.getForeColor();
        if (this.pb instanceof Histogram) {
            Histogram hist = (Histogram)this.pb;
            this.BinWidth = hist.getBinWidth();
        }
        if (this.pb instanceof Plot) {
            Plot pt = (Plot)this.pb;
            this.Marks = pt.getMarksStyle();
            this.Impulses = pt.getImpulses();
            this.Connected = pt.getConnected();
        }
        this.dataGiven = false;
        this.NoCols = 0;
    }

    public void addPlotInfo(int dataSet) {
        PlotInfo pinfo = new PlotInfo();
        pinfo.addSelectedXColName(this.buttons.getSelectedXColumn());
        pinfo.addSelectedYColName(this.buttons.getSelectedYColumn());
        pinfo.addSelectedFilterName(this.buttons.getSelectedFilter());
        pinfo.addCatalogueIndex(this.pva.getCurrentPlotDataIndex());
        if (dataSet == 1) {
            PlotInfo tmpinfo = (PlotInfo)this._plotInfo.get(0);
            tmpinfo.addLegend(this.pb.getLegend(0));
        }
        if (dataSet >= 1) {
            pinfo.addLegend(this.pb.getLegend(dataSet));
        }
        pinfo.addXLog(this.buttons.isLogX());
        pinfo.addYLog(this.buttons.isLogY());
        pinfo.addSelectedXColIndex(this.pva.getColumnIndex(this.buttons.getSelectedXColumn()));
        pinfo.addSelectedYColIndex(this.pva.getColumnIndex(this.buttons.getSelectedYColumn()));
        pinfo.setCooSysIndex(this.buttons.getSelectedCooSysIndex());
        for (int i = 0; i < this.noPlotsAsYet; ++i) {
            PlotInfo pi = (PlotInfo)this._plotInfo.get(i);
            if (pi.getDataset() != dataSet) continue;
            this._plotInfo.set(i, pinfo);
            return;
        }
        this.noPlotsAsYet = dataSet + 1;
        this._plotInfo.add(pinfo);
    }

    public PlotInfo getPlotInfo(int dataSet) {
        return (PlotInfo)this._plotInfo.get(dataSet);
    }

    public void addPlotData(int index, Double[] givenData) {
        for (int i = 0; i < this.NoCols; ++i) {
            PlotPoints pp = (PlotPoints)this._plotPoints.get(i);
            if (pp.getIndex() != index) continue;
            return;
        }
        PlotPoints datapts = new PlotPoints();
        datapts.addData(index, givenData);
        this._plotPoints.add(datapts);
        ++this.NoCols;
        this.dataGiven = true;
    }

    public PlotPoints getPlotData(int index) {
        for (int i = 0; i < this.NoCols; ++i) {
            PlotPoints pp = (PlotPoints)this._plotPoints.get(i);
            if (pp.getIndex() != index) continue;
            return (PlotPoints)this._plotPoints.get(i);
        }
        return null;
    }

    public void addFilterData(String givenName, boolean[] givenFilterData) {
        for (int i = 0; i < this.NoFils; ++i) {
            PlotFilterData pfd = (PlotFilterData)this._plotFilterData.get(i);
            if (!pfd.getFilterName().equals(givenName)) continue;
            return;
        }
        PlotFilterData datapts = new PlotFilterData();
        datapts.addFilterData(givenName, givenFilterData);
        this._plotFilterData.add(datapts);
        ++this.NoFils;
    }

    public PlotFilterData getFilterData(String givenName) {
        for (int i = 0; i < this.NoFils; ++i) {
            PlotFilterData pfd = (PlotFilterData)this._plotFilterData.get(i);
            if (!pfd.getFilterName().equals(givenName)) continue;
            return (PlotFilterData)this._plotFilterData.get(i);
        }
        return null;
    }

    public void clearAll() {
        this._plotInfo.clear();
        this._plotPoints.clear();
        this.noPlotsAsYet = 0;
        this.NoCols = 0;
    }

    public void clearData() {
        this._plotPoints.clear();
        this.NoCols = 0;
    }

    public String getTitle() {
        return this.Title;
    }

    public String getXLabel() {
        return this.XLabel;
    }

    public String getYLabel() {
        return this.YLabel;
    }

    public boolean isGrid() {
        return this.Grid;
    }

    public boolean getColor() {
        return this.Colors;
    }

    public boolean toOverlay() {
        return this.Overlay;
    }

    public boolean isHistogram() {
        return this.Histogram;
    }

    public int getHeight() {
        return this.Height;
    }

    public int getWidth() {
        return this.Width;
    }

    public double[] getXRange() {
        return this.XRange;
    }

    public double[] getYRange() {
        return this.YRange;
    }

    public double getBinWidth() {
        return this.BinWidth;
    }

    public String getXTicks() {
        String spec = new String();
        if (this.XTicks != null) {
            for (int i = 0; i < this.XTicks[1].size(); ++i) {
                spec = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(spec))).append(this.XTicks[1].get(i)).append(" ").append(this.XTicks[0].get(i)).append(", ")));
            }
        }
        return spec;
    }

    public String getYTicks() {
        String spec = new String();
        if (this.YTicks != null) {
            for (int i = 0; i < this.YTicks[1].size(); ++i) {
                spec = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(spec))).append(this.YTicks[1].get(i)).append(" ").append(this.YTicks[0].get(i)).append(", ")));
            }
        }
        return spec;
    }

    public Color getBackColor() {
        return this.Background;
    }

    public Color getForeColor() {
        return this.Foreground;
    }

    public String getMarks() {
        return this.Marks;
    }

    public boolean isConnected() {
        return this.Connected;
    }

    public boolean isImpulses() {
        return this.Impulses;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.Title);
        out.writeObject(this.XLabel);
        out.writeObject(this.YLabel);
        out.writeInt(this.NoPlots);
        out.writeInt(this.NoCols);
        out.writeInt(this.NoFils);
        out.writeBoolean(this.Grid);
        out.writeBoolean(this.Colors);
        out.writeBoolean(this.Overlay);
        out.writeBoolean(this.Histogram);
        out.writeInt(this.Height);
        out.writeInt(this.Width);
        out.writeObject(this.XRange);
        out.writeObject(this.YRange);
        out.writeObject(this.XTicks);
        out.writeObject(this.YTicks);
        out.writeObject(this.Background);
        out.writeObject(this.Foreground);
        out.writeBoolean(this.dataGiven);
        out.writeObject(this._plotInfo);
        out.writeObject(this._plotFilterData);
        if (!this.Histogram) {
            out.writeObject(this.Marks);
            out.writeBoolean(this.Impulses);
            out.writeBoolean(this.Connected);
        } else {
            out.writeDouble(this.BinWidth);
        }
        if (this.dataGiven) {
            out.writeObject(this._plotPoints);
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        this.Title = (String)in.readObject();
        this.XLabel = (String)in.readObject();
        this.YLabel = (String)in.readObject();
        this.NoPlots = in.readInt();
        this.NoCols = in.readInt();
        this.NoFils = in.readInt();
        this.Grid = in.readBoolean();
        this.Colors = in.readBoolean();
        this.Overlay = in.readBoolean();
        this.Histogram = in.readBoolean();
        this.Height = in.readInt();
        this.Width = in.readInt();
        this.XRange = (double[])in.readObject();
        this.YRange = (double[])in.readObject();
        this.XTicks = (Vector[])in.readObject();
        this.YTicks = (Vector[])in.readObject();
        this.Background = (Color)in.readObject();
        this.Foreground = (Color)in.readObject();
        this.dataGiven = in.readBoolean();
        this._plotInfo = (ArrayList)in.readObject();
        this._plotFilterData = (ArrayList)in.readObject();
        if (!this.Histogram) {
            this.Marks = (String)in.readObject();
            this.Impulses = in.readBoolean();
            this.Connected = in.readBoolean();
        } else {
            this.BinWidth = in.readDouble();
        }
        if (this.dataGiven) {
            this._plotPoints = (ArrayList)in.readObject();
        }
    }
}

