/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import com.jvt.applets.PlotButtons;
import com.jvt.applets.PlotVOApplet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import ptolemy.plot.EPSGraphics;

public class PlotBox
extends JPanel
implements Printable {
    private PlotVOApplet pva;
    private PlotButtons buttons;
    private String xcoordFormat = "";
    private String ycoordFormat = "";
    public static final String PTPLOT_RELEASE = "5.2";
    protected transient double _yMax = 0.0;
    protected transient double _yMin = 0.0;
    protected transient double _xMax = 0.0;
    protected transient double _xMin = 0.0;
    protected double _padding = 0.05;
    protected transient boolean _xRangeGiven = false;
    protected transient boolean _yRangeGiven = false;
    protected transient boolean _xTickDistGiven = false;
    protected transient boolean _yTickDistGiven = false;
    protected transient boolean _rangesGivenByZooming = false;
    protected double _xlowgiven;
    protected double _xhighgiven;
    protected double _ylowgiven;
    protected double _yhighgiven;
    protected double _xBottom = Double.MAX_VALUE;
    protected double _xTop = -1.7976931348623157E308;
    protected double _yBottom = Double.MAX_VALUE;
    protected double _yTop = -1.7976931348623157E308;
    protected boolean _xlog = false;
    protected boolean _ylog = false;
    protected static final double _LOG10SCALE;
    protected boolean _grid = true;
    protected boolean _wrap = false;
    protected double _wrapHigh;
    protected double _wrapLow;
    protected Color _background = Color.white;
    protected Color _foreground = Color.black;
    protected int _topPadding = 10;
    protected int _bottomPadding = 5;
    protected int _rightPadding = 10;
    protected int _leftPadding = 10;
    protected int _ulx = 1;
    protected int _uly = 1;
    protected int _lrx = 100;
    protected int _lry = 100;
    protected double _yscale = 1.0;
    protected double _xscale = 1.0;
    protected boolean _usecolor = true;
    private transient boolean _shiftKeyPressed = false;
    public static final Color[] _colors;
    public static final int[] _markerStyles;
    protected int _width = 500;
    protected int _height = 300;
    protected int _preferredWidth = 500;
    protected int _preferredHeight = 300;
    protected boolean _sizeHasBeenSet = false;
    public static final String _PSPLDatasetLabel = "Current";
    public URL _documentBase = null;
    private static final int ZOOM_MODE = 1;
    private static final int SELECT_MODE = 2;
    private static final int UNSELECT_MODE = 3;
    private int _buttonMode = 1;
    private boolean _actionsDeferred = false;
    private List _deferredActions;
    private String _filespec = null;
    private static final Color _boxColor;
    private double _ytickMax = 0.0;
    private double _ytickMin = 0.0;
    private double _xtickMax = 0.0;
    private double _xtickMin = 0.0;
    private int _yExp = 0;
    private int _xExp = 0;
    private double _ytickscale = 0.0;
    private double _xtickscale = 0.0;
    private Font _labelFont = null;
    private Font _superscriptFont = null;
    private Font _titleFont = null;
    private FontMetrics _labelFontMetrics = null;
    private FontMetrics _superscriptFontMetrics = null;
    private FontMetrics _titleFontMetrics = null;
    private transient int _gridCurJuke = 0;
    private transient double _gridBase = 0.0;
    private transient String[] _errorMsg;
    private String _xlabel;
    private String _ylabel;
    private String _title;
    private double _xtickdist;
    private double _ytickdist;
    private Vector _legendStrings = new Vector();
    private Vector _legendDatasets = new Vector();
    private Vector _legendColors = new Vector();
    private Vector _legendStyles = new Vector();
    private Vector _xticks = null;
    private Vector _xticklabels = null;
    private Vector _yticks = null;
    private Vector _yticklabels = null;
    boolean _originalXRangeGiven = false;
    boolean _originalYRangeGiven = false;
    double _originalXlow = 0.0;
    double _originalXhigh = 0.0;
    double _originalYlow = 0.0;
    double _originalYhigh = 0.0;
    private transient int _zoomx = -1;
    private transient int _zoomy = -1;
    private transient int _zoomxn = -1;
    private transient int _zoomyn = -1;
    private transient boolean _zoomin = false;
    private transient boolean _zoomout = false;
    private transient boolean _drawn = false;
    private transient boolean _zooming = false;
    private static final String _DTD = "<!-- PlotML DTD, created by Edward A. Lee, eal@eecs.berkeley.edu.\n   See http://ptolemy.eecs.berkeley.edu/java/ptplot -->\n<!ELEMENT plot (barGraph | bin | dataset | default | noColor | \n\tnoGrid | title | wrap | xLabel | xLog | xRange | xTicks | yLabel | \n yLog | yRange | yTicks)*>\n  <!ELEMENT barGraph EMPTY>\n    <!ATTLIST barGraph width CDATA #IMPLIED>\n    <!ATTLIST barGraph offset CDATA #IMPLIED>\n  <!ELEMENT bin EMPTY>\n    <!ATTLIST bin width CDATA #IMPLIED>\n    <!ATTLIST bin offset CDATA #IMPLIED>\n  <!ELEMENT dataset (m | move | p | point)*>\n    <!ATTLIST dataset connected (yes | no) #IMPLIED>\n    <!ATTLIST dataset marks (none | dots | points | various) #IMPLIED>\n    <!ATTLIST dataset name CDATA #IMPLIED>\n    <!ATTLIST dataset stems (yes | no) #IMPLIED>\n  <!ELEMENT default EMPTY>\n    <!ATTLIST default connected (yes | no) \"yes\">\n    <!ATTLIST default marks (none | dots | points | various) \"none\">\n    <!ATTLIST default stems (yes | no) \"no\">\n  <!ELEMENT noColor EMPTY>\n  <!ELEMENT noGrid EMPTY>\n  <!ELEMENT title (#PCDATA)>\n  <!ELEMENT wrap EMPTY>\n  <!ELEMENT xLabel (#PCDATA)>\n  <!ELEMENT xLog EMPTY>\n  <!ELEMENT xRange EMPTY>\n    <!ATTLIST xRange min CDATA #REQUIRED>\n    <!ATTLIST xRange max CDATA #REQUIRED>\n  <!ELEMENT xTicks (tick)+>\n  <!ELEMENT yLabel (#PCDATA)>\n  <!ELEMENT yLog EMPTY>\n  <!ELEMENT yRange EMPTY>\n    <!ATTLIST yRange min CDATA #REQUIRED>\n    <!ATTLIST yRange max CDATA #REQUIRED>\n  <!ELEMENT yTicks (tick)+>\n    <!ELEMENT tick EMPTY>\n      <!ATTLIST tick label CDATA #REQUIRED>\n      <!ATTLIST tick position CDATA #REQUIRED>\n    <!ELEMENT m EMPTY>\n      <!ATTLIST m x CDATA #IMPLIED>\n      <!ATTLIST m x CDATA #REQUIRED>\n      <!ATTLIST m lowErrorBar CDATA #IMPLIED>\n      <!ATTLIST m highErrorBar CDATA #IMPLIED>\n    <!ELEMENT move EMPTY>\n      <!ATTLIST move x CDATA #IMPLIED>\n      <!ATTLIST move x CDATA #REQUIRED>\n      <!ATTLIST move lowErrorBar CDATA #IMPLIED>\n      <!ATTLIST move highErrorBar CDATA #IMPLIED>\n    <!ELEMENT p EMPTY>\n      <!ATTLIST p x CDATA #IMPLIED>\n      <!ATTLIST p x CDATA #REQUIRED>\n      <!ATTLIST p lowErrorBar CDATA #IMPLIED>\n      <!ATTLIST p highErrorBar CDATA #IMPLIED>\n    <!ELEMENT point EMPTY>\n      <!ATTLIST point x CDATA #IMPLIED>\n      <!ATTLIST point x CDATA #REQUIRED>\n      <!ATTLIST point lowErrorBar CDATA #IMPLIED>\n      <!ATTLIST point highErrorBar CDATA #IMPLIED>";

    public PlotBox() {
        this.setOpaque(true);
        this.setLayout(new FlowLayout(2, 2, 2));
        this.addMouseListener(new ZoomListener());
        this.addKeyListener(new CommandListener());
        this.addMouseMotionListener(new DragListener());
        this._measureFonts();
    }

    public void setVOApplet(PlotVOApplet applet, PlotButtons butt) {
        this.pva = applet;
        this.buttons = butt;
    }

    public synchronized void addLegend(int dataset, String legend) {
        if (legend == null || legend.equals("")) {
            return;
        }
        this._legendStrings.addElement(legend);
        this._legendDatasets.addElement(new Integer(dataset));
        this.addColorAndMarkerStyle(dataset);
    }

    public synchronized void addColorAndMarkerStyle(int dataset) {
        this._legendColors.addElement(_colors[dataset % _colors.length]);
        this._legendStyles.addElement(new Integer(_markerStyles[dataset % _markerStyles.length]));
    }

    public synchronized void addXTick(String label, double position) {
        if (this._xticks == null) {
            this._xticks = new Vector();
            this._xticklabels = new Vector();
        }
        this._xticks.addElement(new Double(position));
        this._xticklabels.addElement(label);
    }

    public synchronized void addYTick(String label, double position) {
        if (this._yticks == null) {
            this._yticks = new Vector();
            this._yticklabels = new Vector();
        }
        this._yticks.addElement(new Double(position));
        this._yticklabels.addElement(label);
    }

    public synchronized void clear(boolean axes) {
        this._xBottom = Double.MAX_VALUE;
        this._xTop = -1.7976931348623157E308;
        this._yBottom = Double.MAX_VALUE;
        this._yTop = -1.7976931348623157E308;
        if (axes) {
            this._yMax = 0.0;
            this._yMin = 0.0;
            this._xMax = 0.0;
            this._xMin = 0.0;
            this._xRangeGiven = false;
            this._yRangeGiven = false;
            this._xTickDistGiven = false;
            this._yTickDistGiven = false;
            this._originalXRangeGiven = false;
            this._originalYRangeGiven = false;
            this._rangesGivenByZooming = false;
            this._xlog = false;
            this._ylog = false;
            this._wrap = false;
            this._filespec = null;
            this._xlabel = null;
            this._ylabel = null;
            this._title = null;
            this._legendStrings = new Vector();
            this._legendDatasets = new Vector();
            this._legendColors = new Vector();
            this._legendStyles = new Vector();
            this._xticks = null;
            this._xticklabels = null;
            this._yticks = null;
            this._yticklabels = null;
        }
    }

    public synchronized void clearLegends() {
        this._legendStrings = new Vector();
        this._legendDatasets = new Vector();
        this._legendColors = new Vector();
        this._legendStyles = new Vector();
    }

    public void deferIfNecessary(Runnable action) {
        if (EventQueue.isDispatchThread()) {
            action.run();
        } else {
            if (this._deferredActions == null) {
                this._deferredActions = new LinkedList();
            }
            this._deferredActions.add(action);
            if (!this._actionsDeferred) {
                Runnable doActions = new Runnable(){

                    public void run() {
                        PlotBox.this._executeDeferredActions();
                    }
                };
                try {
                    SwingUtilities.invokeLater(doActions);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this._actionsDeferred = true;
            }
        }
    }

    public synchronized void export(OutputStream out) {
        try {
            EPSGraphics g = new EPSGraphics(out, this._width, this._height);
            this._drawPlot(g, false);
            g.showpage();
        }
        catch (RuntimeException ex) {
            String message = "Export failed: ".concat(String.valueOf(String.valueOf(ex.getMessage())));
            JOptionPane.showMessageDialog(this, message, "Ptolemy Plot Message", 0);
            throw (RuntimeException)ex.fillInStackTrace();
        }
    }

    public synchronized BufferedImage exportImage() {
        Rectangle rectangle = new Rectangle(this._preferredWidth, this._preferredHeight);
        return this.exportImage(new BufferedImage(rectangle.width, rectangle.height, 2), rectangle, this._defaultImageRenderingHints(), false);
    }

    public synchronized BufferedImage exportImage(Rectangle rectangle) {
        return this.exportImage(new BufferedImage(rectangle.width, rectangle.height, 2), rectangle, this._defaultImageRenderingHints(), false);
    }

    public synchronized BufferedImage exportImage(BufferedImage bufferedImage, Rectangle rectangle, RenderingHints hints, boolean transparent) {
        Graphics2D graphics = bufferedImage.createGraphics();
        graphics.addRenderingHints(this._defaultImageRenderingHints());
        if (!transparent) {
            graphics.setColor(Color.white);
            graphics.fill(rectangle);
        }
        this._drawPlot(graphics, false, rectangle);
        return bufferedImage;
    }

    public synchronized BufferedImage exportImage(BufferedImage bufferedImage) {
        return this.exportImage(bufferedImage, new Rectangle(bufferedImage.getWidth(), bufferedImage.getHeight()), this._defaultImageRenderingHints(), true);
    }

    public synchronized void fillPlot() {
        this.setXRange(this._xBottom, this._xTop);
        this.setYRange(this._yBottom, this._yTop);
        double tick = 0.0;
        double width = -1.0;
        String tickLbl = new String();
        width = this.getXTickSpacing();
        if (width > 0.0) {
            for (tick = this._xBottom; tick < this._xTop; tick += width) {
                tickLbl = Double.toString(tick);
                tickLbl = tickLbl.substring(0, tickLbl.lastIndexOf(46) + 2);
                this.addXTick(Double.toString(tick), tick);
            }
        }
        width = this.getYTickSpacing();
        if (width > 0.0) {
            for (tick = this._yBottom; tick < this._yTop; tick += width) {
                tickLbl = Double.toString(tick);
                tickLbl = tickLbl.substring(0, tickLbl.lastIndexOf(46) + 2);
                this.addYTick(Double.toString(tick), tick);
            }
        }
        this.repaint();
    }

    public boolean getColor() {
        return this._usecolor;
    }

    public static Color getColorByName(String name) {
        try {
            Color col;
            if (name.startsWith("#")) {
                name = name.substring(1);
            }
            Color color = col = new Color(Integer.parseInt(name, 16));
            return color;
        }
        catch (NumberFormatException col) {
            String[][] names = new String[][]{{"black", "00000"}, {"white", "ffffff"}, {"red", "ff0000"}, {"green", "00ff00"}, {"blue", "0000ff"}};
            for (int i = 0; i < names.length; ++i) {
                if (!name.equals(names[i][0])) continue;
                try {
                    Color col2;
                    Color color = col2 = new Color(Integer.parseInt(names[i][1], 16));
                    return color;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public String getDataurl() {
        return this._filespec;
    }

    public URL getDocumentBase() {
        return this._documentBase;
    }

    public boolean getGrid() {
        return this._grid;
    }

    public synchronized String getLegend(int dataset) {
        int idx = this._legendDatasets.indexOf(new Integer(dataset), 0);
        if (idx != -1) {
            return (String)this._legendStrings.elementAt(idx);
        }
        return null;
    }

    public synchronized int getMarkerStyle(int dataset) {
        int index = this._legendDatasets.indexOf(new Integer(dataset), 0);
        if (index != -1) {
            try {
                int n = (Integer)this._legendStyles.elementAt(index);
                return n;
            }
            catch (Exception e) {
                int n = -1;
                return n;
            }
        }
        return -1;
    }

    public synchronized void setMarkerStyle(int dataset, int style) {
        block2: {
            int index = dataset;
            if (index == -1) break block2;
            try {
                this._legendStyles.setElementAt(new Integer(style), dataset);
            }
            catch (Exception ex) {
                this._legendStyles.add(dataset, new Integer(style));
            }
            PlotBox._markerStyles[dataset % 10] = style;
        }
    }

    public Vector getLegendStrings() {
        return this._legendStrings;
    }

    public void setLegendStrings(Vector legendStrings) {
        this._legendStrings = legendStrings;
    }

    public Vector getLegendDatasets() {
        return this._legendDatasets;
    }

    public void setLegendDatasets(Vector legendDatasets) {
        this._legendDatasets = legendDatasets;
    }

    public Vector getLegendColors() {
        return this._legendColors;
    }

    public void setLegendColors(Vector legendColors) {
        this._legendColors = legendColors;
    }

    public Vector getLegendStyles() {
        return this._legendStyles;
    }

    public void setLegendStyles(Vector legendStyles) {
        this._legendStyles = legendStyles;
    }

    public synchronized Color getColor(int dataset) {
        int index = this._legendDatasets.indexOf(new Integer(dataset), 0);
        if (index != -1) {
            return (Color)this._legendColors.elementAt(index);
        }
        return null;
    }

    public synchronized void setColor(int dataset, Color color) {
        block2: {
            int index = dataset;
            if (index == -1) break block2;
            try {
                int colorIndex = (Integer)this._legendDatasets.elementAt(index);
                this._legendColors.setElementAt(color, colorIndex);
                PlotBox._colors[dataset % 11] = color;
            }
            catch (Exception exception) {}
        }
    }

    public synchronized Dimension getMaximumSize() {
        if (this._sizeHasBeenSet) {
            return new Dimension(this._preferredWidth, this._preferredHeight);
        }
        return super.getMaximumSize();
    }

    public synchronized Dimension getMinimumSize() {
        if (this._sizeHasBeenSet) {
            return new Dimension(this._preferredWidth, this._preferredHeight);
        }
        return super.getMinimumSize();
    }

    public synchronized Dimension getPreferredSize() {
        return new Dimension(this._preferredWidth, this._preferredHeight);
    }

    public synchronized String getTitle() {
        if (this._title == null) {
            return "";
        }
        return this._title;
    }

    public synchronized String getXLabel() {
        return this._xlabel;
    }

    public boolean getXLog() {
        return this._xlog;
    }

    public synchronized double[] getXRange() {
        double[] result = new double[2];
        if (this._xRangeGiven) {
            result[0] = this._xlowgiven;
            result[1] = this._xhighgiven;
        } else {
            result[0] = this._xMin + (this._xMax - this._xMin) * this._padding;
            result[1] = this._xMax - (this._xMax - this._xMin) * this._padding;
        }
        return result;
    }

    public synchronized Vector[] getXTicks() {
        if (this._xticks == null) {
            return null;
        }
        Vector[] result = new Vector[]{this._xticks, this._xticklabels};
        return result;
    }

    public double getXTickSpacing() {
        if (this._xTickDistGiven) {
            return this._xtickdist;
        }
        return -1.0;
    }

    public String getYLabel() {
        return this._ylabel;
    }

    public boolean getYLog() {
        return this._ylog;
    }

    public synchronized double[] getYRange() {
        double[] result = new double[2];
        if (this._yRangeGiven) {
            result[0] = this._ylowgiven;
            result[1] = this._yhighgiven;
        } else {
            result[0] = this._yMin + (this._yMax - this._yMin) * this._padding;
            result[1] = this._yMax - (this._yMax - this._yMin) * this._padding;
        }
        return result;
    }

    public synchronized Vector[] getYTicks() {
        if (this._yticks == null) {
            return null;
        }
        Vector[] result = new Vector[]{this._yticks, this._yticklabels};
        return result;
    }

    public double getYTickSpacing() {
        if (this._yTickDistGiven) {
            return this._ytickdist;
        }
        return -1.0;
    }

    public void init() {
        this.buttons.setButtons(true, Color.white);
        if (this._filespec != null) {
            this.parseFile(this._filespec, this._documentBase);
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this._drawPlot(graphics, true);
    }

    public void parseFile(String filespec) {
        this.parseFile(filespec, null);
    }

    /*
     * Loose catch block
     */
    public synchronized void parseFile(String filespec, URL documentBase) {
        block25: {
            DataInputStream in = null;
            if (filespec == null || filespec.length() == 0) {
                in = new DataInputStream(System.in);
            } else {
                try {
                    URL url = null;
                    if (documentBase == null && this._documentBase != null) {
                        documentBase = this._documentBase;
                    }
                    if (documentBase == null) {
                        url = new URL(filespec);
                    } else {
                        try {
                            url = new URL(documentBase, filespec);
                        }
                        catch (NullPointerException e) {
                            url = new URL(filespec);
                        }
                    }
                    in = new DataInputStream(url.openStream());
                }
                catch (MalformedURLException e) {
                    try {
                        in = new DataInputStream(new FileInputStream(filespec));
                    }
                    catch (FileNotFoundException me) {
                        this._errorMsg = new String[2];
                        this._errorMsg[0] = "File not found: ".concat(String.valueOf(String.valueOf(filespec)));
                        this._errorMsg[1] = me.getMessage();
                        return;
                    }
                    catch (SecurityException me) {
                        this._errorMsg = new String[2];
                        this._errorMsg[0] = "Security Exception: ".concat(String.valueOf(String.valueOf(filespec)));
                        this._errorMsg[1] = me.getMessage();
                        return;
                    }
                }
                catch (IOException ioe) {
                    this._errorMsg = new String[3];
                    this._errorMsg[0] = "Failure opening URL: ";
                    this._errorMsg[1] = " ".concat(String.valueOf(String.valueOf(filespec)));
                    this._errorMsg[2] = ioe.getMessage();
                    return;
                }
            }
            BufferedReader din = new BufferedReader(new InputStreamReader(in));
            String line = din.readLine();
            while (line != null) {
                this._parseLine(line);
                line = din.readLine();
            }
            Object var7_13 = null;
            try {
                in.close();
            }
            catch (IOException iOException) {}
            break block25;
            {
                catch (MalformedURLException e) {
                    this._errorMsg = new String[2];
                    this._errorMsg[0] = "Malformed URL: ".concat(String.valueOf(String.valueOf(filespec)));
                    this._errorMsg[1] = e.getMessage();
                    Object var7_14 = null;
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return;
                }
                catch (IOException e) {
                    this._errorMsg = new String[2];
                    this._errorMsg[0] = "Failure reading data: ".concat(String.valueOf(String.valueOf(filespec)));
                    this._errorMsg[1] = e.getMessage();
                    this._errorMsg[1] = e.getMessage();
                    Object var7_15 = null;
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_16 = null;
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public synchronized int print(Graphics graphics, PageFormat format, int index) throws PrinterException {
        if (graphics == null) {
            return 1;
        }
        if (index >= 1) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double scalex = format.getImageableWidth() / (double)this.getWidth();
        double scaley = format.getImageableHeight() / (double)this.getHeight();
        double scale = Math.min(scalex, scaley);
        graphics2D.translate((int)format.getImageableX(), (int)format.getImageableY());
        graphics2D.scale(scale, scale);
        this._drawPlot(graphics, true);
        return 0;
    }

    public void printPlotBox() {
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat format = job.pageDialog(job.defaultPage());
        job.setPrintable(this, format);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (Exception ex) {
                Container ancestor = this.getTopLevelAncestor();
                JOptionPane.showMessageDialog(ancestor, "Printing failed:\n".concat(String.valueOf(String.valueOf(ex.toString()))), "Print Error", 2);
            }
        }
    }

    public synchronized void read(InputStream in) throws IOException {
        try {
            BufferedReader din = new BufferedReader(new InputStreamReader(in));
            try {
                String line = din.readLine();
                while (line != null) {
                    this._parseLine(line);
                    line = din.readLine();
                }
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                din.close();
                throw throwable;
            }
            din.close();
            {
            }
        }
        catch (IOException e) {
            this._errorMsg = new String[2];
            this._errorMsg[0] = "Failure reading input data.";
            this._errorMsg[1] = e.getMessage();
            throw e;
        }
    }

    public synchronized void read(String command) {
        this._parseLine(command);
    }

    public synchronized void removeLegend(int dataset) {
        int len = this._legendDatasets.size();
        int foundIndex = -1;
        boolean found = false;
        for (int i = 0; i < len && !found; ++i) {
            if ((Integer)this._legendDatasets.get(i) != dataset) continue;
            foundIndex = i;
            found = true;
        }
        if (found) {
            this._legendDatasets.remove(foundIndex);
            this._legendStrings.remove(foundIndex);
            this._legendColors.remove(foundIndex);
            this._legendStyles.remove(foundIndex);
        }
    }

    public synchronized void resetAxes() {
        this.setXRange(this._originalXlow, this._originalXhigh);
        this.setYRange(this._originalYlow, this._originalYhigh);
        this.repaint();
    }

    public void samplePlot() {
    }

    public void setBackground(Color background) {
        this._background = background;
        super.setBackground(this._background);
    }

    public synchronized void setBounds(int x, int y, int width, int height) {
        this._width = width;
        this._height = height;
        super.setBounds(x, y, this._width, this._height);
    }

    public void redrawHistogram(double binwidth) {
        this.pva.redrawHistograms(binwidth);
        this.repaint();
    }

    public void setColor(boolean useColor) {
        this._usecolor = useColor;
    }

    public void setDataurl(String filespec) {
        this._filespec = filespec;
    }

    public void setDocumentBase(URL documentBase) {
        this._documentBase = documentBase;
    }

    public void setForeground(Color foreground) {
        this._foreground = foreground;
        super.setForeground(this._foreground);
    }

    public void setGrid(boolean grid) {
        this._grid = grid;
    }

    public void setLabelFont(String name) {
        this._labelFont = Font.decode(name);
        this._labelFontMetrics = ((Component)this).getFontMetrics(this._labelFont);
    }

    public void setSize(int width, int height) {
        this._width = width;
        this._height = height;
        this._preferredWidth = width;
        this._preferredHeight = height;
        this._sizeHasBeenSet = true;
        super.setSize(width, height);
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public void setTitleFont(String name) {
        this._titleFont = Font.decode(name);
        this._titleFontMetrics = ((Component)this).getFontMetrics(this._titleFont);
    }

    public void setWrap(boolean wrap) {
        this._wrap = wrap;
        if (!this._xRangeGiven) {
            if (this._xBottom > this._xTop) {
                this.setXRange(0.0, 0.0);
            } else {
                this.setXRange(this._xBottom, this._xTop);
            }
        }
        this._wrapLow = this._xlowgiven;
        this._wrapHigh = this._xhighgiven;
    }

    public void setXLabel(String label) {
        this._xlabel = label;
    }

    public void setXTickSpacing(double dist) {
        this._xTickDistGiven = true;
        this._xtickdist = dist;
    }

    public void setXLog(boolean xlog) {
        this._xlog = xlog;
    }

    public synchronized void setXRange(double min, double max) {
        this._xRangeGiven = true;
        this._xlowgiven = min;
        this._xhighgiven = max;
        if (!this._originalXRangeGiven) {
            this._originalXlow = min;
            this._originalXhigh = max;
            this._originalXRangeGiven = true;
        }
        this._setXRange(min, max);
    }

    public void setYLabel(String label) {
        this._ylabel = label;
    }

    public void setYTickSpacing(double dist) {
        this._yTickDistGiven = true;
        this._ytickdist = dist;
    }

    public void setYLog(boolean ylog) {
        this._ylog = ylog;
    }

    public synchronized void setYRange(double min, double max) {
        this._yRangeGiven = true;
        this._ylowgiven = min;
        this._yhighgiven = max;
        if (!this._originalYRangeGiven) {
            this._originalYlow = min;
            this._originalYhigh = max;
            this._originalYRangeGiven = true;
        }
        this._setYRange(min, max);
    }

    public void write(OutputStream out) {
        this.write(out, null);
    }

    public synchronized void write(OutputStream out, String dtd) {
        this.write(new OutputStreamWriter(out), dtd);
    }

    public synchronized void write(Writer out, String dtd) {
        PrintWriter output = new PrintWriter((Writer)new BufferedWriter(out), false);
        if (dtd == null) {
            output.println("<?xml version=\"1.0\" standalone=\"yes\"?>");
            output.println("<!DOCTYPE plot PUBLIC \"-//UC Berkeley//DTD PlotML 1//EN\"");
            output.println("    \"http://ptolemy.eecs.berkeley.edu/xml/dtd/PlotML_1.dtd\">");
        } else {
            output.println("<?xml version=\"1.0\" standalone=\"no\"?>");
            output.println(String.valueOf(String.valueOf(new StringBuffer("<!DOCTYPE plot SYSTEM \"").append(dtd).append("\">"))));
        }
        output.println("<plot>");
        output.println("<!-- Ptolemy plot, version 5.2 , PlotML format. -->");
        this.writeFormat(output);
        this.writeData(output);
        output.println("</plot>");
        output.flush();
    }

    public synchronized void writeData(PrintWriter output) {
    }

    public synchronized void writeFormat(PrintWriter output) {
        int i;
        int last;
        if (this._title != null) {
            output.println(String.valueOf(String.valueOf(new StringBuffer("<title>").append(this._title).append("</title>"))));
        }
        if (this._xlabel != null) {
            output.println(String.valueOf(String.valueOf(new StringBuffer("<xLabel>").append(this._xlabel).append("</xLabel>"))));
        }
        if (this._ylabel != null) {
            output.println(String.valueOf(String.valueOf(new StringBuffer("<yLabel>").append(this._ylabel).append("</yLabel>"))));
        }
        if (this._xRangeGiven) {
            output.println(String.valueOf(String.valueOf(new StringBuffer("<xRange min=\"").append(this._xlowgiven).append("\" max=\"").append(this._xhighgiven).append("\"/>"))));
        }
        if (this._yRangeGiven) {
            output.println(String.valueOf(String.valueOf(new StringBuffer("<yRange min=\"").append(this._ylowgiven).append("\" max=\"").append(this._yhighgiven).append("\"/>"))));
        }
        if (this._xticks != null && this._xticks.size() > 0) {
            output.println("<xTicks>");
            last = this._xticks.size() - 1;
            for (i = 0; i <= last; ++i) {
                output.println(String.valueOf(String.valueOf(new StringBuffer("  <tick label=\"").append((String)this._xticklabels.elementAt(i)).append("\" position=\"").append((Double)this._xticks.elementAt(i)).append("\"/>"))));
            }
            output.println("</xTicks>");
        }
        if (this._yticks != null && this._yticks.size() > 0) {
            output.println("<yTicks>");
            last = this._yticks.size() - 1;
            for (i = 0; i <= last; ++i) {
                output.println(String.valueOf(String.valueOf(new StringBuffer("  <tick label=\"").append((String)this._yticklabels.elementAt(i)).append("\" position=\"").append((Double)this._yticks.elementAt(i)).append("\"/>"))));
            }
            output.println("</yTicks>");
        }
        if (this._xlog) {
            output.println("<xLog/>");
        }
        if (this._ylog) {
            output.println("<yLog/>");
        }
        if (!this._grid) {
            output.println("<noGrid/>");
        }
        if (this._wrap) {
            output.println("<wrap/>");
        }
        if (!this._usecolor) {
            output.println("<noColor/>");
        }
    }

    public synchronized void writeOldSyntax(OutputStream out) {
        PrintWriter output = new PrintWriter(new BufferedOutputStream(out), false);
        this._writeOldSyntax(output);
        output.flush();
        if (out != System.out) {
            output.close();
        }
    }

    public synchronized void zoom(double lowx, double lowy, double highx, double highy) {
        this._setXRange(lowx, highx);
        this._setYRange(lowy, highy);
        this.repaint();
    }

    protected synchronized void _drawPlot(Graphics graphics, boolean clearfirst) {
        Rectangle bounds = this.getBounds();
        this._drawPlot(graphics, clearfirst, bounds);
    }

    protected synchronized void _drawPlot(Graphics graphics, boolean clearfirst, Rectangle drawRect) {
        if (graphics == null) {
            return;
        }
        graphics.setPaintMode();
        if (this._errorMsg != null) {
            int fheight;
            int msgy = fheight = this._labelFontMetrics.getHeight() + 2;
            graphics.setColor(Color.black);
            for (int i = 0; i < this._errorMsg.length; ++i) {
                graphics.drawString(this._errorMsg[i], 10, msgy);
                msgy += fheight;
                System.err.println(this._errorMsg[i]);
            }
            return;
        }
        int numfracdigitsX = 0;
        int numfracdigitsY = 0;
        if (!this._xRangeGiven) {
            if (this._xBottom > this._xTop) {
                this._setXRange(0.0, 0.0);
            } else {
                this._setXRange(this._xBottom, this._xTop);
            }
        }
        if (!this._yRangeGiven) {
            if (this._yBottom > this._yTop) {
                this._setYRange(0.0, 0.0);
            } else {
                this._setYRange(this._yBottom, this._yTop);
            }
        }
        int titley = 0;
        int titlefontheight = this._titleFontMetrics.getHeight();
        if (this._title == null) {
            this._title = "";
        }
        if (this._title != null || this._yExp != 0) {
            titley = titlefontheight + this._topPadding;
        }
        Font previousFont = graphics.getFont();
        graphics.setFont(this._labelFont);
        graphics.setColor(this._foreground);
        int labelheight = this._labelFontMetrics.getHeight();
        int halflabelheight = labelheight / 2;
        int ySPos = drawRect.height - 5;
        int xSPos = drawRect.width - this._rightPadding;
        if (this._xlog) {
            this._xExp = (int)Math.floor(this._xtickMin);
        }
        if (this._xExp != 0 && this._xticks == null) {
            String superscript = Integer.toString(this._xExp);
            xSPos -= this._superscriptFontMetrics.stringWidth(superscript);
            graphics.setFont(this._superscriptFont);
            if (!this._xlog) {
                graphics.drawString(superscript, xSPos + 10, ySPos - 20 - halflabelheight);
                graphics.setFont(this._labelFont);
                graphics.drawString("x10", (xSPos -= this._labelFontMetrics.stringWidth("x10")) + 10, ySPos - 20);
            }
            this._bottomPadding = 3 * labelheight / 2 + 5;
        }
        if (this._xlabel != null && this._bottomPadding < labelheight + 5) {
            this._bottomPadding = labelheight + 5;
        }
        this._uly = titley + 5;
        this._lry = drawRect.height - labelheight - this._bottomPadding - 3;
        int height = this._lry - this._uly;
        this._yscale = (double)height / (this._yMax - this._yMin);
        this._ytickscale = (double)height / (this._ytickMax - this._ytickMin);
        int ny = 2 + height / (labelheight + 10);
        double yStep = this._roundUp((this._ytickMax - this._ytickMin) / (double)ny);
        double yStart = yStep * Math.ceil(this._ytickMin / yStep);
        int widesty = 0;
        String[] ylabels = new String[ny];
        int[] ylabwidth = new int[ny];
        int ind = 0;
        if (this._yticks == null) {
            int numfracdigits;
            Vector ygrid = null;
            if (this._ylog) {
                ygrid = this._gridInit(yStart, yStep, true, null);
            }
            numfracdigitsY = numfracdigits = this._numFracDigits(yStep);
            double yTmpStart = yStart;
            if (this._ylog) {
                yTmpStart = this._gridStep(ygrid, yStart, yStep, this._ylog);
            }
            double ypos = yTmpStart;
            while (ypos <= this._ytickMax && ind < ny) {
                String yticklabel = this._ylog ? this._formatLogNum(ypos, numfracdigits) : this._formatNum(ypos, numfracdigits);
                ylabels[ind] = yticklabel;
                int lw = this._labelFontMetrics.stringWidth(yticklabel);
                ylabwidth[ind++] = lw;
                if (lw > widesty) {
                    widesty = lw;
                }
                ypos = this._gridStep(ygrid, ypos, yStep, this._ylog);
            }
        } else {
            Enumeration nl = this._yticklabels.elements();
            while (nl.hasMoreElements()) {
                String label = (String)nl.nextElement();
                int lw = this._labelFontMetrics.stringWidth(label);
                if (lw <= widesty) continue;
                widesty = lw;
            }
        }
        this._ulx = this._ylabel != null ? widesty + this._labelFontMetrics.stringWidth("W") + this._leftPadding : widesty + this._leftPadding;
        int legendwidth = this._drawLegend(graphics, drawRect.width - this._rightPadding, this._uly);
        this._lrx = drawRect.width - legendwidth - this._rightPadding;
        int width = this._lrx - this._ulx;
        this._xscale = (double)width / (this._xMax - this._xMin);
        this._xtickscale = (double)width / (this._xtickMax - this._xtickMin);
        graphics.setColor(Color.white);
        graphics.fillRect(this._ulx, this._uly, width, height);
        graphics.setColor(this._foreground);
        graphics.drawRect(this._ulx, this._uly, width, height);
        int tickLength = 5;
        int xCoord1 = this._ulx + tickLength;
        int xCoord2 = this._lrx - tickLength;
        if (this._yticks == null) {
            Vector ygrid = null;
            double yTmpStart = yStart;
            if (this._ylog) {
                ygrid = this._gridInit(yStart, yStep, true, null);
                yTmpStart = this._gridStep(ygrid, yStart, yStep, this._ylog);
                ny = ind;
            }
            boolean needExponent = this._ylog;
            double ypos = yTmpStart;
            for (ind = 0; ypos <= this._ytickMax && ind < ny; ++ind) {
                int yCoord1 = this._lry - (int)((ypos - this._ytickMin) * this._ytickscale);
                int offset = 0;
                if (ind > 0 && !this._ylog) {
                    offset = halflabelheight;
                }
                graphics.drawLine(this._ulx, yCoord1, xCoord1, yCoord1);
                graphics.drawLine(this._lrx, yCoord1, xCoord2, yCoord1);
                if (this._grid && yCoord1 != this._uly && yCoord1 != this._lry) {
                    graphics.setColor(Color.lightGray);
                    graphics.drawLine(xCoord1, yCoord1, xCoord2, yCoord1);
                    graphics.setColor(this._foreground);
                }
                if (this._ylog && ylabels[ind].indexOf(101) != -1) {
                    needExponent = false;
                }
                graphics.drawString(ylabels[ind], this._ulx - ylabwidth[ind] - 4, yCoord1 + offset);
                ypos = this._gridStep(ygrid, ypos, yStep, this._ylog);
            }
            if (this._ylog) {
                Vector unlabeledgrid = this._gridInit(yStart, yStep, false, ygrid);
                if (unlabeledgrid.size() > 0) {
                    double tmpStep = yStep > 1.0 ? 1.0 : yStep;
                    double ypos2 = this._gridStep(unlabeledgrid, yStart, tmpStep, this._ylog);
                    while (ypos2 <= this._ytickMax) {
                        int yCoord1 = this._lry - (int)((ypos2 - this._ytickMin) * this._ytickscale);
                        if (this._grid && yCoord1 != this._uly && yCoord1 != this._lry) {
                            graphics.setColor(Color.lightGray);
                            graphics.drawLine(this._ulx + 1, yCoord1, this._lrx - 1, yCoord1);
                            graphics.setColor(this._foreground);
                        }
                        ypos2 = this._gridStep(unlabeledgrid, ypos2, tmpStep, this._ylog);
                    }
                }
                this._yExp = needExponent ? (int)Math.floor(yTmpStart) : 0;
            }
            if (this._yExp != 0) {
                graphics.drawString("x10", 10, titley - 4);
                graphics.setFont(this._superscriptFont);
                graphics.drawString(Integer.toString(this._yExp), this._labelFontMetrics.stringWidth("x10") + 10, titley - 4 - halflabelheight);
                graphics.setFont(this._labelFont);
            }
        } else {
            Enumeration nt = this._yticks.elements();
            Enumeration nl = this._yticklabels.elements();
            while (nl.hasMoreElements()) {
                String label = (String)nl.nextElement();
                double ypos = (Double)nt.nextElement();
                if (ypos > this._yMax || ypos < this._yMin) continue;
                int yCoord1 = this._lry - (int)((ypos - this._yMin) * this._yscale);
                int offset = 0;
                if (ypos < (double)(this._lry - labelheight)) {
                    offset = halflabelheight;
                }
                graphics.drawLine(this._ulx, yCoord1, xCoord1, yCoord1);
                graphics.drawLine(this._lrx, yCoord1, xCoord2, yCoord1);
                if (this._grid && yCoord1 != this._uly && yCoord1 != this._lry) {
                    graphics.setColor(Color.lightGray);
                    graphics.drawLine(xCoord1, yCoord1, xCoord2, yCoord1);
                    graphics.setColor(this._foreground);
                }
                graphics.drawString(label, this._ulx - this._labelFontMetrics.stringWidth(label) - 3, yCoord1 + offset);
            }
        }
        int yCoord1 = this._uly + tickLength;
        int yCoord2 = this._lry - tickLength;
        int charwidth = this._labelFontMetrics.stringWidth("8");
        if (this._xticks == null) {
            int nx = 10;
            double xStep = 0.0;
            int numfracdigits = 0;
            if (this._xlog) {
                nx = 2 + width / (charwidth * 6 + 10);
            } else {
                int count = 0;
                while (count++ <= 10) {
                    int savenx;
                    int maxlabelwidth;
                    int inttemp;
                    xStep = this._roundUp((this._xtickMax - this._xtickMin) / (double)nx);
                    numfracdigits = this._numFracDigits(xStep);
                    int intdigits = this._numIntDigits(this._xtickMax);
                    if (intdigits < (inttemp = this._numIntDigits(this._xtickMin))) {
                        intdigits = inttemp;
                    }
                    if ((nx = 2 + width / ((maxlabelwidth = charwidth * (numfracdigits + 2 + intdigits)) + 10)) - (savenx = nx) > 1 && savenx - nx > 1) continue;
                }
            }
            xStep = this._roundUp((this._xtickMax - this._xtickMin) / (double)nx);
            numfracdigitsX = numfracdigits = this._numFracDigits(xStep);
            double xStart = xStep * Math.ceil(this._xtickMin / xStep);
            Vector xgrid = null;
            double xTmpStart = xStart;
            if (this._xlog) {
                xgrid = this._gridInit(xStart, xStep, true, null);
                xTmpStart = this._gridRoundUp(xgrid, xStart);
            }
            boolean needExponent = this._xlog;
            double xpos = xTmpStart;
            while (xpos <= this._xtickMax) {
                String xticklabel;
                if (this._xlog) {
                    xticklabel = this._formatLogNum(xpos, numfracdigits);
                    if (xticklabel.indexOf(101) != -1) {
                        needExponent = false;
                    }
                } else {
                    xticklabel = this._formatNum(xpos, numfracdigits);
                }
                xCoord1 = this._ulx + (int)((xpos - this._xtickMin) * this._xtickscale);
                graphics.drawLine(xCoord1, this._uly, xCoord1, yCoord1);
                graphics.drawLine(xCoord1, this._lry, xCoord1, yCoord2);
                if (this._grid && xCoord1 != this._ulx && xCoord1 != this._lrx) {
                    graphics.setColor(Color.lightGray);
                    graphics.drawLine(xCoord1, yCoord1, xCoord1, yCoord2);
                    graphics.setColor(this._foreground);
                }
                int labxpos = xCoord1 - this._labelFontMetrics.stringWidth(xticklabel) / 2;
                graphics.drawString(xticklabel, labxpos, this._lry + 3 + labelheight);
                xpos = this._gridStep(xgrid, xpos, xStep, this._xlog);
            }
            if (this._xlog) {
                double tmpStep = xStep > 1.0 ? 1.0 : xStep;
                xTmpStart = tmpStep * Math.ceil(this._xtickMin / tmpStep);
                Vector unlabeledgrid = this._gridInit(xTmpStart, tmpStep, false, xgrid);
                if (unlabeledgrid.size() > 0) {
                    double xpos2 = this._gridStep(unlabeledgrid, xTmpStart, tmpStep, this._xlog);
                    while (xpos2 <= this._xtickMax) {
                        xCoord1 = this._ulx + (int)((xpos2 - this._xtickMin) * this._xtickscale);
                        if (this._grid && xCoord1 != this._ulx && xCoord1 != this._lrx) {
                            graphics.setColor(Color.lightGray);
                            graphics.drawLine(xCoord1, this._uly + 1, xCoord1, this._lry - 1);
                            graphics.setColor(this._foreground);
                        }
                        xpos2 = this._gridStep(unlabeledgrid, xpos2, tmpStep, this._xlog);
                    }
                }
                if (needExponent) {
                    this._xExp = (int)Math.floor(xTmpStart);
                    graphics.setFont(this._superscriptFont);
                    graphics.drawString(Integer.toString(this._xExp), xSPos + 10, ySPos - 20 - halflabelheight);
                    graphics.setFont(this._labelFont);
                    graphics.drawString("x10", (xSPos -= this._labelFontMetrics.stringWidth("x10")) + 10, ySPos - 20);
                } else {
                    this._xExp = 0;
                }
            }
        } else {
            Enumeration nt = this._xticks.elements();
            Enumeration nl = this._xticklabels.elements();
            double preLength = 0.0;
            while (nl.hasMoreElements()) {
                int labxpos;
                String label = (String)nl.nextElement();
                double xpos = (Double)nt.nextElement();
                if (xpos > this._xMax || xpos < this._xMin || !((double)(labxpos = (xCoord1 = this._ulx + (int)((xpos - this._xMin) * this._xscale)) - this._labelFontMetrics.stringWidth(label) / 2) > preLength)) continue;
                preLength = xCoord1 + this._labelFontMetrics.stringWidth(label) / 2 + 10;
                graphics.drawString(label, labxpos, this._lry + 3 + labelheight);
                graphics.drawLine(xCoord1, this._uly, xCoord1, yCoord1);
                graphics.drawLine(xCoord1, this._lry, xCoord1, yCoord2);
                if (!this._grid || xCoord1 == this._ulx || xCoord1 == this._lrx) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(xCoord1, yCoord1, xCoord1, yCoord2);
                graphics.setColor(this._foreground);
            }
        }
        graphics.setColor(this._foreground);
        if (this._title != null) {
            graphics.setFont(this._titleFont);
            int titlex = this._ulx + (width - this._titleFontMetrics.stringWidth(this._title)) / 2;
            graphics.drawString(this._title, titlex, titley);
        }
        graphics.setFont(this._labelFont);
        if (this._xlabel != null) {
            int labelx = this._ulx + (width - this._labelFontMetrics.stringWidth(this._xlabel)) / 2;
            graphics.drawString(this._xlabel, labelx, ySPos);
        }
        int charcenter = 2 + this._labelFontMetrics.stringWidth("W") / 2;
        if (this._ylabel != null) {
            int yl = this._ylabel.length();
            if (graphics instanceof Graphics2D) {
                int starty = this._uly + (this._lry - this._uly) / 2 + this._labelFontMetrics.stringWidth(this._ylabel) / 2 - charwidth;
                Graphics2D g2d = (Graphics2D)graphics;
                int startx = charcenter + halflabelheight - 2;
                g2d.rotate(Math.toRadians(-90.0), startx, starty);
                g2d.drawString(this._ylabel, startx, starty);
                g2d.rotate(Math.toRadians(90.0), startx, starty);
            } else {
                int starty = this._uly + (this._lry - this._uly) / 2 - yl * halflabelheight + labelheight;
                for (int i = 0; i < yl; ++i) {
                    String nchar = this._ylabel.substring(i, i + 1);
                    int cwidth = this._labelFontMetrics.stringWidth(nchar);
                    graphics.drawString(nchar, charcenter - cwidth / 2, starty);
                    starty += labelheight;
                }
            }
        }
        graphics.setFont(previousFont);
        this.xcoordFormat = this.getCoordDecimalFormat(numfracdigitsX, this._xExp);
        this.ycoordFormat = this.getCoordDecimalFormat(numfracdigitsY, this._yExp);
    }

    protected void _drawPoint(Graphics graphics, int dataset, long xpos, long ypos, boolean clip, boolean selected, boolean highlighted) {
        boolean pointinside;
        if (graphics == null) {
            return;
        }
        boolean bl = pointinside = ypos <= (long)this._lry && ypos >= (long)this._uly && xpos <= (long)this._lrx && xpos >= (long)this._ulx;
        if (!pointinside && clip) {
            return;
        }
        graphics.fillRect((int)xpos - 6, (int)ypos - 6, 6, 6);
    }

    protected void _help() {
        String message = "Ptolemy plot package\nBy: Edward A. Lee, eal@eecs.berkeley.edu\nand Christopher Hylands, cxh@eecs.berkeley.edu\nVersion 5.2, Build: $Id: PlotBox.java,v 1.49 2003/11/26 14:18:30 balaji Exp $\n\nKey bindings:\n   Cntrl-c:  copy plot to clipboard (EPS format), if permitted\n   D: dump plot data to standard out\n   E: export plot to standard out (EPS format)\n   F: fill plot\n   H or ?: print help message (this message)\n   Cntrl-D or Q: quit\nFor more information, see\nhttp://ptolemy.eecs.berkeley.edu/java/ptplot\n";
        JOptionPane.showMessageDialog(this, message, "Ptolemy Plot Help Window", 1);
    }

    protected boolean _parseLine(String line) {
        String lcLine = new String(line.toLowerCase());
        if (lcLine.startsWith("#")) {
            return true;
        }
        if (lcLine.startsWith("titletext:")) {
            this.setTitle(line.substring(10).trim());
            return true;
        }
        if (lcLine.startsWith("title:")) {
            this.setTitle(line.substring(10).trim());
            return true;
        }
        if (lcLine.startsWith("xlabel:")) {
            this.setXLabel(line.substring(7).trim());
            return true;
        }
        if (lcLine.startsWith("ylabel:")) {
            this.setYLabel(line.substring(7).trim());
            return true;
        }
        if (lcLine.startsWith("xrange:")) {
            int comma = line.indexOf(",", 7);
            if (comma > 0) {
                String min = line.substring(7, comma).trim();
                String max = line.substring(comma + 1).trim();
                try {
                    Double dmin = new Double(min);
                    Double dmax = new Double(max);
                    this.setXRange(dmin, dmax);
                }
                catch (NumberFormatException dmin) {
                    // empty catch block
                }
            }
            return true;
        }
        if (lcLine.startsWith("yrange:")) {
            int comma = line.indexOf(",", 7);
            if (comma > 0) {
                String min = line.substring(7, comma).trim();
                String max = line.substring(comma + 1).trim();
                try {
                    Double dmin = new Double(min);
                    Double dmax = new Double(max);
                    this.setYRange(dmin, dmax);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return true;
        }
        if (lcLine.startsWith("xticks:")) {
            this._parsePairs(line.substring(7), true);
            return true;
        }
        if (lcLine.startsWith("yticks:")) {
            this._parsePairs(line.substring(7), false);
            return true;
        }
        if (lcLine.startsWith("xlog:")) {
            this._xlog = lcLine.indexOf("off", 5) < 0;
            return true;
        }
        if (lcLine.startsWith("ylog:")) {
            this._ylog = lcLine.indexOf("off", 5) < 0;
            return true;
        }
        if (lcLine.startsWith("grid:")) {
            this._grid = lcLine.indexOf("off", 5) < 0;
            return true;
        }
        if (lcLine.startsWith("wrap:")) {
            this._wrap = lcLine.indexOf("off", 5) < 0;
            return true;
        }
        if (lcLine.startsWith("color:")) {
            this._usecolor = lcLine.indexOf("off", 6) < 0;
            return true;
        }
        return false;
    }

    protected void _setButtonsVisibility(boolean vis) {
    }

    protected void _setPadding(double padding) {
        this._padding = padding;
    }

    protected void _writeOldSyntax(PrintWriter output) {
        int i;
        int last;
        output.println("# Ptolemy plot, version 2.0");
        if (this._title != null) {
            output.println("TitleText: ".concat(String.valueOf(String.valueOf(this._title))));
        }
        if (this._xlabel != null) {
            output.println("XLabel: ".concat(String.valueOf(String.valueOf(this._xlabel))));
        }
        if (this._ylabel != null) {
            output.println("YLabel: ".concat(String.valueOf(String.valueOf(this._ylabel))));
        }
        if (this._xRangeGiven) {
            output.println(String.valueOf(String.valueOf(new StringBuffer("XRange: ").append(this._xlowgiven).append(", ").append(this._xhighgiven))));
        }
        if (this._yRangeGiven) {
            output.println(String.valueOf(String.valueOf(new StringBuffer("YRange: ").append(this._ylowgiven).append(", ").append(this._yhighgiven))));
        }
        if (this._xticks != null && this._xticks.size() > 0) {
            output.print("XTicks: ");
            last = this._xticks.size() - 1;
            for (i = 0; i < last; ++i) {
                output.print(String.valueOf(String.valueOf(new StringBuffer("\"").append((String)this._xticklabels.elementAt(i)).append("\" ").append((Double)this._xticks.elementAt(i)).append(", "))));
            }
            output.println(String.valueOf(String.valueOf(new StringBuffer("\"").append((String)this._xticklabels.elementAt(last)).append("\" ").append((Double)this._xticks.elementAt(last)))));
        }
        if (this._yticks != null && this._yticks.size() > 0) {
            output.print("YTicks: ");
            last = this._yticks.size() - 1;
            for (i = 0; i < last; ++i) {
                output.print(String.valueOf(String.valueOf(new StringBuffer("\"").append((String)this._yticklabels.elementAt(i)).append("\" ").append((Double)this._yticks.elementAt(i)).append(", "))));
            }
            output.println(String.valueOf(String.valueOf(new StringBuffer("\"").append((String)this._yticklabels.elementAt(last)).append("\" ").append((Double)this._yticks.elementAt(last)))));
        }
        if (this._xlog) {
            output.println("XLog: on");
        }
        if (this._ylog) {
            output.println("YLog: on");
        }
        if (!this._grid) {
            output.println("Grid: off");
        }
        if (this._wrap) {
            output.println("Wrap: on");
        }
        if (!this._usecolor) {
            output.println("Color: off");
        }
    }

    private int _drawLegend(Graphics graphics, int urx, int ury) {
        if (graphics == null) {
            return 0;
        }
        Font previousFont = graphics.getFont();
        graphics.setFont(this._labelFont);
        int spacing = this._labelFontMetrics.getHeight();
        Enumeration v = this._legendStrings.elements();
        Enumeration i = this._legendDatasets.elements();
        Enumeration c = this._legendColors.elements();
        int ypos = ury + spacing;
        int maxwidth = 0;
        while (v.hasMoreElements()) {
            int dataset;
            String legend = (String)v.nextElement();
            if (legend.startsWith(_PSPLDatasetLabel) || (dataset = ((Integer)i.nextElement()).intValue()) < 0) continue;
            if (this._usecolor) {
                Color color = (Color)c.nextElement();
                graphics.setColor(color);
            }
            this._drawPoint(graphics, dataset, urx - 3, ypos - 3, false, false, false);
            graphics.setColor(this._foreground);
            int width = this._labelFontMetrics.stringWidth(legend);
            if (width > maxwidth) {
                maxwidth = width;
            }
            graphics.drawString(legend, urx - 15 - width, ypos);
            ypos += spacing;
        }
        graphics.setFont(previousFont);
        return 22 + maxwidth;
    }

    private synchronized void _executeDeferredActions() {
        try {
            Iterator actions = this._deferredActions.iterator();
            while (actions.hasNext()) {
                Runnable action = (Runnable)actions.next();
                action.run();
            }
            Object var4_3 = null;
            this._actionsDeferred = false;
            this._deferredActions.clear();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._actionsDeferred = false;
            this._deferredActions.clear();
            throw throwable;
        }
    }

    private String _formatLogNum(double num, int numfracdigits) {
        int exponent = (int)num;
        String results = exponent >= 0 && exponent < 10 ? "0".concat(String.valueOf(String.valueOf(exponent))) : (exponent < 0 && exponent > -10 ? "-0".concat(String.valueOf(String.valueOf(-exponent))) : Integer.toString(exponent));
        results = num >= 0.0 ? (num - (double)((int)num) < 0.001 ? "1e".concat(String.valueOf(String.valueOf(results))) : this._formatNum(Math.pow(10.0, num - (double)((int)num)), numfracdigits)) : (-num - (double)((int)(-num)) < 0.001 ? "1e".concat(String.valueOf(String.valueOf(results))) : this._formatNum(Math.pow(10.0, num - (double)((int)num)) * (double)10, numfracdigits));
        return results;
    }

    private String _formatNum(double num, int numfracdigits) {
        double fudge = 0.5;
        if (num < 0.0) {
            fudge = -0.5;
        }
        String numString = Double.toString(num + fudge * Math.pow(10.0, -numfracdigits));
        int dpt = numString.lastIndexOf(".");
        StringBuffer result = new StringBuffer();
        if (dpt < 0) {
            if (numfracdigits <= 0) {
                result.append(numString);
                return result.toString();
            }
            result.append(".");
            for (int i = 0; i < numfracdigits; ++i) {
                result.append("0");
            }
            return result.toString();
        }
        int shortby = numfracdigits - (numString.length() - dpt - 1);
        if (shortby <= 0) {
            int numtocopy = dpt + numfracdigits + 1;
            if (numfracdigits == 0) {
                --numtocopy;
            }
            result.append(numString.substring(0, numtocopy));
            return result.toString();
        }
        result.append(numString);
        for (int i = 0; i < shortby; ++i) {
            result.append("0");
        }
        return result.toString();
    }

    private Vector _gridInit(double low, double step, boolean labeled, Vector oldgrid) {
        Vector<Double> grid = new Vector<Double>(10);
        double ratio = Math.pow(10.0, step);
        int ngrid = 1;
        if (labeled) {
            if (ratio <= 3.5) {
                ngrid = ratio > 2.0 ? 2 : (ratio > 1.26 ? 5 : (ratio > 1.125 ? 10 : (int)Math.rint(1.0 / step)));
            }
        } else {
            ngrid = ratio > 10.0 ? 1 : (ratio > 3.0 ? 2 : (ratio > 2.0 ? 5 : (ratio > 1.125 ? 10 : 100)));
        }
        int oldgridi = 0;
        for (int i = 0; i < ngrid; ++i) {
            double gridval = (double)i * 1.0 / (double)ngrid * (double)10;
            double logval = _LOG10SCALE * Math.log(gridval);
            if (logval == Double.NEGATIVE_INFINITY) {
                logval = 0.0;
            }
            if (oldgrid != null && oldgridi < oldgrid.size()) {
                while (oldgridi < oldgrid.size() && (Double)oldgrid.elementAt(oldgridi) < logval) {
                    ++oldgridi;
                }
                if (oldgridi < oldgrid.size()) {
                    if (!(Math.abs((Double)oldgrid.elementAt(oldgridi) - logval) > 1.0E-5)) continue;
                    grid.addElement(new Double(logval));
                    continue;
                }
                grid.addElement(new Double(logval));
                continue;
            }
            grid.addElement(new Double(logval));
        }
        this._gridCurJuke = 0;
        if (low == -0.0) {
            low = 0.0;
        }
        this._gridBase = Math.floor(low);
        double x = low - this._gridBase;
        this._gridCurJuke = -1;
        while (this._gridCurJuke + 1 < grid.size() && x > (Double)grid.elementAt(this._gridCurJuke + 1)) {
            ++this._gridCurJuke;
        }
        return grid;
    }

    private double _gridRoundUp(Vector grid, double pos) {
        int i;
        double x = pos - Math.floor(pos);
        for (i = 0; i < grid.size() && x >= (Double)grid.elementAt(i); ++i) {
        }
        if (i >= grid.size()) {
            return pos;
        }
        return Math.floor(pos) + (Double)grid.elementAt(i);
    }

    private double _gridStep(Vector grid, double pos, double step, boolean logflag) {
        if (logflag) {
            if (++this._gridCurJuke >= grid.size()) {
                this._gridCurJuke = 0;
                this._gridBase += Math.ceil(step);
            }
            if (this._gridCurJuke >= grid.size()) {
                return pos + step;
            }
            return this._gridBase + (Double)grid.elementAt(this._gridCurJuke);
        }
        return pos + step;
    }

    private void _measureFonts() {
        if (this._labelFont == null) {
            this._labelFont = Font.decode("Helvetica-PLAIN-12");
        }
        if (this._superscriptFont == null) {
            this._superscriptFont = Font.decode("Helvetica-PLAIN-9");
        }
        if (this._titleFont == null) {
            this._titleFont = Font.decode("Helvetica-BOLD-14");
        }
        this._labelFontMetrics = ((Component)this).getFontMetrics(this._labelFont);
        this._superscriptFontMetrics = ((Component)this).getFontMetrics(this._superscriptFont);
        this._titleFontMetrics = ((Component)this).getFontMetrics(this._titleFont);
    }

    private int _numFracDigits(double num) {
        int numdigits;
        for (numdigits = 0; numdigits <= 15 && num != Math.floor(num); num *= 10.0, ++numdigits) {
        }
        return numdigits;
    }

    private int _numIntDigits(double num) {
        int numdigits;
        for (numdigits = 0; numdigits <= 15 && (double)((int)num) != 0.0; ++numdigits) {
            num /= 10.0;
        }
        return numdigits;
    }

    private void _parsePairs(String line, boolean xtick) {
        if (xtick) {
            this._xticks = null;
            this._xticklabels = null;
        } else {
            this._yticks = null;
            this._yticklabels = null;
        }
        int start = 0;
        boolean cont = true;
        while (cont) {
            int comma = line.indexOf(",", start);
            String pair = null;
            if (comma > start) {
                pair = line.substring(start, comma).trim();
            } else {
                pair = line.substring(start).trim();
                cont = false;
            }
            int close = -1;
            int open = 0;
            if (pair.startsWith("\"")) {
                close = pair.indexOf("\"", 1);
                open = 1;
            } else {
                close = pair.indexOf(" ");
            }
            if (close > 0) {
                String label = pair.substring(open, close);
                String index = pair.substring(close + 1).trim();
                try {
                    double idx = Double.valueOf(index);
                    if (xtick) {
                        this.addXTick(label, idx);
                    } else {
                        this.addYTick(label, idx);
                    }
                }
                catch (NumberFormatException e) {
                    System.err.println("Warning from PlotBox: Unable to parse ticks: ".concat(String.valueOf(String.valueOf(e.getMessage()))));
                }
            }
            start = comma + 1;
            comma = line.indexOf(",", start);
        }
    }

    private RenderingHints _defaultImageRenderingHints() {
        RenderingHints hints = new RenderingHints(null);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return hints;
    }

    private double _roundUp(double val) {
        int exponent;
        if ((val *= Math.pow(10.0, -(exponent = (int)Math.floor(Math.log(val) * _LOG10SCALE)))) > 5.0) {
            val = 10.0;
        } else if (val > 2.0) {
            val = 5.0;
        } else if (val > 1.0) {
            val = 2.0;
        }
        return val *= Math.pow(10.0, exponent);
    }

    private void _setXRange(double min, double max) {
        if (min > max) {
            min = -1.0;
            max = 1.0;
        } else if (min == max) {
            min -= 1.0;
            max += 1.0;
        }
        this._xMin = min - (max - min) * this._padding;
        this._xMax = max + (max - min) * this._padding;
        double largest = Math.max(Math.abs(this._xMin), Math.abs(this._xMax));
        this._xExp = (int)Math.floor(Math.log(largest) * _LOG10SCALE);
        if (this._xExp > 1 || this._xExp < -1) {
            double xs = 1.0 / Math.pow(10.0, this._xExp);
            this._xtickMin = this._xMin * xs;
            this._xtickMax = this._xMax * xs;
        } else {
            this._xtickMin = this._xMin;
            this._xtickMax = this._xMax;
            this._xExp = 0;
        }
    }

    private void _setYRange(double min, double max) {
        if (min > max) {
            min = -1.0;
            max = 1.0;
        } else if (min == max) {
            min -= 0.1;
            max += 0.1;
        }
        this._yMin = min - (max - min) * this._padding;
        this._yMax = max + (max - min) * this._padding;
        double largest = Math.max(Math.abs(this._yMin), Math.abs(this._yMax));
        this._yExp = (int)Math.floor(Math.log(largest) * _LOG10SCALE);
        if (this._yExp > 1 || this._yExp < -1) {
            double ys = 1.0 / Math.pow(10.0, this._yExp);
            this._ytickMin = this._yMin * ys;
            this._ytickMax = this._yMax * ys;
        } else {
            this._ytickMin = this._yMin;
            this._ytickMax = this._yMax;
            this._yExp = 0;
        }
    }

    void _zoom(int x, int y) {
        this._zooming = false;
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        boolean handled = false;
        if (this._zoomin && this._drawn) {
            if (this._zoomxn != -1 || this._zoomyn != -1) {
                int minx = Math.min(this._zoomx, this._zoomxn);
                int maxx = Math.max(this._zoomx, this._zoomxn);
                int miny = Math.min(this._zoomy, this._zoomyn);
                int maxy = Math.max(this._zoomy, this._zoomyn);
                graphics.setXORMode(_boxColor);
                graphics.drawRect(minx, miny, maxx - minx, maxy - miny);
                graphics.setPaintMode();
                if (y > this._lry) {
                    y = this._lry;
                }
                if (y < this._uly) {
                    y = this._uly;
                }
                if (x > this._lrx) {
                    x = this._lrx;
                }
                if (x < this._ulx) {
                    x = this._ulx;
                }
                if (Math.abs(this._zoomx - x) > 5 && Math.abs(this._zoomy - y) > 5) {
                    double a = this._xMin + (double)(this._zoomx - this._ulx) / this._xscale;
                    double b = this._xMin + (double)(x - this._ulx) / this._xscale;
                    if (this._buttonMode == 1) {
                        if (a < b) {
                            this.setXRange(a, b);
                        } else {
                            this.setXRange(b, a);
                        }
                        a = this._yMax - (double)(this._zoomy - this._uly) / this._yscale;
                        b = this._yMax - (double)(y - this._uly) / this._yscale;
                        if (a < b) {
                            this.setYRange(a, b);
                        } else {
                            this.setYRange(b, a);
                        }
                    } else {
                        double y2;
                        double y1;
                        double x2;
                        double x1;
                        if (a < b) {
                            x1 = a;
                            x2 = b;
                        } else {
                            x1 = b;
                            x2 = a;
                        }
                        a = this._yMax - (double)(this._zoomy - this._uly) / this._yscale;
                        b = this._yMax - (double)(y - this._uly) / this._yscale;
                        if (a < b) {
                            y1 = a;
                            y2 = b;
                        } else {
                            y1 = b;
                            y2 = a;
                        }
                        this.select(x1, y1, x2, y2);
                    }
                }
                this.repaint();
                handled = true;
            }
        } else if (this._zoomout && this._drawn) {
            graphics.setXORMode(_boxColor);
            int x_diff = Math.abs(this._zoomx - this._zoomxn);
            int y_diff = Math.abs(this._zoomy - this._zoomyn);
            graphics.drawRect(this._zoomx - 15 - x_diff, this._zoomy - 15 - y_diff, 30 + x_diff * 2, 30 + y_diff * 2);
            graphics.setPaintMode();
            double a = (double)Math.abs(this._zoomx - x) / 30.0;
            double b = (double)Math.abs(this._zoomy - y) / 30.0;
            double newx1 = this._xMax + (this._xMax - this._xMin) * a;
            double newx2 = this._xMin - (this._xMax - this._xMin) * a;
            double newy1 = this._yMax + (this._yMax - this._yMin) * b;
            double newy2 = this._yMin - (this._yMax - this._yMin) * b;
            if (this._buttonMode == 1) {
                this.zoom(newx2, newy2, newx1, newy1);
            } else {
                this.select(newx2, newy2, newx1, newy1);
            }
            handled = true;
        } else if (!this._drawn) {
            this.repaint();
            handled = true;
        }
        this._drawn = false;
        this._zoomout = false;
        this._zoomin = false;
        this._zoomy = -1;
        this._zoomx = -1;
        this._zoomyn = -1;
        this._zoomxn = -1;
    }

    void select(double lowx, double lowy, double highx, double highy) {
        if (!this._shiftKeyPressed && this._buttonMode == 2) {
            this.pva.clearSelectedPoints(true);
        }
        if (this._buttonMode == 2) {
            this.pva.selectPointsWithin(true, lowx, lowy, highx, highy);
        } else {
            this.pva.selectPointsWithin(false, lowx, lowy, highx, highy);
        }
    }

    public void zoomSelect(String label) {
        if (label == "Zoom") {
            this._buttonMode = 1;
        } else if (label == "Select") {
            this._buttonMode = 2;
        } else if (label == "UnSelect") {
            this._buttonMode = 3;
        }
    }

    void _zoomBox(int x, int y) {
        if (!this._zooming) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        if (y > this._lry) {
            y = this._lry;
        }
        if (y < this._uly) {
            y = this._uly;
        }
        if (x > this._lrx) {
            x = this._lrx;
        }
        if (x < this._ulx) {
            x = this._ulx;
        }
        if (this._zoomx != -1 || this._zoomy != -1) {
            if (!this._zoomin && !this._zoomout) {
                if (y < this._zoomy) {
                    this._zoomout = true;
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(this._zoomx - 15, this._zoomy - 15, 30, 30);
                } else if (y > this._zoomy) {
                    this._zoomin = true;
                }
            }
            if (this._zoomin) {
                int maxy;
                int miny;
                int maxx;
                int minx;
                if ((this._zoomxn != -1 || this._zoomyn != -1) && this._drawn) {
                    minx = Math.min(this._zoomx, this._zoomxn);
                    maxx = Math.max(this._zoomx, this._zoomxn);
                    miny = Math.min(this._zoomy, this._zoomyn);
                    maxy = Math.max(this._zoomy, this._zoomyn);
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(minx, miny, maxx - minx, maxy - miny);
                }
                if (y > this._zoomy) {
                    this._zoomxn = x;
                    this._zoomyn = y;
                    minx = Math.min(this._zoomx, this._zoomxn);
                    maxx = Math.max(this._zoomx, this._zoomxn);
                    miny = Math.min(this._zoomy, this._zoomyn);
                    maxy = Math.max(this._zoomy, this._zoomyn);
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(minx, miny, maxx - minx, maxy - miny);
                    this._drawn = true;
                    return;
                }
                this._drawn = false;
            } else if (this._zoomout) {
                int y_diff;
                int x_diff;
                if ((this._zoomxn != -1 || this._zoomyn != -1) && this._drawn) {
                    x_diff = Math.abs(this._zoomx - this._zoomxn);
                    y_diff = Math.abs(this._zoomy - this._zoomyn);
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(this._zoomx - 15 - x_diff, this._zoomy - 15 - y_diff, 30 + x_diff * 2, 30 + y_diff * 2);
                }
                if (y < this._zoomy) {
                    this._zoomxn = x;
                    this._zoomyn = y;
                    x_diff = Math.abs(this._zoomx - this._zoomxn);
                    y_diff = Math.abs(this._zoomy - this._zoomyn);
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(this._zoomx - 15 - x_diff, this._zoomy - 15 - y_diff, 30 + x_diff * 2, 30 + y_diff * 2);
                    this._drawn = true;
                    return;
                }
                this._drawn = false;
            }
        }
        graphics.setPaintMode();
    }

    public void printCoord(int minx, int miny, int maxx, int maxy, String str) {
        double px = this._xMin + (double)(minx - this._ulx) / this._xscale;
        double pa = this._xMin + (double)(maxx - this._ulx) / this._xscale;
        double py = this._yMax - (double)(miny - this._uly) / this._yscale;
        double pb = this._yMax - (double)(maxy - this._uly) / this._yscale;
        if (this._xlog) {
            px = Math.pow(10.0, px);
        }
        if (this._ylog) {
            py = Math.pow(10.0, py);
        }
        System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(str))).append(" : ").append(px).append(", ").append(py).append(", ").append(pa).append(", ").append(pb))));
    }

    private String getCoordDecimalFormat(int numOfFracDigits, int expDigits) {
        StringBuffer strbuf = new StringBuffer();
        for (int i = 0; i < numOfFracDigits; ++i) {
            strbuf.append("#");
        }
        strbuf.append("#");
        StringBuffer format = new StringBuffer();
        format.append("0.").append(strbuf.toString());
        if (expDigits != 0) {
            format.append("E0");
        }
        return format.toString();
    }

    void _zoomStart(int x, int y) {
        if (y > this._lry) {
            y = this._lry;
        }
        if (y < this._uly) {
            y = this._uly;
        }
        if (x > this._lrx) {
            x = this._lrx;
        }
        if (x < this._ulx) {
            x = this._ulx;
        }
        this._zoomx = x;
        this._zoomy = y;
        this._zooming = true;
    }

    static {
        PTPLOT_RELEASE = PTPLOT_RELEASE;
        _LOG10SCALE = 1.0 / Math.log(10.0);
        _colors = new Color[]{new Color(255), new Color(32768), new Color(0x800080), new Color(16753920), new Color(0), new Color(5473931), new Color(16744272), new Color(4565791), new Color(9454125), new Color(0xA0A0A0), new Color(0xFF00FF)};
        _markerStyles = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        _PSPLDatasetLabel = _PSPLDatasetLabel;
        ZOOM_MODE = 1;
        SELECT_MODE = 2;
        UNSELECT_MODE = 3;
        _boxColor = Color.orange;
        _DTD = _DTD;
    }

    class CommandListener
    implements KeyListener {
        private boolean _control = false;

        CommandListener() {
        }

        public void keyPressed(KeyEvent e) {
            int keycode = e.getKeyCode();
            switch (keycode) {
                case 17: {
                    this._control = true;
                    break;
                }
                case 16: {
                    PlotBox.this._shiftKeyPressed = true;
                    break;
                }
                case 67: {
                    if (!this._control) break;
                    PlotBox.this.export(null);
                    String message = "Encapsulated PostScript (EPS) exported to clipboard.";
                    JOptionPane.showMessageDialog(PlotBox.this, message, "Ptolemy Plot Message", 1);
                    break;
                }
                case 68: {
                    if (!this._control && PlotBox.this._shiftKeyPressed) {
                        PlotBox.this.write(System.out);
                        String message = "Plot data sent to standard out.";
                        JOptionPane.showMessageDialog(PlotBox.this, message, "Ptolemy Plot Message", 1);
                    }
                    if (!this._control) break;
                    System.exit(1);
                    break;
                }
                case 69: {
                    if (this._control || !PlotBox.this._shiftKeyPressed) break;
                    PlotBox.this.export(System.out);
                    String message = "Encapsulated PostScript (EPS) exported to standard out.";
                    JOptionPane.showMessageDialog(PlotBox.this, message, "Ptolemy Plot Message", 1);
                    break;
                }
                case 70: {
                    if (this._control || !PlotBox.this._shiftKeyPressed) break;
                    PlotBox.this.fillPlot();
                    break;
                }
                case 72: {
                    if (this._control || !PlotBox.this._shiftKeyPressed) break;
                    PlotBox.this._help();
                    break;
                }
                case 81: {
                    if (this._control) break;
                    System.exit(1);
                    break;
                }
                case 47: {
                    if (!PlotBox.this._shiftKeyPressed) break;
                    PlotBox.this._help();
                    break;
                }
            }
        }

        public void keyReleased(KeyEvent e) {
            int keycode = e.getKeyCode();
            switch (keycode) {
                case 17: {
                    this._control = false;
                    break;
                }
                case 16: {
                    PlotBox.this._shiftKeyPressed = false;
                    break;
                }
            }
        }

        public void keyTyped(KeyEvent e) {
        }
    }

    public class DragListener
    implements MouseMotionListener {
        public void mouseDragged(MouseEvent event) {
            PlotBox.this._zoomBox(event.getX(), event.getY());
        }

        public void mouseMoved(MouseEvent event) {
            double x = PlotBox.this._xMin + (double)(event.getX() - PlotBox.this._ulx) / PlotBox.this._xscale;
            double y = PlotBox.this._yMax - (double)(event.getY() - PlotBox.this._uly) / PlotBox.this._yscale;
            if (x <= PlotBox.this._xMax && x >= PlotBox.this._xMin && y <= PlotBox.this._yMax && y >= PlotBox.this._yMin) {
                if (PlotBox.this._xlog) {
                    x = Math.pow(10.0, x);
                }
                if (PlotBox.this._ylog) {
                    y = Math.pow(10.0, y);
                }
                DecimalFormat xFormatter = new DecimalFormat(PlotBox.this.xcoordFormat);
                DecimalFormat yFormatter = new DecimalFormat(PlotBox.this.ycoordFormat);
                if (PlotBox.this.buttons != null) {
                    PlotBox.this.buttons.showCoordinates(xFormatter.format(x), yFormatter.format(y));
                }
            }
        }
    }

    public class ZoomListener
    implements MouseListener {
        public void mouseClicked(MouseEvent event) {
            PlotBox.this.requestFocus();
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
        }

        public void mousePressed(MouseEvent event) {
            if ((event.getModifiers() & 0x10) != 0 || event.getModifiers() == 0) {
                PlotBox.this._zoomStart(event.getX(), event.getY());
            }
        }

        public void mouseReleased(MouseEvent event) {
            if ((event.getModifiers() & 0x10) != 0 || event.getModifiers() == 0) {
                PlotBox.this._zoom(event.getX(), event.getY());
            }
        }
    }
}

