/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import com.jvt.applets.ASCIIFilter;
import com.jvt.applets.PlotButtons;
import com.jvt.applets.PlotVOApplet;
import com.jvt.utils.JVTUtil;
import com.jvt.votable.ASCIIWriter;
import com.jvt.votable.PlotData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ptolemy.gui.CloseListener;

public class PlotASCIIFormatDisplayDialog
extends JFrame {
    public Component contents;
    protected String _buttonPressed = "";
    private static String[] _buttons = new String[]{"Close"};
    private static String[] _buttons1 = new String[]{"Close", "Save As File"};
    private boolean _doneHandleClosing = false;
    private JOptionPane _optionPane;
    public PlotVOApplet _pva = null;
    private PlotData _pd = null;
    private PlotButtons _pb = null;
    private JScrollPane _votableDisplayPane;
    private JPanel _panel;
    private JPanel _votableDisplayPanel;
    private JTextArea _votableDisplayArea;
    private int _verticalscrollbar = 22;
    private int _horizontalscrollbar = 32;
    private JLabel _votable = new JLabel("VOTable  : ");
    private JCheckBox _dataDisplayed;
    public static final int dialogboxHeight = 600;
    public static final int dialogboxWidth = 800;
    public static final int textareaHeight = 27;
    public static final int textareaWidth = 60;
    public ArrayList selectedIndexs;
    String _truncatedVOTable = "";
    File _currentDirectory;
    String _noVOTable = "There is no VOTable loaded ";

    public PlotASCIIFormatDisplayDialog(Frame owner, PlotVOApplet pva, PlotButtons pb) {
        try {
            this.setTitle("Display Data In ASCII Comma saperated Format.");
            this._pb = pb;
            this.init(pva);
            this.addPanel();
            ((Frame)this).setIconImage(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource(String.valueOf(String.valueOf(JVTUtil.SMALL_IMAGE_PATH)).concat("voplotlogo.gif"))));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addPanel() {
        this._panel = new JPanel();
        this._panel.setLayout(new BoxLayout(this._panel, 1));
        this._panel.add(this._votableDisplayPanel);
        this.contents = this._votableDisplayPanel;
        this._optionPane = this._pva.isWebApp() ? new JOptionPane(this._panel, 1, 1, null, _buttons, _buttons[0]) : new JOptionPane(this._panel, 1, 1, null, _buttons1, _buttons1[0]);
        this._optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (PlotASCIIFormatDisplayDialog.this.isVisible() && e.getSource() == PlotASCIIFormatDisplayDialog.this._optionPane && (prop.equals("value") || prop.equals("inputValue"))) {
                    Object value = PlotASCIIFormatDisplayDialog.this._optionPane.getValue();
                    if (value == JOptionPane.UNINITIALIZED_VALUE) {
                        return;
                    }
                    PlotASCIIFormatDisplayDialog.this._optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                    if (value instanceof String) {
                        PlotASCIIFormatDisplayDialog.this._buttonPressed = (String)value;
                    }
                    if (_buttons1[1].equals(PlotASCIIFormatDisplayDialog.this._buttonPressed)) {
                        if (PlotASCIIFormatDisplayDialog.this._pva.getPlotData() == null) {
                            PlotASCIIFormatDisplayDialog.this.ClosingDialogBox();
                        } else {
                            String _fileSaved = "";
                            PlotASCIIFormatDisplayDialog.this.selectedIndexs = PlotASCIIFormatDisplayDialog.this._pva.getSelectedPointsIndex();
                            try {
                                JFileChooser fc = new JFileChooser(PlotASCIIFormatDisplayDialog.this._currentDirectory);
                                fc.addChoosableFileFilter(new ASCIIFilter());
                                int returnVal = fc.showSaveDialog(PlotASCIIFormatDisplayDialog.this._pva);
                                if (returnVal == 0) {
                                    File file = fc.getSelectedFile();
                                    String _filePath = file.toString();
                                    String _extensionUpperCase = ".CSV";
                                    String _extensionLowerCase = ".csv";
                                    if (!_filePath.endsWith(_extensionUpperCase) && !_filePath.endsWith(_extensionLowerCase)) {
                                        File fileExtension;
                                        _filePath = String.valueOf(String.valueOf(_filePath)).concat(String.valueOf(String.valueOf(_extensionLowerCase)));
                                        file = fileExtension = new File(_filePath);
                                    }
                                    FileOutputStream saveVotable = new FileOutputStream(file);
                                    ASCIIWriter aSCIIWriter = new ASCIIWriter(PlotASCIIFormatDisplayDialog.this._pva);
                                    _fileSaved = file.getName();
                                    if (PlotASCIIFormatDisplayDialog.this._dataDisplayed.isSelected()) {
                                        aSCIIWriter.getSelectedDataInASCIIFormat(saveVotable, PlotASCIIFormatDisplayDialog.this.selectedIndexs);
                                    } else {
                                        aSCIIWriter.getDataInASCIIFormat(saveVotable);
                                    }
                                    PlotASCIIFormatDisplayDialog.this._currentDirectory = fc.getCurrentDirectory();
                                    JOptionPane.showMessageDialog(null, String.valueOf(String.valueOf(_fileSaved)).concat(" Saved"), "Saved", 1);
                                    return;
                                }
                            }
                            catch (Exception ioe) {
                                JOptionPane.showMessageDialog(null, String.valueOf(String.valueOf(_fileSaved)).concat(" Not Saved"), "Error", 1);
                                ioe.printStackTrace();
                            }
                        }
                    } else {
                        PlotASCIIFormatDisplayDialog.this.ClosingDialogBox();
                    }
                }
            }
        });
        this.getContentPane().add(this._optionPane);
        this.pack();
        this.setResizable(true);
        ((Component)this).setSize(800, 600);
        Toolkit tk = Toolkit.getDefaultToolkit();
        ((Component)this).setLocation((tk.getScreenSize().width - this.getSize().width) / 2, (tk.getScreenSize().height - this.getSize().height) / 2);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JVTUtil.SHOW_VOTABLE = true;
                PlotASCIIFormatDisplayDialog.this._handleClosing();
            }
        });
        ((Component)this).setVisible(true);
    }

    protected void _handleClosing() {
        if (this.contents instanceof CloseListener && !this._doneHandleClosing) {
            this._doneHandleClosing = true;
            ((CloseListener)((Object)this.contents)).windowClosed(this, this._buttonPressed);
        }
    }

    private void init(PlotVOApplet pva) {
        this._pva = pva;
        this._pd = pva.getPlotData();
        JVTUtil.SHOW_VOTABLE = false;
        this._dataDisplayed = new JCheckBox("Display Data Of Selected Points");
        this._dataDisplayed.addItemListener(new CheckboxListener());
        this._votableDisplayPanel = new JPanel(new BorderLayout());
        this._votableDisplayArea = new JTextArea(60, 27);
        this.selectedIndexs = this._pva.getSelectedPointsIndex();
        if (this.selectedIndexs == null || this.selectedIndexs.size() <= 0) {
            this.showEntireTable();
        } else {
            this._dataDisplayed.setSelected(true);
            this.showSelectedPointsTable();
        }
        this._votableDisplayPane = new JScrollPane(this._votableDisplayArea);
        this._votableDisplayPanel.add((Component)this._votable, "North");
        this._votableDisplayPanel.add((Component)this._votableDisplayPane, "Center");
        this._votableDisplayPanel.add((Component)this._dataDisplayed, "South");
        if (!this._pva.isWebApp()) {
            this._currentDirectory = new File(System.getProperty("user.dir"));
        }
    }

    private void showEntireTable() {
        ASCIIWriter aSCIIWriter = new ASCIIWriter(this._pva, 100);
        ByteArrayOutputStream bytesBuffer = new ByteArrayOutputStream();
        aSCIIWriter.getDataInASCIIFormat(bytesBuffer);
        this._truncatedVOTable = bytesBuffer.toString();
        this._votableDisplayArea.setText(this._truncatedVOTable);
        this._votableDisplayArea.setCaretPosition(0);
    }

    private void showSelectedPointsTable() {
        this.selectedIndexs = this._pva.getSelectedPointsIndex();
        ASCIIWriter aSCIIWriter = new ASCIIWriter(this._pva, 100);
        ByteArrayOutputStream bytesBuffer = new ByteArrayOutputStream();
        aSCIIWriter.getSelectedDataInASCIIFormat(bytesBuffer, this.selectedIndexs);
        this._truncatedVOTable = bytesBuffer.toString();
        this._votableDisplayArea.setText(this._truncatedVOTable);
        this._votableDisplayArea.setCaretPosition(0);
    }

    private void ClosingDialogBox() {
        if (this._pva.getPlotData() == null) {
            JOptionPane.showMessageDialog(null, this._noVOTable, "Error", 1);
        }
        ((Component)this).setVisible(false);
        JVTUtil.SHOW_VOTABLE = true;
        this._handleClosing();
    }

    static {
        dialogboxHeight = 600;
        dialogboxWidth = 800;
        textareaHeight = 27;
        textareaWidth = 60;
    }

    class CheckboxListener
    implements ItemListener {
        CheckboxListener() {
        }

        public void itemStateChanged(ItemEvent ie) {
            if (PlotASCIIFormatDisplayDialog.this._pva.getPlotData() != null) {
                if (PlotASCIIFormatDisplayDialog.this._dataDisplayed.isSelected()) {
                    PlotASCIIFormatDisplayDialog.this.showSelectedPointsTable();
                } else {
                    PlotASCIIFormatDisplayDialog.this.showEntireTable();
                }
            } else {
                PlotASCIIFormatDisplayDialog.this.ClosingDialogBox();
            }
        }
    }
}

