/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.Vector;
import javax.swing.JComponent;
import ptolemy.plot.EPSGraphics;
import ptolemy.plot.PlotBox;
import ptolemy.plot.PlotPoint;

public class Plot
extends PlotBox {
    public Vector _points = new Vector();
    protected int _currentdataset = -1;
    protected int _marks;
    private int _pointsPersistence = 0;
    private double _xPersistence = 0.0;
    private boolean _bars = false;
    private double barWidth = 0.5;
    private double _barOffset = 0.05;
    private boolean _connected = false;
    private boolean _impulses = false;
    private int _maxDataset = -1;
    private boolean _reuseDatasets = false;
    private boolean _firstInSet = true;
    private boolean _sawFirstDataSet = false;
    private int _radius = 3;
    private int _diameter = 6;
    private Vector _prevx = new Vector();
    private Vector _prevy = new Vector();
    private static final int _ERRORBAR_LEG_LENGTH = 5;
    private static final int _MAX_MARKS = 10;
    private boolean _xyInvalid = true;
    private String _filename = null;
    private boolean _showing = false;
    private Vector _formats = new Vector();
    private final Color HIGHLIGHT_COLOR = new Color(0xFF0000);

    public synchronized void addLegend(int dataset, String legend) {
        this._checkDatasetIndex(dataset);
        super.addLegend(dataset, legend);
    }

    public synchronized void addPoint(final int dataset, final double x, final double y, final String oid, final boolean connected) {
        Runnable doAddPoint = new Runnable(){

            public void run() {
                Plot.this._addPoint(dataset, x, y, 0.0, 0.0, connected, false, false, oid);
            }
        };
        this.deferIfNecessary(doAddPoint);
    }

    public synchronized void addPointWithErrorBars(final int dataset, final double x, final double y, final double yLowEB, final double yHighEB, final String oid, final boolean connected) {
        Runnable doAddPoint = new Runnable(){

            public void run() {
                Plot.this._addPoint(dataset, x, y, yLowEB, yHighEB, connected, true, false, oid);
            }
        };
        this.deferIfNecessary(doAddPoint);
    }

    public synchronized void addPointWithErrorBars(int dataset, double x, double y, double yLowEB, double yHighEB, String oid, boolean connected, boolean isServerSide) {
        if (isServerSide) {
            this._addPoint(dataset, x, y, yLowEB, yHighEB, connected, true, true, oid);
        } else {
            this.addPointWithErrorBars(dataset, x, y, yLowEB, yHighEB, oid, connected);
        }
    }

    public synchronized void clear(final boolean format) {
        Runnable doClear = new Runnable(){

            public void run() {
                Plot.this._clear(format);
            }
        };
        this.deferIfNecessary(doClear);
    }

    public synchronized void clear(boolean format, boolean isServerSide) {
        if (isServerSide) {
            this._clear(format);
        } else {
            this.clear(format);
        }
    }

    public synchronized void clear(final int dataset) {
        Runnable doClear = new Runnable(){

            public void run() {
                Plot.this._clear(dataset);
            }
        };
        this.deferIfNecessary(doClear);
    }

    public synchronized void clear(int dataset, boolean isServerSide) {
        if (isServerSide) {
            this._clear(dataset);
        } else {
            this.clear(dataset);
        }
    }

    public synchronized void erasePoint(final int dataset, final int index) {
        Runnable doErasePoint = new Runnable(){

            public void run() {
                Plot.this._erasePoint(dataset, index);
            }
        };
        this.deferIfNecessary(doErasePoint);
    }

    public synchronized void erasePoint(int dataset, int index, boolean isServerSide) {
        if (isServerSide) {
            this._erasePoint(dataset, index);
        } else {
            this.erasePoint(dataset, index);
        }
    }

    public synchronized void fillPlot() {
        Runnable doFill = new Runnable(){

            public void run() {
                Plot.this._fillPlot();
            }
        };
        this.deferIfNecessary(doFill);
    }

    public synchronized void fillPlot(boolean isServerSide) {
        if (isServerSide) {
            this._fillPlot();
        } else {
            this.fillPlot();
        }
    }

    public boolean getConnected() {
        return this._connected;
    }

    public boolean getImpulses() {
        return this._impulses;
    }

    public synchronized String getMarksStyle() {
        if (this._marks == 0) {
            return "none";
        }
        if (this._marks == 1) {
            return "points";
        }
        if (this._marks == 2) {
            return "dots";
        }
        if (this._marks == 3) {
            return "various";
        }
        return "pixels";
    }

    public int getMaxDataSets() {
        return Integer.MAX_VALUE;
    }

    public synchronized int getNumDataSets() {
        return this._points.size();
    }

    public void parseFile(String filespec, URL documentBase) {
        this._firstInSet = true;
        this._sawFirstDataSet = false;
        super.parseFile(filespec, documentBase);
    }

    public synchronized void read(InputStream in) throws IOException {
        super.read(in);
        this._firstInSet = true;
        this._sawFirstDataSet = false;
    }

    public synchronized void samplePlot() {
        Runnable sample = new Runnable(){

            public void run() {
                Plot plot = Plot.this;
                synchronized (plot) {
                    Plot.this.clear(true);
                    Plot.this.setTitle("Sample plot");
                    Plot.this.setYRange(-4.0, 4.0);
                    Plot.this.setXRange(0.0, 100.0);
                    Plot.this.setXLabel("time");
                    Plot.this.setYLabel("value");
                    Plot.this.addYTick("-PI", -Math.PI);
                    Plot.this.addYTick("-PI/2", -1.5707963267948966);
                    Plot.this.addYTick("0", 0.0);
                    Plot.this.addYTick("PI/2", 1.5707963267948966);
                    Plot.this.addYTick("PI", Math.PI);
                    Plot.this.setMarksStyle("none");
                    Plot.this.setImpulses(true);
                    boolean first = true;
                    for (int i = 0; i <= 100; ++i) {
                        double xvalue = i;
                        Plot.this.addPoint(0, xvalue, (double)5 * Math.cos(Math.PI * (double)i / (double)20), "x", !first);
                        Plot.this.addPoint(1, xvalue, 4.5 * Math.cos(Math.PI * (double)i / (double)25), "x", !first);
                        Plot.this.addPoint(2, xvalue, (double)4 * Math.cos(Math.PI * (double)i / (double)30), "x", !first);
                        Plot.this.addPoint(3, xvalue, 3.5 * Math.cos(Math.PI * (double)i / (double)35), "x", !first);
                        Plot.this.addPoint(4, xvalue, (double)3 * Math.cos(Math.PI * (double)i / (double)40), "x", !first);
                        Plot.this.addPoint(5, xvalue, 2.5 * Math.cos(Math.PI * (double)i / (double)45), "x", !first);
                        Plot.this.addPoint(6, xvalue, (double)2 * Math.cos(Math.PI * (double)i / (double)50), "x", !first);
                        Plot.this.addPoint(7, xvalue, 1.5 * Math.cos(Math.PI * (double)i / (double)55), "x", !first);
                        Plot.this.addPoint(8, xvalue, 1.0 * Math.cos(Math.PI * (double)i / (double)60), "x", !first);
                        Plot.this.addPoint(9, xvalue, 0.5 * Math.cos(Math.PI * (double)i / (double)65), "x", !first);
                        first = false;
                    }
                }
                Plot.this.repaint();
            }
        };
        this.deferIfNecessary(sample);
    }

    public void setBars(boolean on) {
        this._bars = on;
    }

    public synchronized void setBars(double width, double offset) {
        this.barWidth = width;
        this._barOffset = offset;
        this._bars = true;
    }

    public void setConnected(boolean on) {
        this._connected = on;
    }

    public synchronized void setConnected(boolean on, int dataset) {
        this._checkDatasetIndex(dataset);
        Format fmt = (Format)this._formats.elementAt(dataset);
        fmt.connected = on;
        fmt.connectedUseDefault = false;
    }

    public synchronized void setImpulses(boolean on) {
        this._impulses = on;
    }

    public synchronized void setImpulses(boolean on, int dataset) {
        this._checkDatasetIndex(dataset);
        Format fmt = (Format)this._formats.elementAt(dataset);
        fmt.impulses = on;
        fmt.impulsesUseDefault = false;
    }

    public synchronized void setMarksStyle(String style) {
        if (style.equalsIgnoreCase("none")) {
            this._marks = 0;
        } else if (style.equalsIgnoreCase("points")) {
            this._marks = 1;
        } else if (style.equalsIgnoreCase("dots")) {
            this._marks = 2;
        } else if (style.equalsIgnoreCase("various")) {
            this._marks = 3;
        } else if (style.equalsIgnoreCase("pixels")) {
            this._marks = 4;
        }
    }

    public synchronized void setMarksStyle(String style, int dataset) {
        this._checkDatasetIndex(dataset);
        Format fmt = (Format)this._formats.elementAt(dataset);
        if (style.equalsIgnoreCase("none")) {
            fmt.marks = 0;
        } else if (style.equalsIgnoreCase("points")) {
            fmt.marks = 1;
        } else if (style.equalsIgnoreCase("dots")) {
            fmt.marks = 2;
        } else if (style.equalsIgnoreCase("various")) {
            fmt.marks = 3;
        } else if (style.equalsIgnoreCase("pixels")) {
            fmt.marks = 4;
        }
        fmt.marksUseDefault = false;
    }

    public void setNumSets(int numsets) {
        if (numsets < 1) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("Number of data sets (").append(numsets).append(") must be greater than 0."))));
        }
        this._currentdataset = -1;
        this._points.removeAllElements();
        this._formats.removeAllElements();
        this._prevx.removeAllElements();
        this._prevy.removeAllElements();
        for (int i = 0; i < numsets; ++i) {
            this._points.addElement(new Vector());
            this._formats.addElement(new Format(this));
            this._prevx.addElement(new Long(0L));
            this._prevy.addElement(new Long(0L));
        }
    }

    public void setPointsPersistence(int persistence) {
        this._pointsPersistence = persistence;
    }

    public void setReuseDatasets(boolean on) {
        this._reuseDatasets = on;
    }

    public void setXPersistence(double persistence) {
        this._xPersistence = persistence;
    }

    public synchronized void writeData(PrintWriter output) {
        super.writeData(output);
        for (int dataset = 0; dataset < this._points.size(); ++dataset) {
            String legend;
            StringBuffer options = new StringBuffer();
            Format fmt = (Format)this._formats.elementAt(dataset);
            if (!fmt.connectedUseDefault) {
                if (this._isConnected(dataset)) {
                    options.append(" connected=\"yes\"");
                } else {
                    options.append(" connected=\"no\"");
                }
            }
            if (!fmt.impulsesUseDefault) {
                if (fmt.impulses) {
                    options.append(" stems=\"yes\"");
                } else {
                    output.println(" stems=\"no\"");
                }
            }
            if (!fmt.marksUseDefault) {
                switch (fmt.marks) {
                    case 0: {
                        options.append(" marks=\"none\"");
                    }
                    case 1: {
                        options.append(" marks=\"points\"");
                    }
                    case 2: {
                        options.append(" marks=\"dots\"");
                    }
                    case 3: {
                        options.append(" marks=\"various\"");
                    }
                    case 4: {
                        options.append(" marks=\"pixels\"");
                    }
                }
            }
            if ((legend = this.getLegend(dataset)) != null) {
                options.append(String.valueOf(String.valueOf(new StringBuffer(" name=\"").append(this.getLegend(dataset)).append("\""))));
            }
            output.println(String.valueOf(String.valueOf(new StringBuffer("<dataset").append(options.toString()).append(">"))));
            Vector pts = (Vector)this._points.elementAt(dataset);
            for (int pointnum = 0; pointnum < pts.size(); ++pointnum) {
                PlotPoint pt = (PlotPoint)pts.elementAt(pointnum);
                if (!pt.connected) {
                    output.print("<m ");
                } else {
                    output.print("<p ");
                }
                output.print(String.valueOf(String.valueOf(new StringBuffer("x=\"").append(pt.x).append("\" y=\"").append(pt.y).append("\""))));
                if (pt.errorBar) {
                    output.print(String.valueOf(String.valueOf(new StringBuffer(" lowErrorBar=\"").append(pt.yLowEB).append("\" highErrorBar=\"").append(pt.yHighEB).append("\""))));
                }
                output.println("/>");
            }
            output.println("</dataset>");
        }
    }

    public synchronized void writeFormat(PrintWriter output) {
        super.writeFormat(output);
        if (this._reuseDatasets) {
            output.println("<reuseDatasets/>");
        }
        StringBuffer defaults = new StringBuffer();
        if (!this._connected) {
            defaults.append(" connected=\"no\"");
        }
        switch (this._marks) {
            case 1: {
                defaults.append(" marks=\"points\"");
                break;
            }
            case 2: {
                defaults.append(" marks=\"dots\"");
                break;
            }
            case 3: {
                defaults.append(" marks=\"various\"");
                break;
            }
            case 4: {
                defaults.append(" marks=\"pixels\"");
            }
        }
        if (this._impulses) {
            defaults.append(" stems=\"yes\"");
        }
        if (defaults.length() > 0) {
            output.println(String.valueOf(String.valueOf(new StringBuffer("<default").append(defaults.toString()).append("/>"))));
        }
        if (this._bars) {
            output.println(String.valueOf(String.valueOf(new StringBuffer("<barGraph width=\"").append(this.barWidth).append("\" offset=\"").append(this._barOffset).append("\"/>"))));
        }
    }

    protected synchronized void _checkDatasetIndex(int dataset) {
        if (dataset < 0) {
            throw new IllegalArgumentException("Plot._checkDatasetIndex: Cannot give a negative number for the data set index.");
        }
        while (dataset >= this._points.size()) {
            this._points.addElement(new Vector());
            this._formats.addElement(new Format(this));
            this._prevx.addElement(new Long(0L));
            this._prevy.addElement(new Long(0L));
        }
    }

    protected void _drawBar(Graphics graphics, int dataset, long xpos, long ypos, boolean clip) {
        if (clip) {
            if (ypos < (long)this._uly) {
                ypos = this._uly;
            }
            if (ypos > (long)this._lry) {
                ypos = this._lry;
            }
        }
        if (ypos <= (long)this._lry && xpos <= (long)this._lrx && xpos >= (long)this._ulx) {
            long zeroypos;
            int barlx = (int)((double)xpos - this.barWidth * this._xscale / (double)2 + (double)dataset * this._barOffset * this._xscale);
            int barrx = (int)((double)barlx + this.barWidth * this._xscale);
            if (barlx < this._ulx) {
                barlx = this._ulx;
            }
            if (barrx > this._lrx) {
                barrx = this._lrx;
            }
            if (barlx >= barrx) {
                barrx = barlx + 1;
            }
            if ((long)this._lry < (zeroypos = (long)this._lry - (long)((0.0 - this._yMin) * this._yscale))) {
                zeroypos = this._lry;
            }
            if ((long)this._uly > zeroypos) {
                zeroypos = this._uly;
            }
            if (this._yMin >= 0.0 || ypos <= zeroypos) {
                graphics.fillRect(barlx, (int)ypos, barrx - barlx, (int)(zeroypos - ypos));
            } else {
                graphics.fillRect(barlx, (int)zeroypos, barrx - barlx, (int)(ypos - zeroypos));
            }
        }
    }

    protected void _drawErrorBar(Graphics graphics, int dataset, long xpos, long yLowEBPos, long yHighEBPos, boolean clip) {
        this._drawLine(graphics, dataset, xpos - (long)5, yHighEBPos, xpos + (long)5, yHighEBPos, clip);
        this._drawLine(graphics, dataset, xpos, yLowEBPos, xpos, yHighEBPos, clip);
        this._drawLine(graphics, dataset, xpos - (long)5, yLowEBPos, xpos + (long)5, yLowEBPos, clip);
    }

    protected void _drawImpulse(Graphics graphics, long xpos, long ypos, boolean clip) {
        if (clip) {
            if (ypos < (long)this._uly) {
                ypos = this._uly;
            }
            if (ypos > (long)this._lry) {
                ypos = this._lry;
            }
        }
        if (ypos <= (long)this._lry && xpos <= (long)this._lrx && xpos >= (long)this._ulx) {
            double zeroypos = (long)this._lry - (long)((0.0 - this._yMin) * this._yscale);
            if ((double)this._lry < zeroypos) {
                zeroypos = this._lry;
            }
            if ((double)this._uly > zeroypos) {
                zeroypos = this._uly;
            }
            graphics.drawLine((int)xpos, (int)ypos, (int)xpos, (int)zeroypos);
        }
    }

    protected void _drawLine(Graphics graphics, int dataset, long startx, long starty, long endx, long endy, boolean clip) {
        if (clip) {
            if (!(endx <= (long)this._ulx && startx <= (long)this._ulx || endx >= (long)this._lrx && startx >= (long)this._lrx || endy <= (long)this._uly && starty <= (long)this._uly || endy >= (long)this._lry && starty >= (long)this._lry)) {
                if (startx != endx) {
                    if (endx < (long)this._ulx) {
                        endy = (int)(endy + (starty - endy) * ((long)this._ulx - endx) / (startx - endx));
                        endx = this._ulx;
                    } else if (endx > (long)this._lrx) {
                        endy = (int)(endy + (starty - endy) * ((long)this._lrx - endx) / (startx - endx));
                        endx = this._lrx;
                    }
                }
                if (starty != endy) {
                    if (endy < (long)this._uly) {
                        endx = (int)(endx + (startx - endx) * ((long)this._uly - endy) / (starty - endy));
                        endy = this._uly;
                    } else if (endy > (long)this._lry) {
                        endx = (int)(endx + (startx - endx) * ((long)this._lry - endy) / (starty - endy));
                        endy = this._lry;
                    }
                }
                if (startx != endx) {
                    if (startx < (long)this._ulx) {
                        starty = (int)(starty + (endy - starty) * ((long)this._ulx - startx) / (endx - startx));
                        startx = this._ulx;
                    } else if (startx > (long)this._lrx) {
                        starty = (int)(starty + (endy - starty) * ((long)this._lrx - startx) / (endx - startx));
                        startx = this._lrx;
                    }
                }
                if (starty != endy) {
                    if (starty < (long)this._uly) {
                        startx = (int)(startx + (endx - startx) * ((long)this._uly - starty) / (endy - starty));
                        starty = this._uly;
                    } else if (starty > (long)this._lry) {
                        startx = (int)(startx + (endx - startx) * ((long)this._lry - starty) / (endy - starty));
                        starty = this._lry;
                    }
                }
            }
            if (endx >= (long)this._ulx && endx <= (long)this._lrx && endy >= (long)this._uly && endy <= (long)this._lry && startx >= (long)this._ulx && startx <= (long)this._lrx && starty >= (long)this._uly && starty <= (long)this._lry) {
                graphics.drawLine((int)startx, (int)starty, (int)endx, (int)endy);
            }
        } else {
            graphics.drawLine((int)startx, (int)starty, (int)endx, (int)endy);
        }
    }

    protected synchronized void _drawPlot(Graphics graphics, boolean clearfirst, Rectangle drawRectangle) {
        super._drawPlot(graphics, clearfirst, drawRectangle);
        for (int dataset = this._points.size() - 1; dataset >= 0; --dataset) {
            Vector data = (Vector)this._points.elementAt(dataset);
            Vector<Integer> highlightedPoints = new Vector<Integer>();
            for (int pointnum = 0; pointnum < data.size(); ++pointnum) {
                PlotPoint pt = (PlotPoint)data.elementAt(pointnum);
                if (!pt.highlighted) {
                    this._drawPlotPoint(graphics, dataset, pointnum);
                    continue;
                }
                highlightedPoints.add(new Integer(pointnum));
            }
            for (int pointIndex = 0; pointIndex < highlightedPoints.size(); ++pointIndex) {
                int index = (Integer)highlightedPoints.get(pointIndex);
                PlotPoint pt = (PlotPoint)data.elementAt(index);
                if (!pt.highlighted) continue;
                this._drawPlotPoint(graphics, dataset, index);
            }
        }
        this._showing = true;
    }

    protected void _drawPoint(Graphics graphics, int dataset, long xpos, long ypos, boolean clip, boolean selected, boolean highlighted) {
        boolean pointinside;
        boolean bl = pointinside = ypos <= (long)this._lry && ypos >= (long)this._uly && xpos <= (long)this._lrx && xpos >= (long)this._ulx;
        if (!clip || pointinside) {
            int xposi = (int)xpos;
            int yposi = (int)ypos;
            Format fmt = (Format)this._formats.elementAt(dataset);
            int marks = this._marks;
            if (!fmt.marksUseDefault) {
                marks = fmt.marks;
            }
            if (!pointinside && marks != 3 && this._isConnected(dataset) && graphics instanceof EPSGraphics) {
                graphics.drawLine(xposi - 6, yposi, xposi + 6, yposi);
            } else {
                Color old;
                Color original = graphics.getColor();
                if (highlighted) {
                    old = this.HIGHLIGHT_COLOR;
                    graphics.setColor(old);
                } else {
                    old = original;
                }
                switch (marks) {
                    case 0: {
                        graphics.fillRect(xposi - 6, yposi - 6, 6, 6);
                        break;
                    }
                    case 1: {
                        if (selected) {
                            graphics.setColor(new Color(43690));
                            graphics.drawRect(xposi - 3, yposi - 3, 6, 6);
                            graphics.setColor(old);
                        }
                        graphics.fillOval(xposi - 1, yposi - 1, 3, 3);
                        break;
                    }
                    case 2: {
                        if (selected) {
                            graphics.setColor(new Color(43690));
                            graphics.drawRect(xposi - 4, yposi - 4, 8, 8);
                            graphics.setColor(old);
                        }
                        graphics.fillOval(xposi - this._radius, yposi - this._radius, this._diameter, this._diameter);
                        break;
                    }
                    case 3: {
                        if (selected) {
                            graphics.setColor(new Color(43690));
                            graphics.drawRect(xposi - 4, yposi - 4, 8, 8);
                            graphics.setColor(old);
                        }
                        int mark = super.getMarkerStyle(dataset);
                        switch (mark) {
                            case 0: {
                                graphics.fillOval(xposi - this._radius, yposi - this._radius, this._diameter, this._diameter);
                                break;
                            }
                            case 1: {
                                graphics.drawLine(xposi - this._radius, yposi - this._radius, xposi + this._radius, yposi + this._radius);
                                graphics.drawLine(xposi + this._radius, yposi - this._radius, xposi - this._radius, yposi + this._radius);
                                break;
                            }
                            case 2: {
                                graphics.drawRect(xposi - this._radius + 1, yposi - this._radius + 1, this._diameter - 2, this._diameter - 2);
                                graphics.drawLine(xposi - this._radius + 1, yposi - this._radius + 1, xposi + this._radius - 1, yposi + this._radius - 1);
                                graphics.drawLine(xposi + this._radius - 1, yposi - this._radius + 1, xposi - this._radius + 1, yposi + this._radius - 1);
                                break;
                            }
                            case 3: {
                                int[] xpoints = new int[4];
                                int[] ypoints = new int[4];
                                xpoints[0] = xposi;
                                ypoints[0] = yposi - this._radius;
                                xpoints[1] = xposi + this._radius;
                                ypoints[1] = yposi + this._radius;
                                xpoints[2] = xposi - this._radius;
                                ypoints[2] = yposi + this._radius;
                                xpoints[3] = xposi;
                                ypoints[3] = yposi - this._radius;
                                graphics.fillPolygon(xpoints, ypoints, 4);
                                break;
                            }
                            case 4: {
                                int[] xpoints = new int[5];
                                int[] ypoints = new int[5];
                                xpoints[0] = xposi;
                                ypoints[0] = yposi - this._radius;
                                xpoints[1] = xposi + this._radius;
                                ypoints[1] = yposi;
                                xpoints[2] = xposi;
                                ypoints[2] = yposi + this._radius;
                                xpoints[3] = xposi - this._radius;
                                ypoints[3] = yposi;
                                xpoints[4] = xposi;
                                ypoints[4] = yposi - this._radius;
                                graphics.drawPolygon(xpoints, ypoints, 5);
                                break;
                            }
                            case 5: {
                                graphics.drawOval(xposi - this._radius, yposi - this._radius, this._diameter, this._diameter);
                                break;
                            }
                            case 6: {
                                graphics.drawLine(xposi, yposi - this._radius, xposi, yposi + this._radius);
                                graphics.drawLine(xposi - this._radius, yposi, xposi + this._radius, yposi);
                                break;
                            }
                            case 7: {
                                graphics.fillRect(xposi - this._radius, yposi - this._radius, this._diameter, this._diameter);
                                break;
                            }
                            case 8: {
                                int[] xpoints = new int[4];
                                int[] ypoints = new int[4];
                                xpoints[0] = xposi;
                                ypoints[0] = yposi - this._radius;
                                xpoints[1] = xposi + this._radius;
                                ypoints[1] = yposi + this._radius;
                                xpoints[2] = xposi - this._radius;
                                ypoints[2] = yposi + this._radius;
                                xpoints[3] = xposi;
                                ypoints[3] = yposi - this._radius;
                                graphics.drawPolygon(xpoints, ypoints, 4);
                                break;
                            }
                            case 9: {
                                int[] xpoints = new int[5];
                                int[] ypoints = new int[5];
                                xpoints[0] = xposi;
                                ypoints[0] = yposi - this._radius;
                                xpoints[1] = xposi + this._radius;
                                ypoints[1] = yposi;
                                xpoints[2] = xposi;
                                ypoints[2] = yposi + this._radius;
                                xpoints[3] = xposi - this._radius;
                                ypoints[3] = yposi;
                                xpoints[4] = xposi;
                                ypoints[4] = yposi - this._radius;
                                graphics.fillPolygon(xpoints, ypoints, 5);
                            }
                        }
                        break;
                    }
                    case 4: {
                        if (selected) {
                            graphics.setColor(new Color(43690));
                            graphics.drawRect(xposi - 2, yposi - 2, 4, 4);
                            graphics.setColor(old);
                        }
                        graphics.fillRect(xposi, yposi, 1, 1);
                        break;
                    }
                    default: {
                        graphics.setColor(original);
                        break;
                    }
                }
            }
        }
    }

    protected boolean _parseLine(String line) {
        boolean connected = false;
        if (this._isConnected(this._currentdataset)) {
            connected = true;
        }
        if (super._parseLine(line)) {
            return true;
        }
        String lcLine = new String(line.toLowerCase());
        if (lcLine.startsWith("marks:")) {
            String style = line.substring(6).trim();
            if (this._sawFirstDataSet) {
                this.setMarksStyle(style, this._currentdataset);
            } else {
                this.setMarksStyle(style);
            }
            return true;
        }
        if (lcLine.startsWith("numsets:")) {
            return true;
        }
        if (lcLine.startsWith("reusedatasets:")) {
            if (lcLine.indexOf("off", 16) >= 0) {
                this.setReuseDatasets(false);
            } else {
                this.setReuseDatasets(true);
            }
            return true;
        }
        if (lcLine.startsWith("dataset:")) {
            String legend;
            if (this._reuseDatasets && lcLine.length() > 0) {
                String tlegend = line.substring(8).trim();
                this._currentdataset = -1;
                for (int i = 0; i <= this._maxDataset; ++i) {
                    if (this.getLegend(i).compareTo(tlegend) != 0) continue;
                    this._currentdataset = i;
                }
                if (this._currentdataset != -1) {
                    return true;
                }
                this._currentdataset = this._maxDataset;
            }
            this._firstInSet = true;
            this._sawFirstDataSet = true;
            ++this._currentdataset;
            if (lcLine.length() > 0 && (legend = line.substring(8).trim()) != null && legend.length() > 0) {
                this.addLegend(this._currentdataset, legend);
            }
            this._maxDataset = this._currentdataset;
            return true;
        }
        if (lcLine.startsWith("lines:")) {
            if (lcLine.indexOf("off", 6) >= 0) {
                this.setConnected(false);
            } else {
                this.setConnected(true);
            }
            return true;
        }
        if (lcLine.startsWith("impulses:")) {
            if (this._sawFirstDataSet) {
                if (lcLine.indexOf("off", 9) >= 0) {
                    this.setImpulses(false, this._currentdataset);
                } else {
                    this.setImpulses(true, this._currentdataset);
                }
            } else if (lcLine.indexOf("off", 9) >= 0) {
                this.setImpulses(false);
            } else {
                this.setImpulses(true);
            }
            return true;
        }
        if (lcLine.startsWith("bars:")) {
            if (lcLine.indexOf("off", 5) >= 0) {
                this.setBars(false);
            } else {
                String barwidth;
                this.setBars(true);
                int comma = line.indexOf(",", 5);
                String baroffset = null;
                if (comma > 0) {
                    barwidth = line.substring(5, comma).trim();
                    baroffset = line.substring(comma + 1).trim();
                } else {
                    barwidth = line.substring(5).trim();
                }
                try {
                    Double bwidth = new Double(barwidth);
                    double boffset = this._barOffset;
                    if (baroffset != null) {
                        boffset = new Double(baroffset);
                    }
                    this.setBars(bwidth, boffset);
                }
                catch (NumberFormatException bwidth) {
                    // empty catch block
                }
            }
            return true;
        }
        if (line.startsWith("move:")) {
            connected = false;
            line = line.substring(5, line.length()).trim();
        } else if (line.startsWith("move")) {
            connected = false;
            line = line.substring(4, line.length()).trim();
        } else if (line.startsWith("draw:")) {
            line = line.substring(5, line.length()).trim();
        } else if (line.startsWith("draw")) {
            line = line.substring(4, line.length()).trim();
        }
        line = line.trim();
        int fieldsplit = line.indexOf(",");
        if (fieldsplit == -1) {
            fieldsplit = line.indexOf(" ");
        }
        if (fieldsplit == -1) {
            fieldsplit = line.indexOf("\t");
        }
        if (fieldsplit > 0) {
            String x = line.substring(0, fieldsplit).trim();
            String y = line.substring(fieldsplit + 1).trim();
            int fieldsplit2 = y.indexOf(",");
            if (fieldsplit2 == -1) {
                fieldsplit2 = y.indexOf(" ");
            }
            if (fieldsplit2 == -1) {
                fieldsplit2 = y.indexOf("\t");
            }
            if (fieldsplit2 > 0) {
                line = y.substring(fieldsplit2 + 1).trim();
                y = y.substring(0, fieldsplit2).trim();
            }
            try {
                Double xpt = new Double(x);
                Double ypt = new Double(y);
                if (fieldsplit2 > 0) {
                    int fieldsplit3 = line.indexOf(",");
                    if (fieldsplit3 == -1) {
                        fieldsplit3 = line.indexOf(" ");
                    }
                    if (fieldsplit3 == -1) {
                        fieldsplit2 = line.indexOf("\t");
                    }
                    if (fieldsplit3 > 0) {
                        String yl = line.substring(0, fieldsplit3).trim();
                        String yh = line.substring(fieldsplit3 + 1).trim();
                        Double yLowEB = new Double(yl);
                        Double yHighEB = new Double(yh);
                        connected = this._addLegendIfNecessary(connected);
                        this.addPointWithErrorBars(this._currentdataset, xpt, ypt, yLowEB, yHighEB, "x", connected);
                        boolean bl = true;
                        return bl;
                    }
                    connected = this._addLegendIfNecessary(connected);
                    this.addPoint(this._currentdataset, xpt, ypt, "x", connected);
                    boolean bl = true;
                    return bl;
                }
                connected = this._addLegendIfNecessary(connected);
                this.addPoint(this._currentdataset, xpt, ypt, "x", connected);
                boolean bl = true;
                return bl;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    protected void _writeOldSyntax(PrintWriter output) {
        super._writeOldSyntax(output);
        if (this._reuseDatasets) {
            output.println("ReuseDatasets: on");
        }
        if (!this._connected) {
            output.println("Lines: off");
        }
        if (this._bars) {
            output.println(String.valueOf(String.valueOf(new StringBuffer("Bars: ").append(this.barWidth).append(", ").append(this._barOffset))));
        }
        if (this._impulses) {
            output.println("Impulses: on");
        }
        switch (this._marks) {
            case 1: {
                output.println("Marks: points");
            }
            case 2: {
                output.println("Marks: dots");
            }
            case 3: {
                output.println("Marks: various");
            }
            case 4: {
                output.println("Marks: pixels");
            }
        }
        for (int dataset = 0; dataset < this._points.size(); ++dataset) {
            String legend = this.getLegend(dataset);
            if (legend != null) {
                output.println("DataSet: ".concat(String.valueOf(String.valueOf(this.getLegend(dataset)))));
            } else {
                output.println("DataSet:");
            }
            Format fmt = (Format)this._formats.elementAt(dataset);
            if (!fmt.impulsesUseDefault) {
                if (fmt.impulses) {
                    output.println("Impulses: on");
                } else {
                    output.println("Impulses: off");
                }
            }
            if (!fmt.marksUseDefault) {
                switch (fmt.marks) {
                    case 0: {
                        output.println("Marks: none");
                    }
                    case 1: {
                        output.println("Marks: points");
                    }
                    case 2: {
                        output.println("Marks: dots");
                    }
                    case 3: {
                        output.println("Marks: various");
                    }
                    case 4: {
                        output.println("Marks: pixels");
                    }
                }
            }
            Vector pts = (Vector)this._points.elementAt(dataset);
            for (int pointnum = 0; pointnum < pts.size(); ++pointnum) {
                PlotPoint pt = (PlotPoint)pts.elementAt(pointnum);
                if (!pt.connected) {
                    output.print("move: ");
                }
                if (pt.errorBar) {
                    output.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pt.x))).append(", ").append(pt.y).append(", ").append(pt.yLowEB).append(", ").append(pt.yHighEB))));
                    continue;
                }
                output.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pt.x))).append(", ").append(pt.y))));
            }
        }
    }

    private boolean _addLegendIfNecessary(boolean connected) {
        if (!(this._sawFirstDataSet && this._currentdataset >= 0 || this._reuseDatasets)) {
            this._sawFirstDataSet = true;
            ++this._currentdataset;
        }
        if (!this._sawFirstDataSet && this.getLegend(this._currentdataset) == null) {
            this._firstInSet = true;
            this._sawFirstDataSet = true;
            this.addLegend(this._currentdataset, new String("Set ".concat(String.valueOf(String.valueOf(this._currentdataset)))));
        }
        if (this._firstInSet && !this._reuseDatasets) {
            connected = false;
            this._firstInSet = false;
        }
        return connected;
    }

    private void _addPoint(int dataset, double x, double y, double yLowEB, double yHighEB, boolean connected, boolean errorBar, boolean isServerSide, String oid) {
        this._checkDatasetIndex(dataset);
        if (super.getLegend(dataset) == null) {
            this.addLegend(dataset, "Current");
        }
        if (this._xlog) {
            if (x <= 0.0) {
                System.err.println("Can't plot non-positive X values when the logarithmic X axis value is specified: ".concat(String.valueOf(String.valueOf(x))));
                return;
            }
            x = Math.log(x) * PlotBox._LOG10SCALE;
        }
        if (this._ylog) {
            if (y <= 0.0) {
                System.err.println("Can't plot non-positive Y values when the logarithmic Y axis value is specified: ".concat(String.valueOf(String.valueOf(y))));
                return;
            }
            y = Math.log(y) * PlotBox._LOG10SCALE;
            if (errorBar) {
                if (yLowEB <= 0.0 || yHighEB <= 0.0) {
                    System.err.println("Can't plot non-positive Y values when the logarithmic Y axis value is specified: ".concat(String.valueOf(String.valueOf(y))));
                    return;
                }
                yLowEB = Math.log(yLowEB) * PlotBox._LOG10SCALE;
                yHighEB = Math.log(yHighEB) * PlotBox._LOG10SCALE;
            }
        }
        Vector pts = (Vector)this._points.elementAt(dataset);
        if (this._xPersistence > 0.0) {
            int numToDelete;
            for (numToDelete = 0; numToDelete < pts.size(); ++numToDelete) {
                PlotPoint old = (PlotPoint)pts.elementAt(numToDelete);
                if (x - old.originalx <= this._xPersistence) break;
            }
            for (int i = 0; i < numToDelete; ++i) {
                this.erasePoint(dataset, 0, isServerSide);
            }
        }
        int size = pts.size();
        PlotPoint pt = new PlotPoint();
        pt.originalx = x;
        if (this._wrap) {
            double width = this._wrapHigh - this._wrapLow;
            if (x < this._wrapLow) {
                x += width * Math.floor(1.0 + (this._wrapLow - x) / width);
            } else if (x > this._wrapHigh && (x -= width * Math.floor(1.0 + (x - this._wrapHigh) / width)) == this._wrapLow) {
                x = this._wrapHigh;
            }
        }
        if (x < this._xBottom) {
            this._xBottom = x;
        }
        if (x > this._xTop) {
            this._xTop = x;
        }
        if (y < this._yBottom) {
            this._yBottom = y;
        }
        if (y > this._yTop) {
            this._yTop = y;
        }
        pt.x = x;
        pt.y = y;
        pt.connected = connected && this._isConnected(dataset);
        pt.objectID = oid;
        if (errorBar) {
            if (yLowEB < this._yBottom) {
                this._yBottom = yLowEB;
            }
            if (yLowEB > this._yTop) {
                this._yTop = yLowEB;
            }
            if (yHighEB < this._yBottom) {
                this._yBottom = yHighEB;
            }
            if (yHighEB > this._yTop) {
                this._yTop = yHighEB;
            }
            pt.yLowEB = yLowEB;
            pt.yHighEB = yHighEB;
            pt.errorBar = true;
        }
        if (size == 0) {
            pt.connected = false;
        } else if (this._wrap) {
            PlotPoint old = (PlotPoint)pts.elementAt(size - 1);
            if (old.x > x) {
                pt.connected = false;
            }
        }
        pts.addElement(pt);
        if (this._pointsPersistence > 0 && size > this._pointsPersistence) {
            this.erasePoint(dataset, 0, isServerSide);
        }
        Graphics graphics = this.getGraphics();
        if (this._showing && graphics != null) {
            if ((this._pointsPersistence > 0 || this._xPersistence > 0.0) && this.isDoubleBuffered()) {
                this.setDoubleBuffered(false);
                for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof JComponent)) continue;
                    ((JComponent)parent).setDoubleBuffered(false);
                }
            }
            this._drawPlotPoint(graphics, dataset, pts.size() - 1);
        }
        if (this._wrap && x == this._wrapHigh) {
            this._addPoint(dataset, this._wrapLow, y, yLowEB, yHighEB, false, errorBar, isServerSide, "x");
        }
    }

    private void _clear(boolean format) {
        super.clear(format);
        this._currentdataset = -1;
        int size = this._points.size();
        this._points = new Vector();
        this._prevx = new Vector();
        this._prevy = new Vector();
        this._maxDataset = -1;
        this._firstInSet = true;
        this._sawFirstDataSet = false;
        this._xyInvalid = true;
        this._filename = null;
        if (format) {
            this._showing = false;
            this._formats = new Vector();
            this._marks = 0;
            this._pointsPersistence = 0;
            this._xPersistence = 0.0;
            this._bars = false;
            this.barWidth = 0.5;
            this._barOffset = 0.05;
            this._connected = true;
            this._impulses = false;
            this._reuseDatasets = false;
        }
    }

    private void _clear(int dataset) {
        this._checkDatasetIndex(dataset);
        this._xyInvalid = true;
        Vector points = (Vector)this._points.elementAt(dataset);
        this._points.setElementAt(new Vector(), dataset);
        this.repaint();
    }

    private void _drawPlotPoint(Graphics graphics, int dataset, int index) {
        if (this._pointsPersistence > 0 || this._xPersistence > 0.0) {
            if (this._background == null) {
                graphics.setXORMode(this.getBackground());
            } else {
                graphics.setXORMode(this._background);
            }
        }
        if (this._usecolor) {
            Color color = super.getColor(dataset);
            graphics.setColor(color);
        } else {
            graphics.setColor(this._foreground);
        }
        Vector pts = (Vector)this._points.elementAt(dataset);
        PlotPoint pt = (PlotPoint)pts.elementAt(index);
        long ypos = (long)this._lry - (long)((pt.y - this._yMin) * this._yscale);
        long xpos = (long)this._ulx + (long)((pt.x - this._xMin) * this._xscale);
        long prevx = (Long)this._prevx.elementAt(dataset);
        long prevy = (Long)this._prevy.elementAt(dataset);
        if (pt.connected) {
            this._drawLine(graphics, dataset, xpos, ypos, prevx, prevy, true);
        }
        this._prevx.setElementAt(new Long(xpos), dataset);
        this._prevy.setElementAt(new Long(ypos), dataset);
        Format fmt = (Format)this._formats.elementAt(dataset);
        if (fmt.impulsesUseDefault) {
            if (this._impulses) {
                this._drawImpulse(graphics, xpos, ypos, true);
            }
        } else if (fmt.impulses) {
            this._drawImpulse(graphics, xpos, ypos, true);
        }
        int marks = this._marks;
        if (!fmt.marksUseDefault) {
            marks = fmt.marks;
        }
        if (marks != 0) {
            this._drawPoint(graphics, dataset, xpos, ypos, true, pt.selected, pt.highlighted);
        }
        if (this._bars) {
            this._drawBar(graphics, dataset, xpos, ypos, true);
        }
        if (pt.errorBar) {
            this._drawErrorBar(graphics, dataset, xpos, (long)this._lry - (long)((pt.yLowEB - this._yMin) * this._yscale), (long)this._lry - (long)((pt.yHighEB - this._yMin) * this._yscale), true);
        }
        graphics.setColor(this._foreground);
        if (this._pointsPersistence > 0 || this._xPersistence > 0.0) {
            graphics.setPaintMode();
        }
    }

    private void _erasePoint(int dataset, int index) {
        Vector points;
        PlotPoint pt;
        this._checkDatasetIndex(dataset);
        Graphics graphics = this.getGraphics();
        if (this._showing && graphics != null) {
            if (this._pointsPersistence > 0 || this._xPersistence > 0.0) {
                if (this._background == null) {
                    graphics.setXORMode(this.getBackground());
                } else {
                    graphics.setXORMode(this._background);
                }
            }
            if (this._usecolor) {
                Color color = super.getColor(dataset);
                graphics.setColor(color);
            } else {
                graphics.setColor(this._foreground);
            }
            Vector pts = (Vector)this._points.elementAt(dataset);
            pt = (PlotPoint)pts.elementAt(index);
            long ypos = (long)this._lry - (long)((pt.y - this._yMin) * this._yscale);
            long xpos = (long)this._ulx + (long)((pt.x - this._xMin) * this._xscale);
            if (index < pts.size() - 1) {
                PlotPoint nextp = (PlotPoint)pts.elementAt(index + 1);
                int nextx = this._ulx + (int)((nextp.x - this._xMin) * this._xscale);
                int nexty = this._lry - (int)((nextp.y - this._yMin) * this._yscale);
                if (nextp.connected) {
                    this._drawLine(graphics, dataset, nextx, nexty, xpos, ypos, true);
                }
                nextp.connected = false;
            }
            Format fmt = (Format)this._formats.elementAt(dataset);
            if (fmt.impulsesUseDefault) {
                if (this._impulses) {
                    this._drawImpulse(graphics, xpos, ypos, true);
                }
            } else if (fmt.impulses) {
                this._drawImpulse(graphics, xpos, ypos, true);
            }
            int marks = this._marks;
            if (!fmt.marksUseDefault) {
                marks = fmt.marks;
            }
            if (marks != 0) {
                this._drawPoint(graphics, dataset, xpos, ypos, true, pt.selected, pt.highlighted);
            }
            if (this._bars) {
                this._drawBar(graphics, dataset, xpos, ypos, true);
            }
            if (pt.errorBar) {
                this._drawErrorBar(graphics, dataset, xpos, (long)this._lry - (long)((pt.yLowEB - this._yMin) * this._yscale), (long)this._lry - (long)((pt.yHighEB - this._yMin) * this._yscale), true);
            }
            graphics.setColor(this._foreground);
            if (this._pointsPersistence > 0 || this._xPersistence > 0.0) {
                graphics.setPaintMode();
            }
        }
        if ((points = (Vector)this._points.elementAt(dataset)) != null && (pt = (PlotPoint)points.elementAt(index)) != null) {
            if (pt.x == this._xBottom || pt.x == this._xTop || pt.y == this._yBottom || pt.y == this._yTop) {
                this._xyInvalid = true;
            }
            points.removeElementAt(index);
        }
    }

    private void _fillPlot() {
        if (this._xyInvalid) {
            this._xBottom = Double.MAX_VALUE;
            this._xTop = -1.7976931348623157E308;
            this._yBottom = Double.MAX_VALUE;
            this._yTop = -1.7976931348623157E308;
            for (int dataset = 0; dataset < this._points.size(); ++dataset) {
                Vector points = (Vector)this._points.elementAt(dataset);
                for (int index = 0; index < points.size(); ++index) {
                    PlotPoint pt = (PlotPoint)points.elementAt(index);
                    if (pt.x < this._xBottom) {
                        this._xBottom = pt.x;
                    }
                    if (pt.x > this._xTop) {
                        this._xTop = pt.x;
                    }
                    if (pt.y < this._yBottom) {
                        this._yBottom = pt.y;
                    }
                    if (!(pt.y > this._yTop)) continue;
                    this._yTop = pt.y;
                }
            }
        }
        this._xyInvalid = false;
        if (this._bars) {
            if (this._yBottom > 0.0) {
                this._yBottom = 0.0;
            }
            if (this._yTop < 0.0) {
                this._yTop = 0.0;
            }
        }
        super.fillPlot();
    }

    private boolean _isConnected(int dataset) {
        if (dataset < 0) {
            return this._connected;
        }
        this._checkDatasetIndex(dataset);
        Format fmt = (Format)this._formats.elementAt(dataset);
        if (fmt.connectedUseDefault) {
            return this._connected;
        }
        return fmt.connected;
    }

    static {
        _ERRORBAR_LEG_LENGTH = 5;
        _MAX_MARKS = 10;
    }

    private class Format
    implements Serializable {
        public boolean connected;
        public boolean connectedUseDefault = true;
        public boolean impulses;
        public boolean impulsesUseDefault = true;
        public int marks;
        public boolean marksUseDefault = true;

        private Format(Plot this$0) {
        }
    }
}

