/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import ptolemy.plot.PlotBox;

public class Histogram
extends PlotBox {
    protected int _currentdataset = -1;
    protected Vector _points = new Vector();
    protected Vector _histogram = new Vector();
    private double _barwidth = 0.5;
    private double _baroffset = 0.15;
    private double _binWidth = 1.0;
    private double _binOffset = 0.5;
    private String _filename = null;
    private boolean _showing = false;
    private boolean _yIncremented = false;

    public void addLegend(int dataset, String legend) {
        this._checkDatasetIndex(dataset);
        super.addLegend(dataset, legend);
    }

    public void setYIncremented(boolean inc) {
        this._yIncremented = inc;
    }

    public boolean isYIncremented() {
        return this._yIncremented;
    }

    public synchronized void addPoint(final int dataset, final double value) {
        Runnable doAddPoint = new Runnable(){

            public void run() {
                Histogram.this._addPoint(dataset, value);
            }
        };
        this.deferIfNecessary(doAddPoint);
    }

    public synchronized void addPoint(int dataset, double value, boolean isServerSide) {
        if (isServerSide) {
            this._addPoint(dataset, value);
        } else {
            this.addPoint(dataset, value);
        }
    }

    public synchronized void addPoint(int dataset, double x, double y, boolean connected) {
        this.addPoint(dataset, y, false);
    }

    public synchronized void addPoint(int dataset, double x, double y, boolean connected, boolean isServerSide) {
        this.addPoint(dataset, y, isServerSide);
    }

    public synchronized void clear(final boolean format) {
        Runnable doClear = new Runnable(){

            public void run() {
                Histogram.this._clear(format);
            }
        };
        this.deferIfNecessary(doClear);
    }

    public synchronized void clear(boolean format, boolean isServerSide) {
        if (isServerSide) {
            this._clear(format);
        } else {
            this.clear(format);
        }
    }

    public synchronized void fillPlot() {
        Runnable doFill = new Runnable(){

            public void run() {
                Histogram.this._fillPlot();
            }
        };
        this.deferIfNecessary(doFill);
    }

    public synchronized void samplePlot() {
        this.clear(true);
        this.setTitle("Sample histogram");
        this.setXLabel("values");
        this.setYLabel("count");
        Random random = new Random();
        for (int i = 0; i <= 1000; ++i) {
            this.addPoint(0, 5.0 * Math.cos(Math.PI * (double)i / 500.0));
            this.addPoint(1, 10.0 * random.nextDouble() - 5.0);
            this.addPoint(2, 2.0 * random.nextGaussian());
        }
        this.repaint();
    }

    public synchronized void setBars(double width, double offset) {
        this._barwidth = width;
        this._baroffset = offset;
    }

    public synchronized void setBinOffset(double offset) {
        this._binOffset = offset;
    }

    public void setBinWidth(double width) {
        this._binWidth = width;
    }

    public double getBinWidth() {
        return this._binWidth;
    }

    public synchronized void writeData(PrintWriter output) {
        super.writeData(output);
        for (int dataset = 0; dataset < this._points.size(); ++dataset) {
            String legend = this.getLegend(dataset);
            if (legend != null) {
                output.println(String.valueOf(String.valueOf(new StringBuffer("<dataset name=\"").append(legend).append("\">"))));
            } else {
                output.println("<dataset>");
            }
            Vector pts = (Vector)this._points.elementAt(dataset);
            for (int pointnum = 0; pointnum < pts.size(); ++pointnum) {
                Double pt = (Double)pts.elementAt(pointnum);
                output.println(String.valueOf(String.valueOf(new StringBuffer("<p y=\"").append(pt).append("\"/>"))));
            }
            output.println("</dataset>");
        }
    }

    public synchronized void writeFormat(PrintWriter output) {
        super.writeFormat(output);
        output.println(String.valueOf(String.valueOf(new StringBuffer("<barGraph width=\"").append(this._barwidth).append("\" offset=\"").append(this._baroffset).append("\"/>"))));
        output.println(String.valueOf(String.valueOf(new StringBuffer("<bin width=\"").append(this._binWidth).append("\" offset=\"").append(this._binOffset).append("\"/>"))));
    }

    protected void _checkDatasetIndex(int dataset) {
        if (dataset < 0) {
            throw new IllegalArgumentException("Plot._checkDatasetIndex: Cannot give a negative number for the data set index.");
        }
        while (dataset >= this._points.size()) {
            this._points.addElement(new Vector());
            this._histogram.addElement(new Hashtable());
        }
    }

    protected void _drawBar(Graphics graphics, int dataset, long xpos, long ypos, boolean clip) {
        if (clip) {
            if (ypos < (long)this._uly) {
                ypos = this._uly;
            }
            if (ypos > (long)this._lry) {
                ypos = this._lry;
            }
        }
        if (ypos <= (long)this._lry && xpos <= (long)this._lrx && xpos >= (long)this._ulx) {
            long zeroypos;
            int barlx = (int)((double)xpos - this._barwidth * this._binWidth * this._xscale / (double)2 + (double)dataset * this._baroffset * this._binWidth * this._xscale);
            int barrx = (int)((double)barlx + this._barwidth * this._binWidth * this._xscale);
            if (barlx < this._ulx) {
                barlx = this._ulx;
            }
            if (barrx > this._lrx) {
                barrx = this._lrx;
            }
            if (barlx >= barrx) {
                barrx = barlx + 1;
            }
            if ((long)this._lry < (zeroypos = (long)this._lry - (long)((0.0 - this._yMin) * this._yscale))) {
                zeroypos = this._lry;
            }
            if ((long)this._uly > zeroypos) {
                zeroypos = this._uly;
            }
            if (this._yMin >= 0.0 || ypos <= zeroypos) {
                graphics.fillRect(barlx, (int)ypos, barrx - barlx, (int)(zeroypos - ypos));
            } else {
                graphics.fillRect(barlx, (int)zeroypos, barrx - barlx, (int)(ypos - zeroypos));
            }
        }
    }

    protected synchronized void _drawPlot(Graphics graphics, boolean clearfirst) {
        super._drawPlot(graphics, clearfirst);
        this._showing = true;
        for (int dataset = this._points.size() - 1; dataset >= 0; --dataset) {
            Hashtable data = (Hashtable)this._histogram.elementAt(dataset);
            Enumeration keys = data.keys();
            while (keys.hasMoreElements()) {
                Integer bin = (Integer)keys.nextElement();
                Integer count = (Integer)data.get(bin);
                this._drawPlotPoint(graphics, dataset, bin, count);
            }
        }
    }

    protected synchronized void _drawPlot(Graphics graphics, boolean clearfirst, Rectangle rect) {
        super._drawPlot(graphics, clearfirst, rect);
        this._showing = true;
        for (int dataset = this._points.size() - 1; dataset >= 0; --dataset) {
            Hashtable data = (Hashtable)this._histogram.elementAt(dataset);
            Enumeration keys = data.keys();
            while (keys.hasMoreElements()) {
                Integer bin = (Integer)keys.nextElement();
                Integer count = (Integer)data.get(bin);
                this._drawPlotPoint(graphics, dataset, bin, count);
            }
        }
    }

    protected boolean _parseLine(String line) {
        if (super._parseLine(line)) {
            return true;
        }
        String lcLine = new String(line.toLowerCase());
        if (lcLine.startsWith("dataset:")) {
            String legend;
            ++this._currentdataset;
            if (lcLine.length() > 0 && (legend = line.substring(8).trim()) != null && legend.length() > 0) {
                this.addLegend(this._currentdataset, legend);
            }
            return true;
        }
        if (lcLine.startsWith("bars:") || lcLine.startsWith("bargraph:")) {
            String barwidth;
            int comma = line.indexOf(",", 5);
            String baroffset = null;
            if (comma > 0) {
                barwidth = line.substring(5, comma).trim();
                baroffset = line.substring(comma + 1).trim();
            } else {
                barwidth = line.substring(5).trim();
            }
            try {
                Double bwidth = new Double(barwidth);
                double boffset = this._baroffset;
                if (baroffset != null) {
                    boffset = new Double(baroffset);
                }
                this.setBars(bwidth, boffset);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return true;
        }
        if (lcLine.startsWith("binwidth:")) {
            String binwidth = line.substring(9).trim();
            try {
                Double bwidth = new Double(binwidth);
                this.setBinWidth(bwidth);
            }
            catch (NumberFormatException bwidth) {
                // empty catch block
            }
            return true;
        }
        if (lcLine.startsWith("binoffset:")) {
            String binoffset = line.substring(10).trim();
            try {
                Double boffset = new Double(binoffset);
                this.setBinOffset(boffset);
            }
            catch (NumberFormatException boffset) {
                // empty catch block
            }
            return true;
        }
        if (lcLine.startsWith("numsets:")) {
            return true;
        }
        if (line.startsWith("move:")) {
            line = line.substring(5, line.length()).trim();
        } else if (line.startsWith("move")) {
            line = line.substring(4, line.length()).trim();
        } else if (line.startsWith("draw:")) {
            line = line.substring(5, line.length()).trim();
        } else if (line.startsWith("draw")) {
            line = line.substring(4, line.length()).trim();
        }
        line = line.trim();
        int fieldsplit = line.indexOf(",");
        if (fieldsplit == -1) {
            fieldsplit = line.indexOf(" ");
        }
        if (fieldsplit == -1) {
            fieldsplit = line.indexOf("\t");
        }
        if (fieldsplit == -1) {
            try {
                Double xpt = new Double(line);
                this.addPoint(this._currentdataset, xpt);
                boolean baroffset = true;
                return baroffset;
            }
            catch (NumberFormatException xpt) {}
        } else {
            String y = line.substring(fieldsplit + 1).trim();
            try {
                Double ypt = new Double(y);
                this.addPoint(this._currentdataset, ypt);
                boolean bl = true;
                return bl;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private void _addPoint(int dataset, double value) {
        block9: {
            int count;
            this._checkDatasetIndex(dataset);
            if (super.getLegend(dataset) == null) {
                this.addLegend(dataset, "Current");
            }
            int bin = (int)Math.round((value - this._binOffset) / this._binWidth);
            Integer binobj = new Integer(bin);
            Hashtable bins = (Hashtable)this._histogram.elementAt(dataset);
            if (bins.containsKey(binobj)) {
                count = 1 + (Integer)bins.get(binobj);
                bins.put(binobj, new Integer(count));
            } else {
                count = 1;
                bins.put(binobj, new Integer(count));
            }
            double x = (double)bin * this._binWidth + this._binOffset;
            double xtop = x + this._binWidth / 2.0;
            if (x < this._xBottom) {
                this._xBottom = x;
            }
            if (xtop > this._xTop) {
                this._xTop = xtop;
            }
            if (this._ylog) {
                double cnt = Math.log(count) * PlotBox._LOG10SCALE;
                if (cnt > this._yTop) {
                    this._yTop = cnt;
                }
            } else if ((double)count > this._yTop) {
                this._yTop = count;
            }
            this._yBottom = 0.0;
            Vector pts = (Vector)this._points.elementAt(dataset);
            pts.addElement(new Double(value));
            Graphics graphics = this.getGraphics();
            if (!this._showing || graphics == null) break block9;
            int pendingDataset = dataset;
            int pendingBin = bin;
            int pendingCount = count;
            this._drawPlotPoint(graphics, pendingDataset, pendingBin, pendingCount);
        }
    }

    private void _clear(boolean format) {
        super.clear(format);
        this._currentdataset = -1;
        this._points = new Vector();
        this._histogram = new Vector();
        this._filename = null;
        this._showing = false;
        if (format) {
            this._barwidth = 0.5;
            this._baroffset = 0.15;
            this._binWidth = 1.0;
            this._binOffset = 0.5;
        }
    }

    private void _drawPlotPoint(Graphics graphics, int dataset, int bin, int count) {
        if (this._usecolor) {
            Color color = super.getColor(dataset);
            graphics.setColor(color);
        } else {
            graphics.setColor(this._foreground);
        }
        double y = count;
        double x = this._binWidth * (double)bin + this._binOffset;
        if (this._xlog) {
            if (x <= 0.0) {
                System.err.println("Can't plot non-positive X values when the logarithmic X axis value is specified: ".concat(String.valueOf(String.valueOf(x))));
                return;
            }
            x = Math.log(x) * PlotBox._LOG10SCALE;
        }
        if (this._ylog) {
            if (this._yIncremented) {
                y += 1.0;
            }
            if (y <= 0.0) {
                System.err.println("Can't plot non-positive Y values when the logarithmic Y axis value is specified: ".concat(String.valueOf(String.valueOf(y))));
                return;
            }
            y = Math.log(y) * PlotBox._LOG10SCALE;
        }
        long ypos = (long)this._lry - (long)((y - this._yMin) * this._yscale);
        long xpos = (long)this._ulx + (long)((x - this._xMin) * this._xscale);
        this._drawBar(graphics, dataset, xpos, ypos, true);
        graphics.setColor(this._foreground);
    }

    private void _fillPlot() {
        super.fillPlot();
        if (this._xBottom >= this._originalXlow) {
            this._xBottom -= this.getBinWidth() / (double)2;
        }
        super.fillPlot();
    }
}

