/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import com.jvt.exprparser.Expression_Parser;
import com.jvt.exprparser.SimpleNode;
import com.jvt.votable.PlotColumn;
import com.jvt.votable.PlotData;
import com.jvt.votable.PlotFilter;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;

public class ColumnExprParser {
    private PlotData _plotdata = null;
    private StringBuffer _suffix = new StringBuffer();
    private ArrayList _colNumExpr = new ArrayList();
    private int _errorCode = 0;
    private String _colNumStr = "";
    private static final int MAX_COL_DIGITS = 3;
    private static final char COL_PREFIX_CHAR = '$';

    public ColumnExprParser(PlotData plotdata) {
        this._plotdata = plotdata;
    }

    private boolean parseExpression(String expr) {
        int startIndex = 0;
        int endIndex = 0;
        StringBuffer strbuf = new StringBuffer();
        for (int i = 0; i < expr.length(); ++i) {
            if (expr.charAt(i) != '$') continue;
            int j = 0;
            if (i + 1 >= expr.length() || !Character.isDigit(expr.charAt(i + 1))) {
                this._errorCode = 4;
                this._colNumStr = "".concat(String.valueOf(String.valueOf(expr.charAt(i + 1))));
                return false;
            }
            endIndex = i;
            char[] c = new char[3];
            while (i + 1 < expr.length() && Character.isDigit(expr.charAt(i + 1)) && j < 3) {
                c[j] = expr.charAt(i + 1);
                ++j;
                ++i;
            }
            int colNum = 0;
            String colNumStr = new String(c, 0, j);
            try {
                colNum = Integer.parseInt(colNumStr);
                if (--colNum < 0 || colNum >= this._plotdata.getNumOfPlotColumns()) {
                    this._errorCode = 4;
                    this._colNumStr = "".concat(String.valueOf(String.valueOf(colNum)));
                    boolean bl = false;
                    return bl;
                }
            }
            catch (NumberFormatException ex) {
                System.err.println(ex.getMessage());
                this._errorCode = 4;
                this._colNumStr = colNumStr;
                boolean bl = false;
                return bl;
            }
            String exprBeforeCol = expr.substring(startIndex, endIndex);
            ColNumExpr cne = new ColNumExpr(this, colNum, exprBeforeCol);
            this._colNumExpr.add(cne);
            if (i >= expr.length()) continue;
            endIndex = startIndex = i + 1;
        }
        String exprSuffix = "";
        if (startIndex >= 0 && startIndex <= expr.length()) {
            exprSuffix = expr.substring(startIndex);
        }
        this._suffix.append(exprSuffix);
        return true;
    }

    private String substituteData(int irow) {
        StringBuffer strbuf = new StringBuffer();
        boolean nulldata = false;
        Double data = null;
        for (int i = 0; i < this._colNumExpr.size(); ++i) {
            ColNumExpr c = (ColNumExpr)this._colNumExpr.get(i);
            strbuf.append(c.getExpr());
            PlotColumn pc = this._plotdata.getPlotColumn(c.getColNum());
            data = pc.getData(irow);
            if (data == null) {
                return null;
            }
            strbuf.append(data);
        }
        strbuf.append((Object)this._suffix);
        String exprWithValues = strbuf.toString();
        return exprWithValues;
    }

    private boolean evaluateExpression(PlotColumn newPC) {
        int numOfRows = this._plotdata.getNumOfRows();
        boolean exprChecked = false;
        for (int irow = 0; irow < numOfRows; ++irow) {
            String exprWithValues = this.substituteData(irow);
            if (exprWithValues == null) {
                newPC.addData(null);
                continue;
            }
            try {
                ByteArrayInputStream stream = new ByteArrayInputStream(exprWithValues.getBytes());
                Expression_Parser parser = new Expression_Parser(stream);
                SimpleNode root = parser.parseExpression();
                Object result = root.eval();
                String resultStr = result.toString();
                Double d = new Double(resultStr);
                newPC.addData(d);
                exprChecked = true;
                continue;
            }
            catch (Exception e) {
                System.out.println("Exception while evaluation of ".concat(String.valueOf(String.valueOf(exprWithValues))));
                System.err.println(e.getMessage());
                if (!exprChecked) {
                    this._errorCode = 5;
                    boolean bl = false;
                    return bl;
                }
                newPC.addData(null);
                continue;
            }
            catch (Error err) {
                System.err.println(err.getMessage());
                if (!exprChecked) {
                    this._errorCode = 5;
                    boolean bl = false;
                    return bl;
                }
                newPC.addData(null);
            }
        }
        return true;
    }

    private boolean evaluateExpression(PlotFilter newPF) {
        Object data = null;
        int numOfRows = this._plotdata.getNumOfRows();
        boolean exprChecked = false;
        for (int irow = 0; irow < numOfRows; ++irow) {
            String exprWithValues = this.substituteData(irow);
            if (exprWithValues == null) {
                newPF.addData(new Boolean(false));
                continue;
            }
            try {
                ByteArrayInputStream stream = new ByteArrayInputStream(exprWithValues.getBytes());
                Expression_Parser parser = new Expression_Parser(stream);
                SimpleNode root = parser.parseExpression();
                Boolean result = (Boolean)root.eval();
                newPF.addData(result);
                exprChecked = true;
                continue;
            }
            catch (Exception e) {
                System.out.println("Exception while evaluation of ".concat(String.valueOf(String.valueOf(exprWithValues))));
                System.out.println(e.getMessage());
                if (!exprChecked) {
                    this._errorCode = 5;
                    boolean bl = false;
                    return bl;
                }
                newPF.addData(new Boolean(false));
                continue;
            }
            catch (Error err) {
                System.out.println(err.getMessage());
                if (!exprChecked) {
                    this._errorCode = 5;
                    boolean bl = false;
                    return bl;
                }
                newPF.addData(new Boolean(false));
            }
        }
        return true;
    }

    public boolean parseAndEvaluate(String expr, PlotColumn newPC) {
        if (!this.parseExpression(expr)) {
            return false;
        }
        return this.evaluateExpression(newPC);
    }

    public boolean parseAndEvaluate(String expr, PlotFilter newPF) {
        if (!this.parseExpression(expr)) {
            return false;
        }
        return this.evaluateExpression(newPF);
    }

    public int getErrorCode() {
        return this._errorCode;
    }

    public String getColumnNumber() {
        return this._colNumStr;
    }

    static {
        MAX_COL_DIGITS = 3;
        COL_PREFIX_CHAR = (char)36;
    }

    class ColNumExpr {
        private String _expr;
        private int _colNum;

        public ColNumExpr(ColumnExprParser this$0) {
            this._expr = null;
            this._colNum = 0;
        }

        public ColNumExpr(ColumnExprParser this$0, int colNum, String expression) {
            this._expr = expression;
            this._colNum = colNum;
        }

        public void setExpr(String expression) {
            this._expr = expression;
        }

        public void setColNum(int colNum) {
            this._colNum = colNum;
        }

        public String getExpr() {
            return this._expr;
        }

        public int getColNum() {
            return this._colNum;
        }
    }
}

