/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import cern.colt.list.DoubleArrayList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;
import ptolemy.plot.PlotStatisticsDialog;

public class BoxPlot
extends JDialog {
    private JPanel _mainPanel = new JPanel();
    private BorderLayout _borderLayout1 = new BorderLayout();
    private PlotStatisticsDialog _parent;
    private Plot _plot = new Plot();
    private JPanel _buttonsPanel = new JPanel();
    private JButton _closeButton = new JButton();
    private JButton _rescaleButton = new JButton();
    private DoubleArrayList _boxPlotValuesList;
    private static Color _BoxPlotColor = Color.blue;
    private static int _BoxPlotHalfWidth = 10;
    private static int _BoxPlotBufferWidth = 5;
    private static int[] _markerStyles;
    private static Color[] _colors;
    private static String _plotInfo;

    public BoxPlot(PlotStatisticsDialog parent, DoubleArrayList boxPlotValuesList, String plotInfo) {
        super((Frame)null, "Box Plot", true);
        this._parent = parent;
        this._boxPlotValuesList = boxPlotValuesList;
        _plotInfo = plotInfo;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            System.out.println("Error displaying Boxplot.");
        }
    }

    private void backUpColorAndMarkerStyles() {
        _markerStyles = new int[PlotBox._markerStyles.length];
        System.arraycopy(PlotBox._markerStyles, 0, _markerStyles, 0, PlotBox._markerStyles.length);
        _colors = new Color[PlotBox._colors.length];
        System.arraycopy(PlotBox._colors, 0, _colors, 0, PlotBox._colors.length);
    }

    private void restoreColorAndMarkerStyles() {
        System.arraycopy(_markerStyles, 0, PlotBox._markerStyles, 0, PlotBox._markerStyles.length);
        System.arraycopy(_colors, 0, PlotBox._colors, 0, PlotBox._colors.length);
    }

    private void jbInit() throws Exception {
        this.backUpColorAndMarkerStyles();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ((Component)BoxPlot.this).setVisible(false);
                BoxPlot.this.restoreColorAndMarkerStyles();
                BoxPlot.this.dispose();
            }
        });
        this._mainPanel.setLayout(this._borderLayout1);
        this._buttonsPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this._closeButton.setToolTipText("Close this dialog");
        this._closeButton.setText("Close");
        this._closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BoxPlot.this._closeButton_actionPerformed(e);
            }
        });
        this._rescaleButton.setText("Rescale");
        this._rescaleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BoxPlot.this._rescaleButton_actionPerformed(e);
            }
        });
        this._mainPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.getContentPane().add((Component)this._mainPanel, "Center");
        this._mainPanel.add((Component)this._buttonsPanel, "South");
        this._mainPanel.add((Component)this._plot, "Center");
        this._buttonsPanel.add((Component)this._closeButton, null);
        this._buttonsPanel.add((Component)this._rescaleButton, null);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setSize(screenSize.width / 3, screenSize.height / 2);
        ((Component)this).setLocation(screenSize.width / 2 - this.getSize().width / 2, screenSize.height / 2 - this.getSize().height / 2);
        this._drawPlot();
    }

    private void _drawPlot() {
        double quantile_25 = 0.0;
        double quantile_50 = 0.0;
        double quantile_75 = 0.0;
        double min = 0.0;
        double max = 0.0;
        try {
            quantile_25 = this._boxPlotValuesList.getQuick(0);
            quantile_50 = this._boxPlotValuesList.getQuick(1);
            quantile_75 = this._boxPlotValuesList.getQuick(2);
            min = this._boxPlotValuesList.getQuick(3);
            max = this._boxPlotValuesList.getQuick(4);
        }
        catch (Exception ex) {
            this._plot.setTitle(String.valueOf(String.valueOf(this._parent.getSelXCol())).concat(" (No Data)"));
            return;
        }
        this._plot.setMarksStyle("various", 0);
        this._plot.addLegend(0, "Maximum");
        this._plot.addPoint(0, 0.0, max, "", false);
        this._plot.setMarkerStyle(0, 8);
        this._plot.setColor(0, _BoxPlotColor);
        this._plot.setMarksStyle("various", 1);
        this._plot.addLegend(1, "25% - 75%");
        this._plot.setMarkerStyle(1, 1);
        this._plot.setColor(1, _BoxPlotColor);
        this._plot.addPoint(1, 0.0, quantile_75, "", false);
        this._plot.addPoint(1, 0.0, quantile_25, "", false);
        this._plot.setMarksStyle("various", 2);
        this._plot.addLegend(2, "Median");
        this._plot.setMarkerStyle(2, 7);
        this._plot.setColor(2, _BoxPlotColor);
        this._plot.addPoint(2, 0.0, quantile_50, "", false);
        this._plot.setMarksStyle("various", 3);
        this._plot.addLegend(3, "Minimum");
        this._plot.setMarkerStyle(3, 5);
        this._plot.setColor(3, _BoxPlotColor);
        this._plot.addPoint(3, 0.0, min, "", false);
        this._plot.setConnected(true);
        this._plot.setConnected(true, 4);
        this._plot.addPoint(4, 0.0, max, "", true);
        this._plot.addPoint(4, 0.0, quantile_75, "", true);
        this._plot.addPoint(4, -_BoxPlotHalfWidth, quantile_75, "", true);
        this._plot.setMarksStyle("none", 4);
        this._plot.addPoint(4, -_BoxPlotHalfWidth, quantile_75, "", true);
        this._plot.addPoint(4, -_BoxPlotHalfWidth, quantile_25, "", true);
        this._plot.addPoint(4, 0.0, quantile_25, "", true);
        this._plot.addPoint(4, 0.0, min, "", true);
        this._plot.addPoint(4, 0.0, quantile_25, "", true);
        this._plot.addPoint(4, _BoxPlotHalfWidth, quantile_25, "", true);
        this._plot.addPoint(4, _BoxPlotHalfWidth, quantile_75, "", true);
        this._plot.addPoint(4, 0.0, quantile_75, "", true);
        this._plot.addPoint(4, 0.0, max, "", true);
        this._plot.setColor(4, _BoxPlotColor);
        this._plot.addPoint(5, -(_BoxPlotHalfWidth + _BoxPlotBufferWidth), max, "", false);
        this._plot.addPoint(5, _BoxPlotHalfWidth + _BoxPlotBufferWidth, min, "", false);
        this._plot.setMarksStyle("none", 5);
        this._plot.setTitle(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this._parent.getSelXCol()))).append("(").append(_plotInfo).append(")"))));
        this._plot.addXTick("", -_BoxPlotHalfWidth);
        this._plot.addXTick("", 0.0);
        this._plot.addXTick("", _BoxPlotHalfWidth);
        this._plot.repaint();
    }

    void _closeButton_actionPerformed(ActionEvent e) {
        ((Component)this).setVisible(false);
        this.restoreColorAndMarkerStyles();
        this.dispose();
    }

    void _rescaleButton_actionPerformed(ActionEvent e) {
        this._plot.fillPlot();
    }
}

