/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import ptolemy.plot.Plot;

class AdvancedPlotFormatter
extends JPanel {
    private Plot _plot = null;
    private JPanel _centerPanel = new JPanel();
    private GridLayout _gridLayout1 = new GridLayout();
    private JLabel _datasetLabel = new JLabel();
    private JLabel _markerStyleLabel = new JLabel();
    private JLabel _colorLabel = new JLabel();
    private JComboBox _datasetsComboBox = new JComboBox();
    private JComboBox _markerStylesComboBox = new JComboBox();
    private JButton _colorChooserButton = new JButton();
    private BorderLayout _borderLayout1 = new BorderLayout();
    private static final String[] _markerStyles = new String[]{"filled circle", "cross", "square", "filled triangle", "diamond", "circle", "plus sign", "filled square", "triangle", "filled diamond"};
    private Vector _legendColors;
    private Vector _legendStyles;
    private int currentDatasetIndex = 0;

    public AdvancedPlotFormatter(Plot plot) {
        this._plot = plot;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this._legendColors = (Vector)this._plot.getLegendColors().clone();
        this._legendStyles = (Vector)this._plot.getLegendDatasets().clone();
        this.setLayout(this._borderLayout1);
        this._centerPanel.setLayout(this._gridLayout1);
        this._gridLayout1.setColumns(2);
        this._gridLayout1.setHgap(50);
        this._gridLayout1.setRows(3);
        this._gridLayout1.setVgap(40);
        this._datasetLabel.setText("    Dataset");
        this._markerStyleLabel.setText("    Marker Style");
        this._colorLabel.setText("    Color");
        this._datasetsComboBox.setToolTipText("Select Dataset");
        this._datasetsComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedPlotFormatter.this._datasetsComboBox_actionPerformed(e);
            }
        });
        this._markerStylesComboBox.setToolTipText("Select Marker style");
        this._colorChooserButton.setToolTipText("Select Color");
        this._colorChooserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedPlotFormatter.this._colorChooserButton_actionPerformed(e);
            }
        });
        this.initializeDatasetsComboBox();
        this.initializeMarkerStylesComboBox();
        this.setMaximumSize(new Dimension(292, 143));
        this.setPreferredSize(new Dimension(292, 143));
        this.add((Component)this._centerPanel, "Center");
        this._centerPanel.add((Component)this._datasetLabel, null);
        this._centerPanel.add((Component)this._datasetsComboBox, null);
        this._centerPanel.add((Component)this._markerStyleLabel, null);
        this._centerPanel.add((Component)this._markerStylesComboBox, null);
        this._centerPanel.add((Component)this._colorLabel, null);
        this._centerPanel.add((Component)this._colorChooserButton, null);
        this._markerStylesComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedPlotFormatter.this._markerStylesComboBox_actionPerformed(e);
            }
        });
        this.refresh();
    }

    public void initializeDatasetsComboBox() {
        Enumeration enum1 = this._plot.getLegendStrings().elements();
        boolean first = true;
        int i = 0;
        while (enum1.hasMoreElements()) {
            String element = (String)enum1.nextElement();
            this._datasetsComboBox.insertItemAt(element, i);
            if (first) {
                this._datasetsComboBox.setSelectedItem(element);
                first = false;
            }
            ++i;
        }
    }

    public void initializeMarkerStylesComboBox() {
        if (this._plot.getMarksStyle().equals("various")) {
            for (int i = 0; i < _markerStyles.length; ++i) {
                String style = _markerStyles[i];
                this._markerStylesComboBox.insertItemAt(style, i);
            }
            int markerStyleIndex = (Integer)this._plot.getLegendStyles().elementAt(this.currentDatasetIndex);
            this._markerStylesComboBox.setSelectedItem(_markerStyles[markerStyleIndex]);
        } else {
            this._markerStylesComboBox.removeAllItems();
            String element = this._plot.getMarksStyle();
            this._markerStylesComboBox.insertItemAt(element, 0);
            this._markerStylesComboBox.setSelectedItem(element);
        }
    }

    public void refresh() {
        this.currentDatasetIndex = this._datasetsComboBox.getSelectedIndex();
        if (this._plot.getMarksStyle().equals("various")) {
            int markerStyleIndex = (Integer)this._plot.getLegendStyles().elementAt(this.currentDatasetIndex);
            this._markerStylesComboBox.setSelectedItem(_markerStyles[markerStyleIndex]);
        }
        if (this._plot.getColor()) {
            Color color = (Color)this._plot.getLegendColors().elementAt(this.currentDatasetIndex);
            this._colorChooserButton.setBackground(color);
        } else {
            Color color = Color.black;
            this._colorChooserButton.setBackground(color);
        }
    }

    void _datasetsComboBox_actionPerformed(ActionEvent e) {
        this.refresh();
    }

    void _markerStylesComboBox_actionPerformed(ActionEvent e) {
        int markerStyleIndex = this._markerStylesComboBox.getSelectedIndex();
        this._plot.setMarkerStyle(this.currentDatasetIndex, markerStyleIndex);
        this._plot.repaint();
    }

    void _colorChooserButton_actionPerformed(ActionEvent e) {
        if (this._plot.getColor()) {
            JColorChooser jc = new JColorChooser(this._colorChooserButton.getBackground());
            Color color = JColorChooser.showDialog(this, "Select dataset color", this._colorChooserButton.getBackground());
            if (color != null) {
                this._colorChooserButton.setBackground(color);
                this._plot.setColor(this.currentDatasetIndex, color);
                this._plot.repaint();
            }
        } else {
            JOptionPane.showMessageDialog(this, "'Use Color' not Enabled !");
        }
    }

    void _cancelButton_actionPerformed(ActionEvent e) {
        this.cancel();
    }

    public void cancel() {
        int i;
        this._plot.setLegendColors(this._legendColors);
        for (i = 0; i < this._legendColors.size(); ++i) {
            this._plot.setColor(i, (Color)this._legendColors.elementAt(i));
        }
        this._plot.setLegendStyles(this._legendStyles);
        for (i = 0; i < this._legendStyles.size(); ++i) {
            this._plot.setMarkerStyle(i, (Integer)this._legendStyles.elementAt(i));
        }
        this._plot.repaint();
    }

    public String toString() {
        return "AdvancedPlotFormatter";
    }
}

