/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import ptolemy.plot.PlotBox;

class AdvancedHistogramFormatter
extends JPanel {
    private PlotBox _plot = null;
    private JPanel _centerPanel = new JPanel();
    private GridLayout _gridLayout1 = new GridLayout();
    private JLabel _datasetLabel = new JLabel();
    private JLabel _colorLabel = new JLabel();
    private JComboBox _datasetsComboBox = new JComboBox();
    private JButton _colorChooserButton = new JButton();
    private BorderLayout _borderLayout1 = new BorderLayout();
    private Vector _legendColors;
    private Vector _legendStyles;
    private int _currentDatasetIndex = 0;

    public AdvancedHistogramFormatter(PlotBox plot) {
        this._plot = plot;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this._legendColors = (Vector)this._plot.getLegendColors().clone();
        this.setLayout(this._borderLayout1);
        this._centerPanel.setMaximumSize(new Dimension(292, 100));
        this._centerPanel.setMinimumSize(new Dimension(292, 100));
        this._centerPanel.setPreferredSize(new Dimension(292, 100));
        this._centerPanel.setLayout(this._gridLayout1);
        this._gridLayout1.setColumns(2);
        this._gridLayout1.setHgap(30);
        this._gridLayout1.setRows(2);
        this._gridLayout1.setVgap(50);
        this._datasetLabel.setText("           Dataset");
        this._colorLabel.setText("           Color");
        this._datasetsComboBox.setToolTipText("Select Dataset");
        this._datasetsComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedHistogramFormatter.this._datasetsComboBox_actionPerformed(e);
            }
        });
        this._colorChooserButton.setToolTipText("Select Color");
        this._colorChooserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedHistogramFormatter.this._colorChooserButton_actionPerformed(e);
            }
        });
        this._initializeDatasetsComboBox();
        this.setMaximumSize(new Dimension(292, 100));
        this.setMinimumSize(new Dimension(292, 100));
        this.setPreferredSize(new Dimension(292, 100));
        this.add((Component)this._centerPanel, "Center");
        this._centerPanel.add((Component)this._datasetLabel, null);
        this._centerPanel.add((Component)this._datasetsComboBox, null);
        this._centerPanel.add((Component)this._colorLabel, null);
        this._centerPanel.add((Component)this._colorChooserButton, null);
        this.refresh();
    }

    private void _initializeDatasetsComboBox() {
        Enumeration enum1 = this._plot.getLegendStrings().elements();
        boolean first = true;
        int i = 0;
        while (enum1.hasMoreElements()) {
            String element = (String)enum1.nextElement();
            this._datasetsComboBox.insertItemAt(element, i);
            if (first) {
                this._datasetsComboBox.setSelectedItem(element);
                first = false;
            }
            ++i;
        }
    }

    public void refresh() {
        this._currentDatasetIndex = this._datasetsComboBox.getSelectedIndex();
        if (this._plot.getColor()) {
            Color color = (Color)this._plot.getLegendColors().elementAt(this._currentDatasetIndex);
            this._colorChooserButton.setBackground(color);
        } else {
            Color color = Color.black;
            this._colorChooserButton.setBackground(color);
        }
    }

    void _datasetsComboBox_actionPerformed(ActionEvent e) {
        this.refresh();
    }

    void _colorChooserButton_actionPerformed(ActionEvent e) {
        if (this._plot.getColor()) {
            JColorChooser jc = new JColorChooser(this._colorChooserButton.getBackground());
            Color color = JColorChooser.showDialog(this, "Select dataset color", this._colorChooserButton.getBackground());
            if (color != null) {
                this._colorChooserButton.setBackground(color);
                this._plot.setColor(this._currentDatasetIndex, color);
                this._plot.repaint();
            }
        } else {
            JOptionPane.showMessageDialog(this, "'Use Color' not Enabled !");
        }
    }

    public void cancel() {
        this._plot.setLegendColors(this._legendColors);
        for (int i = 0; i < this._legendColors.size(); ++i) {
            this._plot.setColor(i, (Color)this._legendColors.elementAt(i));
        }
        this._plot.repaint();
    }

    public String toString() {
        return "AdvancedHistogramFormatter";
    }
}

