/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.gui;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.LinkedList;

public class GUIStringUtilities {
    private GUIStringUtilities() {
    }

    public static String abbreviate(String longName) {
        if (longName == null) {
            return "<Unnamed>";
        }
        if (longName.length() < 80) {
            return longName;
        }
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(longName.substring(0, 37)))).append(". . .").append(longName.substring(longName.length() - 38))));
    }

    public static String split(String longName) {
        int i;
        if (longName == null) {
            return "<Unnamed>";
        }
        if (longName.length() < 80) {
            return longName;
        }
        StringBuffer results = new StringBuffer();
        for (i = 0; i < longName.length() - 80; i += 80) {
            results.append(String.valueOf(String.valueOf(longName.substring(i, i + 79))).concat("\n"));
        }
        results.append(longName.substring(i));
        return results.toString();
    }

    public static String[] tokenizeForExec(String inputString) throws IOException {
        LinkedList<String> commandList = new LinkedList<String>();
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(inputString));
        streamTokenizer.resetSyntax();
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.wordChars(33, 127);
        streamTokenizer.ordinaryChar(34);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.commentChar(35);
        String token = "";
        String singleToken = "";
        boolean inDoubleQuotedString = false;
        block6: while (streamTokenizer.nextToken() != -1) {
            switch (streamTokenizer.ttype) {
                case -3: {
                    if (inDoubleQuotedString) {
                        if (token.length() > 0) {
                            token = String.valueOf(String.valueOf(token)).concat(" ");
                        }
                        token = String.valueOf(String.valueOf(token)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(singleToken)).concat(String.valueOf(String.valueOf(streamTokenizer.sval))))));
                    } else {
                        token = String.valueOf(String.valueOf(singleToken)).concat(String.valueOf(String.valueOf(streamTokenizer.sval)));
                        commandList.add(token);
                    }
                    singleToken = "";
                    continue block6;
                }
                case -2: {
                    throw new RuntimeException(String.valueOf(String.valueOf(new StringBuffer("Internal error: Found TT_NUMBER: '").append(streamTokenizer.nval).append("'.  We should not be ").append("tokenizing numbers"))));
                }
                case 10: {
                    continue block6;
                }
                case -1: {
                    continue block6;
                }
            }
            singleToken = new Character((char)streamTokenizer.ttype).toString();
            if (!singleToken.equals("\"")) continue;
            if (inDoubleQuotedString) {
                commandList.add(token);
            }
            inDoubleQuotedString = !inDoubleQuotedString;
            singleToken = "";
            token = "";
        }
        return commandList.toArray(new String[commandList.size()]);
    }
}

