/*
 * Decompiled with CFR 0.152.
 */
package com.jvt.votable;

import com.jvt.applets.PlotVOApplet;
import com.jvt.utils.JVTUtil;
import com.jvt.utils.RA_DEC_Converter;
import com.jvt.votable.DataDisplayColumn;
import com.jvt.votable.PlotColumn;
import com.jvt.votable.PlotData;
import com.jvt.votable.PlotFilter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import vowrite.VOTable;
import vowrite.VOTableField;
import vowrite.VOTableResource;
import vowrite.VOTableStreamWriter;
import vowrite.VOTableTable;

public class VOTableWriter {
    private VOTable _votable = null;
    private VOTableResource _votableResource = null;
    private VOTableTable _votableTable = null;
    private PlotData _plotData = null;
    VOTableStreamWriter _vos = null;
    private PlotVOApplet _pva = null;
    private int _noOfRows = -1;
    int _truncateFlag = 0;

    public VOTableWriter(PlotVOApplet pva) {
        this._votable = pva.getVOTable();
        this._votableResource = pva.getResource();
        this._votableTable = pva.getTable().returnClone();
        this._plotData = pva.getPlotData();
        this._pva = pva;
        this._noOfRows = -1;
    }

    public VOTableWriter(PlotVOApplet pva, int noOfRows) {
        this._votable = pva.getVOTable();
        this._votableResource = pva.getResource();
        if (pva.getTable() != null) {
            this._votableTable = pva.getTable().returnClone();
        }
        this._plotData = pva.getPlotData();
        this._pva = pva;
        this._noOfRows = noOfRows;
    }

    public void getDataInVOTableFormat(OutputStream out) {
        PrintStream _prnStream = new PrintStream(out);
        this._vos = new VOTableStreamWriter(_prnStream);
        this.writeMetaData(null);
        if (this._truncateFlag == 1) {
            String s = new String(String.valueOf(String.valueOf(new StringBuffer("<!--Result truncated to ").append(this._noOfRows).append(" rows -->"))));
            _prnStream.print(s);
        }
    }

    public void getSelectedDataInVOTableFormat(OutputStream out, ArrayList selectedIndices) {
        PrintStream _prnStream = new PrintStream(out);
        this._vos = new VOTableStreamWriter(_prnStream);
        this.writeMetaData(selectedIndices);
        if (this._truncateFlag == 1) {
            String s = new String(String.valueOf(String.valueOf(new StringBuffer("<!--Result truncated to ").append(this._noOfRows).append(" rows -->"))));
            _prnStream.print(s);
        }
    }

    public void writeMetaData(ArrayList selectedIndices) {
        try {
            if (this._votable != null) {
                this._vos.writeVOTable(this._votable);
            }
            if (this._votableResource != null) {
                this._vos.writeResource(this._votableResource);
            }
            if (this._votableTable != null && this._plotData != null) {
                this.constructFields();
                this._vos.writeTable(this._votableTable);
            }
            if (this._plotData != null) {
                this.writeData(selectedIndices);
            }
            if (this._votableTable != null) {
                this._vos.endTable();
            }
            if (this._votableResource != null) {
                this._vos.endResource();
            }
            if (this._votable != null) {
                this._vos.endVOTable();
            }
        }
        catch (Error e) {
            System.out.println("out of memory error");
        }
    }

    public void constructFields() {
        int i;
        int noOfColumns = this._plotData.getNumOfPlotColumns();
        for (i = 0; i < noOfColumns; ++i) {
            VOTableField voField;
            PlotColumn pc = this._plotData.getPlotColumn(i);
            String ucd = pc.getUCD();
            if (pc == null) continue;
            if (pc.isUserCreated()) {
                voField = new VOTableField();
                voField.setDataType(pc.getDatatype());
                voField.setName(pc.getName());
                voField.setUnit(pc.getUnit());
                voField.setUcd(pc.getUCD());
                this._votableTable.addField(voField);
                continue;
            }
            this._votableTable.addField(pc.getVOField());
            if ((!"POS_EQ_RA_MAIN".equals(pc.getUCD()) || "deg".equals(pc.getUnit())) && (!"POS_EQ_DEC_MAIN".equals(pc.getUCD()) || "deg".equals(pc.getUnit()))) continue;
            voField = this._votableTable.getField(this._votableTable.getNumOfField() - 1);
            voField.setDataType("char");
        }
        noOfColumns = this._plotData.getNumOfDataDisplayColumns();
        for (i = 0; i < noOfColumns; ++i) {
            DataDisplayColumn ddc = this._plotData.getDataDisplayColumn(i);
            if (ddc == null) continue;
            this._votableTable.addField(ddc.getVOField());
        }
        noOfColumns = this._plotData.getNumOfFilters();
        for (i = 0; i < noOfColumns; ++i) {
            VOTableField voField = new VOTableField();
            PlotFilter pf = this._plotData.getPlotFilter(i);
            if (pf == null) continue;
            voField.setDataType(pf.getDatatype());
            voField.setName(pf.getName());
            voField.setUnit(pf.getUnit());
            voField.setUcd(pf.getUCD());
            this._votableTable.addField(voField);
        }
    }

    public void writeData(ArrayList selectedIndices) {
        int noOfRows = this._plotData.getNumOfRows();
        int noOfPlotColumns = this._plotData.getNumOfPlotColumns();
        int noOfDataDisplayColumns = this._plotData.getNumOfDataDisplayColumns();
        int noOfFilters = this._plotData.getNumOfFilters();
        int totalNoOfColumns = noOfPlotColumns + noOfDataDisplayColumns + noOfFilters;
        if (selectedIndices == null) {
            if (this._noOfRows != -1 && this._noOfRows < noOfRows) {
                noOfRows = this._noOfRows;
                this._truncateFlag = 1;
            }
            for (int i = 0; i < noOfRows; ++i) {
                int j;
                String[] data = new String[totalNoOfColumns];
                int k = 0;
                for (j = 0; j < noOfPlotColumns; ++j) {
                    PlotColumn pCol = this._plotData.getPlotColumn(j);
                    if (pCol == null) continue;
                    if (pCol.getData(i) == null) {
                        data[k++] = "";
                        continue;
                    }
                    int datatype = pCol.getDatatypeIntegerFormat();
                    Double d = pCol.getData(i);
                    data[k++] = "POS_EQ_RA_MAIN".equals(pCol.getUCD()) && !"deg".equals(pCol.getUnit()) ? RA_DEC_Converter.convert(d, true) : ("POS_EQ_DEC_MAIN".equals(pCol.getUCD()) && !"deg".equals(pCol.getUnit()) ? RA_DEC_Converter.convert(d, false) : JVTUtil.getInOriginalFormat(d, datatype));
                }
                for (j = 0; j < noOfDataDisplayColumns; ++j) {
                    DataDisplayColumn disCol = this._plotData.getDataDisplayColumn(j);
                    if (disCol == null) continue;
                    data[k++] = disCol.getData(i) == null ? "" : disCol.getData(i);
                }
                for (j = 0; j < noOfFilters; ++j) {
                    PlotFilter pf = this._plotData.getPlotFilter(j);
                    if (pf == null) continue;
                    data[k++] = pf.getData(i) ? "1" : "0";
                }
                this._vos.addRow(data, totalNoOfColumns);
            }
        } else {
            int totalRows = selectedIndices.size();
            if (this._noOfRows != -1 && this._noOfRows < totalRows) {
                totalRows = this._noOfRows;
                this._truncateFlag = 1;
            }
            for (int i = 0; i < totalRows; ++i) {
                int j;
                int rowNum = (Integer)selectedIndices.get(i);
                String[] data = new String[totalNoOfColumns];
                int k = 0;
                for (j = 0; j < noOfPlotColumns; ++j) {
                    PlotColumn pCol = this._plotData.getPlotColumn(j);
                    if (pCol == null) continue;
                    if (pCol.getData(rowNum) == null) {
                        data[k++] = "";
                        continue;
                    }
                    int datatype = pCol.getDatatypeIntegerFormat();
                    Double d = pCol.getData(rowNum);
                    data[k++] = "POS_EQ_RA_MAIN".equals(pCol.getUCD()) ? RA_DEC_Converter.convert(d, true) : ("POS_EQ_DEC_MAIN".equals(pCol.getUCD()) ? RA_DEC_Converter.convert(d, false) : JVTUtil.getInOriginalFormat(d, datatype));
                }
                for (j = 0; j < noOfDataDisplayColumns; ++j) {
                    DataDisplayColumn disCol = this._plotData.getDataDisplayColumn(j);
                    if (disCol == null) continue;
                    data[k++] = disCol.getData(rowNum) == null ? "" : disCol.getData(rowNum);
                }
                for (j = 0; j < noOfFilters; ++j) {
                    PlotFilter pf = this._plotData.getPlotFilter(j);
                    if (pf == null) continue;
                    data[k++] = pf.getData(rowNum) ? "1" : "0";
                }
                this._vos.addRow(data, totalNoOfColumns);
            }
        }
    }

    public static void main(String[] args) {
    }
}

