/*
 * Decompiled with CFR 0.152.
 */
package com.jvt.votable;

import cds.savot.model.CoosysSet;
import cds.savot.model.InfoSet;
import cds.savot.model.LinkSet;
import cds.savot.model.ParamSet;
import cds.savot.model.ResourceSet;
import cds.savot.model.SavotCoosys;
import cds.savot.model.SavotDefinitions;
import cds.savot.model.SavotInfo;
import cds.savot.model.SavotLink;
import cds.savot.model.SavotParam;
import cds.savot.model.SavotResource;
import cds.savot.model.SavotTable;
import cds.savot.model.SavotVOTable;
import cds.savot.model.TableSet;
import cds.savot.pull.SavotPullEngine;
import cds.savot.pull.SavotPullParser;
import java.io.IOException;
import java.util.Vector;
import vowrite.VOTable;
import vowrite.VOTableCoosys;
import vowrite.VOTableDefinitions;
import vowrite.VOTableInfo;
import vowrite.VOTableLink;
import vowrite.VOTableParam;
import vowrite.VOTableResource;
import vowrite.VOTableTable;

public class VOTableMetaDataExtractor {
    private static final String[] _errorMsg = new String[]{"", "Error: No resource in VOTable.", "Error: No table in VOTable."};
    private int _errorNum = 0;
    private VOTable _votable = null;
    private VOTableResource _votableResource = null;
    private VOTableTable _votableTable = null;

    public VOTableMetaDataExtractor(SavotVOTable svotable) {
        try {
            if (svotable == null) {
                System.out.println("Error: VOTable element not found.");
            } else {
                this.extractVOTable(svotable);
                ResourceSet reSet = svotable.getResources();
                if (reSet.getItemCount() <= 0) {
                    this._errorNum = 1;
                } else {
                    SavotResource sResource = (SavotResource)reSet.getItemAt(0);
                    this.extractResource(sResource);
                    TableSet tabSet = sResource.getTables();
                    if (tabSet.getItemCount() <= 0) {
                        this._errorNum = 2;
                    } else {
                        SavotTable sTable = (SavotTable)tabSet.getItemAt(0);
                        this.extractTable(sTable);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void extractVOTable(SavotVOTable svotable) {
        InfoSet infoSet;
        if (svotable == null) {
            return;
        }
        this._votable = new VOTable();
        this._votable.setDescription(svotable.getDescription());
        SavotDefinitions savDef = svotable.getDefinitions();
        if (savDef != null) {
            ParamSet paramSet;
            VOTableDefinitions voDef = new VOTableDefinitions();
            CoosysSet cooSet = savDef.getCoosys();
            if (cooSet != null) {
                voDef.addAllCOOSYS(this.extractCOOSYS(cooSet));
            }
            if ((paramSet = savDef.getParams()) != null) {
                voDef.addAllParam(this.extractParam(paramSet));
            }
            this._votable.setDefinitions(voDef);
        }
        if ((infoSet = svotable.getInfos()) != null) {
            this._votable.addAllInfo(this.extractInfo(infoSet));
        }
    }

    private void extractResource(SavotResource sResource) {
        LinkSet lnSet;
        ParamSet paramSet;
        CoosysSet cooSet;
        if (sResource == null) {
            return;
        }
        this._votableResource = new VOTableResource();
        this._votableResource.setId(sResource.getId());
        this._votableResource.setName(sResource.getName());
        this._votableResource.setType(sResource.getType());
        this._votableResource.setDescription(sResource.getDescription());
        InfoSet infoSet = sResource.getInfos();
        if (infoSet != null) {
            this._votableResource.addAllInfo(this.extractInfo(infoSet));
        }
        if ((cooSet = sResource.getCoosys()) != null) {
            this._votableResource.addAllCOOSYS(this.extractCOOSYS(cooSet));
        }
        if ((paramSet = sResource.getParams()) != null) {
            this._votableResource.addAllParam(this.extractParam(paramSet));
        }
        if ((lnSet = sResource.getLinks()) != null) {
            this._votableResource.addAllLink(VOTableMetaDataExtractor.extractLink(lnSet));
        }
    }

    private void extractTable(SavotTable sTable) {
        if (sTable == null) {
            return;
        }
        this._votableTable = new VOTableTable();
        this._votableTable.setId(sTable.getId());
        this._votableTable.setName(sTable.getName());
        this._votableTable.setRef(sTable.getRef());
        this._votableTable.setDescription(sTable.getDescription());
        LinkSet lnSet = sTable.getLinks();
        if (lnSet != null) {
            this._votableTable.addAllLink(VOTableMetaDataExtractor.extractLink(lnSet));
        }
    }

    private Vector extractCOOSYS(CoosysSet cooSet) {
        int noOfCoosys = 0;
        noOfCoosys = cooSet.getItemCount();
        Vector<VOTableCoosys> allCOOSYS = new Vector<VOTableCoosys>(noOfCoosys);
        for (int i = 0; i < noOfCoosys; ++i) {
            SavotCoosys savCoo = (SavotCoosys)cooSet.getItemAt(i);
            if (savCoo == null) continue;
            allCOOSYS.addElement(this.getSingleCoosys(savCoo));
        }
        return allCOOSYS;
    }

    private VOTableCoosys getSingleCoosys(SavotCoosys savCoo) {
        VOTableCoosys voCoo = new VOTableCoosys();
        voCoo.setID(savCoo.getId());
        voCoo.setEquinox(savCoo.getEquinox());
        voCoo.setEpoch(savCoo.getEpoch());
        voCoo.setSystem(savCoo.getSystem());
        return voCoo;
    }

    public static Vector extractLink(LinkSet lnSet) {
        int noOfLinks = 0;
        noOfLinks = lnSet.getItemCount();
        Vector<VOTableLink> allLink = new Vector<VOTableLink>(noOfLinks);
        for (int i = 0; i < noOfLinks; ++i) {
            SavotLink savLink = (SavotLink)lnSet.getItemAt(i);
            if (savLink == null) continue;
            allLink.addElement(VOTableMetaDataExtractor.getSingleLink(savLink));
        }
        return allLink;
    }

    private static VOTableLink getSingleLink(SavotLink savLink) {
        VOTableLink voLink = new VOTableLink();
        voLink.setAction(savLink.getAction());
        voLink.setContentRole(savLink.getContentRole());
        voLink.setContentType(savLink.getContentType());
        voLink.setGref(savLink.getGref());
        voLink.setHref(savLink.getHref());
        voLink.setId(savLink.getID());
        voLink.setTitle(savLink.getTitle());
        voLink.setValue(savLink.getValue());
        return voLink;
    }

    private Vector extractParam(ParamSet paramSet) {
        int noOfParam = 0;
        noOfParam = paramSet.getItemCount();
        Vector<VOTableParam> allParam = new Vector<VOTableParam>(noOfParam);
        for (int i = 0; i < noOfParam; ++i) {
            SavotParam savParam = (SavotParam)paramSet.getItemAt(i);
            if (savParam == null) continue;
            allParam.addElement(this.getSingleParam(savParam));
        }
        return allParam;
    }

    private VOTableParam getSingleParam(SavotParam savParam) {
        VOTableParam voParam = new VOTableParam();
        voParam.setArraySize(savParam.getArraySize());
        voParam.setDataType(savParam.getDataType());
        voParam.setDescription(savParam.getDescription());
        voParam.setId(savParam.getId());
        voParam.setName(savParam.getName());
        voParam.setPrecision(savParam.getPrecision());
        voParam.setRef(savParam.getRef());
        voParam.setUcd(savParam.getUcd());
        voParam.setUnit(savParam.getUnit());
        voParam.setValue(savParam.getValue());
        voParam.setWidth(savParam.getWidth());
        LinkSet lnSet = savParam.getLinks();
        if (lnSet != null) {
            voParam.addAllLink(VOTableMetaDataExtractor.extractLink(lnSet));
        }
        return voParam;
    }

    private Vector extractInfo(InfoSet infoSet) {
        int noOfInfo = 0;
        noOfInfo = infoSet.getItemCount();
        Vector<VOTableInfo> allInfo = new Vector<VOTableInfo>(noOfInfo);
        for (int i = 0; i < noOfInfo; ++i) {
            SavotInfo savInfo = (SavotInfo)infoSet.getItemAt(i);
            if (savInfo == null) continue;
            allInfo.addElement(this.getSingleInfo(savInfo));
        }
        return allInfo;
    }

    private VOTableInfo getSingleInfo(SavotInfo savInfo) {
        VOTableInfo voInfo = new VOTableInfo();
        voInfo.setID(savInfo.getId());
        voInfo.setName(savInfo.getName());
        voInfo.setValue(savInfo.getValue());
        return voInfo;
    }

    public VOTable getVOTable() {
        return this._votable;
    }

    public VOTableResource getVOTableResource() {
        return this._votableResource;
    }

    public VOTableTable getVOTableTable() {
        return this._votableTable;
    }

    public static void main(String[] argv) throws IOException {
        try {
            SavotPullParser _sb = new SavotPullParser("c:\\vowrite\\Votable1.xml", SavotPullEngine.FULL);
            SavotVOTable _sv = _sb.getVOTable();
            VOTableMetaDataExtractor metaExtract = new VOTableMetaDataExtractor(_sv);
            System.out.println("Getting data... \n");
            VOTable votable = metaExtract.getVOTable();
            VOTableMetaDataExtractor.printVOTable(votable);
            VOTableResource voResource = metaExtract.getVOTableResource();
            VOTableMetaDataExtractor.printVOTableResource(voResource);
            VOTableTable voTable = metaExtract.getVOTableTable();
            VOTableMetaDataExtractor.printVOTableTable(voTable);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void printVOTable(VOTable vot) {
        System.out.println("VOTable description:".concat(String.valueOf(String.valueOf(vot.getDescription()))));
        VOTableDefinitions voDef = vot.getDefinitions();
        VOTableCoosys voCoo = voDef.getCOOSYS(0);
        System.out.println("votable Equinox:".concat(String.valueOf(String.valueOf(voCoo.getEquinox()))));
        VOTableInfo voInfo = vot.getInfo(0);
        System.out.println("votable Info name:".concat(String.valueOf(String.valueOf(voInfo.getName()))));
    }

    private static void printVOTableResource(VOTableResource voResource) {
        VOTableInfo voInfo = voResource.getInfo(0);
        System.out.println("Resource Info name:".concat(String.valueOf(String.valueOf(voInfo.getName()))));
        VOTableCoosys voCoo = voResource.getCOOSYS(0);
        System.out.println("resource Equinox:".concat(String.valueOf(String.valueOf(voCoo.getEquinox()))));
    }

    private static void printVOTableTable(VOTableTable voTable) {
        System.out.println("ID:".concat(String.valueOf(String.valueOf(voTable.getId()))));
        System.out.println("Name:".concat(String.valueOf(String.valueOf(voTable.getName()))));
        System.out.println("Description:".concat(String.valueOf(String.valueOf(voTable.getDescription()))));
    }
}

