/*
 * Decompiled with CFR 0.152.
 */
package com.jvt.votable;

import cds.savot.model.FieldSet;
import cds.savot.model.LinkSet;
import cds.savot.model.ResourceSet;
import cds.savot.model.SavotData;
import cds.savot.model.SavotField;
import cds.savot.model.SavotResource;
import cds.savot.model.SavotTD;
import cds.savot.model.SavotTable;
import cds.savot.model.SavotTableData;
import cds.savot.model.SavotVOTable;
import cds.savot.model.TDSet;
import cds.savot.model.TRSet;
import cds.savot.model.TableSet;
import cds.savot.pull.SavotPullEngine;
import cds.savot.pull.SavotPullParser;
import com.jvt.votable.Column;
import com.jvt.votable.DataDisplayColumn;
import com.jvt.votable.PlotColumn;
import com.jvt.votable.PlotData;
import com.jvt.votable.VOTableMetaDataExtractor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import vowrite.VOTable;
import vowrite.VOTableField;
import vowrite.VOTableResource;
import vowrite.VOTableTable;

public class SAVOTParser {
    private static final String[] _errorMsg = new String[]{"", "Error: No resource in VOTable.", "Error: No columns in VOTable.", "Error: No data in VOTable.", "Error: No table data in VOTable.", "Error: No rows in VOTable.", "Error: No table in VOTable."};
    private int _errorNum = 0;
    VOTableMetaDataExtractor vom = null;
    private static final int _type = SavotPullEngine.FULL;
    private PlotData _plotdata = null;
    public static final String UCD_RA = "POS_EQ_RA_MAIN";
    public static final String UCD_DEC = "POS_EQ_DEC_MAIN";
    private final String XML_ENCODING = "UTF-8";
    private static final char SEP_RA_DEC = ' ';
    private VOTable _votable = null;
    private VOTableResource _votableResource = null;
    private VOTableTable _votableTable = null;

    public SAVOTParser(String source) {
        try {
            URL url = new URL(source);
            SavotPullParser _sb = new SavotPullParser(url, _type, "UTF-8");
            SavotVOTable _sv = _sb.getVOTable();
            this.readMetaData(_sv);
            ResourceSet reSet = _sv.getResources();
            if (reSet.getItemCount() <= 0) {
                this._errorNum = 1;
            } else {
                SavotResource sResource = (SavotResource)reSet.getItemAt(0);
                this.getData(sResource);
            }
        }
        catch (Exception ex) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Error in parsing VOTable at '").append(source).append("'. ").append(ex.toString()))));
        }
    }

    public SAVOTParser(InputStream istream) {
        try {
            SavotPullParser _sb = new SavotPullParser(istream, _type, "UTF-8");
            SavotVOTable _sv = _sb.getVOTable();
            this.readMetaData(_sv);
            ResourceSet reSet = _sv.getResources();
            if (reSet.getItemCount() <= 0) {
                this._errorNum = 1;
            } else {
                SavotResource sResource = (SavotResource)reSet.getItemAt(0);
                this.getData(sResource);
            }
        }
        catch (Exception ex) {
            System.out.println("Error in parsing VOTable from given input.");
        }
    }

    public SAVOTParser(String source, boolean file) {
        try {
            SavotPullParser _sb = new SavotPullParser(source, _type);
            SavotVOTable _sv = _sb.getVOTable();
            this.readMetaData(_sv);
            ResourceSet reSet = _sv.getResources();
            if (reSet.getItemCount() <= 0) {
                this._errorNum = 1;
            } else {
                SavotResource sResource = (SavotResource)reSet.getItemAt(0);
                this.getData(sResource);
            }
        }
        catch (Exception ex) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Error in parsing VOTable at '").append(source).append("'. ").append(ex.toString()))));
        }
    }

    public void readMetaData(SavotVOTable _sav) {
        this.vom = new VOTableMetaDataExtractor(_sav);
    }

    public VOTable getVOTableMetaData() {
        if (this.vom != null) {
            return this.vom.getVOTable();
        }
        return null;
    }

    public VOTableResource getVOTableResourceMetaData() {
        if (this.vom != null) {
            return this.vom.getVOTableResource();
        }
        return null;
    }

    public VOTableTable getVOTableTableMetaData() {
        if (this.vom != null) {
            return this.vom.getVOTableTable();
        }
        return null;
    }

    public PlotData getPlotData() {
        if (this._plotdata == null) {
            // empty if block
        }
        return this._plotdata;
    }

    private void getData(SavotResource resource) {
        try {
            if (resource == null) {
                this._errorNum = 1;
                return;
            }
            Object tr = null;
            this._plotdata = new PlotData();
            String des = resource.getDescription();
            this._plotdata.setCatalogueName(des);
            TableSet ts = resource.getTables();
            if (ts.getItemCount() <= 0) {
                this._errorNum = 6;
                return;
            }
            SavotTable table = (SavotTable)ts.getItemAt(0);
            ArrayList fieldIndex = this.getFieldData(table);
            this._plotdata = this.getTableData(table, fieldIndex);
            if (this._errorNum != 0) {
                return;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void addFieldData(Column c, SavotField f, int ifield) {
        String ucd = f.getUcd();
        String unit = f.getUnit();
        String datatype = f.getDataType();
        String fname = f.getName();
        if (!(fname != null && fname.trim().length() > 0 || (fname = f.getId()) != null && fname.trim().length() > 0)) {
            fname = String.valueOf(String.valueOf(new StringBuffer("Field ").append(ifield + 1)));
        }
        c.setName(fname);
        c.setUnit(unit);
        c.setUCD(ucd);
        c.setDatatype(datatype);
        VOTableField voField = new VOTableField();
        voField.setName(fname);
        voField.setUnit(unit);
        voField.setUcd(ucd);
        voField.setDataType(datatype);
        voField.setId(f.getId());
        voField.setPrecision(f.getPrecision());
        voField.setWidth(f.getWidth());
        voField.setRef(f.getRef());
        voField.setArraySize(f.getArraySize());
        voField.setType(f.getType());
        voField.setDescription(f.getDescription());
        LinkSet lnSet = f.getLinks();
        voField.addAllLink(VOTableMetaDataExtractor.extractLink(lnSet));
        c.setVOField(voField);
    }

    private ArrayList getFieldData(SavotTable table) {
        FieldSet fs = table.getFields();
        if (fs.getItemCount() <= 0) {
            this._errorNum = 2;
        }
        ArrayList<FieldIndexType> fieldIndex = new ArrayList<FieldIndexType>();
        boolean fi = false;
        for (int ifield = 0; ifield < fs.getItemCount(); ++ifield) {
            PlotColumn pc;
            SavotField f = (SavotField)fs.getItemAt(ifield);
            String dt = f.getDataType();
            String ucd = f.getUcd();
            if (UCD_RA.equals(ucd) || UCD_DEC.equals(ucd)) {
                if (ucd.equals(UCD_RA)) {
                    if (this.isNumeric(dt)) {
                        fieldIndex.add(new FieldIndexType(this, ifield, 0));
                    } else if (dt.equals("char")) {
                        fieldIndex.add(new FieldIndexType(this, ifield, 1));
                    }
                }
                if (ucd.equals(UCD_DEC)) {
                    if (this.isNumeric(dt)) {
                        fieldIndex.add(new FieldIndexType(this, ifield, 0));
                    } else if (dt.equals("char")) {
                        fieldIndex.add(new FieldIndexType(this, ifield, 2));
                    }
                }
                pc = new PlotColumn();
                this.addFieldData(pc, f, ifield);
                pc.setDatatype("double");
                VOTableField field = pc.getVOField();
                field.setDataType("char");
                this._plotdata.addPlotColumn(pc);
                continue;
            }
            if (dt == null) continue;
            if (this.isNumeric(dt)) {
                fieldIndex.add(new FieldIndexType(this, ifield, 0));
                pc = new PlotColumn();
                this.addFieldData(pc, f, ifield);
                this._plotdata.addPlotColumn(pc);
                continue;
            }
            fieldIndex.add(new FieldIndexType(this, ifield, 3));
            DataDisplayColumn ddc = new DataDisplayColumn();
            this.addFieldData(ddc, f, ifield);
            VOTableField voField = ddc.getVOField();
            this._plotdata.addDataDisplayColumn(ddc);
        }
        SAVOTParser.printFieldIndex(fieldIndex);
        return fieldIndex;
    }

    private boolean isNumeric(String dt) {
        return dt.equals("unsignedByte") || dt.equals("short") || dt.equals("int") || dt.equals("long") || dt.equals("float") || dt.equals("double");
    }

    private PlotData getTableData(SavotTable table, ArrayList fieldIndex) {
        SavotData sd = table.getData();
        if (sd == null) {
            this._errorNum = 3;
            return this._plotdata;
        }
        SavotTableData std = sd.getTableData();
        if (std == null) {
            this._errorNum = 4;
            return this._plotdata;
        }
        TRSet allRows = std.getTRs();
        if (allRows == null || allRows.getItemCount() <= 0) {
            this._errorNum = 5;
            return this._plotdata;
        }
        for (int irow = 0; irow < allRows.getItemCount(); ++irow) {
            TDSet theTDs = allRows.getTDSet(irow);
            int iPlotCol = 0;
            int iDataDisplayCol = 0;
            for (int icol = 0; icol < fieldIndex.size(); ++icol) {
                PlotColumn pc;
                FieldIndexType fit = (FieldIndexType)fieldIndex.get(icol);
                SavotTD col = (SavotTD)theTDs.getItemAt(fit.getIndex());
                String strdata = col == null ? "" : col.getContent();
                if (3 == fit.getType()) {
                    DataDisplayColumn ddc;
                    if ((ddc = this._plotdata.getDataDisplayColumn(iDataDisplayCol++)) == null) continue;
                    ddc.addData(strdata);
                    continue;
                }
                Double d = this.extractColumnData(strdata, fit.getType());
                if ((pc = this._plotdata.getPlotColumn(iPlotCol++)) == null) continue;
                pc.addData(d);
            }
        }
        return this._plotdata;
    }

    public static Double extractRA(String strdata) {
        Double d = null;
        try {
            if (strdata == null || strdata.trim().length() == 0) {
                Double d2 = d;
                return d2;
            }
            if ((strdata = strdata.trim()).indexOf(32) == strdata.lastIndexOf(32)) {
                float h = Float.parseFloat(strdata.substring(0, strdata.indexOf(32)));
                float m = Float.parseFloat(strdata.substring(strdata.indexOf(32) + 1));
                double d1 = (h + m / (float)60) * (float)15;
                d = new Double(d1);
            } else {
                float h = Float.parseFloat(strdata.substring(0, strdata.indexOf(32)));
                float m = Float.parseFloat(strdata.substring(strdata.indexOf(32) + 1, strdata.lastIndexOf(32)));
                float s = Float.parseFloat(strdata.substring(strdata.lastIndexOf(32) + 1));
                double d1 = (h + m / (float)60 + s / (float)3600) * (float)15;
                d = new Double(d1);
            }
        }
        catch (Exception ex) {
            d = null;
        }
        return d;
    }

    public static Double extractDEC(String strdata) {
        Double d = null;
        int fact = 1;
        int start = 0;
        try {
            if (strdata == null || strdata.trim().length() == 0) {
                Double d2 = d;
                return d2;
            }
            if ((strdata = strdata.trim()).charAt(0) == '-') {
                fact = -1;
                start = 1;
            }
            if (strdata.charAt(0) == '+') {
                fact = 1;
                start = 1;
            }
            if (strdata.indexOf(32) == strdata.lastIndexOf(32)) {
                float h = Float.parseFloat(strdata.substring(start, strdata.indexOf(32)));
                float m = Float.parseFloat(strdata.substring(strdata.indexOf(32) + 1));
                double d1 = (float)fact * (h + m / (float)60);
                d = new Double(d1);
            } else {
                float h = Float.parseFloat(strdata.substring(start, strdata.indexOf(32)));
                float m = Float.parseFloat(strdata.substring(strdata.indexOf(32) + 1, strdata.lastIndexOf(32)));
                float s = Float.parseFloat(strdata.substring(strdata.lastIndexOf(32) + 1));
                double d1 = (float)fact * (h + m / (float)60 + s / (float)3600);
                d = new Double(d1);
            }
        }
        catch (Exception ex) {
            d = null;
        }
        return d;
    }

    private Double extractColumnData(String strdata, int type) {
        Double d = null;
        if (strdata == null || strdata.trim().length() <= 0) {
            d = null;
        } else {
            try {
                if (type == 1) {
                    d = SAVOTParser.extractRA(strdata);
                } else if (type == 2) {
                    d = SAVOTParser.extractDEC(strdata);
                } else if (type == 0) {
                    d = new Double(strdata);
                }
            }
            catch (NumberFormatException ex) {
                d = null;
            }
        }
        return d;
    }

    public static void main(String[] argv) throws IOException {
        if (argv.length == 0) {
            System.out.println("Usage: java SAVOTParser <source> ");
        } else {
            SAVOTParser sp = new SAVOTParser(argv[0], true);
            System.out.println("Getting data... ");
        }
    }

    private static void printVOTableData(PlotData pd) {
        System.out.println("Printing Plot Data.");
        if (pd != null) {
            System.out.println("Number of columns is ".concat(String.valueOf(String.valueOf(pd.getNumOfPlotColumns()))));
            for (int i = 0; i < pd.getNumOfPlotColumns(); ++i) {
                PlotColumn pc = pd.getPlotColumn(i);
                System.out.println(pc.getName());
                Double[] d = pc.getData();
                for (int j = 0; j < d.length; ++j) {
                    System.out.println(d[j]);
                }
            }
        }
    }

    private static void printFieldIndex(ArrayList fieldIndex) {
        for (int i = 0; i < fieldIndex.size(); ++i) {
            FieldIndexType fieldIndexType = (FieldIndexType)fieldIndex.get(i);
        }
    }

    private static void printPlotData(PlotData pd) {
        if (pd == null) {
            System.out.println("Plot data is null.");
            return;
        }
        System.out.println("Number of plot columns is = ".concat(String.valueOf(String.valueOf(pd.getNumOfPlotColumns()))));
        System.out.println("Number of data display columns is = ".concat(String.valueOf(String.valueOf(pd.getNumOfDataDisplayColumns()))));
        for (int i = 0; i < pd.getNumOfDataDisplayColumns(); ++i) {
            DataDisplayColumn ddc = pd.getDataDisplayColumn(i);
            System.out.println("Column name = ".concat(String.valueOf(String.valueOf(ddc.getName()))));
            if (ddc == null) continue;
            for (int j = 0; j < ddc.getNumOfRows(); ++j) {
                System.out.println(ddc.getData(j));
            }
        }
    }

    static {
        UCD_RA = UCD_RA;
        UCD_DEC = UCD_DEC;
        SEP_RA_DEC = (char)32;
    }

    class FieldIndexType {
        public static final int TYPE_NUMERIC = 0;
        public static final int TYPE_RA = 1;
        public static final int TYPE_DEC = 2;
        public static final int TYPE_NONNUMERIC = 3;
        private int _index;
        private int _type;

        public FieldIndexType(SAVOTParser this$0, int fieldIndex, int fieldType) {
            this._index = fieldIndex;
            this._type = fieldType;
        }

        public int getIndex() {
            return this._index;
        }

        public int getType() {
            return this._type;
        }

        static {
            TYPE_NUMERIC = 0;
            TYPE_RA = 1;
            TYPE_DEC = 2;
            TYPE_NONNUMERIC = 3;
        }
    }
}

