/*
 * Decompiled with CFR 0.152.
 */
package com.jvt.votable;

import com.jvt.votable.DataDisplayColumn;
import com.jvt.votable.PlotColumn;
import com.jvt.votable.PlotFilter;
import com.jvt.votable.VOTableMetaData;
import java.io.Serializable;
import java.util.ArrayList;
import vowrite.VOTableField;

public class PlotData
implements Serializable {
    public static final String OBJECT_ID = "_OID";
    public static final String OBJECT_UCD = "ID_NUMBER";
    public static final String[] UCD_MATCH;
    public static final String[] UCD_STARTS_WITH;
    public static final String[] UCD_ENDS_WITH;
    private int _objectIDColIndex = -1;
    private ArrayList _plotColumnList = new ArrayList();
    private ArrayList _plotFilterList = new ArrayList();
    private ArrayList _generalDataList = new ArrayList();
    private int _numOfRows = 0;
    private String _catalogueName;
    private VOTableMetaData _votableMetaData = null;

    public void addPlotColumn(PlotColumn column) {
        if (column != null) {
            this._plotColumnList.add(column);
        }
    }

    public DataDisplayColumn getObjectIDColumn() {
        if (-1 == this._objectIDColIndex) {
            for (int iddc = 0; iddc < this._generalDataList.size(); ++iddc) {
                DataDisplayColumn ddc = (DataDisplayColumn)this._generalDataList.get(iddc);
                if (!OBJECT_ID.equals(ddc.getName())) continue;
                this._objectIDColIndex = iddc;
                return ddc;
            }
        } else if (this._objectIDColIndex >= 0 && this._objectIDColIndex < this._generalDataList.size()) {
            DataDisplayColumn ddc = (DataDisplayColumn)this._generalDataList.get(this._objectIDColIndex);
            return ddc;
        }
        return null;
    }

    public void addDataDisplayColumn(DataDisplayColumn column) {
        if (column != null) {
            this._generalDataList.add(column);
        }
    }

    public void addPlotFilter(PlotFilter filter) {
        if (filter != null) {
            this._plotFilterList.add(filter);
        }
    }

    public int getNumOfPlotColumns() {
        return this._plotColumnList.size();
    }

    public int getNumOfDataDisplayColumns() {
        return this._generalDataList.size();
    }

    public int getNumOfFilters() {
        return this._plotFilterList.size();
    }

    public int getNumOfRows() {
        if (this.getNumOfPlotColumns() > 0) {
            PlotColumn pc = this.getPlotColumn(0);
            this._numOfRows = pc.getNumOfRows();
        }
        return this._numOfRows;
    }

    public PlotFilter getPlotFilter(int filterIndex) {
        if (filterIndex < 0 || filterIndex >= this._plotFilterList.size()) {
            return null;
        }
        return (PlotFilter)this._plotFilterList.get(filterIndex);
    }

    public PlotColumn getPlotColumn(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this._plotColumnList.size()) {
            return null;
        }
        return (PlotColumn)this._plotColumnList.get(columnIndex);
    }

    public DataDisplayColumn getDataDisplayColumn(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this._generalDataList.size()) {
            return null;
        }
        return (DataDisplayColumn)this._generalDataList.get(columnIndex);
    }

    public String getCatalogueName() {
        return this._catalogueName;
    }

    public void setCatalogueName(String catalogueName) {
        this._catalogueName = catalogueName;
    }

    public boolean generateObjectIDColumn() {
        try {
            DataDisplayColumn ddc = new DataDisplayColumn();
            ddc.setName(OBJECT_ID);
            ddc.setUCD(OBJECT_UCD);
            for (int irow = 0; irow < this.getNumOfRows(); ++irow) {
                ddc.addData("".concat(String.valueOf(String.valueOf(irow))));
            }
            VOTableField voField = new VOTableField();
            voField.setName(OBJECT_ID);
            voField.setUcd(OBJECT_UCD);
            voField.setType("hidden");
            voField.setDataType("char");
            ddc.setVOField(voField);
            this.addDataDisplayColumn(ddc);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public int getObjectIDColumnIndex() {
        if (-1 == this._objectIDColIndex) {
            for (int iddc = 0; iddc < this._generalDataList.size(); ++iddc) {
                DataDisplayColumn ddc = (DataDisplayColumn)this._generalDataList.get(iddc);
                if (!OBJECT_ID.equals(ddc.getName())) continue;
                this._objectIDColIndex = iddc;
                return this._objectIDColIndex;
            }
        }
        return this._objectIDColIndex;
    }

    public void deletePointAt(int index) {
        PlotColumn pc;
        for (int iplotcol = 0; iplotcol < this._plotColumnList.size(); ++iplotcol) {
            pc = (PlotColumn)this._plotColumnList.get(iplotcol);
            pc.remove(index);
        }
        for (int ifiltercol = 0; ifiltercol < this._plotFilterList.size(); ++ifiltercol) {
            pc = (PlotColumn)this._plotFilterList.get(ifiltercol);
            pc.remove(index);
        }
        for (int idisplaycol = 0; idisplaycol < this._generalDataList.size(); ++idisplaycol) {
            pc = (PlotColumn)this._plotColumnList.get(idisplaycol);
            pc.remove(index);
        }
    }

    public VOTableMetaData getVOTableMetaData() {
        return this._votableMetaData;
    }

    public void setVOTableMetaData(VOTableMetaData votableMetaData) {
        this._votableMetaData = votableMetaData;
    }

    static {
        OBJECT_ID = OBJECT_ID;
        OBJECT_UCD = OBJECT_UCD;
        UCD_MATCH = new String[]{"ERROR", "NOTE", "NUMBER", "RECORD", "REMARKS", "UNITS", "WEIGHT"};
        UCD_STARTS_WITH = new String[]{"CODE_", "DYN_", "ID_", "REFER_"};
        UCD_ENDS_WITH = new String[]{"_CODE", "_ID"};
    }
}

