/*
 * Decompiled with CFR 0.152.
 */
package com.jvt.votable;

import com.jvt.applets.PlotVOApplet;
import com.jvt.utils.JVTUtil;
import com.jvt.utils.RA_DEC_Converter;
import com.jvt.votable.DataDisplayColumn;
import com.jvt.votable.PlotColumn;
import com.jvt.votable.PlotData;
import com.jvt.votable.PlotFilter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;

public class ASCIIWriter {
    private PlotData _plotData = null;
    private PlotVOApplet _pva = null;
    private int _noOfRows = -1;
    public static String _EMPTY_DATA = "";
    public static String _SAPERATOR = ",";
    int _truncateFlag = 0;

    public ASCIIWriter(PlotVOApplet pva) {
        this._plotData = pva.getPlotData();
        this._pva = pva;
        this._noOfRows = -1;
    }

    public ASCIIWriter(PlotVOApplet pva, int noOfRows) {
        this._plotData = pva.getPlotData();
        this._pva = pva;
        this._noOfRows = noOfRows;
    }

    public void getDataInASCIIFormat(OutputStream out) {
        PrintStream _prnStream = new PrintStream(out);
        this.writeData(_prnStream, null);
    }

    public void getSelectedDataInASCIIFormat(OutputStream out, ArrayList selectedIndices) {
        PrintStream _prnStream = new PrintStream(out);
        this.writeData(_prnStream, selectedIndices);
    }

    private void writeData(PrintStream printStream, ArrayList selectedIndices) {
        int index;
        int noOfRows = this._plotData.getNumOfRows();
        int noOfPlotColumns = this._plotData.getNumOfPlotColumns();
        int noOfDataDisplayColumns = this._plotData.getNumOfDataDisplayColumns();
        int noOfFilters = this._plotData.getNumOfFilters();
        int totalNoOfColumns = noOfPlotColumns + noOfDataDisplayColumns + noOfFilters;
        String[] columnNames = this._pva.getColumnNames();
        for (index = 0; index < columnNames.length; ++index) {
            printStream.print(String.valueOf(String.valueOf(ASCIIWriter.format(columnNames[index]))).concat(String.valueOf(String.valueOf(_SAPERATOR))));
        }
        PlotData plotData = this._pva.getCurrentPlotData();
        for (index = 0; index < plotData.getNumOfDataDisplayColumns() - 1; ++index) {
            printStream.print(String.valueOf(String.valueOf(ASCIIWriter.format(plotData.getDataDisplayColumn((int)index)._name))).concat(String.valueOf(String.valueOf(_SAPERATOR))));
        }
        printStream.print(ASCIIWriter.format(plotData.getDataDisplayColumn((int)index)._name));
        printStream.print("\n");
        if (selectedIndices == null) {
            if (this._noOfRows != -1 && this._noOfRows < noOfRows) {
                noOfRows = this._noOfRows;
                this._truncateFlag = 1;
            }
            for (int i = 0; i < noOfRows; ++i) {
                int j;
                String[] data = new String[totalNoOfColumns];
                int k = 0;
                for (j = 0; j < noOfPlotColumns; ++j) {
                    PlotColumn pCol = this._plotData.getPlotColumn(j);
                    if (pCol == null) continue;
                    if (pCol.getData(i) == null) {
                        data[k++] = _EMPTY_DATA;
                        continue;
                    }
                    int datatype = pCol.getDatatypeIntegerFormat();
                    Double d = pCol.getData(i);
                    data[k++] = "POS_EQ_RA_MAIN".equals(pCol.getUCD()) ? RA_DEC_Converter.convert(d, true) : ("POS_EQ_DEC_MAIN".equals(pCol.getUCD()) ? RA_DEC_Converter.convert(d, false) : JVTUtil.getInOriginalFormat(d, datatype));
                }
                for (j = 0; j < noOfDataDisplayColumns; ++j) {
                    DataDisplayColumn disCol = this._plotData.getDataDisplayColumn(j);
                    if (disCol == null) continue;
                    data[k++] = disCol.getData(i) == null ? _EMPTY_DATA : disCol.getData(i);
                }
                for (j = 0; j < noOfFilters; ++j) {
                    PlotFilter pf = this._plotData.getPlotFilter(j);
                    if (pf == null) continue;
                    data[k++] = pf.getData(i) ? "1" : "0";
                }
                for (int column = 0; column < totalNoOfColumns - 1; ++column) {
                    printStream.print(String.valueOf(String.valueOf(ASCIIWriter.format(data[column]))).concat(String.valueOf(String.valueOf(_SAPERATOR))));
                }
                printStream.print(String.valueOf(String.valueOf(ASCIIWriter.format(data[totalNoOfColumns - 1]))).concat("\n"));
            }
        } else {
            int totalRows = selectedIndices.size();
            if (this._noOfRows != -1 && this._noOfRows < totalRows) {
                totalRows = this._noOfRows;
                this._truncateFlag = 1;
            }
            for (int i = 0; i < totalRows; ++i) {
                int j;
                int rowNum = (Integer)selectedIndices.get(i);
                String[] data = new String[totalNoOfColumns];
                int k = 0;
                for (j = 0; j < noOfPlotColumns; ++j) {
                    PlotColumn pCol = this._plotData.getPlotColumn(j);
                    if (pCol == null) continue;
                    if (pCol.getData(rowNum) == null) {
                        data[k++] = _EMPTY_DATA;
                        continue;
                    }
                    int datatype = pCol.getDatatypeIntegerFormat();
                    Double d = pCol.getData(rowNum);
                    data[k++] = "POS_EQ_RA_MAIN".equals(pCol.getUCD()) ? RA_DEC_Converter.convert(d, true) : ("POS_EQ_DEC_MAIN".equals(pCol.getUCD()) ? RA_DEC_Converter.convert(d, false) : JVTUtil.getInOriginalFormat(d, datatype));
                }
                for (j = 0; j < noOfDataDisplayColumns; ++j) {
                    DataDisplayColumn disCol = this._plotData.getDataDisplayColumn(j);
                    if (disCol == null) continue;
                    data[k++] = disCol.getData(rowNum) == null ? _EMPTY_DATA : disCol.getData(rowNum);
                }
                for (j = 0; j < noOfFilters; ++j) {
                    PlotFilter pf = this._plotData.getPlotFilter(j);
                    if (pf == null) continue;
                    data[k++] = pf.getData(rowNum) ? "1" : "0";
                }
                for (int column = 0; column < totalNoOfColumns - 1; ++column) {
                    printStream.print(String.valueOf(String.valueOf(ASCIIWriter.format(data[column]))).concat(String.valueOf(String.valueOf(_SAPERATOR))));
                }
                printStream.print(String.valueOf(String.valueOf(ASCIIWriter.format(data[totalNoOfColumns - 1]))).concat("\n"));
            }
        }
    }

    private static String format(String field) {
        if (field != null) {
            if (field.indexOf(34) != -1) {
                String newField = field;
                int index = 0;
                while ((index = newField.indexOf(34, index)) != -1) {
                    newField = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(newField.substring(0, index)))).append("\"").append(newField.substring(index, newField.length() - 1))));
                    index += 2;
                }
                newField = String.valueOf(String.valueOf(new StringBuffer("\"").append(newField).append("\"")));
                return newField;
            }
            if (field.indexOf(44) != -1) {
                String newField = String.valueOf(String.valueOf(new StringBuffer("\"").append(field).append("\"")));
                return newField;
            }
            return field;
        }
        return null;
    }

    public static void main(String[] args) {
    }
}

