/*
 * Decompiled with CFR 0.152.
 */
package com.jvt.utils;

import com.jvt.votable.SAVOTParser;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;

public class RA_DEC_Converter {
    public static String convert(double degrees, boolean isHMS) {
        try {
            degrees %= (double)360;
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMinimumIntegerDigits(2);
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
            decimalFormat.setMaximumFractionDigits(2);
            decimalFormat.setMinimumFractionDigits(2);
            decimalFormat.setMinimumIntegerDigits(1);
            DecimalFormatSymbols formatSymbols = new DecimalFormatSymbols();
            formatSymbols.setDecimalSeparator('.');
            decimalFormat.setDecimalFormatSymbols(formatSymbols);
            if (isHMS) {
                int mins;
                int hours;
                double seconds;
                double sec;
                if (degrees < 0.0) {
                    degrees = (double)360 + degrees;
                }
                if (Math.abs((sec = (seconds = degrees * (double)240) - (double)(3600 * (hours = (int)seconds / 3600)) - (double)(60 * (mins = (int)(seconds - (double)(3600 * hours)) / 60))) - (double)60) < 0.001) {
                    sec = 0.0;
                    ++mins;
                }
                String string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(numberFormat.format(hours)))).append(" ").append(numberFormat.format(mins)).append(" ").append(decimalFormat.format(sec))));
                return string;
            }
            int minutes = (int)((degrees - (double)((int)degrees)) * (double)60);
            double seconds = ((degrees - (double)((int)degrees)) * (double)60 - (double)minutes) * (double)60;
            if (degrees < 0.0) {
                minutes = -minutes;
                seconds = -seconds;
            }
            if (Math.abs(seconds - (double)60) < 0.001) {
                seconds = 0.0;
                ++minutes;
            }
            String string = String.valueOf(String.valueOf(new StringBuffer("").append(numberFormat.format((int)degrees)).append(" ").append(numberFormat.format(minutes)).append(" ").append(decimalFormat.format(seconds))));
            return string;
        }
        catch (Exception ex) {
            String string = "";
            return string;
        }
    }

    public static void main(String[] args) {
        double[] degrees = new double[]{36.35, 26.78, 123.34, 370.343, -24.23, -200.16, -400.25, 334.56, 12.2};
        for (int i = 0; i < degrees.length; ++i) {
            String hms = RA_DEC_Converter.convert(degrees[i], true);
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(degrees[i]))).append(" degrees = ").append(hms).append(" HMS"))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(hms))).append(" HMS = ").append(SAVOTParser.extractRA(hms)).append(" degrees."))));
            String dms = RA_DEC_Converter.convert(degrees[i], false);
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(degrees[i]))).append(" degrees = ").append(dms).append(" DMS"))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(dms))).append(" DMS = ").append(SAVOTParser.extractDEC(dms)).append(" degrees."))));
        }
    }
}

