/*
 * Decompiled with CFR 0.152.
 */
package com.jvt.utils;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.text.DecimalFormat;
import javax.swing.JComponent;

public class JVTUtil {
    public static final String PLOT_FONT_PLAIN = "Helvetica-PLAIN-12";
    public static final String PLOT_FONT_BOLD = "Helvetica-BOLD-12";
    public static final String TITLE_FONT_BOLD = "Helvetica-BOLD-14";
    public static final String SUPERSCRIPT_FONT_PLAIN = "Helvetica-PLAIN-9";
    public static final String NO_FILTER = "All";
    public static final int MAX_ROWS_COUNT = 6;
    public static final int VOTABLE_TEXT_INPUT_WIDTH = 25;
    public static final String ZOOM_LABEL = "Zoom";
    public static final String SELECT_LABEL = "Select";
    public static final String UNSELECT_LABEL = "UnSelect";
    public static final int NO_OF_ROWS_DISPLAYED = 100;
    public static final boolean DISPLAYING_VOTABLE = false;
    public static final boolean VOTABLE_NOT_DISPLAYED = true;
    public static final boolean DISPLAYING_DATA = false;
    public static final boolean DATA_NOT_DISPLAYED = true;
    public static boolean SHOW_VOTABLE;
    public static boolean SHOW_DATA;
    public static String SMALL_IMAGE_PATH;
    public static String LARGE_IMAGE_PATH;
    public static double WIDTH_PERCENTAGE;
    public static double HEIGHT_PERCENGAGE;
    public static char CATALOGUE_SEPARATOR_OPEN;
    public static char CATALOGUE_SEPARATOR_CLOSE;
    public static String APP_TITLE_PREFIX;
    public static final String[] COOSYS_NAME;
    public static final String[][] COOSYS_LEGEND;
    public static double _LOG10SCALE;

    public static void showWaitCursor(Component comp) {
        comp.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void showDefaultCursor(Component comp) {
        comp.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static void usePlainFont(JComponent comp) {
        comp.setFont(Font.decode(PLOT_FONT_PLAIN));
    }

    public static void useBoldFont(JComponent comp) {
        comp.setFont(Font.decode(PLOT_FONT_BOLD));
    }

    public static String applyProperFormat(double num, DecimalFormat fmt1, DecimalFormat fmt2) {
        if (Double.isNaN(num)) {
            return "Invalid number";
        }
        if (num < (double)1000 && num > 0.01 || num > (double)-1000 && num < -0.01 || num == 0.0) {
            return fmt1.format(num);
        }
        return fmt2.format(num);
    }

    public static String[] setNoDecimalDigits(double[] range) {
        double diff = range[1] - range[0];
        DecimalFormat fmt1 = new DecimalFormat("0.0000E0");
        DecimalFormat fmt2 = new DecimalFormat("0.0000");
        DecimalFormat fmt3 = new DecimalFormat("0.000E0");
        DecimalFormat fmt4 = new DecimalFormat("0.000");
        DecimalFormat fmt5 = new DecimalFormat("0.00E0");
        DecimalFormat fmt6 = new DecimalFormat("0.00");
        String[] result = new String[2];
        if (diff > (double)999) {
            result[0] = JVTUtil.applyProperFormat(range[0], fmt6, fmt5);
            result[1] = JVTUtil.applyProperFormat(range[1], fmt6, fmt5);
        } else if (diff > (double)99 && diff <= (double)999) {
            result[0] = JVTUtil.applyProperFormat(range[0], fmt4, fmt3);
            result[1] = JVTUtil.applyProperFormat(range[1], fmt4, fmt3);
        } else {
            result[0] = JVTUtil.applyProperFormat(range[0], fmt2, fmt1);
            result[1] = JVTUtil.applyProperFormat(range[1], fmt2, fmt1);
        }
        return result;
    }

    public static String getInOriginalFormat(Double d, int datatype) {
        String actualData = "";
        if (d == null) {
            return actualData;
        }
        if (1 == datatype) {
            actualData = d.toString();
        } else {
            double data = d;
            if (2 == datatype) {
                short origninalVal = (short)data;
                actualData = String.valueOf(String.valueOf(actualData)).concat(String.valueOf(String.valueOf(origninalVal)));
            } else if (3 == datatype) {
                short origninalVal = (short)data;
                actualData = String.valueOf(String.valueOf(actualData)).concat(String.valueOf(String.valueOf(origninalVal)));
            } else if (4 == datatype) {
                int origninalVal = (int)data;
                actualData = String.valueOf(String.valueOf(actualData)).concat(String.valueOf(String.valueOf(origninalVal)));
            } else if (5 == datatype) {
                long origninalVal = (long)data;
                actualData = String.valueOf(String.valueOf(actualData)).concat(String.valueOf(String.valueOf(origninalVal)));
            } else if (6 == datatype) {
                float origninalVal = (float)data;
                actualData = String.valueOf(String.valueOf(actualData)).concat(String.valueOf(String.valueOf(origninalVal)));
            } else if (7 == datatype) {
                actualData = String.valueOf(String.valueOf(actualData)).concat(String.valueOf(String.valueOf(data)));
            }
        }
        return actualData;
    }

    public static boolean matches(String str, String expr) {
        if (str == null || expr == null || expr.length() == 0 || str.length() == 0) {
            return false;
        }
        if (str.length() < expr.length()) {
            return false;
        }
        char[] charstoMatch = str.toCharArray();
        char[] charsExpr = expr.toCharArray();
        boolean matchFound = false;
        int i = 0;
        int j = 0;
        while (i < charstoMatch.length) {
            if (charstoMatch[i] == charsExpr[j]) {
                ++i;
                if (charsExpr.length != ++j) continue;
                matchFound = true;
                return true;
            }
            ++i;
            j = 0;
        }
        return matchFound;
    }

    static {
        PLOT_FONT_PLAIN = PLOT_FONT_PLAIN;
        PLOT_FONT_BOLD = PLOT_FONT_BOLD;
        TITLE_FONT_BOLD = TITLE_FONT_BOLD;
        SUPERSCRIPT_FONT_PLAIN = SUPERSCRIPT_FONT_PLAIN;
        NO_FILTER = NO_FILTER;
        MAX_ROWS_COUNT = 6;
        VOTABLE_TEXT_INPUT_WIDTH = 25;
        ZOOM_LABEL = ZOOM_LABEL;
        SELECT_LABEL = SELECT_LABEL;
        UNSELECT_LABEL = UNSELECT_LABEL;
        NO_OF_ROWS_DISPLAYED = 100;
        DISPLAYING_VOTABLE = false;
        VOTABLE_NOT_DISPLAYED = true;
        DISPLAYING_DATA = false;
        DATA_NOT_DISPLAYED = true;
        SHOW_VOTABLE = true;
        SHOW_DATA = true;
        SMALL_IMAGE_PATH = "/ptolemy/plot/smallImg/";
        LARGE_IMAGE_PATH = "/ptolemy/plot/img/";
        WIDTH_PERCENTAGE = 0.852;
        HEIGHT_PERCENGAGE = 0.892;
        CATALOGUE_SEPARATOR_OPEN = (char)123;
        CATALOGUE_SEPARATOR_CLOSE = (char)125;
        APP_TITLE_PREFIX = "VOPlot - ";
        COOSYS_NAME = new String[]{"Mollweide", "Aitoff", "Mercator", "Sinusoidal", "Simple"};
        COOSYS_LEGEND = new String[][]{{"MOL(", ")"}, {"AIT(", ")"}, {"MER(", ")"}, {"SIN(", ")"}, {"SMP(", ")"}};
        _LOG10SCALE = 1.0 / Math.log(10.0);
    }
}

