/*
 * Decompiled with CFR 0.152.
 */
package com.jvt.statistics;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import java.util.Arrays;

public class StatsCalculator
extends Descriptive {
    private int errorNum = 0;

    public double findlinearcorrelation(double[] XY_X, double[] XY_Y) {
        if (XY_X.length <= 0 || XY_Y.length <= 0) {
            return 0.0;
        }
        DoubleArrayList datax = new DoubleArrayList(XY_X);
        double sumx = Descriptive.sum(datax);
        double sumofsquaresx = Descriptive.sumOfSquares(datax);
        double variancex = Descriptive.variance(datax.size(), sumx, sumofsquaresx);
        double deviationx = Descriptive.standardDeviation(variancex);
        DoubleArrayList datay = new DoubleArrayList(XY_Y);
        double sumy = Descriptive.sum(datay);
        double sumofsquaresy = Descriptive.sumOfSquares(datay);
        double variancey = Descriptive.variance(datay.size(), sumy, sumofsquaresy);
        double deviationy = Descriptive.standardDeviation(variancey);
        double corelation = Descriptive.correlation(datax, deviationx, datay, deviationy);
        return corelation;
    }

    public double findmean(double[] X_X) {
        if (X_X.length <= 0) {
            return 0.0;
        }
        DoubleArrayList dat = new DoubleArrayList(X_X);
        double mean = Descriptive.mean(dat);
        return mean;
    }

    public double findvariance(double[] X_X) {
        if (X_X.length <= 0) {
            return 0.0;
        }
        DoubleArrayList dat = new DoubleArrayList(X_X);
        double sum = Descriptive.sum(dat);
        double sumofsq = Descriptive.sumOfSquares(dat);
        double variance = Descriptive.variance(dat.size(), sum, sumofsq);
        return variance;
    }

    public double findstddev(double[] X_X) {
        double variance = this.findvariance(X_X);
        double stddev = Descriptive.standardDeviation(variance);
        return stddev;
    }

    public double findskew(double[] X_X) {
        if (X_X.length <= 0) {
            return 0.0;
        }
        DoubleArrayList dat = new DoubleArrayList(X_X);
        double mean = this.findmean(X_X);
        double stddev = this.findstddev(X_X);
        double skew = Descriptive.skew(dat, mean, stddev);
        return skew;
    }

    public double findkurtosis(double[] X_X) {
        if (X_X.length <= 0) {
            return 0.0;
        }
        DoubleArrayList dat = new DoubleArrayList(X_X);
        double mean = this.findmean(X_X);
        double stddev = this.findstddev(X_X);
        double kurtosis = Descriptive.kurtosis(dat, mean, stddev);
        return kurtosis;
    }

    public double findmin(double[] X_X) {
        if (X_X.length <= 0) {
            return 0.0;
        }
        DoubleArrayList dat = new DoubleArrayList(X_X);
        double min = Descriptive.min(dat);
        return min;
    }

    public double findmax(double[] X_X) {
        if (X_X.length <= 0) {
            return 0.0;
        }
        DoubleArrayList dat = new DoubleArrayList(X_X);
        double max = Descriptive.max(dat);
        return max;
    }

    public double findrange(double[] X_X) {
        if (X_X.length <= 0) {
            return 0.0;
        }
        DoubleArrayList dat = new DoubleArrayList(X_X);
        double max = Descriptive.max(dat);
        double min = Descriptive.min(dat);
        return max - min;
    }

    public int findnoofobservations(double[] X_X) {
        return X_X.length;
    }

    public double findrankcorrelation(double[] XY_X, double[] XY_Y) {
        int k;
        double midrank;
        int count;
        int j;
        double sum;
        double num;
        int i;
        double[] datax = XY_X;
        if (XY_X.length <= 0) {
            return 0.0;
        }
        double[] rankx = new double[datax.length];
        double[] sortx = new double[datax.length];
        for (i = 0; i < datax.length; ++i) {
            sortx[i] = datax[i];
        }
        Arrays.sort(sortx);
        for (i = 0; i < sortx.length; ++i) {
            rankx[i] = i + 1;
        }
        i = 0;
        while (i < sortx.length - 1) {
            num = sortx[i];
            sum = rankx[i];
            j = i + 1;
            count = 1;
            while (num == sortx[j]) {
                ++count;
                sum += rankx[j];
                if (++j != sortx.length) continue;
            }
            midrank = sum / (double)count;
            for (k = j - count; k < j; ++k) {
                rankx[k] = midrank;
            }
            i = j;
        }
        double[] nrankx = new double[rankx.length];
        block5: for (i = 0; i < rankx.length; ++i) {
            for (j = 0; j < rankx.length; ++j) {
                if (datax[i] != sortx[j]) continue;
                nrankx[i] = rankx[j];
                continue block5;
            }
        }
        double[] datay = XY_Y;
        double[] ranky = new double[datay.length];
        double[] sorty = new double[datay.length];
        for (i = 0; i < datay.length; ++i) {
            sorty[i] = datay[i];
        }
        Arrays.sort(sorty);
        for (i = 0; i < sorty.length; ++i) {
            ranky[i] = i + 1;
        }
        i = 0;
        while (i < sorty.length - 1) {
            num = sorty[i];
            sum = ranky[i];
            j = i + 1;
            count = 1;
            while (num == sorty[j]) {
                ++count;
                sum += ranky[j];
                if (++j != sorty.length) continue;
            }
            midrank = sum / (double)count;
            for (k = j - count; k < j; ++k) {
                ranky[k] = midrank;
            }
            i = j;
        }
        double[] nranky = new double[ranky.length];
        block12: for (i = 0; i < ranky.length; ++i) {
            for (j = 0; j < ranky.length; ++j) {
                if (datay[i] != sorty[j]) continue;
                nranky[i] = ranky[j];
                continue block12;
            }
        }
        DoubleArrayList datx = new DoubleArrayList(nrankx);
        double sumx = Descriptive.sum(datx);
        double sumofsquaresx = Descriptive.sumOfSquares(datx);
        double variancex = Descriptive.variance(datx.size(), sumx, sumofsquaresx);
        double deviationx = Descriptive.standardDeviation(variancex);
        DoubleArrayList daty = new DoubleArrayList(nranky);
        double sumy = Descriptive.sum(daty);
        double sumofsquaresy = Descriptive.sumOfSquares(daty);
        double variancey = Descriptive.variance(daty.size(), sumy, sumofsquaresy);
        double deviationy = Descriptive.standardDeviation(variancey);
        double corelation = Descriptive.correlation(datx, deviationx, daty, deviationy);
        return corelation;
    }

    public double findt_linear(double[] XY_X, double[] XY_Y) {
        double cor = this.findlinearcorrelation(XY_X, XY_Y);
        int num = this.findnoofobservations(XY_X);
        double denominator = (1.0 - cor + 1.0E-20) * (1.0 + cor + 1.0E-20);
        double t = cor * Math.sqrt((double)(num - 2) / denominator);
        return t;
    }

    public double findlinearcorprob(double[] XY_X, double[] XY_Y) {
        int num = this.findnoofobservations(XY_X);
        int df = num - 2;
        double t = this.findt_linear(XY_X, XY_Y);
        double prob = this.betai(0.5 * (double)df, 0.5, (double)df / ((double)df + t * t));
        return prob;
    }

    public double findt_rank(double[] XY_X, double[] XY_Y) {
        double cor = this.findrankcorrelation(XY_X, XY_Y);
        int num = this.findnoofobservations(XY_X);
        double denominator = (1.0 - cor) * (1.0 + cor);
        double t = cor * Math.sqrt((double)(num - 2) / denominator);
        return t;
    }

    public double findrankcorprob(double[] XY_X, double[] XY_Y) {
        int num = this.findnoofobservations(XY_X);
        int df = num - 2;
        double t = this.findt_rank(XY_X, XY_Y);
        double prob = this.betai(0.5 * (double)df, 0.5, (double)df / ((double)df + t * t));
        return prob;
    }

    public int getErrorNum() {
        return this.errorNum;
    }

    public double findpartialcorrelation(double[] XYZ_X, double[] XYZ_Y, double[] XYZ_Z) {
        if (XYZ_X.length <= 0 || XYZ_Y.length <= 0 || XYZ_Z.length <= 0) {
            return 0.0;
        }
        DoubleArrayList datax = new DoubleArrayList(XYZ_X);
        double sumx = Descriptive.sum(datax);
        double sumofsquaresx = Descriptive.sumOfSquares(datax);
        double variancex = Descriptive.variance(datax.size(), sumx, sumofsquaresx);
        double deviationx = Descriptive.standardDeviation(variancex);
        DoubleArrayList datay = new DoubleArrayList(XYZ_Y);
        double sumy = Descriptive.sum(datay);
        double sumofsquaresy = Descriptive.sumOfSquares(datay);
        double variancey = Descriptive.variance(datay.size(), sumy, sumofsquaresy);
        double deviationy = Descriptive.standardDeviation(variancey);
        DoubleArrayList dataz = new DoubleArrayList(XYZ_Z);
        double sumz = Descriptive.sum(dataz);
        double sumofsquaresz = Descriptive.sumOfSquares(dataz);
        double variancez = Descriptive.variance(dataz.size(), sumz, sumofsquaresz);
        double deviationz = Descriptive.standardDeviation(variancez);
        double corelationxy = Descriptive.correlation(datax, deviationx, datay, deviationy);
        double corelationyz = Descriptive.correlation(datay, deviationy, dataz, deviationz);
        double corelationxz = Descriptive.correlation(datax, deviationx, dataz, deviationz);
        double val = corelationxz * corelationyz;
        double numerator = corelationxy - val;
        double denominator = Math.sqrt((1.0 - corelationxz * corelationxz) * (1.0 - corelationyz * corelationyz));
        double partialcorelation = numerator / denominator;
        return partialcorelation;
    }

    public double gammln(double xx) {
        double x;
        double[] cof = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
        double y = x = xx;
        double tmp = x + 5.5;
        tmp -= (x + 0.5) * Math.log(tmp);
        double ser = 1.000000000190015;
        for (int j = 0; j <= 5; ++j) {
            ser += cof[j] / (y += 1.0);
        }
        return -tmp + Math.log(2.5066282746310007 * ser / x);
    }

    public double betacf(double a, double b, double x) {
        double h;
        block6: {
            int m;
            double FPMIN = 1.0E-30;
            double EPS = 3.0E-7;
            int MAXIT = 100;
            double qab = a + b;
            double qap = a + 1.0;
            double qam = a - 1.0;
            double c = 1.0;
            double d = 1.0 - qab * x / qap;
            if (Math.abs(d) < FPMIN) {
                d = FPMIN;
            }
            h = d = 1.0 / d;
            for (m = 1; m <= MAXIT; ++m) {
                int m2 = 2 * m;
                double aa = (double)m * (b - (double)m) * x / ((qam + (double)m2) * (a + (double)m2));
                if (Math.abs(d = 1.0 + aa * d) < FPMIN) {
                    d = FPMIN;
                }
                if (Math.abs(c = 1.0 + aa / c) < FPMIN) {
                    c = FPMIN;
                }
                d = 1.0 / d;
                h *= d * c;
                aa = -(a + (double)m) * (qab + (double)m) * x / ((a + (double)m2) * (qap + (double)m2));
                if (Math.abs(d = 1.0 + aa * d) < FPMIN) {
                    d = FPMIN;
                }
                if (Math.abs(c = 1.0 + aa / c) < FPMIN) {
                    c = FPMIN;
                }
                d = 1.0 / d;
                double del = d * c;
                h *= del;
                if (Math.abs(del - 1.0) < EPS) break;
            }
            if (m <= MAXIT) break block6;
            this.errorNum = 2;
        }
        return h;
    }

    public double betai(double a, double b, double x) {
        double bt;
        if (x < 0.0 || x > 1.0) {
            this.errorNum = 1;
        }
        if (x == 0.0 || x == 1.0) {
            bt = 0.0;
        } else {
            double result1 = this.gammln(a + b);
            double result2 = this.gammln(a);
            double result3 = this.gammln(b);
            bt = Math.exp(result1 - result2 - result3 + a * Math.log(x) + b * Math.log(1.0 - x));
        }
        if (x < (a + 1.0) / (a + b + 2.0)) {
            return bt * this.betacf(a, b, x) / a;
        }
        return 1.0 - bt * this.betacf(b, a, 1.0 - x) / b;
    }

    void printArray(double[] x) {
    }
}

