/*
 * Decompiled with CFR 0.152.
 */
package com.jvt.exprparser;

import com.jvt.exprparser.ExpressionEvalException;
import com.jvt.exprparser.Expression_Parser;
import com.jvt.exprparser.Expression_ParserTreeConstants;
import com.jvt.exprparser.Node;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected Expression_Parser parser;
    private Boolean trueObject = new Boolean(true);
    private Boolean falseObject = new Boolean(false);
    private static final double _LOG10SCALE = 1.0 / Math.log(10.0);
    public String nodeVal;
    public byte m_nodeType;

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(Expression_Parser p, int i) {
        this(i);
        this.parser = p;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        return Expression_ParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(prefix))).append(this.toString()).append(this.m_nodeType)));
    }

    public void dump(String prefix) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n == null) continue;
                n.dump(String.valueOf(String.valueOf(prefix)).concat(" "));
            }
        }
    }

    public void value(String image) {
        this.nodeVal = image;
    }

    public void setType(byte type) {
        this.m_nodeType = type;
    }

    public Object eval() throws ExpressionEvalException {
        switch (this.id) {
            case 0: {
                SimpleNode node1 = (SimpleNode)this.children[0];
                Object obj1 = node1.eval();
                return obj1;
            }
            case 2: {
                SimpleNode node1 = (SimpleNode)this.children[0];
                Boolean b1 = (Boolean)node1.eval();
                if (b1.booleanValue()) {
                    return this.trueObject;
                }
                SimpleNode node2 = (SimpleNode)this.children[1];
                return (Boolean)node2.eval();
            }
            case 3: {
                SimpleNode node1 = (SimpleNode)this.children[0];
                Boolean b1 = (Boolean)node1.eval();
                if (!b1.booleanValue()) {
                    return this.falseObject;
                }
                SimpleNode node2 = (SimpleNode)this.children[1];
                Boolean b2 = (Boolean)node2.eval();
                if (!b2.booleanValue()) {
                    return this.falseObject;
                }
                return this.trueObject;
            }
            case 16: {
                SimpleNode node1 = (SimpleNode)this.children[0];
                Boolean b1 = (Boolean)node1.eval();
                if (!b1.booleanValue()) {
                    return this.trueObject;
                }
                return this.falseObject;
            }
            case 4: {
                Timestamp ts2;
                Timestamp ts1;
                Date dt2;
                Date dt1;
                String s2;
                String s1;
                Number n2;
                Number n1;
                SimpleNode Temp;
                SimpleNode node1 = (SimpleNode)this.children[0];
                SimpleNode node2 = (SimpleNode)this.children[1];
                if (node1.m_nodeType < 8) {
                    if (node1.m_nodeType < node2.m_nodeType) {
                        Temp = node1;
                        node1 = node2;
                        node2 = Temp;
                    }
                    n1 = (Number)node1.eval();
                    n2 = (Number)node2.eval();
                    switch (node1.m_nodeType) {
                        case 1: {
                            if (n1.byteValue() == n2.byteValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 2: {
                            if (n1.shortValue() == n2.shortValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 3: {
                            if (n1.intValue() == n2.intValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 4: {
                            if (n1.longValue() == n2.longValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 5: {
                            if (n1.floatValue() == n2.floatValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 6: {
                            if (n1.doubleValue() == n2.doubleValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 7: {
                            BigDecimal op1 = new BigDecimal(n1.toString());
                            BigDecimal op2 = new BigDecimal(n2.toString());
                            if (op1.compareTo(op2) == 0) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                    }
                }
                if (node1.m_nodeType == 9) {
                    s1 = (String)node1.eval();
                    if (s1.compareTo(s2 = (String)node2.eval()) == 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
                if (node1.m_nodeType == 11) {
                    dt1 = (Date)node1.eval();
                    if (dt1.compareTo(dt2 = (Date)node1.eval()) == 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
                if (node1.m_nodeType == 12) {
                    ts1 = (Timestamp)node1.eval();
                    if (((Date)ts1).compareTo(ts2 = (Timestamp)node1.eval()) == 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
            }
            case 5: {
                Timestamp ts2;
                Timestamp ts1;
                Date dt2;
                Date dt1;
                String s2;
                String s1;
                Number n2;
                Number n1;
                SimpleNode Temp;
                SimpleNode node1 = (SimpleNode)this.children[0];
                SimpleNode node2 = (SimpleNode)this.children[1];
                if (node1.m_nodeType < 8) {
                    if (node1.m_nodeType < node2.m_nodeType) {
                        Temp = node1;
                        node1 = node2;
                        node2 = Temp;
                    }
                    n1 = (Number)node1.eval();
                    n2 = (Number)node2.eval();
                    switch (node1.m_nodeType) {
                        case 1: {
                            if (n1.byteValue() != n2.byteValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 2: {
                            if (n1.shortValue() != n2.shortValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 3: {
                            if (n1.intValue() != n2.intValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 4: {
                            if (n1.longValue() != n2.longValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 5: {
                            if (n1.floatValue() != n2.floatValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 6: {
                            if (n1.doubleValue() != n2.doubleValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 7: {
                            BigDecimal op1 = new BigDecimal(n1.toString());
                            BigDecimal op2 = new BigDecimal(n2.toString());
                            if (op1.compareTo(op2) != 0) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                    }
                }
                if (node1.m_nodeType == 9) {
                    s1 = (String)node1.eval();
                    if (s1.compareTo(s2 = (String)node2.eval()) != 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
                if (node1.m_nodeType == 11) {
                    dt1 = (Date)node1.eval();
                    if (dt1.compareTo(dt2 = (Date)node1.eval()) != 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
                if (node1.m_nodeType == 12) {
                    ts1 = (Timestamp)node1.eval();
                    if (((Date)ts1).compareTo(ts2 = (Timestamp)node1.eval()) != 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
            }
            case 6: {
                Timestamp ts2;
                Timestamp ts1;
                Date dt2;
                Date dt1;
                String s2;
                String s1;
                Number n2;
                Number n1;
                SimpleNode Temp;
                SimpleNode node1 = (SimpleNode)this.children[0];
                SimpleNode node2 = (SimpleNode)this.children[1];
                if (node1.m_nodeType < 8) {
                    if (node1.m_nodeType < node2.m_nodeType) {
                        Temp = node1;
                        node1 = node2;
                        node2 = Temp;
                    }
                    n1 = (Number)node1.eval();
                    n2 = (Number)node2.eval();
                    switch (node1.m_nodeType) {
                        case 1: {
                            if (n1.byteValue() < n2.byteValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 2: {
                            if (n1.shortValue() < n2.shortValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 3: {
                            if (n1.intValue() < n2.intValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 4: {
                            if (n1.longValue() < n2.longValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 5: {
                            if (n1.floatValue() < n2.floatValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 6: {
                            if (n1.doubleValue() < n2.doubleValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 7: {
                            BigDecimal op1 = new BigDecimal(n1.toString());
                            BigDecimal op2 = new BigDecimal(n2.toString());
                            if (op1.compareTo(op2) < 0) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                    }
                }
                if (node1.m_nodeType == 9) {
                    s1 = (String)node1.eval();
                    if (s1.compareTo(s2 = (String)node2.eval()) < 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
                if (node1.m_nodeType == 11) {
                    dt1 = (Date)node1.eval();
                    if (dt1.compareTo(dt2 = (Date)node1.eval()) < 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
                if (node1.m_nodeType == 12) {
                    ts1 = (Timestamp)node1.eval();
                    if (((Date)ts1).compareTo(ts2 = (Timestamp)node1.eval()) < 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
            }
            case 7: {
                Timestamp ts2;
                Timestamp ts1;
                Date dt2;
                Date dt1;
                String s2;
                String s1;
                Number n2;
                Number n1;
                SimpleNode Temp;
                SimpleNode node1 = (SimpleNode)this.children[0];
                SimpleNode node2 = (SimpleNode)this.children[1];
                if (node1.m_nodeType < 8) {
                    if (node1.m_nodeType < node2.m_nodeType) {
                        Temp = node1;
                        node1 = node2;
                        node2 = Temp;
                    }
                    n1 = (Number)node1.eval();
                    n2 = (Number)node2.eval();
                    switch (node1.m_nodeType) {
                        case 1: {
                            if (n1.byteValue() > n2.byteValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 2: {
                            if (n1.shortValue() > n2.shortValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 3: {
                            if (n1.intValue() > n2.intValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 4: {
                            if (n1.longValue() > n2.longValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 5: {
                            if (n1.floatValue() > n2.floatValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 6: {
                            if (n1.doubleValue() > n2.doubleValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 7: {
                            BigDecimal op1 = new BigDecimal(n1.toString());
                            BigDecimal op2 = new BigDecimal(n2.toString());
                            if (op1.compareTo(op2) > 0) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                    }
                }
                if (node1.m_nodeType == 9) {
                    s1 = (String)node1.eval();
                    if (s1.compareTo(s2 = (String)node2.eval()) > 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
                if (node1.m_nodeType == 11) {
                    dt1 = (Date)node1.eval();
                    if (dt1.compareTo(dt2 = (Date)node1.eval()) > 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
                if (node1.m_nodeType == 12) {
                    ts1 = (Timestamp)node1.eval();
                    if (((Date)ts1).compareTo(ts2 = (Timestamp)node1.eval()) > 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
            }
            case 8: {
                Timestamp ts2;
                Timestamp ts1;
                Date dt2;
                Date dt1;
                String s2;
                String s1;
                Number n2;
                Number n1;
                SimpleNode Temp;
                SimpleNode node1 = (SimpleNode)this.children[0];
                SimpleNode node2 = (SimpleNode)this.children[1];
                if (node1.m_nodeType < 8) {
                    if (node1.m_nodeType < node2.m_nodeType) {
                        Temp = node1;
                        node1 = node2;
                        node2 = Temp;
                    }
                    n1 = (Number)node1.eval();
                    n2 = (Number)node2.eval();
                    switch (node1.m_nodeType) {
                        case 1: {
                            if (n1.byteValue() <= n2.byteValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 2: {
                            if (n1.shortValue() <= n2.shortValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 3: {
                            if (n1.intValue() <= n2.intValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 4: {
                            if (n1.longValue() <= n2.longValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 5: {
                            if (n1.floatValue() <= n2.floatValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 6: {
                            if (n1.doubleValue() <= n2.doubleValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 7: {
                            BigDecimal op1 = new BigDecimal(n1.toString());
                            BigDecimal op2 = new BigDecimal(n2.toString());
                            if (op1.compareTo(op2) <= 0) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                    }
                }
                if (node1.m_nodeType == 9) {
                    s1 = (String)node1.eval();
                    if (s1.compareTo(s2 = (String)node2.eval()) <= 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
                if (node1.m_nodeType == 11) {
                    dt1 = (Date)node1.eval();
                    if (dt1.compareTo(dt2 = (Date)node1.eval()) <= 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
                if (node1.m_nodeType == 12) {
                    ts1 = (Timestamp)node1.eval();
                    if (((Date)ts1).compareTo(ts2 = (Timestamp)node1.eval()) <= 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
            }
            case 9: {
                Timestamp ts2;
                Timestamp ts1;
                Date dt2;
                Date dt1;
                String s2;
                String s1;
                Number n2;
                Number n1;
                SimpleNode Temp;
                SimpleNode node1 = (SimpleNode)this.children[0];
                SimpleNode node2 = (SimpleNode)this.children[1];
                if (node1.m_nodeType < 8) {
                    if (node1.m_nodeType < node2.m_nodeType) {
                        Temp = node1;
                        node1 = node2;
                        node2 = Temp;
                    }
                    n1 = (Number)node1.eval();
                    n2 = (Number)node2.eval();
                    switch (node1.m_nodeType) {
                        case 1: {
                            if (n1.byteValue() >= n2.byteValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 2: {
                            if (n1.shortValue() >= n2.shortValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 3: {
                            if (n1.intValue() >= n2.intValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 4: {
                            if (n1.longValue() >= n2.longValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 5: {
                            if (n1.floatValue() >= n2.floatValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 6: {
                            if (n1.doubleValue() >= n2.doubleValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 7: {
                            BigDecimal op1 = new BigDecimal(n1.toString());
                            BigDecimal op2 = new BigDecimal(n2.toString());
                            if (op1.compareTo(op2) >= 0) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                    }
                }
                if (node1.m_nodeType == 9) {
                    s1 = (String)node1.eval();
                    if (s1.compareTo(s2 = (String)node2.eval()) >= 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
                if (node1.m_nodeType == 11) {
                    dt1 = (Date)node1.eval();
                    if (dt1.compareTo(dt2 = (Date)node1.eval()) >= 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
                if (node1.m_nodeType == 12) {
                    ts1 = (Timestamp)node1.eval();
                    if (((Date)ts1).compareTo(ts2 = (Timestamp)node1.eval()) >= 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
            }
            case 14: {
                SimpleNode node1 = (SimpleNode)this.children[0];
                SimpleNode node2 = (SimpleNode)this.children[1];
                Number obj1 = (Number)node1.eval();
                Number obj2 = (Number)node2.eval();
                int op1 = obj1.intValue();
                int op2 = obj2.intValue();
                return new Integer(op1 % op2);
            }
            case 10: {
                Number n2;
                Number n1;
                Object Temp;
                Object node1 = (SimpleNode)this.children[0];
                Object node2 = (SimpleNode)this.children[1];
                if (((SimpleNode)node1).m_nodeType < 8) {
                    if (((SimpleNode)node1).m_nodeType < ((SimpleNode)node2).m_nodeType) {
                        Temp = node1;
                        node1 = node2;
                        node2 = Temp;
                    }
                    n1 = (Number)((SimpleNode)node1).eval();
                    n2 = (Number)((SimpleNode)node2).eval();
                    switch (((SimpleNode)node1).m_nodeType) {
                        case 1: {
                            return new Byte((byte)(n1.byteValue() + n2.byteValue()));
                        }
                        case 2: {
                            return new Short((short)(n1.shortValue() + n2.shortValue()));
                        }
                        case 3: {
                            return new Integer(n1.intValue() + n2.intValue());
                        }
                        case 4: {
                            return new Long(n1.longValue() + n2.longValue());
                        }
                        case 5: {
                            return new Float(n1.floatValue() + n2.floatValue());
                        }
                        case 6: {
                            return new Double(n1.doubleValue() + n2.doubleValue());
                        }
                        case 7: {
                            BigDecimal op1 = new BigDecimal(n1.toString());
                            BigDecimal op2 = new BigDecimal(n2.toString());
                            return op1.add(op2);
                        }
                    }
                }
                if (((SimpleNode)node1).m_nodeType == 9) {
                    String s1 = (String)((SimpleNode)node1).eval();
                    String s2 = (String)((SimpleNode)node2).eval();
                    return String.valueOf(String.valueOf(s1)).concat(String.valueOf(String.valueOf(s2)));
                }
            }
            case 11: {
                Object Temp;
                Object node1 = (SimpleNode)this.children[0];
                Object node2 = (SimpleNode)this.children[1];
                if (((SimpleNode)node1).m_nodeType < ((SimpleNode)node2).m_nodeType) {
                    Temp = node1;
                    node1 = node2;
                    node2 = Temp;
                }
                Number n1 = (Number)((SimpleNode)node1).eval();
                Number n2 = (Number)((SimpleNode)node2).eval();
                switch (((SimpleNode)node1).m_nodeType) {
                    case 1: {
                        return new Byte((byte)(n1.byteValue() - n2.byteValue()));
                    }
                    case 2: {
                        return new Short((short)(n1.shortValue() - n2.shortValue()));
                    }
                    case 3: {
                        return new Integer(n1.intValue() - n2.intValue());
                    }
                    case 4: {
                        return new Long(n1.longValue() - n2.longValue());
                    }
                    case 5: {
                        return new Float(n1.floatValue() - n2.floatValue());
                    }
                    case 6: {
                        return new Double(n1.doubleValue() - n2.doubleValue());
                    }
                    case 7: {
                        BigDecimal op1 = new BigDecimal(n1.toString());
                        BigDecimal op2 = new BigDecimal(n2.toString());
                        return op1.subtract(op2);
                    }
                }
            }
            case 12: {
                Object Temp;
                Object node1 = (SimpleNode)this.children[0];
                Object node2 = (SimpleNode)this.children[1];
                if (((SimpleNode)node1).m_nodeType < ((SimpleNode)node2).m_nodeType) {
                    Temp = node1;
                    node1 = node2;
                    node2 = Temp;
                }
                Number n1 = (Number)((SimpleNode)node1).eval();
                Number n2 = (Number)((SimpleNode)node2).eval();
                switch (((SimpleNode)node1).m_nodeType) {
                    case 1: {
                        return new Byte((byte)(n1.byteValue() * n2.byteValue()));
                    }
                    case 2: {
                        return new Short((short)(n1.shortValue() * n2.shortValue()));
                    }
                    case 3: {
                        return new Integer(n1.intValue() * n2.intValue());
                    }
                    case 4: {
                        return new Long(n1.longValue() * n2.longValue());
                    }
                    case 5: {
                        return new Float(n1.floatValue() * n2.floatValue());
                    }
                    case 6: {
                        return new Double(n1.doubleValue() * n2.doubleValue());
                    }
                    case 7: {
                        BigDecimal op1 = new BigDecimal(n1.toString());
                        BigDecimal op2 = new BigDecimal(n2.toString());
                        return op1.multiply(op2);
                    }
                }
            }
            case 13: {
                Object Temp;
                Object node1 = (SimpleNode)this.children[0];
                Object node2 = (SimpleNode)this.children[1];
                if (((SimpleNode)node1).m_nodeType < ((SimpleNode)node2).m_nodeType) {
                    Temp = node1;
                    node1 = node2;
                    node2 = Temp;
                }
                Number n1 = (Number)((SimpleNode)node1).eval();
                Number n2 = (Number)((SimpleNode)node2).eval();
                switch (((SimpleNode)node1).m_nodeType) {
                    case 1: {
                        return new Byte((byte)(n1.byteValue() / n2.byteValue()));
                    }
                    case 2: {
                        return new Short((short)(n1.shortValue() / n2.shortValue()));
                    }
                    case 3: {
                        return new Integer(n1.intValue() / n2.intValue());
                    }
                    case 4: {
                        return new Long(n1.longValue() / n2.longValue());
                    }
                    case 5: {
                        return new Float(n1.floatValue() / n2.floatValue());
                    }
                    case 6: {
                        return new Double(n1.doubleValue() / n2.doubleValue());
                    }
                    case 7: {
                        BigDecimal op1 = new BigDecimal(n1.toString());
                        BigDecimal op2 = new BigDecimal(n2.toString());
                        return op1.divide(op2, 5, 4);
                    }
                }
            }
            case 15: {
                Object node1 = (SimpleNode)this.children[0];
                Number n1 = (Number)((SimpleNode)node1).eval();
                switch (((SimpleNode)node1).m_nodeType) {
                    case 1: {
                        return new Byte((byte)(n1.byteValue() * -1));
                    }
                    case 2: {
                        return new Short((short)(n1.shortValue() * -1));
                    }
                    case 3: {
                        return new Integer(n1.intValue() * -1);
                    }
                    case 4: {
                        return new Long(n1.longValue() * (long)-1);
                    }
                    case 5: {
                        return new Float(n1.floatValue() * (float)-1);
                    }
                    case 6: {
                        return new Double(n1.doubleValue() * (double)-1);
                    }
                    case 7: {
                        BigDecimal op1 = new BigDecimal(n1.toString());
                        return op1.negate();
                    }
                }
            }
            case 37: {
                Object node1;
                try {
                    node1 = new Integer(this.nodeVal);
                    return node1;
                }
                catch (NumberFormatException nfe) {
                    throw new ExpressionEvalException(nfe.toString());
                }
            }
            case 38: {
                try {
                    Double nfe = new Double(this.nodeVal);
                    return nfe;
                }
                catch (NumberFormatException nfe) {
                    throw new ExpressionEvalException(nfe.toString());
                }
            }
            case 17: {
                SimpleNode node = (SimpleNode)this.children[0];
                Object obj = node.eval();
                double num = ((Number)obj).doubleValue();
                return new Double(Math.abs(num));
            }
            case 18: {
                SimpleNode node = (SimpleNode)this.children[0];
                Object obj = node.eval();
                double num = ((Number)obj).doubleValue();
                return new Double(Math.exp(num));
            }
            case 19: {
                SimpleNode node = (SimpleNode)this.children[0];
                Object obj = node.eval();
                double num = ((Number)obj).doubleValue();
                return new Double(Math.pow(10.0, num));
            }
            case 20: {
                if (this.jjtGetNumChildren() == 1) {
                    SimpleNode node = (SimpleNode)this.children[0];
                    Object obj = node.eval();
                    double num = ((Number)obj).doubleValue();
                    return new Double(Math.ceil(num));
                }
                SimpleNode node = (SimpleNode)this.children[0];
                SimpleNode CeilConstNode = (SimpleNode)this.children[1];
                Object obj = node.eval();
                Object CeilConstobj = CeilConstNode.eval();
                double num = ((Number)obj).doubleValue();
                double CeilConst = ((Number)CeilConstobj).doubleValue();
                return new Double(Math.min(num, CeilConst));
            }
            case 21: {
                if (this.jjtGetNumChildren() == 1) {
                    SimpleNode node = (SimpleNode)this.children[0];
                    Object obj = node.eval();
                    double num = ((Number)obj).doubleValue();
                    return new Double(Math.floor(num));
                }
                SimpleNode node = (SimpleNode)this.children[0];
                SimpleNode FloorConstNode = (SimpleNode)this.children[1];
                Object obj = node.eval();
                Object FloorConstobj = FloorConstNode.eval();
                double num = ((Number)obj).doubleValue();
                double FloorConst = ((Number)FloorConstobj).doubleValue();
                return new Double(Math.max(num, FloorConst));
            }
            case 22: {
                SimpleNode node = (SimpleNode)this.children[0];
                Object obj = node.eval();
                double num = ((Number)obj).doubleValue();
                return new Double(Math.log(num) * _LOG10SCALE);
            }
            case 23: {
                SimpleNode node = (SimpleNode)this.children[0];
                Object obj = node.eval();
                double num = ((Number)obj).doubleValue();
                return new Double(Math.log(num));
            }
            case 24: {
                SimpleNode baseNode = (SimpleNode)this.children[0];
                SimpleNode powNode = (SimpleNode)this.children[1];
                Object baseObj = baseNode.eval();
                Object powObj = powNode.eval();
                double baseNum = ((Number)baseObj).doubleValue();
                double powNum = ((Number)powObj).doubleValue();
                return new Double(Math.pow(baseNum, powNum));
            }
            case 25: {
                return new Double(Math.random());
            }
            case 26: {
                SimpleNode node = (SimpleNode)this.children[0];
                Object obj = node.eval();
                double num = ((Number)obj).doubleValue();
                return new Double(Math.round(num));
            }
            case 27: {
                SimpleNode node = (SimpleNode)this.children[0];
                Object obj = node.eval();
                double num = ((Number)obj).doubleValue();
                return new Double(Math.sqrt(num));
            }
            case 28: {
                SimpleNode node = (SimpleNode)this.children[0];
                Object obj = node.eval();
                double num = ((Number)obj).doubleValue();
                return new Double(Math.acos(num));
            }
            case 29: {
                SimpleNode node = (SimpleNode)this.children[0];
                Object obj = node.eval();
                double num = ((Number)obj).doubleValue();
                return new Double(Math.asin(num));
            }
            case 30: {
                SimpleNode node = (SimpleNode)this.children[0];
                Object obj = node.eval();
                double num = ((Number)obj).doubleValue();
                return new Double(Math.atan(num));
            }
            case 31: {
                SimpleNode baseNode = (SimpleNode)this.children[0];
                SimpleNode powNode = (SimpleNode)this.children[1];
                Object baseObj = baseNode.eval();
                Object powObj = powNode.eval();
                double baseNum = ((Number)baseObj).doubleValue();
                double powNum = ((Number)powObj).doubleValue();
                return new Double(Math.atan2(baseNum, powNum));
            }
            case 32: {
                SimpleNode node = (SimpleNode)this.children[0];
                Object obj = node.eval();
                double num = ((Number)obj).doubleValue();
                return new Double(Math.cos(num));
            }
            case 33: {
                SimpleNode node = (SimpleNode)this.children[0];
                Object obj = node.eval();
                double num = ((Number)obj).doubleValue();
                return new Double(Math.sin(num));
            }
            case 34: {
                SimpleNode node = (SimpleNode)this.children[0];
                Object obj = node.eval();
                double num = ((Number)obj).doubleValue();
                return new Double(Math.tan(num));
            }
            case 35: {
                SimpleNode node = (SimpleNode)this.children[0];
                Object obj = node.eval();
                double num = ((Number)obj).doubleValue();
                return new Double(Math.toRadians(num));
            }
            case 36: {
                SimpleNode node = (SimpleNode)this.children[0];
                Object obj = node.eval();
                double num = ((Number)obj).doubleValue();
                return new Double(Math.toDegrees(num));
            }
        }
        throw new ExpressionEvalException("Invalid operator");
    }

    private boolean isNumber(int type) {
        switch (type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private boolean isString(int type) {
        switch (type) {
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private boolean isBoolean(int type) {
        switch (type) {
            case -7: {
                return true;
            }
        }
        return false;
    }

    private String operatorToString(int op) {
        switch (op) {
            case 10: {
                return new String("+");
            }
            case 11: {
                return new String("-");
            }
            case 12: {
                return new String("*");
            }
            case 13: {
                return new String("/");
            }
            case 14: {
                return new String("%");
            }
            case 15: {
                return new String("(-)");
            }
            case 7: {
                return new String(">");
            }
            case 6: {
                return new String("<");
            }
            case 8: {
                return new String(">=");
            }
            case 9: {
                return new String("<=");
            }
            case 4: {
                return new String("==");
            }
            case 5: {
                return new String("!=");
            }
            case 3: {
                return new String("&&");
            }
            case 2: {
                return new String("||");
            }
            case 16: {
                return new String("!");
            }
            case 17: {
                return new String("Abs");
            }
            case 18: {
                return new String("Exp");
            }
            case 20: {
                return new String("Ceil");
            }
            case 21: {
                return new String("Floor");
            }
            case 22: {
                return new String("Log");
            }
            case 24: {
                return new String("Pow");
            }
            case 25: {
                return new String("Random");
            }
            case 26: {
                return new String("Round");
            }
            case 27: {
                return new String("Sqrt");
            }
            case 23: {
                return new String("Ln");
            }
            case 19: {
                return new String("Dexp");
            }
            case 28: {
                return new String("Acos");
            }
            case 29: {
                return new String("Asin");
            }
            case 30: {
                return new String("Atan");
            }
            case 31: {
                return new String("Atan2");
            }
            case 32: {
                return new String("Cos");
            }
            case 33: {
                return new String("Sin");
            }
            case 34: {
                return new String("Tan");
            }
            case 35: {
                return new String("toRadian");
            }
            case 36: {
                return new String("toDegree");
            }
        }
        return null;
    }
}

