/*
 * Decompiled with CFR 0.152.
 */
package com.jvt.applets;

class Projections {
    private double pi = 2.0 * Math.asin(1.0);
    private int itern = 30;
    private double tol = 1.0E-7;
    private double alfa0b50 = 282.25 * this.pi / (double)180;
    private double dl0b50 = 33.0 * this.pi / (double)180;
    private double delngp = 27.4 * this.pi / 180.0;
    private Double[] xproj;
    private Double[] yproj;

    Projections() {
    }

    public static void main(String[] args) {
        double[] RA = new double[]{0.01, 0.02, 0.08, 0.1, 0.11, 0.13, 0.2, 0.21};
        double[] DEC = new double[]{-2.63, 1.99, 1.16, 2.53, 2.76, -39.81, -17.73, -26.33};
        Double[] RAdeg = new Double[RA.length + 1];
        Double[] DECdeg = new Double[DEC.length + 1];
        for (int i = 0; i < RA.length; ++i) {
            RAdeg[i] = new Double(RA[i]);
            DECdeg[i] = new Double(DEC[i]);
        }
        RAdeg[RA.length] = null;
        DECdeg[RA.length] = null;
        Projections p = new Projections();
        p.sinu(RAdeg, DECdeg);
        Double[] xproj = p.getxproj();
        Double[] yproj = p.getyproj();
        System.out.println("Galactic Longitude \t Galactic Latitude");
        for (int i = 0; i < RAdeg.length; ++i) {
            if (xproj[i] == null || yproj[i] == null) continue;
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(xproj[i]))).append("\t").append(yproj[i]))));
        }
    }

    public void simpleprojection(Double[] RAdeg, Double[] DECdeg) {
        int nrows = RAdeg.length;
        this.xproj = new Double[nrows];
        this.yproj = new Double[nrows];
        for (int i = 0; i < nrows; ++i) {
            if (RAdeg[i] == null || DECdeg[i] == null) {
                this.xproj[i] = null;
                this.yproj[i] = null;
                continue;
            }
            double deldel = Math.sin(DECdeg[i] * this.pi / (double)180) * Math.sin(this.delngp);
            double delalfa = Math.cos(DECdeg[i] * this.pi / (double)180) * Math.cos(this.delngp) * Math.sin(RAdeg[i] * this.pi / (double)180 - this.alfa0b50);
            this.yproj[i] = new Double(Math.asin(deldel - delalfa) * (double)180 / this.pi);
            double parta = Math.cos(this.delngp) * Math.tan(DECdeg[i] * this.pi / (double)180) / Math.cos(RAdeg[i] * this.pi / (double)180 - this.alfa0b50);
            double partb = Math.tan(RAdeg[i] * this.pi / (double)180 - this.alfa0b50) * Math.sin(this.delngp);
            this.xproj[i] = new Double((Math.atan(parta + partb) + this.dl0b50) * (double)180 / this.pi);
        }
    }

    public void projmoll(Double[] RAdeg, Double[] DECdeg) {
        int i;
        int nrows = RAdeg.length;
        Double[] dlrad = new Double[nrows];
        Double[] brad = new Double[nrows];
        for (i = 0; i < nrows; ++i) {
            if (RAdeg[i] == null || DECdeg[i] == null) {
                brad[i] = null;
                dlrad[i] = null;
                continue;
            }
            double deldel = Math.sin(DECdeg[i] * this.pi / (double)180) * Math.sin(this.delngp);
            double delalfa = Math.cos(DECdeg[i] * this.pi / (double)180) * Math.cos(this.delngp) * Math.sin(RAdeg[i] * this.pi / (double)180 - this.alfa0b50);
            brad[i] = new Double(Math.asin(deldel - delalfa));
            double parta = Math.cos(this.delngp) * Math.tan(DECdeg[i] * this.pi / (double)180) / Math.cos(RAdeg[i] * this.pi / (double)180 - this.alfa0b50);
            double partb = Math.tan(RAdeg[i] * this.pi / (double)180 - this.alfa0b50) * Math.sin(this.delngp);
            dlrad[i] = new Double(Math.atan(parta + partb) + this.dl0b50);
        }
        this.xproj = new Double[nrows];
        this.yproj = new Double[nrows];
        for (i = 0; i < nrows; ++i) {
            if (brad[i] == null || dlrad[i] == null) {
                this.xproj[i] = null;
                this.yproj[i] = null;
                continue;
            }
            double phi = brad[i];
            double theta = this.newtonraphson(phi);
            this.xproj[i] = new Double(2.0 * Math.sqrt(2.0) * (dlrad[i] - this.dl0b50) * Math.cos(theta) / this.pi * (double)180 / this.pi);
            this.yproj[i] = new Double(Math.sqrt(2.0) * Math.sin(theta) * (double)180 / this.pi);
        }
    }

    public void aitoff(Double[] RAdeg, Double[] DECdeg) {
        int i;
        int nrows = RAdeg.length;
        Double[] dlrad = new Double[nrows];
        Double[] brad = new Double[nrows];
        for (i = 0; i < nrows; ++i) {
            if (RAdeg[i] == null || DECdeg[i] == null) {
                brad[i] = null;
                dlrad[i] = null;
                continue;
            }
            double deldel = Math.sin(DECdeg[i] * this.pi / (double)180) * Math.sin(this.delngp);
            double delalfa = Math.cos(DECdeg[i] * this.pi / (double)180) * Math.cos(this.delngp) * Math.sin(RAdeg[i] * this.pi / (double)180 - this.alfa0b50);
            brad[i] = new Double(Math.asin(deldel - delalfa));
            double parta = Math.cos(this.delngp) * Math.tan(DECdeg[i] * this.pi / (double)180) / Math.cos(RAdeg[i] * this.pi / (double)180 - this.alfa0b50);
            double partb = Math.tan(RAdeg[i] * this.pi / (double)180 - this.alfa0b50) * Math.sin(this.delngp);
            dlrad[i] = new Double(Math.atan(parta + partb) + this.dl0b50);
        }
        this.xproj = new Double[nrows];
        this.yproj = new Double[nrows];
        for (i = 0; i < nrows; ++i) {
            if (brad[i] == null || dlrad[i] == null) {
                this.xproj[i] = null;
                this.yproj[i] = null;
                continue;
            }
            double t_ha = Math.sqrt(2.0 / (1.0 + Math.cos(brad[i]) * Math.cos(dlrad[i] * 0.5)));
            this.xproj[i] = new Double(2.0 * t_ha * Math.cos(brad[i]) * Math.sin(0.5 * dlrad[i]) * (double)180 / this.pi);
            this.yproj[i] = new Double(t_ha * Math.sin(brad[i]) * (double)180 / this.pi);
        }
    }

    public void merc(Double[] RAdeg, Double[] DECdeg) {
        int i;
        int nrows = RAdeg.length;
        Double[] dlrad = new Double[nrows];
        Double[] brad = new Double[nrows];
        for (i = 0; i < nrows; ++i) {
            if (RAdeg[i] == null || DECdeg[i] == null) {
                brad[i] = null;
                dlrad[i] = null;
                continue;
            }
            double deldel = Math.sin(DECdeg[i] * this.pi / (double)180) * Math.sin(this.delngp);
            double delalfa = Math.cos(DECdeg[i] * this.pi / (double)180) * Math.cos(this.delngp) * Math.sin(RAdeg[i] * this.pi / (double)180 - this.alfa0b50);
            brad[i] = new Double(Math.asin(deldel - delalfa));
            double parta = Math.cos(this.delngp) * Math.tan(DECdeg[i] * this.pi / (double)180) / Math.cos(RAdeg[i] * this.pi / (double)180 - this.alfa0b50);
            double partb = Math.tan(RAdeg[i] * this.pi / (double)180 - this.alfa0b50) * Math.sin(this.delngp);
            dlrad[i] = new Double(Math.atan(parta + partb) + this.dl0b50);
        }
        this.xproj = new Double[nrows];
        this.yproj = new Double[nrows];
        for (i = 0; i < nrows; ++i) {
            if (brad[i] == null || dlrad[i] == null) {
                this.xproj[i] = null;
                this.yproj[i] = null;
                continue;
            }
            this.xproj[i] = new Double((dlrad[i] - this.dl0b50) * (double)180 / this.pi);
            this.yproj[i] = new Double(0.5 * Math.log((1.0 + Math.sin(brad[i])) / (1.0 - Math.sin(brad[i]))) * (double)180 / this.pi);
        }
    }

    public void sinu(Double[] RAdeg, Double[] DECdeg) {
        int i;
        int nrows = RAdeg.length;
        Double[] dlrad = new Double[nrows];
        Double[] brad = new Double[nrows];
        for (i = 0; i < nrows; ++i) {
            if (RAdeg[i] == null || DECdeg[i] == null) {
                brad[i] = null;
                dlrad[i] = null;
                continue;
            }
            double deldel = Math.sin(DECdeg[i] * this.pi / (double)180) * Math.sin(this.delngp);
            double delalfa = Math.cos(DECdeg[i] * this.pi / (double)180) * Math.cos(this.delngp) * Math.sin(RAdeg[i] * this.pi / (double)180 - this.alfa0b50);
            brad[i] = new Double(Math.asin(deldel - delalfa));
            double parta = Math.cos(this.delngp) * Math.tan(DECdeg[i] * this.pi / (double)180) / Math.cos(RAdeg[i] * this.pi / (double)180 - this.alfa0b50);
            double partb = Math.tan(RAdeg[i] * this.pi / (double)180 - this.alfa0b50) * Math.sin(this.delngp);
            dlrad[i] = new Double(Math.atan(parta + partb) + this.dl0b50);
        }
        this.xproj = new Double[nrows];
        this.yproj = new Double[nrows];
        for (i = 0; i < nrows; ++i) {
            if (brad[i] == null || dlrad[i] == null) {
                this.xproj[i] = null;
                this.yproj[i] = null;
                continue;
            }
            this.xproj[i] = new Double((dlrad[i] - this.dl0b50) * Math.cos(brad[i]) * (double)180 / this.pi);
            this.yproj[i] = new Double(brad[i] * (double)180 / this.pi);
        }
    }

    public double newtonraphson(double phi) {
        double tht0 = 2.0 * Math.asin(2.0 * phi / this.pi);
        double tht1 = 0.0;
        int itcnt = 1;
        boolean iflag = false;
        while (!iflag) {
            double deno;
            iflag = true;
            tht1 = tht0 - this.func(tht0, phi) / this.grad(tht0);
            double dnum = Math.abs(tht1 - tht0);
            if (!(dnum / (deno = Math.abs(tht1)) > this.tol) || itcnt >= this.itern) continue;
            iflag = false;
            tht0 = tht1;
            ++itcnt;
        }
        return tht1;
    }

    public double func(double theta, double phi) {
        double tht2 = 2.0 * theta;
        return tht2 + Math.sin(tht2) - this.pi * Math.sin(phi);
    }

    public double grad(double theta) {
        double tht2 = 2.0 * theta;
        return 2.0 * (1.0 + Math.cos(tht2));
    }

    public Double[] getxproj() {
        int nrows = this.xproj.length;
        for (int i = 0; i < nrows; ++i) {
            if (this.xproj[i] == null) continue;
            this.xproj[i] = new Double(Math.cos(this.yproj[i] * this.pi / (double)180) * this.xproj[i]);
        }
        return this.xproj;
    }

    public Double[] getyproj() {
        return this.yproj;
    }
}

