/*
 * Decompiled with CFR 0.152.
 */
package com.jvt.applets;

import cds.aladin.Aladin;
import cds.tools.ExtApp;
import com.jvt.applets.ColumnInfo;
import com.jvt.applets.CoordinateSystems;
import com.jvt.applets.PlotApplication;
import com.jvt.applets.PlotButtons;
import com.jvt.applets.UserSystemInformation;
import com.jvt.applets.VOPlotExternalApps;
import com.jvt.utils.JVTUtil;
import com.jvt.votable.Column;
import com.jvt.votable.DataDisplayColumn;
import com.jvt.votable.PlotColumn;
import com.jvt.votable.PlotData;
import com.jvt.votable.PlotFilter;
import com.jvt.votable.SAVOTParser;
import com.jvt.votable.VOTableMetaData;
import com.jvt.votable.VOTableWriter;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import netscape.javascript.JSObject;
import ptolemy.plot.Histogram;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;
import ptolemy.plot.PlotBoxProperties;
import ptolemy.plot.PlotFilterDialog;
import ptolemy.plot.PlotInfo;
import ptolemy.plot.PlotPoint;
import ptolemy.plot.PlotTransformerDialog;
import vowrite.VOTable;
import vowrite.VOTableResource;
import vowrite.VOTableTable;

public class PlotVOApplet
extends JApplet
implements ExtApp,
VOPlotExternalApps {
    private Container _container = null;
    public static final String FILENAME = "filename";
    public static final String SERVLETPATH = "servletpath";
    public static final String VOTABLEPATH = "votablepath";
    public static final String PARAMETERS = "parameters";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String BACKGROUND = "background";
    public static final String FOREGROUND = "foreground";
    public static final String DATAURL = "dataurl";
    public static final String SAVE_EPS_URL = "saveEPS";
    public static final String SESSION_ID = "sessionid";
    public static final String HELP_URL = "userguideURL";
    public static String SCRIPT_NAME;
    public static String HTTP_HOST;
    private int _numColumns = 0;
    public static JFrame voplotFrame;
    private ArrayList _plotDataList = new ArrayList();
    private ArrayList _votableMetaDataList = new ArrayList();
    private int _currentPlotDataIndex = -1;
    private double _binwidth;
    private String _xunit = new String();
    private String _yunit = new String();
    private String _xucd = new String();
    private String _yucd = new String();
    private boolean _usedAsWebApp = false;
    private Color _background = Color.white;
    private Color _foreground = Color.black;
    private int _width;
    private int _height;
    private boolean _histogram = false;
    private ArrayList _colsPlotted;
    private JSObject _mainWindow;
    PlotApplication plotApp;
    private int _dataSet = -1;
    private ArrayList _plotDataOverlayIndexList = new ArrayList();
    public static final int PLOT = 0;
    public static final int HISTOGRAM = 1;
    public static final String HIST_Y_LABEL = "Data Points";
    public static final int VOTABLE_TEXT_INPUT_WIDTH = 25;
    public static final int APPLET_WIDTH = 840;
    public static final int APPLET_HEIGHT = 550;
    public static final int APPLET_SUB_APP_WIDTH = 670;
    public static final int APPLET_SUB_APP_HEIGHT = 500;
    public static final String BACKGROUND_COLOR = "#faf0e6";
    private boolean _redrawingHistogram = false;
    private boolean _firstHistogram = false;
    private int _currentPlotType = 0;
    private HashSet _selectedPointOIds = new HashSet();
    private HashSet _highlightedPoints = new HashSet();
    private ExtApp _extApp = null;
    private String _filterApplied = "All";
    private PlotBoxProperties _prop;
    private CoordinateSystems coosys;
    private PlotButtons _buttons = new PlotButtons();
    public static String[] _errorMsg;
    private static PlotBox _plot;
    private boolean _connected;
    private boolean _impulses;
    private boolean _color;
    private boolean _grid;
    private boolean _yincrement;
    private String _marker;
    private boolean _isSubApp = false;
    private static boolean _invokeAladin;
    boolean APPLET_PROPERTIES = false;
    private double errorX = 0.0;
    private double errorY = 0.0;

    public String getAppletInfo() {
        return "PlotVOApplet : A votable data plotter.\nDeveloped by Persistent Systems and IUCAA in association with CDS \n as part of Virtual Observatory India initiative.\n($Id: PlotVOApplet.java,v 1.136 2003/11/19 07:10:55 balaji Exp $)";
    }

    public String[][] getParameterInfo() {
        String[][] pinfo = new String[][]{{FILENAME, "string", "100"}, {SERVLETPATH, "string", "100"}, {VOTABLEPATH, "string", "100"}, {PARAMETERS, "string", "100"}, {WIDTH, "integer", "100"}, {HEIGHT, "integer", "100"}, {BACKGROUND, "hexcolor value", "background color"}, {HELP_URL, "url", "100"}};
        return pinfo;
    }

    public void init() {
        super.init();
        PlotVOApplet.printVOPlotInfo();
        this.setAsWebApp(true);
    }

    public void setPlotApplication(PlotApplication app) {
        this.plotApp = app;
    }

    public void systemInfo() {
        String SYSTEM_INFO = "";
        String LOG_URL = "";
        String OS_NAME = System.getProperty("os.name");
        String OS_ARCH = System.getProperty("os.arch");
        String OS_VERSION = System.getProperty("os.version");
        String JAVA_VERSION = System.getProperty("java.version");
        String JAVA_VENDOR = System.getProperty("java.vendor");
        this.APPLET_PROPERTIES = true;
        SYSTEM_INFO = String.valueOf(String.valueOf(new StringBuffer("APPLET_PROPERTIES = ").append(this.APPLET_PROPERTIES).append("&").append("OS_NAME=").append(OS_NAME).append("&").append("OS_ARCH=").append(OS_ARCH).append("&").append("OS_VERSION=").append(OS_VERSION).append("&").append("JAVA_VERSION=").append(JAVA_VERSION).append("&").append("JAVA_VENDOR=").append(JAVA_VENDOR)));
        HTTP_HOST = this.getParameter("http_host");
        SCRIPT_NAME = this.getParameter("script_name");
        LOG_URL = String.valueOf(String.valueOf(new StringBuffer("http://").append(HTTP_HOST).append(SCRIPT_NAME).append("?").append(URLEncoder.encode(SYSTEM_INFO))));
        new UserSystemInformation(LOG_URL);
    }

    public void start() {
        if (_plot == null) {
            _plot = new Plot();
            this._currentPlotType = 0;
            _plot.setVOApplet(this, this._buttons);
            this.setDefaultPlotProperties();
            Plot plot = (Plot)PlotVOApplet.plot();
            plot.setTitle("NO VOTABLE LOADED");
            this.applyPlotProperties(plot);
            this._selectedPointOIds.clear();
        }
        this._colsPlotted = new ArrayList();
        this.coosys = new CoordinateSystems();
        if (this.isSubApp()) {
            this._width = 670;
            this._height = 500;
        } else {
            this._width = 840;
            this._height = 625;
        }
        String _colorspec = BACKGROUND_COLOR;
        if (_colorspec != null) {
            this._background = PlotBox.getColorByName(_colorspec);
        }
        if (this.isWebApp() && !this.isSubApp()) {
            this.readParameters();
            this.readData();
            this._mainWindow = JSObject.getWindow((Applet)this);
        }
        this._container = this.getContentPane();
        this._buttons.init(this._container, this._background, this);
        this.setUpPlotBox();
        this._dataSet = -1;
        this._prop = new PlotBoxProperties();
        if (this.isWebApp()) {
            this.plotDefaultColumns();
        }
    }

    public void destroy() {
        JVTUtil.SHOW_DATA = true;
        JVTUtil.SHOW_VOTABLE = true;
    }

    public static void printVOPlotInfo() {
        System.out.println("----------------------------------------------");
        System.out.println("VOPlot (VOTable Plotting tool) Version 1.2.1 \n");
        System.out.println("VOPlot is developed by Persistent Systems, Pune and");
        System.out.println("IUCAA in association with CDS as a part of the");
        System.out.println("Virtual Observatory India initiative. ");
        System.out.println("---------------------------------------------- \n");
    }

    public int setAsSubApplication(boolean subApp) {
        this._isSubApp = subApp;
        return 1;
    }

    public int setInvokeAladin(boolean invokeAladin) {
        _invokeAladin = invokeAladin;
        return 1;
    }

    public int getNumOfColumns() {
        PlotData pd = this.getCurrentPlotData();
        this._numColumns = pd == null ? 0 : pd.getNumOfPlotColumns();
        return this._numColumns;
    }

    public PlotData getCurrentPlotData() {
        if (this._currentPlotDataIndex >= 0 && this._currentPlotDataIndex < this._plotDataList.size()) {
            return (PlotData)this._plotDataList.get(this._currentPlotDataIndex);
        }
        return null;
    }

    public int getNumOfPlotData() {
        return this._plotDataList.size();
    }

    public boolean setCurrentPlotDataIndex(int index) {
        if (index >= 0 || index < this._plotDataList.size()) {
            this._currentPlotDataIndex = index;
            return true;
        }
        return false;
    }

    public void clearPlotData() {
        this._plotDataList.clear();
        this._votableMetaDataList.clear();
        this._currentPlotDataIndex = -1;
    }

    public int addVOTableMetaData(VOTableMetaData metaData) {
        this._votableMetaDataList.add(metaData);
        return this._votableMetaDataList.size() - 1;
    }

    public void resetCurrentPlotData(PlotData pd) {
        if (this._currentPlotDataIndex < 0 || this._currentPlotDataIndex > this._plotDataList.size()) {
            this._plotDataList.add(pd);
            this._currentPlotDataIndex = this._plotDataList.size() - 1;
        } else {
            this._plotDataList.set(this._currentPlotDataIndex, pd);
        }
    }

    public int setPlotDataAsCurrent(PlotData pd) {
        this._plotDataList.add(pd);
        this._currentPlotDataIndex = this._plotDataList.size() - 1;
        return this._currentPlotDataIndex;
    }

    public int getCurrentPlotDataIndex() {
        return this._currentPlotDataIndex;
    }

    public int getAppletHeight() {
        return this._height;
    }

    public int getAppletWidth() {
        return this._width;
    }

    public Color getBackColor() {
        return this._background;
    }

    public Color getForeColor() {
        return this._foreground;
    }

    public ArrayList getSelectedPointsIndex() {
        ArrayList selectedPointsList = this.getIndexesForOIds(this._selectedPointOIds);
        return selectedPointsList;
    }

    public ArrayList getHighlightedPointsIndex() {
        ArrayList highLightedPointsList = this.getIndexesForOIds(this._highlightedPoints);
        return highLightedPointsList;
    }

    public ArrayList getIndexesForOIds(HashSet oids) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        DataDisplayColumn ddc = this.getCurrentPlotData().getObjectIDColumn();
        if (oids == null || ddc == null || oids.size() <= 0) {
            return indexes;
        }
        Iterator oidsIterator = oids.iterator();
        block0: while (oidsIterator.hasNext()) {
            String oid = (String)oidsIterator.next();
            if (oid == null) continue;
            for (int iddc = 0; iddc < ddc.getNumOfRows(); ++iddc) {
                if (!oid.equals(ddc.getData(iddc))) continue;
                indexes.add(new Integer(iddc));
                continue block0;
            }
        }
        return indexes;
    }

    public String[] getColumnNames() {
        if (this.getCurrentPlotData() == null) {
            return new String[0];
        }
        int numOfCols = this.getCurrentPlotData().getNumOfPlotColumns();
        String[] stringNames = new String[numOfCols];
        for (int i = 0; i < numOfCols; ++i) {
            stringNames[i] = this.getCurrentPlotData().getPlotColumn(i).getName();
        }
        return stringNames;
    }

    public int getColumnIndex(String ColumnName) {
        PlotData pd = this.getCurrentPlotData();
        if (pd == null) {
            return -1;
        }
        int numOfCols = pd.getNumOfPlotColumns();
        for (int i = 0; i < numOfCols; ++i) {
            if (!ColumnName.equals(pd.getPlotColumn(i).getName())) continue;
            return i;
        }
        return -1;
    }

    public String[] getFilterNames() {
        if (this.getCurrentPlotData() == null) {
            return new String[0];
        }
        int numOfFilters = this.getCurrentPlotData().getNumOfFilters();
        String[] stringNames = new String[numOfFilters + 1];
        stringNames[0] = "All";
        for (int i = 0; i < numOfFilters; ++i) {
            stringNames[i + 1] = this.getCurrentPlotData().getPlotFilter(i).getName();
        }
        return stringNames;
    }

    public Double[] getColumnData(int index) {
        Double[] d = new Double[]{};
        PlotColumn pc = this.getCurrentPlotData().getPlotColumn(index);
        if (pc == null) {
            return d;
        }
        return pc.getData();
    }

    public String getColumnUcd(int index) {
        String s = new String();
        PlotColumn pc = this.getCurrentPlotData().getPlotColumn(index);
        if (pc == null) {
            return s;
        }
        return pc.getUCD();
    }

    public String getColumnUnit(int index) {
        String unit = "";
        PlotColumn pc = this.getCurrentPlotData().getPlotColumn(index);
        if (pc == null) {
            return unit;
        }
        unit = pc.getUnit();
        if (unit == null || unit.trim().length() <= 0) {
            unit = "";
            return unit;
        }
        return String.valueOf(String.valueOf(new StringBuffer("[").append(unit).append("]")));
    }

    private boolean[] getFilterData(String filterName) {
        boolean[] data = new boolean[]{};
        for (int i = 0; i < this.getCurrentPlotData().getNumOfFilters(); ++i) {
            PlotFilter pf = this.getCurrentPlotData().getPlotFilter(i);
            if (!filterName.equals(pf.getName())) continue;
            data = pf.getData();
        }
        return data;
    }

    public boolean toOverlay() {
        if (1 == this._currentPlotType) {
            if (this._redrawingHistogram && this._firstHistogram) {
                return false;
            }
            if (this._redrawingHistogram && !this._firstHistogram) {
                return true;
            }
            if (!this._redrawingHistogram) {
                return this._buttons.isOverlaySelected();
            }
        }
        return this._buttons.isOverlaySelected();
    }

    private void readParameters() {
        String widthspec = this.getParameter(WIDTH);
        this._width = widthspec != null ? Integer.parseInt(widthspec) - 140 : 840;
        String heightspec = this.getParameter(HEIGHT);
        this._height = heightspec != null ? Integer.parseInt(heightspec) - 30 : 550;
        String colorspec = this.getParameter(BACKGROUND);
        this._background = colorspec != null ? PlotBox.getColorByName(colorspec) : PlotBox.getColorByName(BACKGROUND_COLOR);
        colorspec = this.getParameter(FOREGROUND);
        if (colorspec != null) {
            this._foreground = PlotBox.getColorByName(colorspec);
        }
    }

    private void readData() {
        String param = this.getParameter(PARAMETERS);
        this.getVOTableData(param);
    }

    public boolean isAladinInvoked() {
        return _invokeAladin;
    }

    public void setAsWebApp(boolean web) {
        this._usedAsWebApp = web;
    }

    public boolean isWebApp() {
        return this._usedAsWebApp;
    }

    public boolean isSubApp() {
        return this._isSubApp;
    }

    public boolean isHistogram() {
        return this._histogram;
    }

    public int getNumPlots() {
        return this._dataSet + 1;
    }

    private void addToHighlightedPoints(String[] oid) {
        this._highlightedPoints.clear();
        if (oid == null) {
            return;
        }
        for (int i = 0; i < oid.length; ++i) {
            this._highlightedPoints.add(oid[i]);
        }
    }

    public boolean deleteSelectedPoints() {
        ArrayList selectedIndices = this.getIndexesForOIds(this._selectedPointOIds);
        PlotData pd = this.getCurrentPlotData();
        for (int i = 0; i < selectedIndices.size(); ++i) {
            int deletePointIndex = (Integer)selectedIndices.get(i);
            pd.deletePointAt(deletePointIndex);
        }
        if (this._currentPlotType == 0) {
            Plot plt = (Plot)PlotVOApplet.plot();
            Vector datasets = plt._points;
            for (int dataset = 0; dataset < datasets.size(); ++dataset) {
                boolean isCurrentPlotData = false;
                int plotDataIndex = (Integer)this._plotDataOverlayIndexList.get(dataset);
                if (plotDataIndex == this._currentPlotDataIndex) {
                    isCurrentPlotData = true;
                }
                Vector points = (Vector)datasets.elementAt(dataset);
                for (int i = 0; i < selectedIndices.size(); ++i) {
                    int deletePointIndex = (Integer)selectedIndices.get(i);
                    PlotPoint plotPoint = (PlotPoint)points.remove(deletePointIndex);
                }
            }
            PlotVOApplet.plot().repaint();
        }
        this._selectedPointOIds.clear();
        return true;
    }

    public void addToSelectedPoints(String[] oid, boolean isClear) {
        if (isClear) {
            this._selectedPointOIds.clear();
            this.clearSelectedPoints(false);
        }
        if (oid == null) {
            return;
        }
        for (int i = 0; i < oid.length; ++i) {
            this._selectedPointOIds.add(oid[i]);
        }
    }

    public void drawPlot(boolean isDefaultPlot) {
        this.drawPlot(isDefaultPlot, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void drawPlot(boolean isDefaultPlot, boolean updateErrorBars) {
        block44: {
            Plot plot;
            block43: {
                int i;
                boolean showErrorBar;
                Double[] errorBarhighY;
                Double[] errorBarlowY;
                DataDisplayColumn oidCol;
                boolean[] filter;
                Double[] dataY;
                Double[] dataX;
                block42: {
                    if (this.getCurrentPlotData() == null) {
                        System.out.println("Error : Cannot draw plot, plot data not found.");
                        return;
                    }
                    try {
                        StringBuffer plotName;
                        boolean redrawLatestDataset;
                        String ylabel;
                        String xlabel;
                        String catName;
                        block41: {
                            JVTUtil.showWaitCursor(this);
                            if (1 == this._currentPlotType) {
                                this.storeHistogramProperties((Histogram)_plot);
                                _plot = new Plot();
                                this._currentPlotType = 0;
                                this.reInitialize();
                                this._prop.clearAll();
                            }
                            plot = (Plot)PlotVOApplet.plot();
                            this._selectedPointOIds.clear();
                            if (this._dataSet == -1) {
                                this.applyPlotProperties(plot);
                            }
                            catName = this.getCurrentPlotData().getCatalogueName();
                            this._histogram = false;
                            dataX = new Double[]{};
                            dataY = new Double[]{};
                            filter = new boolean[]{};
                            this._filterApplied = this._buttons.getSelectedFilter();
                            oidCol = this.getCurrentPlotData().getObjectIDColumn();
                            if (this._filterApplied != "All") {
                                filter = this.getFilterData(this._filterApplied);
                            }
                            String[] colNames = this.getColumnNames();
                            String colX = this._buttons.getSelectedXColumn();
                            String colY = this._buttons.getSelectedYColumn();
                            for (int i2 = 0; i2 < this.getNumOfColumns(); ++i2) {
                                if (colX.equals(colNames[i2])) {
                                    dataX = this.getColumnData(i2);
                                    this._xunit = this.getColumnUnit(i2);
                                    this._xucd = this.getColumnUcd(i2);
                                }
                                if (!colY.equals(colNames[i2])) continue;
                                dataY = this.getColumnData(i2);
                                this._yunit = this.getColumnUnit(i2);
                                this._yucd = this.getColumnUcd(i2);
                            }
                            if (this._buttons.isLogY() && this.showErrorIfNonPositive(this._filterApplied, dataY, 2)) {
                                return;
                            }
                            if (this._buttons.isLogX() && this.showErrorIfNonPositive(this._filterApplied, dataX, 1)) {
                                return;
                            }
                            xlabel = this.generateLabel('x');
                            ylabel = this.generateLabel('y');
                            this.storePlotProperties(plot);
                            redrawLatestDataset = false;
                            if (this.isAlreadyPlotted(this.getCurrentPlotDataIndex(), this._filterApplied, xlabel, ylabel, 0.0, this._buttons.getSelectedCooSysIndex())) {
                                if (this.toOverlay() && updateErrorBars) {
                                    redrawLatestDataset = true;
                                    break block41;
                                } else {
                                    plot.fillPlot();
                                    JVTUtil.showDefaultCursor(this);
                                    return;
                                }
                            }
                            plotName = new StringBuffer();
                            plotName.append(this.getCurrentPlotDataIndex());
                            plotName.append(this._filterApplied).append(" ").append(xlabel).append(" ").append(ylabel).append(0.0).append(this._buttons.getSelectedCooSysIndex());
                            this._colsPlotted.add(plotName.toString());
                        }
                        if (this.toOverlay()) {
                            if (redrawLatestDataset) {
                                plot.clear(this._dataSet);
                            } else {
                                ++this._dataSet;
                            }
                            if (this._dataSet == 1 && !redrawLatestDataset) {
                                String legend = this.getLegendLabel(false, false);
                                plot.clearLegends();
                                plot.addLegend(0, legend);
                            }
                            if (this._dataSet >= 1 && !redrawLatestDataset) {
                                String legendLabel = this.getLegendLabel(true, false);
                                plot.addLegend(this._dataSet, legendLabel);
                            }
                            plot.setTitle(catName);
                            this._plotDataOverlayIndexList.add(new Integer(this._currentPlotDataIndex));
                            if (plot.getXLabel() != null) {
                                plot.setXLabel(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(plot.getXLabel()))).append(", ").append(xlabel))));
                            } else {
                                plot.setXLabel(xlabel);
                            }
                            if (plot.getYLabel() != null) {
                                plot.setYLabel(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(plot.getYLabel()))).append(", ").append(ylabel))));
                            } else {
                                plot.setYLabel(ylabel);
                            }
                            if (this._dataSet > 0) {
                                double[] range = plot.getXRange();
                                plot.setXRange(range[0], range[1]);
                                range = plot.getYRange();
                                plot.setYRange(range[0], range[1]);
                            }
                        } else {
                            _plot.addColorAndMarkerStyle(0);
                            this._dataSet = 0;
                            this._prop.clearAll();
                            this._colsPlotted.clear();
                            this._plotDataOverlayIndexList.clear();
                            this._plotDataOverlayIndexList.add(new Integer(this._currentPlotDataIndex));
                            plotName = new StringBuffer();
                            plotName.append(this.getCurrentPlotDataIndex());
                            plotName.append(this._filterApplied).append(" ").append(xlabel).append(" ").append(ylabel).append(0.0).append(this._buttons.getSelectedCooSysIndex());
                            this._colsPlotted.add(plotName.toString());
                            if (isDefaultPlot) {
                                plot.clear(false);
                            } else {
                                plot.clear(true);
                            }
                            plot.repaint();
                            plot.setXLabel(xlabel);
                            plot.setYLabel(ylabel);
                            plot.setTitle(catName);
                        }
                        this.applyPlotProperties(plot);
                        if (this._buttons.isLogY()) {
                            plot.setYLog(true);
                        } else {
                            plot.setYLog(false);
                        }
                        if (this._buttons.isLogX()) {
                            plot.setXLog(true);
                        } else {
                            plot.setXLog(false);
                        }
                        errorBarlowY = new Double[]{};
                        errorBarhighY = new Double[]{};
                        PlotColumn pc = this.getCurrentPlotData().getPlotColumn(this._buttons.getSelectedYIndex());
                        errorBarlowY = this.getColumnData(pc.getLowerYErrorBarColumnIndex());
                        errorBarhighY = this.getColumnData(pc.getUpperYErrorBarColumnIndex());
                        showErrorBar = pc.getShowErrorBar();
                        if (this._filterApplied != "All") {
                            break block42;
                        }
                        for (i = 0; i < dataX.length; ++i) {
                            if (dataX[i] == null || dataY[i] == null) continue;
                            this.errorY = 0.0;
                            this.errorX = 0.0;
                            if (showErrorBar) {
                                if (errorBarlowY[i] != null) {
                                    this.errorY = errorBarlowY[i];
                                }
                                if (errorBarhighY[i] != null) {
                                    this.errorX = errorBarhighY[i];
                                }
                                plot.addPointWithErrorBars(this._dataSet, dataX[i], dataY[i], dataY[i] + this.errorX, dataY[i] - this.errorY, oidCol.getData(i), true);
                                continue;
                            }
                            plot.addPoint(this._dataSet, dataX[i], dataY[i], oidCol.getData(i), true);
                        }
                        break block43;
                    }
                    catch (Exception ex) {
                        System.out.println("Error while drawing plot.");
                        ex.printStackTrace();
                        break block44;
                    }
                }
                for (i = 0; i < dataX.length; ++i) {
                    if (!filter[i] || dataX[i] == null || dataY[i] == null) continue;
                    this.errorY = 0.0;
                    this.errorX = 0.0;
                    if (showErrorBar) {
                        if (errorBarlowY[i] != null) {
                            this.errorY = errorBarlowY[i];
                        }
                        if (errorBarhighY[i] != null) {
                            this.errorX = errorBarhighY[i];
                        }
                        plot.addPointWithErrorBars(this._dataSet, dataX[i], dataY[i], dataY[i] + this.errorX, dataY[i] - this.errorY, oidCol.getData(i), true);
                        continue;
                    }
                    plot.addPoint(this._dataSet, dataX[i], dataY[i], oidCol.getData(i), true);
                }
            }
            if (this._dataSet == 0) {
                plot.fillPlot();
            }
            String[] oids = new String[this._highlightedPoints.size()];
            Iterator highlightedPtsIterator = this._highlightedPoints.iterator();
            int ipoint = 0;
            while (highlightedPtsIterator.hasNext()) {
                oids[ipoint++] = (String)highlightedPtsIterator.next();
            }
            this.highlightPoints(oids);
            plot.repaint();
            this._prop.setPlotBoxProperties(this, _plot, this._buttons);
            this._prop.addPlotInfo(this._dataSet);
        }
        JVTUtil.showDefaultCursor(this);
    }

    double[] getMinMax(Double[] data) {
        double maxDataPoint = Double.NEGATIVE_INFINITY;
        double minDataPoint = Double.POSITIVE_INFINITY;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == null) continue;
            if (data[i] > maxDataPoint) {
                maxDataPoint = data[i];
            }
            if (!(data[i] < minDataPoint)) continue;
            minDataPoint = data[i];
        }
        double[] minMax = new double[]{minDataPoint, maxDataPoint};
        return minMax;
    }

    double[] getMinMax(Double[] data, boolean[] filter) {
        double maxDataPoint = Double.NEGATIVE_INFINITY;
        double minDataPoint = Double.POSITIVE_INFINITY;
        for (int i = 0; i < data.length; ++i) {
            if (!filter[i] || data[i] == null) continue;
            if (data[i] > maxDataPoint) {
                maxDataPoint = data[i];
            }
            if (!(data[i] < minDataPoint)) continue;
            minDataPoint = data[i];
        }
        double[] minMax = new double[]{minDataPoint, maxDataPoint};
        return minMax;
    }

    public String generateLabel(char axis) {
        String lbl = new String();
        if (axis == 'x') {
            lbl = this._buttons.getSelectedXColumn();
            if (this._buttons.isLogX()) {
                lbl = String.valueOf(String.valueOf(new StringBuffer("log(").append(lbl).append(")")));
            }
            if (this._xunit != null) {
                lbl = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(lbl))).append(" ").append(this._xunit)));
            }
        } else {
            lbl = this._buttons.getSelectedYColumn();
            if (this._buttons.isLogY()) {
                lbl = String.valueOf(String.valueOf(new StringBuffer("log(").append(lbl).append(")")));
            }
            if (this._yunit != null) {
                lbl = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(lbl))).append(" ").append(this._yunit)));
            }
        }
        return lbl;
    }

    boolean isAlreadyPlotted(int plotDataIndex, String filter, String xlabel, String ylabel, double binw, int coosys) {
        if (!this._buttons.isOverlaySelected()) {
            return false;
        }
        StringBuffer str = new StringBuffer();
        str.append(plotDataIndex).append(filter).append(" ").append(xlabel).append(" ").append(ylabel).append(binw).append(coosys);
        for (int i = 0; i < this._colsPlotted.size(); ++i) {
            String label = (String)this._colsPlotted.get(i);
            if (!label.equals(str.toString())) continue;
            return true;
        }
        return false;
    }

    boolean showErrorIfNonPositive(String filter, Double[] data, int msgIndex) {
        if (!this.isColPositive(filter, data)) {
            JVTUtil.showDefaultCursor(this);
            this.showError(_errorMsg[msgIndex]);
            this.repaint();
            return true;
        }
        return false;
    }

    void showError(String msg) {
        JOptionPane.showMessageDialog(null, msg, "Error", 0);
    }

    public void showHelp() {
        try {
            String userGuidePath = this.getParameter(HELP_URL);
            this._mainWindow.eval(String.valueOf(String.valueOf(new StringBuffer("window.open(\"").append(userGuidePath).append("\")"))));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static PlotVOApplet launch() {
        final PlotVOApplet voplot = new PlotVOApplet();
        try {
            try {
                System.getProperty("java.class.path");
                voplot.setAsWebApp(false);
            }
            catch (AccessControlException e) {
                voplot.setAsWebApp(true);
            }
            voplotFrame = new JFrame();
            voplotFrame.setTitle("VOPlot");
            voplot.getContentPane().addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent ce) {
                    Component c = ce.getComponent();
                    int width = c.getWidth();
                    int height = c.getHeight();
                    PlotVOApplet.plot().setSize((int)((double)width * JVTUtil.WIDTH_PERCENTAGE), (int)((double)height * JVTUtil.HEIGHT_PERCENGAGE));
                    PlotVOApplet.plot().repaint();
                }
            });
            JPanel panel = new JPanel();
            panel.add(voplot);
            voplotFrame.getContentPane().add((Component)voplot, "Center");
            voplot.setAsSubApplication(true);
            voplot.start();
            ((Component)voplotFrame).setSize(new Dimension(860, 600));
            ((Component)voplotFrame).setVisible(true);
            ((Frame)voplotFrame).setIconImage(Toolkit.getDefaultToolkit().createImage(voplotFrame.getClass().getResource(String.valueOf(String.valueOf(JVTUtil.SMALL_IMAGE_PATH)).concat("voplotlogo.gif"))));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return voplot;
    }

    public void showVOPlotFrame() {
        try {
            PlotVOApplet _testVOPlot = PlotVOApplet.launch();
            VOTableWriter votableWriter = new VOTableWriter(this);
            ByteArrayOutputStream bytesBuffer = new ByteArrayOutputStream();
            votableWriter.getDataInVOTableFormat(bytesBuffer);
            ByteArrayInputStream is = new ByteArrayInputStream(bytesBuffer.toByteArray());
            _testVOPlot.loadVOTable(this, is);
            this.showPointsInExtApp(this._selectedPointOIds);
        }
        catch (NoClassDefFoundError ex) {
            System.err.println(ex.getMessage());
        }
    }

    private byte[] writeTestVOTable() {
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buf.append("\t<VOTABLE>\n");
        buf.append("\t<DEFINITIONS>\n");
        buf.append("\t  <COOSYS ID=\"J2000\" system=\"eq_FK5\" equinox=\"J2000\"/>\n");
        buf.append("\t</DEFINITIONS>\n");
        buf.append("\t<RESOURCE ID=\"yCat_1200\" name=\"I/200\">\n");
        buf.append("\t  <DESCRIPTION>Lick Northern Proper Motion: NPM1 Ref. Galaxies</DESCRIPTION>\n");
        buf.append("\t  <COOSYS ID=\"B1950\" system=\"eq_FK4\" equinox=\"J1950\"/>\n");
        buf.append("\t  <TABLE ID=\"I_200_npm1rgal\" name=\"I/200/npm1rgal\">\n");
        buf.append("\t  <FIELD name=\"_OID\" ucd=\"ID_NUMBER\" datatype=\"char\" type=\"hidden\">");
        buf.append("\t      </FIELD>\n");
        buf.append("\t  <FIELD name=\"RAB1950\" ucd=\"POS_EQ_RA_MAIN\" datatype=\"char\" arraysize=\"12\" unit=\"&quot;h:m:s&quot;\">");
        buf.append("\t      </FIELD>\n");
        buf.append("\t  <FIELD name=\"DEB1950\" ucd=\"POS_EQ_DEC_MAIN\" datatype=\"char\" arraysize=\"12\" unit=\"&quot;h:m:s&quot;\">");
        buf.append("\t\t</FIELD>\n");
        buf.append("\t\t<DATA><TABLEDATA>\n");
        buf.append("<TR><TD>1</TD><TD>12 20 02.855</TD><TD>+79 01 57.74</TD></TR>\n");
        buf.append("<TR><TD>2</TD><TD>12 20 03.827</TD><TD>+13 59 38.74</TD></TR>\n");
        buf.append("<TR><TD>3</TD><TD>12 20 04.358</TD><TD>-14 00 56.23</TD></TR>\n");
        buf.append("<TR><TD>4</TD><TD>12 20 04.698</TD><TD>+24 21 44.27</TD></TR>\n");
        buf.append("<TR><TD>5</TD><TD>12 20 04.742</TD><TD>+13 43 28.96</TD></TR>\n");
        buf.append("<TR><TD>6</TD><TD>12 20 05.898</TD><TD>-13 34 53.95</TD></TR>\n");
        buf.append("<TR><TD>7</TD><TD>12 20 06.606</TD><TD>+75 06 55.73</TD></TR>\n");
        buf.append("<TR><TD>8</TD><TD>12 20 08.937</TD><TD>+03 25 08.17</TD></TR>\n");
        buf.append("<TR><TD>9</TD><TD>12 20 09.029</TD><TD>+51 25 55.00</TD></TR>\n");
        buf.append("<TR><TD>10</TD><TD>12 20 09.223</TD><TD>+56 51 08.34</TD></TR>\n");
        buf.append("<TR><TD>11</TD><TD>12 20 09.762</TD><TD>+64 10 48.80</TD></TR>\n");
        buf.append("<TR><TD>12</TD><TD>12 20 10.241</TD><TD>-12 14 29.68</TD></TR>\n");
        buf.append("<TR><TD>13</TD><TD>12 20 13.367</TD><TD>-19 33 00.19</TD></TR>\n");
        buf.append("<TR><TD>14</TD><TD>12 20 13.657</TD><TD>+28 00 51.04</TD></TR>\n");
        buf.append("<TR><TD>15</TD><TD>12 20 13.877</TD><TD>+35 38 13.93</TD></TR>\n");
        buf.append("<TR><TD>16</TD><TD>12 20 14.501</TD><TD>+05 53 01.86</TD></TR>\n");
        buf.append("<TR><TD>17</TD><TD>12 20 14.553</TD><TD>+20 02 50.49</TD></TR>\n");
        buf.append("<TR><TD>18</TD><TD>12 20 16.148</TD><TD>+03 22 51.67</TD></TR>\n");
        buf.append("<TR><TD>19</TD><TD>12 20 17.183</TD><TD>+12 51 27.43</TD></TR>\n");
        buf.append("<TR><TD>20</TD><TD>12 20 19.164</TD><TD>+39 17 48.46</TD></TR>\n");
        buf.append("<TR><TD>21</TD><TD>12 20 20.340</TD><TD>-02 23 30.87</TD></TR>\n");
        buf.append("<TR><TD>22</TD><TD>12 20 20.609</TD><TD>+06 06 06.58</TD></TR>\n");
        buf.append("<TR><TD>23</TD><TD>12 20 22.215</TD><TD>+22 43 27.96</TD></TR>\n");
        buf.append("<TR><TD>24</TD><TD>12 20 22.553</TD><TD>+18 56 30.28</TD></TR>\n");
        buf.append("<TR><TD>25</TD><TD>12 20 23.188</TD><TD>+03 01 26.77</TD></TR>\n");
        buf.append("<TR><TD>26</TD><TD>12 20 23.806</TD><TD>+31 27 24.61</TD></TR>\n");
        buf.append("<TR><TD>27</TD><TD>12 20 25.281</TD><TD>+10 49 32.96</TD></TR>\n");
        buf.append("<TR><TD>28</TD><TD>12 20 26.843</TD><TD>-12 56 47.29</TD></TR>\n");
        buf.append("<TR><TD>29</TD><TD>12 20 27.420</TD><TD>-14 03 42.01</TD></TR>\n");
        buf.append("<TR><TD>30</TD><TD>12 20 27.424</TD><TD>+22 54 42.13</TD></TR>\n");
        buf.append("<TR><TD>31</TD><TD>12 20 30.246</TD><TD>+67 08 22.56</TD></TR>\n");
        buf.append("<TR><TD>32</TD><TD>12 20 32.386</TD><TD>+53 52 46.99</TD></TR>\n");
        buf.append("<TR><TD>33</TD><TD>12 20 34.132</TD><TD>+10 53 53.92</TD></TR>\n");
        buf.append("<TR><TD>34</TD><TD>12 20 35.013</TD><TD>+15 47 11.93</TD></TR>\n");
        buf.append("<TR><TD>35</TD><TD>12 20 35.392</TD><TD>-10 45 44.70</TD></TR>\n");
        buf.append("<TR><TD>36</TD><TD>12 20 35.706</TD><TD>-12 55 39.11</TD></TR>\n");
        buf.append("<TR><TD>37</TD><TD>12 20 35.970</TD><TD>-12 36 12.57</TD></TR>\n");
        buf.append("<TR><TD>38</TD><TD>12 20 36.816</TD><TD>-04 46 39.26</TD></TR>\n");
        buf.append("<TR><TD>39</TD><TD>12 20 37.945</TD><TD>+27 10 56.21</TD></TR>\n");
        buf.append("<TR><TD>40</TD><TD>12 20 38.288</TD><TD>+14 37 24.51</TD></TR>\n");
        buf.append("<TR><TD>41</TD><TD>12 20 38.407</TD><TD>-16 24 55.85</TD></TR>\n");
        buf.append("<TR><TD>42</TD><TD>12 20 38.567</TD><TD>+06 20 56.85</TD></TR>\n");
        buf.append("<TR><TD>43</TD><TD>12 20 40.033</TD><TD>+76 14 33.19</TD></TR>\n");
        buf.append("<TR><TD>44</TD><TD>12 20 40.363</TD><TD>+32 25 38.20</TD></TR>\n");
        buf.append("<TR><TD>45</TD><TD>12 20 42.249</TD><TD>-15 50 54.64</TD></TR>\n");
        buf.append("<TR><TD>46</TD><TD>12 20 44.282</TD><TD>+63 29 58.33</TD></TR>\n");
        buf.append("<TR><TD>47</TD><TD>12 20 47.223</TD><TD>-05 24 23.21</TD></TR>\n");
        buf.append("<TR><TD>48</TD><TD>12 20 48.174</TD><TD>+28 25 48.79</TD></TR>\n");
        buf.append("<TR><TD>49</TD><TD>12 20 48.450</TD><TD>-14 05 46.47</TD></TR>\n");
        buf.append("<TR><TD>50</TD><TD>12 20 49.203</TD><TD>+06 19 03.73</TD></TR>\n");
        buf.append("\t\t</TABLEDATA>\n");
        buf.append("\t\t</DATA>\n");
        buf.append("\t\t</TABLE>\n");
        buf.append("\t\t</RESOURCE>\n");
        buf.append("\t\t</VOTABLE>\n");
        String testVOTable = buf.toString();
        return testVOTable.getBytes();
    }

    public int showAladinDialog() {
        try {
            this._extApp = this.isWebApp() ? Aladin.launch((Applet)this) : Aladin.launch();
            this.setInvokeAladin(true);
            VOTableWriter votableWriter = new VOTableWriter(this);
            ByteArrayOutputStream bytesBuffer = new ByteArrayOutputStream();
            votableWriter.getDataInVOTableFormat(bytesBuffer);
            ByteArrayInputStream is = new ByteArrayInputStream(bytesBuffer.toByteArray());
            this._extApp.loadVOTable(this, is);
            this.showPointsInExtApp(this._selectedPointOIds);
            int n = 1;
            return n;
        }
        catch (NoClassDefFoundError exNoClassFound) {
            this.setInvokeAladin(false);
            int n = 0;
            return n;
        }
        catch (Exception ex) {
            System.err.println("Error while launching Aladin ".concat(String.valueOf(String.valueOf(ex.getMessage()))));
            int n = 0;
            return n;
        }
    }

    boolean isColPositive(String _filterApplied, Double[] data) {
        boolean[] filter = new boolean[]{true};
        if (_filterApplied != "All") {
            filter = this.getFilterData(_filterApplied);
            for (int i = 0; i < data.length; ++i) {
                if (!filter[i] || data[i] == null || !(data[i] <= 0.0)) continue;
                return false;
            }
        } else {
            for (int i = 0; i < data.length; ++i) {
                if (data[i] == null || !(data[i] <= 0.0)) continue;
                return false;
            }
        }
        return true;
    }

    private void setDefaultPlotProperties() {
        this._connected = false;
        this._impulses = false;
        this._marker = "various";
        this._grid = true;
        this._color = true;
        this._yincrement = false;
        this._binwidth = 1.0;
    }

    public void applyPlotProperties(Plot plot) {
        plot.setConnected(this._connected);
        plot.setImpulses(this._impulses);
        plot.setMarksStyle(this._marker);
        plot.setGrid(this._grid);
        plot.setColor(this._color);
    }

    public void storePlotProperties(Plot plot) {
        this._connected = plot.getConnected();
        this._impulses = plot.getImpulses();
        this._marker = plot.getMarksStyle();
        this._grid = plot.getGrid();
        this._color = plot.getColor();
    }

    public void applyHistogramProperties(Histogram plot) {
        plot.setGrid(this._grid);
        plot.setColor(this._color);
        plot.setYIncremented(this._yincrement);
    }

    public void storeHistogramProperties(Histogram plot) {
        this._yincrement = plot.isYIncremented();
        this._grid = plot.getGrid();
        this._color = plot.getColor();
    }

    public void drawHistogram(double binw) {
        if (this.getCurrentPlotData() == null) {
            System.out.println("Error : Cannot draw histogram, plot data not found.");
            return;
        }
        JVTUtil.showWaitCursor(this);
        if (this._currentPlotType == 0) {
            Plot pt = (Plot)PlotVOApplet.plot();
            this.applyPlotProperties(pt);
            this.storePlotProperties(pt);
            _plot = new Histogram();
            this._currentPlotType = 1;
            this.reInitialize();
            this._prop.clearAll();
        }
        this._redrawingHistogram = false;
        String colX = this._buttons.getSelectedXColumn();
        String colY = this._buttons.getSelectedYColumn();
        this.drawColHist(this._buttons.getSelectedFilter(), colX, colY);
        JVTUtil.showDefaultCursor(this);
    }

    public void redrawHistograms(double binw) {
        JVTUtil.showWaitCursor(this);
        if (this._currentPlotType == 0) {
            _plot = new Histogram();
            this._currentPlotType = 1;
            this.reInitialize();
        }
        this._redrawingHistogram = true;
        this._binwidth = binw;
        int plotCnt = this._dataSet;
        for (int i = 0; i <= plotCnt; ++i) {
            this._firstHistogram = i == 0;
            PlotInfo info = this._prop.getPlotInfo(i);
            String colX = info.getSelectedXColName();
            String colY = info.getSelectedYColName();
            String filter = info.getSelectedFilterName();
            this.drawColHist(filter, colX, colY);
            this._prop.setPlotBoxProperties(this, _plot, this._buttons);
        }
        JVTUtil.showDefaultCursor(this);
    }

    public void drawColHist(String _filterApplied, String colX, String colY) {
        PlotVOApplet.plot().zoomSelect("Zoom");
        Histogram plot = (Histogram)PlotVOApplet.plot();
        if (this._dataSet == -1) {
            this.applyHistogramProperties(plot);
        }
        boolean[] filter = new boolean[]{};
        if (_filterApplied != "All") {
            filter = this.getFilterData(_filterApplied);
        }
        this._histogram = true;
        Double[] dataX = new Double[]{};
        Double[] dataY = new Double[]{};
        String catName = this.getCurrentPlotData().getCatalogueName();
        String[] colNames = this.getColumnNames();
        for (int i = 0; i < this.getNumOfColumns(); ++i) {
            if (colX.equals(colNames[i])) {
                dataX = this.getColumnData(i);
                this._xunit = this.getColumnUnit(i);
                this._xucd = this.getColumnUcd(i);
            }
            if (!colY.equals(colNames[i])) continue;
            dataY = this.getColumnData(i);
            this._yunit = this.getColumnUnit(i);
            this._yucd = this.getColumnUcd(i);
        }
        if (this._buttons.isLogX() && this.showErrorIfNonPositive(_filterApplied, dataX, 1)) {
            return;
        }
        this.storeHistogramProperties(plot);
        String xlabel = this._redrawingHistogram ? colX : this.generateLabel('x');
        String ylabel = HIST_Y_LABEL;
        if (this._buttons.isLogY()) {
            if (plot.isYIncremented()) {
                ylabel = String.valueOf(String.valueOf(ylabel)).concat("+1");
            }
            ylabel = String.valueOf(String.valueOf(new StringBuffer("log(").append(ylabel).append(")")));
        }
        if (this.isAlreadyPlotted(this.getCurrentPlotDataIndex(), _filterApplied, "", xlabel, this._binwidth, this._buttons.getSelectedCooSysIndex())) {
            plot.fillPlot();
            return;
        }
        StringBuffer plotName = new StringBuffer();
        plotName.append(this.getCurrentPlotDataIndex());
        plotName.append(_filterApplied).append(" ").append(" ").append(xlabel).append(this._binwidth).append(this._buttons.getSelectedCooSysIndex());
        this._colsPlotted.add(plotName.toString());
        if (this.toOverlay()) {
            String legendLabel;
            ++this._dataSet;
            if (this._dataSet == 1) {
                legendLabel = this.getLegendLabel(false, true);
                plot.clearLegends();
                plot.addLegend(0, legendLabel);
            }
            if (this._dataSet >= 1) {
                legendLabel = this.getLegendLabel(true, true);
                plot.addLegend(this._dataSet, legendLabel);
            }
            plot.setTitle(catName);
            if (plot.getXLabel() != null) {
                plot.setXLabel(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(plot.getXLabel()))).append(", ").append(xlabel))));
            } else {
                plot.setXLabel(xlabel);
            }
        } else {
            this._colsPlotted.clear();
            plotName = new StringBuffer();
            plotName.append(this.getCurrentPlotDataIndex());
            plotName.append(_filterApplied).append(" ").append(" ").append(xlabel).append(this._binwidth).append(this._buttons.getSelectedCooSysIndex());
            this._colsPlotted.add(plotName.toString());
            this._dataSet = 0;
            if (!this._redrawingHistogram) {
                this._prop.clearAll();
            }
            plot.clear(true);
            plot.repaint();
            plot.setXLabel(xlabel);
            plot.setTitle(catName);
        }
        plot.setYLabel(ylabel);
        plot.setBinWidth(this._binwidth);
        plot.setBinOffset(this._binwidth / (double)2);
        this.applyHistogramProperties(plot);
        if (this._buttons.isLogY()) {
            plot.setYLog(true);
        } else {
            plot.setYLog(false);
        }
        if (_filterApplied != "All") {
            for (int i = 0; i < dataX.length; ++i) {
                if (!filter[i] || dataX[i] == null) continue;
                if (this._buttons.isLogX()) {
                    plot.addPoint(this._dataSet, Math.log(dataX[i]) * JVTUtil._LOG10SCALE);
                    continue;
                }
                plot.addPoint(this._dataSet, dataX[i]);
            }
        } else {
            for (int i = 0; i < dataX.length; ++i) {
                if (dataX[i] == null) continue;
                if (this._buttons.isLogX()) {
                    plot.addPoint(this._dataSet, Math.log(dataX[i]) * JVTUtil._LOG10SCALE);
                    continue;
                }
                plot.addPoint(this._dataSet, dataX[i]);
            }
        }
        if (this._dataSet == 0) {
            plot.fillPlot();
        }
        if (!this._redrawingHistogram) {
            this._prop.setPlotBoxProperties(this, _plot, this._buttons);
            this._prop.addPlotInfo(this._dataSet);
        }
        plot.repaint();
    }

    public void setUpPlotBox() {
        this._setPlotSize(this._width, this._height);
        this._buttons.setButtons(true, this._background);
        this.setBackground(this._background);
        PlotVOApplet.plot().setBackground(this._background);
        PlotVOApplet.plot().setForeground(this._foreground);
        PlotVOApplet.plot().setVisible(true);
    }

    void setUpPlotBoxSwap() {
        if (this.isWebApp() && !this.isSubApp()) {
            if (this._buttons.displayToolbar()) {
                this._setPlotSize(this._width, this._height);
            } else {
                this._setPlotSize(this._width + 130, this._height);
            }
        } else {
            this._setPlotSize(this._width, this._height);
        }
        this.repaint();
        this.setBackground(this._background);
        PlotVOApplet.plot().setBackground(this._background);
        PlotVOApplet.plot().setForeground(this._foreground);
        PlotVOApplet.plot().setVisible(true);
    }

    private void reInitialize() {
        _plot.setVOApplet(this, this._buttons);
        this._buttons.swapPanels();
        this._dataSet = -1;
        this._colsPlotted.clear();
        this._selectedPointOIds.clear();
    }

    public void selectPointsWithin(boolean isSelected, double lowx, double lowy, double highx, double highy) {
        if (this._currentPlotType == 0) {
            Plot plt = (Plot)PlotVOApplet.plot();
            Vector datasets = plt._points;
            for (int dataset = 0; dataset < datasets.size(); ++dataset) {
                boolean isCurrentPlotData = false;
                int plotDataIndex = (Integer)this._plotDataOverlayIndexList.get(dataset);
                if (plotDataIndex == this._currentPlotDataIndex) {
                    isCurrentPlotData = true;
                }
                Vector points = (Vector)datasets.elementAt(dataset);
                for (int index = 0; index < points.size(); ++index) {
                    PlotPoint pt = (PlotPoint)points.elementAt(index);
                    if (!(pt.x > lowx) || !(pt.x < highx) || !(pt.y > lowy) || !(pt.y < highy)) continue;
                    if (isSelected) {
                        pt.selected = true;
                        if (!isCurrentPlotData) continue;
                        this._selectedPointOIds.add(pt.objectID);
                        continue;
                    }
                    pt.selected = false;
                    if (!isCurrentPlotData) continue;
                    this._selectedPointOIds.remove(pt.objectID);
                }
            }
            this.repaint();
        }
        this.showPointsInExtApp(this._selectedPointOIds);
    }

    private void showPointsInExtApp(HashSet pointsToShow) {
        if (pointsToShow == null) {
            return;
        }
        Iterator iteratorOnPoints = pointsToShow.iterator();
        String[] oids = new String[pointsToShow.size()];
        int indexOId = 0;
        while (iteratorOnPoints.hasNext()) {
            oids[indexOId] = (String)iteratorOnPoints.next();
            ++indexOId;
        }
        if (this._extApp != null) {
            this._extApp.selectVOTableObject(oids);
        }
    }

    private void clearPointsInExtApp() {
        if (this._extApp != null) {
            String[] oids = new String[]{};
            this._extApp.selectVOTableObject(oids);
        }
    }

    public void selectPoints(String[] oid) {
        if (this._currentPlotType == 0 && oid != null) {
            Plot plt = (Plot)PlotVOApplet.plot();
            Vector datasets = plt._points;
            boolean isCurrentPlotData = false;
            for (int dataset = 0; dataset < datasets.size(); ++dataset) {
                isCurrentPlotData = false;
                int plotDataIndex = (Integer)this._plotDataOverlayIndexList.get(dataset);
                if (plotDataIndex == this._currentPlotDataIndex) {
                    isCurrentPlotData = true;
                }
                Vector points = (Vector)datasets.elementAt(dataset);
                block1: for (int index = 0; index < points.size(); ++index) {
                    PlotPoint pt = (PlotPoint)points.elementAt(index);
                    for (int i = 0; i < oid.length; ++i) {
                        if (!isCurrentPlotData || !pt.objectID.equals(oid[i])) continue;
                        pt.selected = true;
                        continue block1;
                    }
                }
            }
            this.repaint();
        }
    }

    public void selectPoints(int[] indices) {
        if (this._currentPlotType == 0 && indices != null) {
            Plot plt = (Plot)PlotVOApplet.plot();
            Vector datasets = plt._points;
            boolean isCurrentPlotData = false;
            for (int dataset = 0; dataset < datasets.size(); ++dataset) {
                isCurrentPlotData = false;
                int plotDataIndex = (Integer)this._plotDataOverlayIndexList.get(dataset);
                if (plotDataIndex == this._currentPlotDataIndex) {
                    isCurrentPlotData = true;
                }
                Vector points = (Vector)datasets.elementAt(dataset);
                block1: for (int index = 0; index < points.size(); ++index) {
                    PlotPoint pt = (PlotPoint)points.elementAt(index);
                    for (int i = 0; i < indices.length; ++i) {
                        if (!isCurrentPlotData || indices[i] != index) continue;
                        pt.selected = true;
                        continue block1;
                    }
                }
            }
            this.repaint();
        }
    }

    public void clearSelectedPoints(boolean shouldClearFromApp) {
        if (this._currentPlotType == 0) {
            this._selectedPointOIds.clear();
            Plot plt = (Plot)PlotVOApplet.plot();
            Vector datasets = plt._points;
            for (int dataset = 0; dataset < datasets.size(); ++dataset) {
                Vector points = (Vector)datasets.elementAt(dataset);
                for (int index = 0; index < points.size(); ++index) {
                    PlotPoint pt = (PlotPoint)points.elementAt(index);
                    pt.selected = false;
                }
            }
            this.repaint();
        }
        if (shouldClearFromApp) {
            this.clearPointsInExtApp();
        }
    }

    public void highlightPoints(int[] indices) {
        if (indices == null) {
            return;
        }
        int i = 0;
        if (this._currentPlotType == 0) {
            Plot plt = (Plot)PlotVOApplet.plot();
            Vector datasets = plt._points;
            for (int dataset = 0; dataset < datasets.size(); ++dataset) {
                Vector points = (Vector)datasets.elementAt(dataset);
                block1: for (int index = 0; index < points.size(); ++index) {
                    PlotPoint pt = (PlotPoint)points.elementAt(index);
                    pt.highlighted = false;
                    for (i = 0; i < indices.length; ++i) {
                        if (index != indices[i]) continue;
                        pt.highlighted = true;
                        continue block1;
                    }
                }
            }
            this.repaint();
        }
    }

    public void highlightPoints(String[] oid) {
        if (oid == null) {
            return;
        }
        int i = 0;
        if (this._currentPlotType == 0) {
            Plot plt = (Plot)PlotVOApplet.plot();
            Vector datasets = plt._points;
            for (int dataset = 0; dataset < datasets.size(); ++dataset) {
                Vector points = (Vector)datasets.elementAt(dataset);
                block1: for (int index = 0; index < points.size(); ++index) {
                    PlotPoint pt = (PlotPoint)points.elementAt(index);
                    pt.highlighted = false;
                    for (i = 0; i < oid.length; ++i) {
                        if (!pt.objectID.equals(oid[i])) continue;
                        pt.highlighted = true;
                        continue block1;
                    }
                }
            }
            this.repaint();
        }
    }

    public void setMarkerStyle(String style) {
        String[] markerStyles = new String[]{"none", "points", "dots", "various"};
        for (int i = 0; i < markerStyles.length; ++i) {
            if (!style.toLowerCase().equals(markerStyles[i])) continue;
            ((Plot)_plot).setMarksStyle(markerStyles[i]);
            return;
        }
        System.out.println("Marker Style not valid : ".concat(String.valueOf(String.valueOf(style))));
    }

    public void writeVOTable(OutputStream opstream) {
        VOTableWriter votableWriter = new VOTableWriter(this);
        ByteArrayOutputStream bytesBuffer = new ByteArrayOutputStream();
        votableWriter.getDataInVOTableFormat(bytesBuffer);
        try {
            opstream.write(bytesBuffer.toByteArray());
        }
        catch (IOException ex) {
            System.out.println("IOException : ".concat(String.valueOf(String.valueOf(ex))));
        }
    }

    public int getSelectedY() {
        return this._buttons.getSelectedYIndex();
    }

    public void addColumn(String name, String unit, String expression) {
        PlotTransformerDialog.addColumn(this, name, unit, expression);
    }

    public void addFilter(String name, String expression) {
        PlotFilterDialog.addFilter(this, name, expression);
    }

    public void setFilter(String name) {
        this._buttons.setSelectedFilter(name);
    }

    public void showFullRange() {
        PlotVOApplet.plot().fillPlot();
    }

    public void resetXY() {
        PlotVOApplet.plot().resetAxes();
    }

    public int getSelectedX() {
        return this._buttons.getSelectedXIndex();
    }

    public void clearAllSelections() {
        this.clearSelectedPoints(true);
    }

    public void unselectPoints(int[] indices) {
        if (this._currentPlotType == 0 && indices != null) {
            Plot plt = (Plot)PlotVOApplet.plot();
            Vector datasets = plt._points;
            boolean isCurrentPlotData = false;
            for (int dataset = 0; dataset < datasets.size(); ++dataset) {
                isCurrentPlotData = false;
                int plotDataIndex = (Integer)this._plotDataOverlayIndexList.get(dataset);
                if (plotDataIndex == this._currentPlotDataIndex) {
                    isCurrentPlotData = true;
                }
                Vector points = (Vector)datasets.elementAt(dataset);
                block1: for (int index = 0; index < points.size(); ++index) {
                    PlotPoint pt = (PlotPoint)points.elementAt(index);
                    for (int i = 0; i < indices.length; ++i) {
                        if (!isCurrentPlotData || indices[i] != index) continue;
                        pt.selected = false;
                        continue block1;
                    }
                }
            }
            this.repaint();
        }
    }

    private void showNoStatus() {
        this.showStatus("");
    }

    public void setPlotData(PlotData newpd) {
        if (!this._buttons.showMultipleCatalogues()) {
            this._dataSet = -1;
        }
        this.setPlotDataAsCurrent(newpd);
        this._buttons.emptyCmbData();
        this._buttons.emptyCmbFilter();
        this._buttons.addFilterItem("All");
        if (this.getCurrentPlotData() != null) {
            this._numColumns = this.getCurrentPlotData().getNumOfPlotColumns();
            String[] fields = this.getColumnNames();
            for (int i = 0; i < this._numColumns; ++i) {
                this._buttons.addDataItem(fields[i]);
            }
        } else {
            this._numColumns = 0;
        }
        if (!this._buttons.showMultipleCatalogues()) {
            PlotVOApplet.plot().clear(true);
        }
        PlotVOApplet.plot().repaint();
    }

    public void setPlotData(PlotData newpd, boolean isFilter) {
        this.resetCurrentPlotData(newpd);
        this._numColumns = this.getCurrentPlotData().getNumOfPlotColumns();
        for (int i = 0; i < this._numColumns; ++i) {
            PlotColumn plotColumn = this.getCurrentPlotData().getPlotColumn(i);
        }
        if (!isFilter) {
            int xindex = this._buttons.getSelectedXIndex();
            int yindex = this._buttons.getSelectedYIndex();
            this._buttons.emptyCmbData();
            for (int i = 0; i < this.getCurrentPlotData().getNumOfPlotColumns(); ++i) {
                PlotColumn pc = this.getCurrentPlotData().getPlotColumn(i);
                this._buttons.addDataItem(pc.getName());
            }
            this._buttons.setSelectedXIndex(xindex);
            this._buttons.setSelectedYIndex(yindex);
        } else {
            int filterIndex = this._buttons.getSelectedFilterIndex();
            this._buttons.emptyCmbFilter();
            this._buttons.addFilterItem("All");
            for (int i = 0; i < this.getCurrentPlotData().getNumOfFilters(); ++i) {
                PlotFilter pf = this.getCurrentPlotData().getPlotFilter(i);
                this._buttons.addFilterItem(pf.getName());
            }
            this._buttons.setSelectedFilterIndex(filterIndex);
        }
        this.coosys = new CoordinateSystems();
    }

    private String getLegendLabel(boolean currentPlot, boolean isHistogram) {
        String colY;
        String colX;
        String filter;
        int catalogueNum = 0;
        boolean attachCatalogueNum = false;
        if (this._plotDataList.size() > 1) {
            attachCatalogueNum = true;
        }
        if (currentPlot) {
            filter = this._buttons.getSelectedFilter();
            colX = this._buttons.getSelectedXColumn();
            colY = this._buttons.getSelectedYColumn();
            int coosys = this._buttons.getSelectedCooSysIndex();
            if (attachCatalogueNum) {
                catalogueNum = this.getCurrentPlotDataIndex() + 1;
            }
        } else {
            PlotInfo pi = this._prop.getPlotInfo(0);
            filter = pi.getSelectedFilterName();
            colX = pi.getSelectedXColName();
            colY = pi.getSelectedYColName();
            int coosys = pi.getCooSysIndex();
            if (attachCatalogueNum) {
                catalogueNum = pi.getCatalogueIndex() + 1;
            }
        }
        StringBuffer legend = new StringBuffer();
        StringBuffer defLabel = new StringBuffer();
        if (attachCatalogueNum && catalogueNum != 0) {
            defLabel.append(JVTUtil.CATALOGUE_SEPARATOR_OPEN).append(catalogueNum).append(JVTUtil.CATALOGUE_SEPARATOR_CLOSE);
        }
        if (isHistogram) {
            defLabel.append(colX);
        } else {
            defLabel.append(colY).append(" : ").append(colX);
        }
        if (filter != "All") {
            legend.append(filter).append("[").append((Object)defLabel).append("]");
        } else {
            legend.append((Object)defLabel);
        }
        return legend.toString();
    }

    private void getVOTableData(String paramList) {
        try {
            String votablePath = this.getParameter(VOTABLEPATH);
            String vourl = String.valueOf(String.valueOf(votablePath)).concat(String.valueOf(String.valueOf(paramList)));
            URL votable = new URL(vourl);
            this.showStatus("Parsing VOTable. Please wait...");
            try {
                SAVOTParser sp = new SAVOTParser(vourl);
                PlotData pd = sp.getPlotData();
                this._plotDataList.clear();
                this.setPlotDataAsCurrent(pd);
                this.setVOTable(sp.getVOTableMetaData());
                this.setResource(sp.getVOTableResourceMetaData());
                this.setTable(sp.getVOTableTableMetaData());
                this.showNoStatus();
            }
            catch (Exception ex) {
                this.showStatus("Error while parsing VOTable.");
                ex.printStackTrace();
            }
            if (this.getCurrentPlotData() == null) {
                this._numColumns = 0;
                this.showError(_errorMsg[0]);
                System.err.println("Error: No Plot Data found in this VOTable.");
            } else {
                this._numColumns = this.getNumOfColumns();
                if (this.getCurrentPlotData().getObjectIDColumn() == null) {
                    this.getCurrentPlotData().generateObjectIDColumn();
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Error while reading votable data : ".concat(String.valueOf(String.valueOf(ex.toString()))));
        }
    }

    public PlotData getPlotData() {
        return this.getCurrentPlotData();
    }

    public PlotData getPlotData(int index) {
        if (index < 0 || index >= this._plotDataList.size()) {
            return null;
        }
        return (PlotData)this._plotDataList.get(index);
    }

    public VOTable getVOTable() {
        PlotData pd = this.getCurrentPlotData();
        if (pd != null && pd.getVOTableMetaData() != null) {
            return pd.getVOTableMetaData().getVOTable();
        }
        return null;
    }

    public VOTableResource getResource() {
        PlotData pd = this.getCurrentPlotData();
        if (pd != null && pd.getVOTableMetaData() != null) {
            return pd.getVOTableMetaData().getResource();
        }
        return null;
    }

    public VOTableTable getTable() {
        PlotData pd = this.getCurrentPlotData();
        if (pd != null && pd.getVOTableMetaData() != null) {
            return pd.getVOTableMetaData().getTable();
        }
        return null;
    }

    public void setVOTable(VOTable votable) {
        PlotData pd = this.getCurrentPlotData();
        if (pd != null) {
            VOTableMetaData metaData = pd.getVOTableMetaData();
            if (metaData == null) {
                metaData = new VOTableMetaData();
            }
            metaData.setVOTable(votable);
            pd.setVOTableMetaData(metaData);
        }
    }

    public void setResource(VOTableResource resource) {
        PlotData pd = this.getCurrentPlotData();
        if (pd != null) {
            VOTableMetaData metaData = pd.getVOTableMetaData();
            if (metaData == null) {
                metaData = new VOTableMetaData();
            }
            metaData.setResource(resource);
            pd.setVOTableMetaData(metaData);
        }
    }

    public void setTable(VOTableTable table) {
        PlotData pd = this.getCurrentPlotData();
        if (pd != null) {
            VOTableMetaData metaData = pd.getVOTableMetaData();
            if (metaData == null) {
                metaData = new VOTableMetaData();
            }
            metaData.setTable(table);
            pd.setVOTableMetaData(metaData);
        }
    }

    public static PlotBox plot() {
        return _plot;
    }

    public void plotDefaultColumns() {
        try {
            int colX = this.getDefaultPlotCol(0);
            if (-1 == colX) {
                this.drawPlot(true);
                return;
            }
            int colY = this.getDefaultPlotCol(colX + 1);
            if (-1 == colY) {
                colY = colX;
            }
            this._buttons.setSelectedXIndex(colX);
            this._buttons.setSelectedYIndex(colY);
            this.drawPlot(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void plotAsPreviouslySelected(int previousPlotIndex, int colXIndex, int colYIndex) {
        if (!this._buttons.isOverlaySelected()) {
            this.setDefaultPlotProperties();
            this._buttons.setOverlaySelected(true);
        }
        if (previousPlotIndex >= 0 && previousPlotIndex < this._plotDataList.size()) {
            PlotData previousPlotData = (PlotData)this._plotDataList.get(previousPlotIndex);
            PlotColumn previousColX = previousPlotData.getPlotColumn(colXIndex);
            PlotColumn previousColY = previousPlotData.getPlotColumn(colYIndex);
            PlotData pd = this.getCurrentPlotData();
            int colX_UCDIndex = -1;
            int colY_UCDIndex = -1;
            int colX_NameIndex = -1;
            int colY_NameIndex = -1;
            for (int iPlotCol = 0; iPlotCol < pd.getNumOfPlotColumns(); ++iPlotCol) {
                PlotColumn pc = pd.getPlotColumn(iPlotCol);
                if (colX_UCDIndex == -1 && pc.getUCD().equals(previousColX.getUCD())) {
                    colX_UCDIndex = iPlotCol;
                }
                if (colY_UCDIndex == -1 && pc.getUCD().equals(previousColY.getUCD())) {
                    colY_UCDIndex = iPlotCol;
                }
                if (colX_NameIndex == -1 && pc.getName().equals(previousColX.getName())) {
                    colX_NameIndex = iPlotCol;
                }
                if (colY_NameIndex != -1 || !pc.getName().equals(previousColY.getName())) continue;
                colY_NameIndex = iPlotCol;
            }
            int currentColX = colX_UCDIndex;
            int currentColY = colY_UCDIndex;
            if (-1 == currentColX) {
                currentColX = colX_NameIndex;
            }
            if (-1 == currentColY) {
                currentColY = colY_NameIndex;
            }
            if (-1 == currentColX) {
                currentColX = this.getDefaultPlotCol(0);
            }
            if (-1 == currentColY) {
                if (currentColX == -1) {
                    this.drawPlot(true);
                    return;
                }
                currentColY = this.getDefaultPlotCol(currentColX + 1);
            }
            this._buttons.setSelectedXIndex(currentColX);
            this._buttons.setSelectedYIndex(currentColY);
            this.drawPlot(true);
        } else {
            this.plotDefaultColumns();
        }
    }

    private int getDefaultPlotCol(int startIndex) {
        int defaultColIndex = -1;
        if (this.getCurrentPlotData() == null || this.getCurrentPlotData().getNumOfPlotColumns() == 0) {
            return defaultColIndex;
        }
        for (int index = startIndex; index < this.getCurrentPlotData().getNumOfPlotColumns(); ++index) {
            PlotColumn pc = this.getCurrentPlotData().getPlotColumn(index);
            if (pc == null) continue;
            boolean ignoreCol = false;
            String ucd = pc.getUCD();
            if (ucd != null && ucd.length() > 0) {
                int iucd;
                for (iucd = 0; iucd < PlotData.UCD_MATCH.length && !ignoreCol; ++iucd) {
                    if (!PlotData.UCD_MATCH[iucd].equals(ucd)) continue;
                    ignoreCol = true;
                    break;
                }
                for (iucd = 0; iucd < PlotData.UCD_STARTS_WITH.length && !ignoreCol; ++iucd) {
                    if (!ucd.startsWith(PlotData.UCD_STARTS_WITH[iucd])) continue;
                    ignoreCol = true;
                    break;
                }
                for (iucd = 0; iucd < PlotData.UCD_ENDS_WITH.length && !ignoreCol; ++iucd) {
                    if (!ucd.endsWith(PlotData.UCD_ENDS_WITH[iucd])) continue;
                    ignoreCol = true;
                    break;
                }
            } else {
                ignoreCol = true;
            }
            if (ignoreCol) continue;
            return index;
        }
        return defaultColIndex;
    }

    protected void _setPlotSize(int appletWidth, int appletHeight) {
        PlotVOApplet.plot().setSize(appletWidth, appletHeight);
    }

    public static VOPlotExternalApps addVOPlot(JPanel panel) {
        final PlotVOApplet voplot = new PlotVOApplet();
        try {
            try {
                System.getProperty("java.class.path");
                voplot.setAsWebApp(false);
            }
            catch (AccessControlException e) {
                voplot.setAsWebApp(true);
            }
            panel.add(voplot);
            voplot.setAsSubApplication(true);
            voplot.start();
            panel.validate();
            voplot.getContentPane().addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent ce) {
                    voplot.resizePlot();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return voplot;
    }

    public void loadVOTable(InputStream voTableStream, boolean showMultipleVOTables) {
        if (showMultipleVOTables) {
            this._buttons.loadMultipleVOTable(voTableStream);
        } else {
            this._buttons.loadSingleVOTable(voTableStream);
        }
    }

    public void plotColumns(int colXIndex, boolean isLogX, int colYIndex, boolean isLogY, boolean isOverlay) {
        this._buttons.setSelectedXIndex(colXIndex);
        this._buttons.setLogX(isLogX);
        this._buttons.setSelectedYIndex(colYIndex);
        this._buttons.setLogY(isLogY);
        this._buttons.setOverlaySelected(isOverlay);
        this._buttons.drawPlot();
    }

    public void drawHistogram(int colXIndex, boolean isLog, boolean isOverlay) {
        this._buttons.setSelectedXIndex(colXIndex);
        this._buttons.setLogX(isLog);
        this._buttons.setOverlaySelected(isOverlay);
        this._buttons.drawHistogram();
    }

    public void setBinWidth(double binWidth) {
        _plot.redrawHistogram(binWidth);
    }

    public void clear() {
        _plot.clear(true);
        _plot.repaint();
    }

    public void loadData(Vector columnMetaData, Vector data, boolean isMultiple) {
        PlotData pd = new PlotData();
        for (int i = 0; i < columnMetaData.size(); ++i) {
            boolean isNumericColumn;
            Column dataColumn;
            ColumnInfo columnInfo = (ColumnInfo)columnMetaData.get(i);
            if (columnInfo.getDataType().equals("double")) {
                dataColumn = new PlotColumn();
                isNumericColumn = true;
            } else {
                dataColumn = new DataDisplayColumn();
                isNumericColumn = false;
            }
            if (columnInfo.getName() != null) {
                dataColumn.setName(columnInfo.getName());
            } else {
                dataColumn.setName("Column ".concat(String.valueOf(String.valueOf(i))));
            }
            if (columnInfo.getDataType() != null) {
                dataColumn.setDatatype(columnInfo.getDataType());
            } else {
                dataColumn.setDatatype("char");
            }
            if (columnInfo.getUnit() != null) {
                dataColumn.setUnit(columnInfo.getUnit());
            } else {
                dataColumn.setUnit("");
            }
            if (columnInfo.getUCD() != null) {
                dataColumn.setUCD(columnInfo.getUCD());
            } else {
                dataColumn.setUCD("");
            }
            Vector columnDataVector = (Vector)data.get(i);
            for (int j = 0; j < columnDataVector.size(); ++j) {
                if (isNumericColumn) {
                    ((PlotColumn)dataColumn).addData(new Double((String)columnDataVector.get(j)));
                    continue;
                }
                ((DataDisplayColumn)dataColumn).addData((String)columnDataVector.get(j));
            }
            if (isNumericColumn) {
                pd.addPlotColumn((PlotColumn)dataColumn);
                continue;
            }
            pd.addDataDisplayColumn((DataDisplayColumn)dataColumn);
        }
        if (pd.getObjectIDColumn() == null) {
            System.err.println("Error: No object ID column found in VOTable.");
            pd.generateObjectIDColumn();
        }
        if (isMultiple) {
            this._buttons.loadMultipleData(pd);
        } else {
            this._buttons.loadSingleData(pd);
        }
    }

    public void resizePlot() {
        int width = this.getWidth();
        int height = this.getHeight();
        PlotVOApplet.plot().setSize((int)((double)width * JVTUtil.WIDTH_PERCENTAGE), (int)((double)height * JVTUtil.HEIGHT_PERCENGAGE));
        PlotVOApplet.plot().repaint();
        this.validate();
    }

    public void loadVOTable(ExtApp app, InputStream in) {
        try {
            this._extApp = app;
            SAVOTParser savotParser = new SAVOTParser(in);
            PlotData pd = savotParser.getPlotData();
            if (pd == null) {
                this.showError(_errorMsg[0]);
                System.err.println("Error: No plot data found in this VOTable.");
            } else if (pd.getObjectIDColumn() == null) {
                System.err.println("Error: No object ID column found in VOTable.");
                pd.generateObjectIDColumn();
            }
            _plot.clear(true);
            this._highlightedPoints.clear();
            this._selectedPointOIds.clear();
            this.setPlotData(pd);
            this.setVOTable(savotParser.getVOTableMetaData());
            this.setResource(savotParser.getVOTableResourceMetaData());
            this.setTable(savotParser.getVOTableTableMetaData());
            this.plotDefaultColumns();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void showVOTableObject(String[] oid) {
        this.addToHighlightedPoints(oid);
        this.highlightPoints(oid);
    }

    public void selectVOTableObject(String[] oid) {
        this.addToSelectedPoints(oid, true);
        this.selectPoints(oid);
    }

    public String execCommand(String cmd) {
        return null;
    }

    static {
        FILENAME = FILENAME;
        SERVLETPATH = SERVLETPATH;
        VOTABLEPATH = VOTABLEPATH;
        PARAMETERS = PARAMETERS;
        WIDTH = WIDTH;
        HEIGHT = HEIGHT;
        BACKGROUND = BACKGROUND;
        FOREGROUND = FOREGROUND;
        DATAURL = DATAURL;
        SAVE_EPS_URL = SAVE_EPS_URL;
        SESSION_ID = SESSION_ID;
        HELP_URL = HELP_URL;
        SCRIPT_NAME = "script_name";
        HTTP_HOST = "http_host";
        PLOT = 0;
        HISTOGRAM = 1;
        HIST_Y_LABEL = HIST_Y_LABEL;
        VOTABLE_TEXT_INPUT_WIDTH = 25;
        APPLET_WIDTH = 840;
        APPLET_HEIGHT = 550;
        APPLET_SUB_APP_WIDTH = 670;
        APPLET_SUB_APP_HEIGHT = 500;
        BACKGROUND_COLOR = BACKGROUND_COLOR;
        _errorMsg = new String[]{"No valid columns in this VOTable", "Cannot plot non-positive data on logarithmic X axis.", "Cannot plot non-positive data on logarithmic Y axis.", "No numeric data found in VOTable.", ""};
        _invokeAladin = false;
    }
}

