/*
 * Decompiled with CFR 0.152.
 */
package com.jvt.applets;

import com.jvt.applets.AboutDialog;
import com.jvt.applets.PSFilter;
import com.jvt.applets.PlotVOApplet;
import com.jvt.applets.ToolbarButtonProperties;
import com.jvt.applets.VOTableFilter;
import com.jvt.utils.JVTUtil;
import com.jvt.votable.PlotData;
import com.jvt.votable.SAVOTParser;
import com.jvt.votable.VOTableMetaData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import ptolemy.plot.PlotASCIIFormatDisplayDialog;
import ptolemy.plot.PlotBox;
import ptolemy.plot.PlotDataDisplayDialog;
import ptolemy.plot.PlotErrorBarsDialogBox;
import ptolemy.plot.PlotFilterDialog;
import ptolemy.plot.PlotFormatter;
import ptolemy.plot.PlotStatisticsDialog;
import ptolemy.plot.PlotTransformerDialog;
import ptolemy.plot.PlotVotableDisplayDialog;
import vowrite.VOTable;
import vowrite.VOTableResource;
import vowrite.VOTableTable;

public class PlotButtons
implements ActionListener {
    private JComboBox _cmbDataX = new JComboBox();
    private JComboBox _cmbDataY = new JComboBox();
    private JComboBox _cmbFilters = null;
    private JComboBox _cmbVOTables = new JComboBox();
    private JCheckBox _chkLogX = null;
    private JCheckBox _chkLogY = null;
    private JCheckBox _chkOverlay = null;
    private JLabel _lblVOTables = null;
    private JLabel _lblX = null;
    private JLabel _lblY = null;
    private JLabel _lblFilter = null;
    private JButton _btnPlot = null;
    private JButton _btnHist = null;
    private transient MouseListener _btnPlotMouseListener = null;
    private transient MouseListener _btnHistMouseListener = null;
    private JButton _browseButton = null;
    private JButton _loadButton = null;
    private ActionListener _browseButtonListener = null;
    private ActionListener _loadButtonListener = null;
    private JLabel _XCoord = null;
    private JLabel _YCoord = null;
    private JTextField _txtCoord1 = new JTextField("   Coordinates");
    private JTextField _txtCoord2 = new JTextField("   Coordinates");
    private JPanel _panelPlotArea = new JPanel();
    private JPanel _panelButtonsArea = new JPanel();
    private JPanel _panelButtons = new JPanel();
    private JPanel _buttons = new JPanel();
    private JPanel _mainPanel = new JPanel();
    private JPanel _panelXCoordinate;
    private JPanel _panelYCoordinate;
    JPanel _entirePanel;
    JScrollPane _mainScrollPane;
    private int _verticalscrollbar = 20;
    private int _horizontalscrollbar = 30;
    private JPanel _toolbarButtonsPanel;
    private String _selectedFile;
    private JLabel _statusBar;
    private static String _imagePath = JVTUtil.SMALL_IMAGE_PATH;
    private Container _container;
    private Color _background;
    private PlotVOApplet _pva;
    private int _xcoordinate = 0;
    private int _ycoordinate = 0;
    private static final double TOOLBAR_CELLSPACING = 1.0;
    private int _northAnchor = 11;
    private int _northeastAnchor = 12;
    private int _northwestAnchor = 18;
    protected boolean _showToolbar = true;
    private JMenuItem _loadFileMenuItem;
    private JMenuItem _closeVOPlotMenuItem;
    private JMenuItem _loadMultipleFilesMenuItem;
    private JMenuItem _saveGraphMenuItem;
    private JMenuItem _printGraphMenuItem;
    private JRadioButtonMenuItem _selectPointMenuItem;
    private JRadioButtonMenuItem _unselectPointsMenuItem;
    private JMenuItem _clearAllSelectedPointsMenuItem;
    private JRadioButtonMenuItem _zoomPlotMenuItem;
    private ButtonGroup modeGroup = new ButtonGroup();
    private JMenuItem _aladinMenuItem;
    private JMenuItem _plotPropertiesMenuItem;
    private JMenuItem _votableXmlFormatMenuItem;
    private JMenuItem _aSCIIFormatMenuItem;
    private JMenuItem _votableTableFormatMenuItem;
    private JMenuItem _createFilterMenuItem;
    private JMenuItem _generateStatisticsMenuItem;
    private JMenuItem _createNewColumnMenuItem;
    private JMenuItem _resetGraphMenuItem;
    private JMenuItem _fillGraphMenuItem;
    private JMenuItem _helpMenuItem;
    private JMenuItem _aboutUsMenuItem;
    private JMenuItem _showToolbarMenuItem;
    private JMenuItem _plotErrorBarsMenuItem;
    private ItemListener _showToolbarMenuItemListener = null;
    private String filename;
    private ToolbarButtonProperties _selectProperties;
    private ToolbarButtonProperties _plotProperties;
    private ToolbarButtonProperties _zoomProperties;
    private ToolbarButtonProperties _resetProperties;
    private ToolbarButtonProperties _fillProperties;
    private ToolbarButtonProperties _clearSelectionProperties;
    Border blackline;
    private File _currentDirectory;
    private boolean _showMultipleVOTables = false;
    private transient MouseListener _chkOverlayMouseListener = null;
    private transient MouseListener _chkLogXMouseListener = null;
    private transient MouseListener _chkLogYMouseListener = null;
    private transient JButton _fillButton = null;
    private transient ActionListener _fillButtonListener = null;
    private transient MouseListener _fillButtonMouseListener = null;
    private transient JButton _resetButton = null;
    private transient ActionListener _resetButtonListener = null;
    private transient MouseListener _resetButtonMouseListener = null;
    private transient JButton _zoomButton = null;
    private transient ActionListener _zoomButtonListener = null;
    private transient MouseListener _zoomButtonMouseListener = null;
    private transient JButton _clearSelectionButton = null;
    private transient ActionListener _clearSelectionButtonListener = null;
    private transient MouseListener _clearSelectionButtonMouseListener = null;
    private transient JButton _selectButton = null;
    private transient ActionListener _selectButtonListener = null;
    private transient MouseListener _selectMouseListener = null;
    private transient JButton _plotPropertiesButton = null;
    private transient ActionListener _plotPropertiesButtonListener = null;
    private transient MouseListener _plotPropertiesMouseListener = null;
    private transient ActionListener _buttonListener = null;
    private transient MouseListener _buttonMouseListener = null;
    private int _buttonMode = 1;
    private boolean _isSelectButtonDown = true;
    private static String _ZOOM_ON_TOOLTIP_TEXT;
    private static String _ZOOM_OFF_TOOLTIP_TEXT;
    private static String _SELECT_ON_TOOLTIP_TEXT;
    private static String _SELECT_OFF_TOOLTIP_TEXT;

    public void init(Container con, Color back, PlotVOApplet pv) {
        this._container = con;
        this._pva = pv;
        this._background = back;
        this._panelButtonsArea = this.addButtons(this._pva.getColumnNames(), this._background);
        this.setUpContainer();
    }

    public void emptyCmbData() {
        this._cmbDataX.removeAllItems();
        this._cmbDataY.removeAllItems();
    }

    public void addDataItem(String name) {
        this._cmbDataX.addItem(name);
        this._cmbDataY.addItem(name);
    }

    public void addVOTableItem(String name) {
        this._cmbVOTables.addItem(name);
    }

    public boolean showMultipleCatalogues() {
        return this._showMultipleVOTables;
    }

    public void emptyCmbVOTables() {
        this._cmbVOTables.removeAllItems();
    }

    public void emptyCmbFilter() {
        this._cmbFilters.removeAllItems();
    }

    public void addFilterItem(String item) {
        this._cmbFilters.addItem(item);
    }

    public boolean isOverlaySelected() {
        return this._chkOverlay.isSelected();
    }

    public void setOverlaySelected(boolean select) {
        if (this._chkOverlay.isSelected() && !select || !this._chkOverlay.isSelected() && select) {
            this._chkOverlay.doClick();
        }
    }

    public int getSelectedCooSysIndex() {
        return 4;
    }

    public String getSelectedXColumn() {
        return (String)this._cmbDataX.getSelectedItem();
    }

    public int getSelectedXIndex() {
        return this._cmbDataX.getSelectedIndex();
    }

    public void setSelectedXIndex(int index) {
        if (index >= 0 && index < this._cmbDataX.getItemCount()) {
            this._cmbDataX.setSelectedIndex(index);
        }
    }

    public void setLogX(boolean isLogX) {
        this._chkLogX.setSelected(isLogX);
    }

    public void setLogY(boolean isLogY) {
        this._chkLogY.setSelected(isLogY);
    }

    public String getSelectedFilter() {
        return (String)this._cmbFilters.getSelectedItem();
    }

    public int getSelectedFilterIndex() {
        return this._cmbFilters.getSelectedIndex();
    }

    public void setSelectedFilterIndex(int index) {
        if (index >= 0 && index < this._cmbFilters.getItemCount()) {
            this._cmbFilters.setSelectedIndex(index);
        }
    }

    public void setSelectedFilter(String name) {
        for (int index = 0; index < this._cmbFilters.getItemCount(); ++index) {
            if (!((String)this._cmbFilters.getItemAt(index)).equals(name)) continue;
            this._cmbFilters.setSelectedIndex(index);
        }
    }

    public String getSelectedYColumn() {
        return (String)this._cmbDataY.getSelectedItem();
    }

    public int getSelectedYIndex() {
        return this._cmbDataY.getSelectedIndex();
    }

    public void setSelectedYIndex(int index) {
        if (index >= 0 && index < this._cmbDataY.getItemCount()) {
            this._cmbDataY.setSelectedIndex(index);
        }
    }

    public boolean isLogX() {
        return this._chkLogX.isSelected();
    }

    public boolean isLogY() {
        return this._chkLogY.isSelected();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._btnPlot) {
            this.drawPlot();
        } else if (e.getSource() == this._btnHist) {
            this.drawHistogram();
        }
    }

    public void drawPlot() {
        if (this._pva.getPlotData() != null) {
            this._pva.drawPlot(false);
            this._pva.resizePlot();
            this._pva.clearSelectedPoints(true);
            this._selectButton.setEnabled(true);
            this._selectPointMenuItem.setEnabled(true);
            this._unselectPointsMenuItem.setEnabled(true);
        }
    }

    public void close() {
        System.out.println("VOPlot is closing.");
        this._pva.stop();
        System.exit(0);
    }

    public void drawHistogram() {
        if (this._pva.getPlotData() != null) {
            this._pva.drawHistogram(-1.0);
            this._pva.resizePlot();
            this._selectButton.setEnabled(false);
            this._selectPointMenuItem.setEnabled(false);
            this._unselectPointsMenuItem.setEnabled(false);
        }
    }

    public PlotVOApplet getPlotApplet() {
        return this._pva;
    }

    public void loadSingleVOTable(InputStream voTableStream) {
        boolean previousMultipleLoaded = this.showMultipleCatalogues();
        if (this.loadVOTable(voTableStream, true)) {
            if (previousMultipleLoaded) {
                this._panelButtonsArea = this.addButtons(this._pva.getColumnNames(), this._background);
                this.swapPanels();
            }
            if (this.isOverlaySelected()) {
                this.setOverlaySelected(false);
            }
            PlotVOApplet.plot().clear(false);
            this._pva.plotDefaultColumns();
        }
    }

    public void loadSingleData(PlotData pd) {
        boolean previousMultipleLoaded = this.showMultipleCatalogues();
        if (this.loadData(pd, true)) {
            if (previousMultipleLoaded) {
                this._panelButtonsArea = this.addButtons(this._pva.getColumnNames(), this._background);
                this.swapPanels();
            }
            if (this.isOverlaySelected()) {
                this.setOverlaySelected(false);
            }
            PlotVOApplet.plot().clear(false);
            this._pva.plotDefaultColumns();
        }
    }

    public void loadMultipleVOTable(InputStream voTableStream) {
        if (this._pva.getPlotData() == null) {
            this.loadVOTable(voTableStream, true);
            this._pva.plotDefaultColumns();
        } else {
            int previousPlotDataIndex = -1;
            int previousColX = -1;
            int previousColY = -1;
            previousPlotDataIndex = this._pva.getCurrentPlotDataIndex();
            previousColX = this.getSelectedXIndex();
            previousColY = this.getSelectedYIndex();
            if (this.loadVOTable(voTableStream, false)) {
                if (this._pva.getNumOfPlotData() == 2) {
                    this._panelButtonsArea = this.addButtons(this._pva.getColumnNames(), this._background);
                    this.swapPanels();
                }
                this._pva.plotAsPreviouslySelected(previousPlotDataIndex, previousColX, previousColY);
            }
            JVTUtil.showDefaultCursor(this._pva);
        }
    }

    public void loadMultipleData(PlotData pd) {
        if (this._pva.getPlotData() == null) {
            this.loadData(pd, true);
            this._pva.plotDefaultColumns();
        } else {
            int previousPlotDataIndex = -1;
            int previousColX = -1;
            int previousColY = -1;
            previousPlotDataIndex = this._pva.getCurrentPlotDataIndex();
            previousColX = this.getSelectedXIndex();
            previousColY = this.getSelectedYIndex();
            this.loadData(pd, false);
            if (this._pva.getNumOfPlotData() == 2) {
                this._panelButtonsArea = this.addButtons(this._pva.getColumnNames(), this._background);
                this.swapPanels();
            }
            this._pva.plotAsPreviouslySelected(previousPlotDataIndex, previousColX, previousColY);
            JVTUtil.showDefaultCursor(this._pva);
        }
    }

    private boolean loadVOTable(InputStream voTableStream, boolean isMultiple) {
        try {
            String tableName;
            if (isMultiple) {
                this._pva.clearPlotData();
                this._showMultipleVOTables = false;
                this.emptyCmbVOTables();
            } else {
                this._showMultipleVOTables = true;
            }
            this._selectButton.setEnabled(true);
            this.setStatusText("");
            this.setStatusText("Parsing VOTable. Please wait.");
            JVTUtil.showWaitCursor(this._pva);
            System.out.println("Parsing VOTable ....");
            SAVOTParser sp = new SAVOTParser(voTableStream);
            PlotData pd = sp.getPlotData();
            VOTableMetaData votableMetaData = new VOTableMetaData();
            votableMetaData.setVOTable(sp.getVOTableMetaData());
            votableMetaData.setResource(sp.getVOTableResourceMetaData());
            votableMetaData.setTable(sp.getVOTableTableMetaData());
            int iVOTableNum = this._pva.getNumOfPlotData() + 1;
            try {
                tableName = sp.getVOTableTableMetaData().getName();
            }
            catch (Exception ex) {
                tableName = "";
            }
            if (tableName == null || tableName.length() == 0) {
                tableName = "Table".concat(String.valueOf(String.valueOf(iVOTableNum)));
            }
            this.addVOTableItem(String.valueOf(String.valueOf(new StringBuffer("").append(JVTUtil.CATALOGUE_SEPARATOR_OPEN).append(iVOTableNum).append(JVTUtil.CATALOGUE_SEPARATOR_CLOSE).append(tableName))));
            this._pva.clearSelectedPoints(true);
            this._pva.showVOTableObject(null);
            if (pd == null) {
                this.setStatusText("Error while loading VOTable.");
                this._pva.showError(String.valueOf(String.valueOf(new StringBuffer("Could not load votable from '").append(this.filename).append("'."))));
            } else {
                votableMetaData.setLocation(this.filename);
                pd.setVOTableMetaData(votableMetaData);
                if (pd.getNumOfPlotColumns() <= 0) {
                    this._pva.showError(PlotVOApplet._errorMsg[3]);
                } else {
                    this.setStatusText("Loaded VOTable.");
                    if (pd.getObjectIDColumn() == null) {
                        pd.generateObjectIDColumn();
                    }
                }
            }
            this._pva.setPlotData(pd);
            this._cmbVOTables.setSelectedIndex(this._cmbVOTables.getItemCount() - 1);
            JVTUtil.showDefaultCursor(this._pva);
        }
        catch (Exception ex) {
            System.err.println("Error: Could not load VOTable data.");
            JVTUtil.showDefaultCursor(this._pva);
            boolean bl = false;
            return bl;
        }
        return true;
    }

    private boolean loadData(PlotData pd, boolean isMultiple) {
        try {
            if (isMultiple) {
                this._pva.clearPlotData();
                this._showMultipleVOTables = false;
                this.emptyCmbVOTables();
            } else {
                this._showMultipleVOTables = true;
            }
            this._selectButton.setEnabled(true);
            this.setStatusText("");
            this.setStatusText("Loading data.... Please wait.");
            JVTUtil.showWaitCursor(this._pva);
            System.out.println("Loading data ....");
            VOTableMetaData votableMetaData = new VOTableMetaData();
            VOTable votable = new VOTable();
            votableMetaData.setVOTable(votable);
            votableMetaData.setResource(new VOTableResource());
            votableMetaData.setTable(new VOTableTable());
            String tableName = "";
            int iVOTableNum = this._pva.getNumOfPlotData() + 1;
            if (tableName == null || tableName.length() == 0) {
                tableName = "Table".concat(String.valueOf(String.valueOf(iVOTableNum)));
            }
            this.addVOTableItem(String.valueOf(String.valueOf(new StringBuffer("").append(JVTUtil.CATALOGUE_SEPARATOR_OPEN).append(iVOTableNum).append(JVTUtil.CATALOGUE_SEPARATOR_CLOSE).append(tableName))));
            this._pva.clearSelectedPoints(true);
            this._pva.showVOTableObject(null);
            if (pd == null) {
                this.setStatusText("Error while loading Data.");
                this._pva.showError("Could not load Data into VOPlot.");
            } else {
                votableMetaData.setLocation(this.filename);
                pd.setVOTableMetaData(votableMetaData);
                if (pd.getNumOfPlotColumns() <= 0) {
                    this._pva.showError(PlotVOApplet._errorMsg[3]);
                } else {
                    this.setStatusText("Loaded Data.");
                    if (pd.getObjectIDColumn() == null) {
                        pd.generateObjectIDColumn();
                    }
                }
            }
            this._pva.setPlotData(pd);
            this._cmbVOTables.setSelectedIndex(this._cmbVOTables.getItemCount() - 1);
            JVTUtil.showDefaultCursor(this._pva);
        }
        catch (Exception ex) {
            System.err.println("Error: Could not load data into VOPlot.");
            JVTUtil.showDefaultCursor(this._pva);
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public void setUpContainer() {
        this._entirePanel = new JPanel(new BorderLayout());
        this._mainPanel.setLayout(new BorderLayout());
        this._mainPanel.setBackground(this._background);
        this._panelPlotArea.setBackground(this._background);
        this._panelPlotArea.add(PlotVOApplet.plot());
        this._entirePanel.setBackground(this._background);
        if (this._pva.isWebApp() && !this._pva.isSubApp()) {
            this._panelButtonsArea.setPreferredSize(new Dimension(130, 0));
            if (this._showToolbar) {
                this._mainPanel.add((Component)this._panelButtonsArea, "East");
            }
            this._mainPanel.add((Component)this._panelPlotArea, "West");
        } else {
            JPanel buttonPanel = new JPanel(new BorderLayout());
            JPanel plotAndUserInputPanel = new JPanel(new BorderLayout());
            JPanel fillerPanel1 = new JPanel();
            JPanel fillerPanel2 = new JPanel();
            fillerPanel1.setBackground(this._background);
            fillerPanel2.setBackground(this._background);
            buttonPanel.setBackground(this._background);
            plotAndUserInputPanel.setBackground(this._background);
            plotAndUserInputPanel.add((Component)this._panelPlotArea, "North");
            plotAndUserInputPanel.add((Component)fillerPanel1, "South");
            JPanel statusBar = this.addStatusBar();
            buttonPanel.add((Component)this._panelButtonsArea, "North");
            buttonPanel.add((Component)fillerPanel2, "South");
            if (this._showToolbar) {
                this._mainPanel.add((Component)buttonPanel, "East");
            }
            this._mainPanel.add((Component)plotAndUserInputPanel, "West");
        }
        this.blackline = BorderFactory.createLineBorder(Color.black);
        this._entirePanel.add((Component)this.createMenu(), "North");
        this._container.add((Component)this._mainPanel, "Center");
        this._entirePanel.setBorder(this.blackline);
        this._entirePanel.add((Component)this._mainPanel, "Center");
        this._mainScrollPane = new JScrollPane(this._entirePanel, this._verticalscrollbar, this._horizontalscrollbar);
        if (this._pva.isWebApp()) {
            this._entirePanel.setBorder(this.blackline);
            this._container.add(this._entirePanel);
        } else {
            this._container.add(this._mainScrollPane);
        }
        this._buttonMode = 1;
    }

    private JMenuBar createMenu() {
        JMenuBar menubar = new JMenuBar();
        JMenu filemenu = new JMenu("File                ");
        filemenu.setMnemonic(70);
        this._loadFileMenuItem = new JMenuItem("Open");
        this._saveGraphMenuItem = new JMenuItem("Save Graph as EPS");
        this._printGraphMenuItem = new JMenuItem("Print Graph");
        this._closeVOPlotMenuItem = new JMenuItem("Exit");
        this._closeVOPlotMenuItem.setMnemonic(88);
        this._loadMultipleFilesMenuItem = new JMenuItem("Load multiple VOTables");
        this._loadFileMenuItem.addActionListener(this.setButtonListener());
        this._loadMultipleFilesMenuItem.addActionListener(this.setButtonListener());
        this._saveGraphMenuItem.addActionListener(this.setButtonListener());
        this._printGraphMenuItem.addActionListener(this.setButtonListener());
        this._closeVOPlotMenuItem.addActionListener(this.setButtonListener());
        if (!this._pva.isWebApp()) {
            filemenu.add(this._loadFileMenuItem);
            filemenu.add(this._loadMultipleFilesMenuItem);
            filemenu.add(this._saveGraphMenuItem);
        }
        filemenu.add(this._printGraphMenuItem);
        if (!this._pva.isWebApp()) {
            filemenu.add(this._closeVOPlotMenuItem);
        }
        JMenu editmenu = new JMenu("Mode                ");
        editmenu.setMnemonic(77);
        this._clearAllSelectedPointsMenuItem = new JMenuItem("Clear All Selections");
        this._selectPointMenuItem = new JRadioButtonMenuItem("Select Points mode", false);
        this._unselectPointsMenuItem = new JRadioButtonMenuItem("Unselect Points mode", false);
        this._zoomPlotMenuItem = new JRadioButtonMenuItem("Zoom mode", true);
        this.modeGroup.add(this._selectPointMenuItem);
        this.modeGroup.add(this._unselectPointsMenuItem);
        this.modeGroup.add(this._zoomPlotMenuItem);
        this._zoomPlotMenuItem.setSelected(true);
        this._selectPointMenuItem.addActionListener(this.setButtonListener());
        this._unselectPointsMenuItem.addActionListener(this.setButtonListener());
        this._clearAllSelectedPointsMenuItem.addActionListener(this.setButtonListener());
        this._zoomPlotMenuItem.addActionListener(this.setButtonListener());
        editmenu.add(this._zoomPlotMenuItem);
        editmenu.add(this._selectPointMenuItem);
        editmenu.add(this._unselectPointsMenuItem);
        editmenu.add(this._clearAllSelectedPointsMenuItem);
        JMenu viewmenu = new JMenu("View                ");
        viewmenu.setMnemonic(86);
        this._showToolbarMenuItem = this._showToolbar ? new JCheckBoxMenuItem("Hide Toolbar", false) : new JCheckBoxMenuItem("Hide Toolbar", true);
        this._plotPropertiesMenuItem = new JMenuItem("Plot Properties");
        this._plotErrorBarsMenuItem = new JMenuItem("Plot With Error Bars");
        this._votableXmlFormatMenuItem = new JMenuItem("Data in VOTable Format");
        this._aSCIIFormatMenuItem = new JMenuItem("Data in CSV Format");
        this._votableTableFormatMenuItem = new JMenuItem("Data in Table Format");
        this._resetGraphMenuItem = new JMenuItem("Reset");
        this._fillGraphMenuItem = new JMenuItem("Full data range");
        this._plotPropertiesMenuItem.addActionListener(this.setButtonListener());
        this._plotErrorBarsMenuItem.addActionListener(this.setButtonListener());
        this._votableXmlFormatMenuItem.addActionListener(this.setButtonListener());
        this._aSCIIFormatMenuItem.addActionListener(this.setButtonListener());
        this._votableTableFormatMenuItem.addActionListener(this.setButtonListener());
        this._resetGraphMenuItem.addActionListener(this.setButtonListener());
        this._fillGraphMenuItem.addActionListener(this.setButtonListener());
        this._showToolbarMenuItemListener = new ButtonListener();
        this._showToolbarMenuItem.addItemListener(this._showToolbarMenuItemListener);
        if (this._pva.isWebApp()) {
            viewmenu.add(this._showToolbarMenuItem);
        }
        viewmenu.add(this._plotPropertiesMenuItem);
        viewmenu.add(this._plotErrorBarsMenuItem);
        viewmenu.add(this._votableXmlFormatMenuItem);
        viewmenu.add(this._aSCIIFormatMenuItem);
        viewmenu.add(this._votableTableFormatMenuItem);
        viewmenu.add(this._resetGraphMenuItem);
        viewmenu.add(this._fillGraphMenuItem);
        JMenu functionsmenu = new JMenu("Functions                ");
        functionsmenu.setMnemonic(85);
        this._createFilterMenuItem = new JMenuItem("Create Filters");
        this._generateStatisticsMenuItem = new JMenuItem("Generate Statistics");
        this._createNewColumnMenuItem = new JMenuItem("Create New Columns");
        this._createFilterMenuItem.addActionListener(this.setButtonListener());
        this._generateStatisticsMenuItem.addActionListener(this.setButtonListener());
        this._createNewColumnMenuItem.addActionListener(this.setButtonListener());
        functionsmenu.add(this._createNewColumnMenuItem);
        functionsmenu.add(this._createFilterMenuItem);
        functionsmenu.add(this._generateStatisticsMenuItem);
        JMenu aladinmenu = new JMenu("Aladin                ");
        aladinmenu.setMnemonic(65);
        this._aladinMenuItem = new JMenuItem("Launch Aladin");
        this._aladinMenuItem.addActionListener(this.setButtonListener());
        aladinmenu.add(this._aladinMenuItem);
        JMenu helpmenu = new JMenu("Help                ");
        helpmenu.setMnemonic(72);
        this._helpMenuItem = new JMenuItem("Show VOPlot Help");
        this._aboutUsMenuItem = new JMenuItem("About VOPlot");
        this._helpMenuItem.addActionListener(this.setButtonListener());
        this._aboutUsMenuItem.addActionListener(this.setButtonListener());
        if (this._pva.isWebApp()) {
            helpmenu.add(this._helpMenuItem);
        }
        helpmenu.add(this._aboutUsMenuItem);
        menubar.add(filemenu);
        menubar.add(editmenu);
        menubar.add(viewmenu);
        menubar.add(functionsmenu);
        if (!this._pva.isSubApp()) {
            menubar.add(aladinmenu);
        }
        menubar.add(helpmenu);
        return menubar;
    }

    private JPanel addStatusBar() {
        JPanel statusBarPanel = new JPanel();
        this._statusBar = !this._pva.isSubApp() ? new JLabel("Load a VOTable for plotting.") : new JLabel("You are currently in Zoom mode.");
        JVTUtil.usePlainFont(this._statusBar);
        this._statusBar.setForeground(Color.black);
        statusBarPanel.add(this._statusBar);
        return statusBarPanel;
    }

    public void swapPanels() {
        this._pva.setUpPlotBoxSwap();
        this._container.removeAll();
        this._mainPanel.removeAll();
        this._panelPlotArea.remove(0);
        this.setUpContainer();
        this._container.invalidate();
        this._container.validate();
        this.updateListeners();
        this._zoomButton.setIcon(this._zoomProperties.getHighlightedImagePath());
        this._selectButton.setIcon(this._selectProperties.getHighlightedImagePath());
        this._plotPropertiesButton.setIcon(this._plotProperties.getImagePath());
        this._buttonMode = 1;
    }

    public JPanel addButtons(String[] fields, Color background) {
        JPanel panelLabelFilter = new JPanel(new BorderLayout());
        JPanel panelComboFilter = new JPanel(new BorderLayout());
        JPanel panelFilter = new JPanel(new BorderLayout());
        JPanel panelLabelX = new JPanel(new BorderLayout());
        JPanel panelComboDataX = new JPanel(new BorderLayout());
        JPanel panelCheckLogX = new JPanel(new BorderLayout());
        JPanel panelLabelY = new JPanel(new BorderLayout());
        JPanel panelComboDataY = new JPanel(new BorderLayout());
        JPanel panelCheckLogY = new JPanel(new BorderLayout());
        JPanel panelPlotButton = new JPanel(new BorderLayout());
        JPanel panelCheckOverlay = new JPanel(new BorderLayout());
        JPanel panelVOTables = new JPanel(new BorderLayout());
        JPanel panelX = new JPanel(new BorderLayout());
        JPanel panelY = new JPanel(new BorderLayout());
        JPanel panelOverlay = new JPanel(new BorderLayout());
        JPanel panelPlot = new JPanel(new BorderLayout());
        JPanel panelOverlayPlot = new JPanel(new BorderLayout());
        JPanel panelCoordinate = new JPanel(new BorderLayout());
        JPanel panelLabelVOTables = new JPanel(new BorderLayout());
        JPanel panelComboDataVOTables = new JPanel(new BorderLayout());
        this._panelXCoordinate = new JPanel(new BorderLayout());
        this._panelYCoordinate = new JPanel(new BorderLayout());
        JPanel panelButtonsArea = new JPanel();
        this._cmbDataX = new JComboBox();
        this._cmbDataY = new JComboBox();
        this._cmbFilters = new JComboBox();
        this._cmbFilters.addItem("All");
        this._chkLogX = new JCheckBox("Log");
        this._chkLogXMouseListener = new StatusListener();
        this._chkLogX.addMouseListener(this._chkLogXMouseListener);
        this._chkLogY = new JCheckBox("Log");
        this._chkLogYMouseListener = new StatusListener();
        this._chkLogY.addMouseListener(this._chkLogYMouseListener);
        this._chkOverlay = new JCheckBox("Overlay");
        this._chkOverlayMouseListener = new StatusListener();
        this._chkOverlay.addMouseListener(this._chkOverlayMouseListener);
        this._lblVOTables = new JLabel();
        this._lblX = new JLabel();
        this._lblY = new JLabel();
        this._lblFilter = new JLabel();
        this._btnPlot = new JButton("Plot");
        this._btnHist = new JButton("Histogram");
        this._btnPlot.setPreferredSize(new Dimension(100, 25));
        this._btnHist.setPreferredSize(new Dimension(100, 25));
        this._txtCoord1.setPreferredSize(new Dimension(80, 22));
        this._txtCoord2.setPreferredSize(new Dimension(80, 22));
        JVTUtil.usePlainFont(this._btnPlot);
        JVTUtil.usePlainFont(this._btnHist);
        JVTUtil.usePlainFont(this._chkLogX);
        JVTUtil.usePlainFont(this._chkLogY);
        JVTUtil.usePlainFont(this._chkOverlay);
        JVTUtil.usePlainFont(this._lblVOTables);
        JVTUtil.usePlainFont(this._lblX);
        JVTUtil.usePlainFont(this._lblY);
        JVTUtil.usePlainFont(this._lblFilter);
        JVTUtil.usePlainFont(this._cmbDataX);
        JVTUtil.usePlainFont(this._cmbDataY);
        JVTUtil.usePlainFont(this._cmbFilters);
        JVTUtil.usePlainFont(this._cmbVOTables);
        int i = 0;
        for (i = 0; i < this._pva.getNumOfColumns(); ++i) {
            this._cmbDataX.addItem(fields[i]);
            this._cmbDataY.addItem(fields[i]);
        }
        this._cmbVOTables.setMaximumRowCount(6);
        this._cmbDataX.setMaximumRowCount(6);
        this._cmbDataY.setMaximumRowCount(6);
        this._cmbFilters.setMaximumRowCount(6);
        this._lblVOTables.setText("VOTable");
        this._lblX.setText("X axis");
        this._lblY.setText("Y axis");
        this._lblFilter.setText("Filter    ");
        panelLabelFilter.add((Component)this._lblFilter, "West");
        panelComboFilter.add((Component)this._cmbFilters, "West");
        panelFilter.add((Component)panelLabelFilter, "North");
        panelFilter.add((Component)panelComboFilter, "South");
        panelFilter.setMaximumSize(new Dimension(100, 45));
        this._cmbVOTables.addActionListener(new VOTableActionListener());
        if (this._showMultipleVOTables) {
            panelLabelVOTables.add((Component)this._lblVOTables, "West");
            panelComboDataVOTables.add((Component)this._cmbVOTables, "Center");
            panelVOTables.add((Component)panelLabelVOTables, "North");
            panelVOTables.add((Component)panelComboDataVOTables, "South");
            panelVOTables.setMaximumSize(new Dimension(100, 55));
        }
        panelLabelX.add((Component)this._lblX, "West");
        panelLabelX.add((Component)this._chkLogX, "East");
        panelComboDataX.add((Component)this._cmbDataX, "Center");
        panelX.add((Component)panelLabelX, "North");
        panelX.add((Component)panelComboDataX, "South");
        panelX.setMaximumSize(new Dimension(100, 55));
        panelLabelY.add((Component)this._lblY, "West");
        panelLabelY.add((Component)this._chkLogY, "East");
        panelComboDataY.add((Component)this._cmbDataY, "Center");
        panelY.add((Component)panelLabelY, "North");
        panelY.add((Component)panelComboDataY, "South");
        panelY.setMaximumSize(new Dimension(100, 55));
        panelOverlay.add((Component)this._chkOverlay, "West");
        panelPlot.add((Component)this._btnPlot, "North");
        panelPlot.add(Box.createRigidArea(new Dimension(0, 3)));
        panelPlot.add((Component)this._btnHist, "South");
        panelOverlayPlot.add((Component)panelOverlay, "North");
        panelOverlayPlot.add((Component)panelPlot, "South");
        panelOverlayPlot.setMaximumSize(new Dimension(100, 90));
        this._XCoord = new JLabel("X");
        this._YCoord = new JLabel("Y");
        JVTUtil.usePlainFont(this._XCoord);
        JVTUtil.usePlainFont(this._YCoord);
        this._txtCoord1.setBackground(Color.lightGray);
        this._txtCoord1.setHorizontalAlignment(0);
        this._txtCoord1.setEditable(false);
        this._txtCoord2.setBackground(Color.lightGray);
        this._txtCoord2.setHorizontalAlignment(0);
        this._txtCoord2.setEditable(false);
        this._btnPlot.addActionListener(this);
        this._btnPlotMouseListener = new StatusListener();
        this._btnPlot.addMouseListener(this._btnPlotMouseListener);
        this._btnHist.addActionListener(this);
        this._btnHistMouseListener = new StatusListener();
        this._btnHist.addMouseListener(this._btnHistMouseListener);
        this._panelXCoordinate.add((Component)this._XCoord, "West");
        this._panelXCoordinate.add((Component)this._txtCoord1, "East");
        this._panelYCoordinate.add((Component)this._YCoord, "West");
        this._panelYCoordinate.add((Component)this._txtCoord2, "East");
        panelCoordinate.add((Component)this._panelXCoordinate, "Center");
        panelCoordinate.add((Component)this._panelYCoordinate, "South");
        panelCoordinate.setMaximumSize(new Dimension(100, 40));
        panelButtonsArea.setLayout(new BoxLayout(panelButtonsArea, 1));
        panelButtonsArea.add(Box.createRigidArea(new Dimension(0, 10)));
        panelButtonsArea.add(panelCoordinate);
        JPanel spacePanel = new JPanel();
        spacePanel.setBackground(this._background);
        if (this._showMultipleVOTables) {
            panelButtonsArea.add(Box.createRigidArea(new Dimension(0, 1)));
            panelButtonsArea.add(spacePanel);
            panelButtonsArea.add(Box.createRigidArea(new Dimension(0, 3)));
            panelButtonsArea.add(panelVOTables);
        }
        panelButtonsArea.add(Box.createRigidArea(new Dimension(0, 3)));
        panelButtonsArea.add(panelY);
        panelButtonsArea.add(Box.createRigidArea(new Dimension(0, 3)));
        panelButtonsArea.add(panelX);
        panelButtonsArea.add(Box.createRigidArea(new Dimension(0, 3)));
        panelButtonsArea.add(panelFilter);
        panelButtonsArea.add(Box.createRigidArea(new Dimension(0, 3)));
        panelButtonsArea.add(panelOverlayPlot);
        panelButtonsArea.add(Box.createRigidArea(new Dimension(0, 3)));
        panelButtonsArea.add(this._buttons);
        panelLabelVOTables.setBackground(this._background);
        this._XCoord.setBackground(this._background);
        this._YCoord.setBackground(this._background);
        this._panelXCoordinate.setBackground(this._background);
        this._panelYCoordinate.setBackground(this._background);
        this._chkLogX.setBackground(this._background);
        this._chkLogY.setBackground(this._background);
        this._chkOverlay.setBackground(this._background);
        panelButtonsArea.setBackground(this._background);
        panelVOTables.setBackground(this._background);
        panelLabelX.setBackground(this._background);
        panelComboDataX.setBackground(this._background);
        panelCheckLogX.setBackground(this._background);
        panelLabelY.setBackground(this._background);
        panelLabelFilter.setBackground(this._background);
        panelComboFilter.setBackground(this._background);
        panelFilter.setBackground(this._background);
        panelComboDataY.setBackground(this._background);
        panelCheckLogY.setBackground(this._background);
        panelPlotButton.setBackground(this._background);
        panelCheckOverlay.setBackground(this._background);
        panelPlot.setBackground(this._background);
        panelOverlay.setBackground(this._background);
        panelOverlayPlot.setBackground(this._background);
        this._panelButtons.setBackground(this._background);
        panelX.setBackground(this._background);
        panelY.setBackground(this._background);
        panelFilter.setBackground(this._background);
        panelOverlayPlot.setBackground(this._background);
        panelCoordinate.setBackground(this._background);
        return panelButtonsArea;
    }

    public void showCoordinates(String text1, String text2) {
        this._txtCoord1.setText(text1);
        this._txtCoord2.setText(text2);
    }

    public void updateListeners() {
        this._fillButton.removeActionListener(this._fillButtonListener);
        this._fillButtonListener = new ButtonListener(this, PlotVOApplet.plot());
        this._fillButton.addActionListener(this._fillButtonListener);
        this._resetButton.removeActionListener(this._resetButtonListener);
        this._resetButtonListener = new ButtonListener(this, PlotVOApplet.plot());
        this._resetButton.addActionListener(this._resetButtonListener);
        this._zoomButton.removeActionListener(this._zoomButtonListener);
        this._zoomButtonListener = new ButtonListener(this, PlotVOApplet.plot());
        this._zoomButton.addActionListener(this._zoomButtonListener);
        this._clearSelectionButton.removeActionListener(this._clearSelectionButtonListener);
        this._clearSelectionButtonListener = new ButtonListener(this, PlotVOApplet.plot());
        this._clearSelectionButton.addActionListener(this._clearSelectionButtonListener);
        this._selectButton.removeActionListener(this._selectButtonListener);
        this._selectButtonListener = new ButtonListener(this, PlotVOApplet.plot());
        this._selectButton.addActionListener(this._selectButtonListener);
        this._plotPropertiesButton.removeActionListener(this._plotPropertiesButtonListener);
        this._plotPropertiesButtonListener = new ButtonListener(this, PlotVOApplet.plot());
        this._plotPropertiesButton.addActionListener(this._plotPropertiesButtonListener);
    }

    private void initToolbarButtons() {
        this._selectProperties = new ToolbarButtonProperties(String.valueOf(String.valueOf(_imagePath)).concat("select.gif"), String.valueOf(String.valueOf(_imagePath)).concat("select_on.gif"), "SP", this._background, _SELECT_OFF_TOOLTIP_TEXT);
        this._plotProperties = new ToolbarButtonProperties(String.valueOf(String.valueOf(_imagePath)).concat("format.gif"), String.valueOf(String.valueOf(_imagePath)).concat("format_on.gif"), "PP", this._background, "Change Plot Properties");
        this._zoomProperties = new ToolbarButtonProperties(String.valueOf(String.valueOf(_imagePath)).concat("zoom.gif"), String.valueOf(String.valueOf(_imagePath)).concat("zoom_on.gif"), "Z", this._background, _ZOOM_OFF_TOOLTIP_TEXT);
        this._resetProperties = new ToolbarButtonProperties(String.valueOf(String.valueOf(_imagePath)).concat("reset.gif"), String.valueOf(String.valueOf(_imagePath)).concat("reset_on.gif"), "R", this._background, "Reset X and Y ranges to their original values");
        this._fillProperties = new ToolbarButtonProperties(String.valueOf(String.valueOf(_imagePath)).concat("fill.gif"), String.valueOf(String.valueOf(_imagePath)).concat("fill_on.gif"), "F", this._background, "Show full data range");
        this._clearSelectionProperties = new ToolbarButtonProperties(String.valueOf(String.valueOf(_imagePath)).concat("clear.gif"), String.valueOf(String.valueOf(_imagePath)).concat("clear_on.gif"), "C", this._background, "Clear Selection");
    }

    public JButton setSingleToolbarButton(JButton button, ToolbarButtonProperties properties) {
        if (properties.getImagePath() != null) {
            button = new JButton(properties.getImagePath());
            button.setBorderPainted(false);
        } else {
            button = new JButton(properties.getAltText());
        }
        button.setToolTipText(properties.getToolTip());
        button.setOpaque(true);
        button.setBackground(properties.getBackgroundColor());
        return button;
    }

    public ActionListener setButtonListener() {
        this._buttonListener = new ButtonListener(this, PlotVOApplet.plot());
        return this._buttonListener;
    }

    public MouseListener setMouseListener() {
        this._buttonMouseListener = new StatusListener();
        return this._buttonMouseListener;
    }

    public synchronized void setButtons(boolean visible, Color background) {
        this._buttons.setMaximumSize(new Dimension(100, 90));
        this._buttons.setLayout(new BorderLayout());
        this._buttons.setBackground(this._background);
        this.initToolbarButtons();
        if (this._resetButton == null) {
            this._resetButton = this.setSingleToolbarButton(this._resetButton, this._resetProperties);
            this._resetButtonListener = this.setButtonListener();
            this._resetButtonMouseListener = this.setMouseListener();
            this._resetButton.addActionListener(this._resetButtonListener);
            this._resetButton.addMouseListener(this._resetButtonMouseListener);
        }
        this._resetButton.setVisible(visible);
        if (this._fillButton == null) {
            this._fillButton = this.setSingleToolbarButton(this._fillButton, this._fillProperties);
            this._fillButtonListener = this.setButtonListener();
            this._fillButtonMouseListener = this.setMouseListener();
            this._fillButton.addActionListener(this._fillButtonListener);
            this._fillButton.addMouseListener(this._fillButtonMouseListener);
        }
        this._fillButton.setVisible(visible);
        if (this._zoomButton == null) {
            this._zoomButton = this.setSingleToolbarButton(this._zoomButton, this._zoomProperties);
            this._zoomButtonListener = this.setButtonListener();
            this._zoomButtonMouseListener = this.setMouseListener();
            this._zoomButton.addActionListener(this._zoomButtonListener);
            this._zoomButton.addMouseListener(this._zoomButtonMouseListener);
        }
        this._zoomButton.setIcon(this._zoomProperties.getHighlightedImagePath());
        this._zoomButton.setVisible(visible);
        if (this._clearSelectionButton == null) {
            this._clearSelectionButton = this.setSingleToolbarButton(this._clearSelectionButton, this._clearSelectionProperties);
            this._clearSelectionButtonListener = this.setButtonListener();
            this._clearSelectionButtonMouseListener = this.setMouseListener();
            this._clearSelectionButton.addActionListener(this._clearSelectionButtonListener);
            this._clearSelectionButton.addMouseListener(this._clearSelectionButtonMouseListener);
        }
        this._clearSelectionButton.setVisible(visible);
        if (this._selectButton == null) {
            this._selectButton = this.setSingleToolbarButton(this._selectButton, this._selectProperties);
            this._selectButtonListener = this.setButtonListener();
            this._selectMouseListener = this.setMouseListener();
            this._selectButton.addActionListener(this._selectButtonListener);
            this._selectButton.addMouseListener(this._selectMouseListener);
        }
        this._selectButton.setVisible(visible);
        if (this._plotPropertiesButton == null) {
            this._plotPropertiesButton = this.setSingleToolbarButton(this._plotPropertiesButton, this._plotProperties);
            this._plotPropertiesButtonListener = this.setButtonListener();
            this._plotPropertiesMouseListener = this.setMouseListener();
            this._plotPropertiesButton.addActionListener(this._plotPropertiesButtonListener);
            this._plotPropertiesButton.addMouseListener(this._plotPropertiesMouseListener);
        }
        this._plotPropertiesButton.setVisible(visible);
        this._buttons.add((Component)this.addToolbarButtons(), "North");
    }

    public void setMultiple(boolean isMultiple) {
        this._showMultipleVOTables = isMultiple;
    }

    private JPanel addToolbarButtons() {
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this._toolbarButtonsPanel = new JPanel(gb);
        gbc.weightx = 1.0;
        gbc.gridx = this._xcoordinate;
        gbc.gridy = this._ycoordinate;
        gbc.anchor = this._northeastAnchor;
        gb.setConstraints(this._resetButton, gbc);
        gbc.gridx = this._xcoordinate + 1;
        gbc.gridy = this._ycoordinate;
        gbc.anchor = this._northAnchor;
        gb.setConstraints(this._fillButton, gbc);
        gbc.gridx = this._xcoordinate;
        gbc.gridy = this._ycoordinate + 1;
        gbc.anchor = this._northeastAnchor;
        gb.setConstraints(this._selectButton, gbc);
        gbc.gridx = this._xcoordinate + 1;
        gbc.gridy = this._ycoordinate + 1;
        gbc.anchor = this._northAnchor;
        gb.setConstraints(this._plotPropertiesButton, gbc);
        gbc.gridx = this._xcoordinate;
        gbc.gridy = this._ycoordinate + 2;
        gbc.anchor = this._northeastAnchor;
        gb.setConstraints(this._zoomButton, gbc);
        gbc.gridx = this._xcoordinate + 1;
        gbc.gridy = this._ycoordinate + 2;
        gbc.anchor = this._northAnchor;
        gb.setConstraints(this._clearSelectionButton, gbc);
        this._toolbarButtonsPanel.add(this._resetButton);
        this._toolbarButtonsPanel.add(this._fillButton);
        this._toolbarButtonsPanel.add(this._selectButton);
        this._toolbarButtonsPanel.add(this._plotPropertiesButton);
        this._toolbarButtonsPanel.add(this._zoomButton);
        this._toolbarButtonsPanel.add(this._clearSelectionButton);
        return this._toolbarButtonsPanel;
    }

    public void setSelectedFile(String file) {
        this._selectedFile = file;
    }

    public String getSelectedFile() {
        return this._selectedFile;
    }

    public void setStatusText(String text) {
        this._statusBar.setText(text);
    }

    public boolean displayToolbar() {
        return this._showToolbar;
    }

    public void showStatusMessages(String statusbarMessage) {
        if (this._pva.isWebApp() && !this._pva.isSubApp()) {
            this._pva.showStatus(statusbarMessage);
        } else {
            this._statusBar.setText(statusbarMessage);
        }
    }

    public void showVOPlotAboutBox() {
        JPanel toplevel = new JPanel();
        Frame frame = null;
        if (toplevel instanceof Frame) {
            frame = (Frame)((Object)toplevel);
        }
        AboutDialog aboutDialog = new AboutDialog(frame, "", true);
        ((Component)aboutDialog).setVisible(true);
    }

    static {
        TOOLBAR_CELLSPACING = 1.0;
        _ZOOM_ON_TOOLTIP_TEXT = "Zoom On";
        _ZOOM_OFF_TOOLTIP_TEXT = "Zoom Off";
        _SELECT_ON_TOOLTIP_TEXT = "Select points on Plot";
        _SELECT_OFF_TOOLTIP_TEXT = "Unselect points on Plot";
    }

    class VOTableActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            block6: {
                int selectedIndex = PlotButtons.this._cmbVOTables.getSelectedIndex();
                try {
                    if (!PlotButtons.this._pva.setCurrentPlotDataIndex(selectedIndex)) break block6;
                    PlotButtons.this.emptyCmbData();
                    PlotButtons.this.emptyCmbFilter();
                    PlotButtons.this.addFilterItem("All");
                    if (PlotButtons.this._pva.getCurrentPlotData() == null) break block6;
                    PlotData pd = PlotButtons.this._pva.getCurrentPlotData();
                    try {
                        String string = pd.getVOTableMetaData().getLocation();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    int numOfCols = pd.getNumOfPlotColumns();
                    String[] fields = PlotButtons.this._pva.getColumnNames();
                    for (int i = 0; i < numOfCols; ++i) {
                        PlotButtons.this.addDataItem(fields[i]);
                    }
                    String[] filters = PlotButtons.this._pva.getFilterNames();
                    for (int i = 0; i < filters.length; ++i) {
                        PlotButtons.this.addFilterItem(filters[i]);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    class ButtonListener
    implements ActionListener,
    ItemListener {
        private PlotButtons _plotButtons;
        private PlotBox pb;

        public ButtonListener(PlotButtons pvb, PlotBox pa) {
            this._plotButtons = pvb;
            this.pb = pa;
        }

        public ButtonListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            PlotButtons.this._showToolbar = !PlotButtons.this._showToolbar;
            if (PlotButtons.this._pva.isSubApp()) {
                if (PlotButtons.this._showToolbar) {
                    PlotButtons.this._pva;
                    ((Component)PlotVOApplet.voplotFrame).setSize(new Dimension(860, 620));
                } else {
                    PlotButtons.this._pva;
                    ((Component)PlotVOApplet.voplotFrame).setSize(new Dimension(700, 620));
                }
            }
            PlotButtons.this.swapPanels();
            if (PlotButtons.this._showToolbar && PlotButtons.this._pva.isSubApp()) {
                PlotButtons.this._pva;
                ((Component)PlotVOApplet.voplotFrame).setSize(new Dimension(861, 620));
            }
        }

        public void actionPerformed(ActionEvent event) {
            if (event == null) {
                return;
            }
            if (event.getSource() == PlotButtons.this._aboutUsMenuItem) {
                PlotButtons.this.showVOPlotAboutBox();
            } else if (event.getSource() == PlotButtons.this._loadFileMenuItem) {
                boolean previousMultipleLoaded = PlotButtons.this.showMultipleCatalogues();
                if (this.loadVOTable(true)) {
                    if (previousMultipleLoaded) {
                        PlotButtons.this._panelButtonsArea = PlotButtons.this.addButtons(PlotButtons.this._pva.getColumnNames(), PlotButtons.this._background);
                        PlotButtons.this.swapPanels();
                    }
                    if (PlotButtons.this.isOverlaySelected()) {
                        PlotButtons.this.setOverlaySelected(false);
                    }
                    PlotButtons.this._pva;
                    PlotVOApplet.plot().clear(false);
                    PlotButtons.this._pva.plotDefaultColumns();
                }
            } else if (event.getSource() == PlotButtons.this._loadMultipleFilesMenuItem) {
                if (PlotButtons.this._pva.getPlotData() == null) {
                    this.loadVOTable(true);
                    PlotButtons.this._pva.plotDefaultColumns();
                } else {
                    int previousPlotDataIndex = -1;
                    int previousColX = -1;
                    int previousColY = -1;
                    previousPlotDataIndex = PlotButtons.this._pva.getCurrentPlotDataIndex();
                    previousColX = PlotButtons.this.getSelectedXIndex();
                    previousColY = PlotButtons.this.getSelectedYIndex();
                    if (this.loadVOTable(false)) {
                        if (PlotButtons.this._pva.getNumOfPlotData() == 2) {
                            PlotButtons.this._panelButtonsArea = PlotButtons.this.addButtons(PlotButtons.this._pva.getColumnNames(), PlotButtons.this._background);
                            PlotButtons.this.swapPanels();
                        }
                        PlotButtons.this._pva.plotAsPreviouslySelected(previousPlotDataIndex, previousColX, previousColY);
                    }
                    JVTUtil.showDefaultCursor(PlotButtons.this._pva);
                }
            } else if (event.getSource() == PlotButtons.this._closeVOPlotMenuItem) {
                PlotButtons.this.close();
            }
            if (PlotButtons.this._pva.getPlotData() == null) {
                return;
            }
            if (event.getSource() == PlotButtons.this._printGraphMenuItem) {
                this.pb.printPlotBox();
            } else if (event.getSource() == PlotButtons.this._plotErrorBarsMenuItem) {
                JPanel toplevel = new JPanel();
                Frame frame = null;
                if (toplevel instanceof Frame) {
                    frame = (Frame)((Object)toplevel);
                }
                PlotErrorBarsDialogBox previousColY = new PlotErrorBarsDialogBox(frame, PlotButtons.this._pva, this._plotButtons);
            } else if (event.getSource() == PlotButtons.this._plotPropertiesMenuItem || event.getSource() == PlotButtons.this._plotPropertiesButton) {
                PlotFormatter fmt = new PlotFormatter(this.pb);
                fmt.openModal();
            } else if (event.getSource() == PlotButtons.this._generateStatisticsMenuItem) {
                JPanel toplevel = new JPanel();
                Frame frame = null;
                if (toplevel instanceof Frame) {
                    frame = (Frame)((Object)toplevel);
                }
                PlotStatisticsDialog previousColY = new PlotStatisticsDialog(this.pb, frame, PlotButtons.this._pva, this._plotButtons);
            } else if (event.getSource() == PlotButtons.this._saveGraphMenuItem || event.getSource() == PlotButtons.this._helpMenuItem) {
                if (PlotButtons.this._pva.isWebApp()) {
                    PlotButtons.this._pva.showHelp();
                } else {
                    JFileChooser fc = new JFileChooser();
                    fc.addChoosableFileFilter(new PSFilter());
                    if (fc.showSaveDialog(PlotButtons.this._pva) == 0) {
                        try {
                            File fp = fc.getSelectedFile();
                            String fname = fp.getAbsolutePath();
                            if (fname.indexOf(46) == -1) {
                                fname = fname.concat(".ps");
                                fp = new File(fname);
                            }
                            fp.createNewFile();
                            FileOutputStream fos = new FileOutputStream(fp);
                            this.pb.export(fos);
                        }
                        catch (Exception ex) {
                            PlotButtons.this._pva.showError("Error while saving image of the plot.");
                            ex.printStackTrace();
                        }
                    }
                }
            } else if (event.getSource() == PlotButtons.this._createNewColumnMenuItem) {
                JPanel toplevel = new JPanel();
                Frame frame = null;
                if (toplevel instanceof Frame) {
                    frame = (Frame)((Object)toplevel);
                }
                PlotTransformerDialog plotTransformerDialog = new PlotTransformerDialog(frame, PlotButtons.this._pva);
            } else if (event.getSource() == PlotButtons.this._createFilterMenuItem) {
                JPanel toplevel = new JPanel();
                Frame frame = null;
                if (toplevel instanceof Frame) {
                    frame = (Frame)((Object)toplevel);
                }
                PlotFilterDialog plotFilterDialog = new PlotFilterDialog(frame, PlotButtons.this._pva);
            } else if (event.getSource() == PlotButtons.this._votableTableFormatMenuItem) {
                if (PlotButtons.this._pva.getPlotData() != null && JVTUtil.SHOW_DATA) {
                    JPanel toplevel = new JPanel();
                    Frame frame = null;
                    if (toplevel instanceof Frame) {
                        frame = (Frame)((Object)toplevel);
                    }
                    PlotDataDisplayDialog plotDataDisplayDialog = new PlotDataDisplayDialog(frame, PlotButtons.this._pva, this._plotButtons);
                }
            } else if (event.getSource() == PlotButtons.this._votableXmlFormatMenuItem) {
                if (PlotButtons.this._pva.getPlotData() != null && JVTUtil.SHOW_VOTABLE) {
                    JPanel toplevel = new JPanel();
                    Frame frame = null;
                    if (toplevel instanceof Frame) {
                        frame = (Frame)((Object)toplevel);
                    }
                    PlotVotableDisplayDialog plotVotableDisplayDialog = new PlotVotableDisplayDialog(frame, PlotButtons.this._pva, this._plotButtons);
                }
            } else if (event.getSource() == PlotButtons.this._aSCIIFormatMenuItem) {
                if (PlotButtons.this._pva.getPlotData() != null) {
                    JPanel toplevel = new JPanel();
                    Frame frame = null;
                    if (toplevel instanceof Frame) {
                        frame = (Frame)((Object)toplevel);
                    }
                    PlotASCIIFormatDisplayDialog plotASCIIFormatDisplayDialog = new PlotASCIIFormatDisplayDialog(frame, PlotButtons.this._pva, this._plotButtons);
                }
            } else if (event.getSource() == PlotButtons.this._aladinMenuItem) {
                if (!PlotButtons.this._pva.isSubApp()) {
                    int isAladinVisible = PlotButtons.this._pva.showAladinDialog();
                    if (isAladinVisible != 1) {
                        String aladinNotAvailable = "Aladin is not shipped with this version of VOPlot (VOTable Plotting tool)  \n ";
                        JOptionPane.showMessageDialog(null, aladinNotAvailable, "Warning !!", 1);
                    }
                } else {
                    PlotButtons.this.showVOPlotAboutBox();
                }
            } else if (event.getSource() == PlotButtons.this._resetButton || event.getSource() == PlotButtons.this._resetGraphMenuItem) {
                this.pb.resetAxes();
            } else if (event.getSource() == PlotButtons.this._fillButton || event.getSource() == PlotButtons.this._fillGraphMenuItem) {
                this.pb.fillPlot();
            } else if (event.getSource() == PlotButtons.this._zoomButton || event.getSource() == PlotButtons.this._zoomPlotMenuItem) {
                if (PlotButtons.this._buttonMode != 1) {
                    PlotButtons.this._buttonMode = 1;
                    PlotButtons.this._zoomButton.setIcon(PlotButtons.this._zoomProperties.getHighlightedImagePath());
                    PlotButtons.this._zoomButton.setToolTipText(_ZOOM_OFF_TOOLTIP_TEXT);
                    String label = "Zoom";
                    PlotButtons.this._pva.repaint();
                    this.pb.zoomSelect(label);
                    PlotButtons.this._buttonMode = 1;
                    PlotButtons.this._zoomPlotMenuItem.setSelected(true);
                } else if (PlotButtons.this._isSelectButtonDown) {
                    PlotButtons.this._buttonMode = 2;
                    String label = "Select";
                    PlotButtons.this._pva.repaint();
                    this.pb.zoomSelect(label);
                    PlotButtons.this._selectButton.setIcon(PlotButtons.this._selectProperties.getHighlightedImagePath());
                    PlotButtons.this._selectButton.setToolTipText(_SELECT_OFF_TOOLTIP_TEXT);
                    PlotButtons.this._zoomButton.setIcon(PlotButtons.this._zoomProperties.getImagePath());
                    PlotButtons.this._zoomButton.setToolTipText(_ZOOM_ON_TOOLTIP_TEXT);
                    PlotButtons.this._selectPointMenuItem.setSelected(true);
                } else {
                    PlotButtons.this._buttonMode = 3;
                    String label = "UnSelect";
                    PlotButtons.this._pva.repaint();
                    this.pb.zoomSelect(label);
                    PlotButtons.this._selectButton.setIcon(PlotButtons.this._selectProperties.getImagePath());
                    PlotButtons.this._selectButton.setToolTipText(_SELECT_ON_TOOLTIP_TEXT);
                    PlotButtons.this._zoomButton.setIcon(PlotButtons.this._zoomProperties.getImagePath());
                    PlotButtons.this._zoomButton.setToolTipText(_ZOOM_ON_TOOLTIP_TEXT);
                    PlotButtons.this._unselectPointsMenuItem.setSelected(true);
                }
            } else if (event.getSource() == PlotButtons.this._clearSelectionButton || event.getSource() == PlotButtons.this._clearAllSelectedPointsMenuItem) {
                PlotButtons.this._pva.clearSelectedPoints(true);
            } else if (event.getSource() == PlotButtons.this._selectButton || event.getSource() == PlotButtons.this._selectPointMenuItem) {
                String label = "";
                if (event.getSource() == PlotButtons.this._selectButton) {
                    PlotButtons.this._isSelectButtonDown = !PlotButtons.this._isSelectButtonDown;
                } else if (event.getSource() == PlotButtons.this._selectPointMenuItem) {
                    PlotButtons.this._isSelectButtonDown = true;
                }
                if (PlotButtons.this._isSelectButtonDown) {
                    label = "Select";
                    PlotButtons.this._selectButton.setIcon(PlotButtons.this._selectProperties.getHighlightedImagePath());
                    PlotButtons.this._selectButton.setToolTipText(_SELECT_OFF_TOOLTIP_TEXT);
                    PlotButtons.this._buttonMode = 2;
                    PlotButtons.this._selectPointMenuItem.setSelected(true);
                } else {
                    label = "UnSelect";
                    PlotButtons.this._selectButton.setIcon(PlotButtons.this._selectProperties.getImagePath());
                    PlotButtons.this._selectButton.setToolTipText(_SELECT_ON_TOOLTIP_TEXT);
                    PlotButtons.this._buttonMode = 3;
                    PlotButtons.this._unselectPointsMenuItem.setSelected(true);
                }
                PlotButtons.this._zoomButton.setIcon(PlotButtons.this._zoomProperties.getImagePath());
                PlotButtons.this._zoomButton.setToolTipText(_ZOOM_ON_TOOLTIP_TEXT);
                this.pb.zoomSelect(label);
                PlotButtons.this._pva.repaint();
            } else if (event.getSource() == PlotButtons.this._unselectPointsMenuItem) {
                String label = "UnSelect";
                this.pb.zoomSelect(label);
                PlotButtons.this._zoomButton.setIcon(PlotButtons.this._zoomProperties.getImagePath());
                PlotButtons.this._zoomButton.setToolTipText(_ZOOM_OFF_TOOLTIP_TEXT);
                PlotButtons.this._selectButton.setIcon(PlotButtons.this._selectProperties.getImagePath());
                PlotButtons.this._selectButton.setToolTipText(_SELECT_ON_TOOLTIP_TEXT);
                PlotButtons.this._buttonMode = 3;
                PlotButtons.this._isSelectButtonDown = false;
                PlotButtons.this._pva.repaint();
            }
        }

        private boolean loadVOTable(boolean isMultiple) {
            try {
                String tableName;
                PlotData pd;
                if (PlotButtons.this._currentDirectory == null) {
                    PlotButtons.this._currentDirectory = new File(System.getProperty("user.dir"));
                }
                JFileChooser fc = new JFileChooser(PlotButtons.this._currentDirectory);
                fc.addChoosableFileFilter(new VOTableFilter());
                int returnVal = fc.showOpenDialog(PlotButtons.this._pva);
                if (returnVal != 0) {
                    boolean file2 = false;
                    return file2;
                }
                File file2 = fc.getSelectedFile();
                PlotButtons.this._currentDirectory = fc.getCurrentDirectory();
                PlotButtons.this.setSelectedFile(file2.getPath());
                if (isMultiple) {
                    PlotButtons.this._pva.clearPlotData();
                    PlotButtons.this._showMultipleVOTables = false;
                    PlotButtons.this.emptyCmbVOTables();
                } else {
                    PlotButtons.this._showMultipleVOTables = true;
                }
                PlotButtons.this._selectButton.setEnabled(true);
                PlotButtons.this.filename = PlotButtons.this.getSelectedFile();
                if (PlotButtons.this.filename == null || PlotButtons.this.filename.trim().length() <= 0) {
                    JOptionPane.showMessageDialog(null, "No VOTable file selected.", "Error !!", 0);
                    boolean file2 = false;
                    return file2;
                }
                PlotButtons.this.filename = PlotButtons.this.filename.trim();
                if (PlotButtons.this._showMultipleVOTables) {
                    for (int i = 0; i < PlotButtons.this._pva.getNumOfPlotData(); ++i) {
                        pd = PlotButtons.this._pva.getPlotData(i);
                        String location = pd.getVOTableMetaData().getLocation();
                        if (!location.equals(PlotButtons.this.filename)) continue;
                        JOptionPane.showMessageDialog(null, "This VOTable document is already loaded in VOPlot.", "Error !!", 0);
                        boolean bl = false;
                        return bl;
                    }
                }
                this._plotButtons.setStatusText("");
                this._plotButtons.setStatusText("Parsing VOTable. Please wait.");
                JVTUtil.showWaitCursor(PlotButtons.this._pva);
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parsing VOTable '").append(PlotButtons.this.filename).append("'."))));
                SAVOTParser sp = PlotButtons.this.filename.startsWith("http://") || PlotButtons.this.filename.startsWith("HTTP://") ? new SAVOTParser(PlotButtons.this.filename) : new SAVOTParser(PlotButtons.this.filename, true);
                pd = sp.getPlotData();
                VOTableMetaData votableMetaData = new VOTableMetaData();
                votableMetaData.setVOTable(sp.getVOTableMetaData());
                votableMetaData.setResource(sp.getVOTableResourceMetaData());
                votableMetaData.setTable(sp.getVOTableTableMetaData());
                int iVOTableNum = PlotButtons.this._pva.getNumOfPlotData() + 1;
                try {
                    tableName = sp.getVOTableTableMetaData().getName();
                }
                catch (Exception ex) {
                    tableName = "";
                }
                if (tableName == null || tableName.length() == 0) {
                    tableName = "Table".concat(String.valueOf(String.valueOf(iVOTableNum)));
                }
                PlotButtons.this.addVOTableItem(String.valueOf(String.valueOf(new StringBuffer("").append(JVTUtil.CATALOGUE_SEPARATOR_OPEN).append(iVOTableNum).append(JVTUtil.CATALOGUE_SEPARATOR_CLOSE).append(tableName))));
                PlotButtons.this._pva.clearSelectedPoints(true);
                PlotButtons.this._pva.showVOTableObject(null);
                if (pd == null) {
                    this._plotButtons.setStatusText("Error while loading VOTable.");
                    PlotButtons.this._pva.showError(String.valueOf(String.valueOf(new StringBuffer("Could not load votable from '").append(PlotButtons.this.filename).append("'."))));
                } else {
                    votableMetaData.setLocation(PlotButtons.this.filename);
                    pd.setVOTableMetaData(votableMetaData);
                    if (pd.getNumOfPlotColumns() <= 0) {
                        PlotButtons.this._pva.showError(PlotVOApplet._errorMsg[3]);
                    } else {
                        this._plotButtons.setStatusText(String.valueOf(String.valueOf(new StringBuffer("Loaded VOTable '").append(PlotButtons.this.filename).append("'."))));
                        if (pd.getObjectIDColumn() == null) {
                            pd.generateObjectIDColumn();
                        }
                    }
                }
                PlotButtons.this._pva.setPlotData(pd);
                ((PlotButtons)PlotButtons.this)._pva.plotApp.setTitle(String.valueOf(String.valueOf(JVTUtil.APP_TITLE_PREFIX)).concat(String.valueOf(String.valueOf(PlotButtons.this.filename))));
                PlotButtons.this._cmbVOTables.setSelectedIndex(PlotButtons.this._cmbVOTables.getItemCount() - 1);
                JVTUtil.showDefaultCursor(PlotButtons.this._pva);
            }
            catch (Exception ex) {
                System.err.println("Error: Could not load VOTable data.");
                JVTUtil.showDefaultCursor(PlotButtons.this._pva);
                boolean bl = false;
                return bl;
            }
            return true;
        }
    }

    class StatusListener
    implements MouseListener {
        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            if (e.getSource() == PlotButtons.this._resetButton) {
                PlotButtons.this.showStatusMessages("Reset the graph back to its original dimensions.");
            } else if (e.getSource() == PlotButtons.this._fillButton) {
                PlotButtons.this.showStatusMessages("View the entire data range in the graph.");
            } else if (e.getSource() == PlotButtons.this._zoomButton) {
                PlotButtons.this.showStatusMessages("Zoom mode - Drag the left mouse button down to the right to zoom in.");
            } else if (e.getSource() == PlotButtons.this._clearSelectionButton) {
                PlotButtons.this.showStatusMessages("Unselects all the selected points.");
            } else if (e.getSource() == PlotButtons.this._selectButton) {
                PlotButtons.this.showStatusMessages("Select mode - Drag the left mouse button down to the right to select points.");
            } else if (e.getSource() == PlotButtons.this._plotPropertiesButton) {
                PlotButtons.this.showStatusMessages("Change Plot Properties");
            } else if (e.getSource() == PlotButtons.this._btnPlot) {
                PlotButtons.this.showStatusMessages("Draw scatter plot based on the selected X and Y columns.");
            } else if (e.getSource() == PlotButtons.this._btnHist) {
                PlotButtons.this.showStatusMessages("Draw histogram based on the selected X column.");
            } else if (e.getSource() == PlotButtons.this._chkOverlay) {
                PlotButtons.this.showStatusMessages("To overlay plot.");
            } else if (e.getSource() == PlotButtons.this._chkLogX) {
                PlotButtons.this.showStatusMessages("Takes log of X column.");
            } else if (e.getSource() == PlotButtons.this._chkLogY) {
                PlotButtons.this.showStatusMessages("Takes log of Y column.");
            }
        }

        public void mouseExited(MouseEvent e) {
            if (PlotButtons.this._pva.getPlotData() != null) {
                if (PlotButtons.this._buttonMode == 1) {
                    PlotButtons.this.showStatusMessages("You are currently in Zoom mode.");
                } else if (PlotButtons.this._buttonMode == 2) {
                    PlotButtons.this.showStatusMessages("You are currently in Select mode.");
                } else {
                    PlotButtons.this.showStatusMessages("You are currently in Unselect mode.");
                }
            } else {
                PlotButtons.this.showStatusMessages("No VOTable Loaded. ");
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.getSource() == PlotButtons.this._resetButton) {
                PlotButtons.this._resetButton.setIcon(PlotButtons.this._resetProperties.getHighlightedImagePath());
            } else if (e.getSource() == PlotButtons.this._fillButton) {
                PlotButtons.this._fillButton.setIcon(PlotButtons.this._fillProperties.getHighlightedImagePath());
            } else if (e.getSource() == PlotButtons.this._clearSelectionButton) {
                PlotButtons.this._clearSelectionButton.setIcon(PlotButtons.this._clearSelectionProperties.getHighlightedImagePath());
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.getSource() == PlotButtons.this._resetButton) {
                PlotButtons.this._resetButton.setIcon(PlotButtons.this._resetProperties.getImagePath());
            } else if (e.getSource() == PlotButtons.this._fillButton) {
                PlotButtons.this._fillButton.setIcon(PlotButtons.this._fillProperties.getImagePath());
            } else if (e.getSource() == PlotButtons.this._clearSelectionButton) {
                PlotButtons.this._clearSelectionButton.setIcon(PlotButtons.this._clearSelectionProperties.getImagePath());
            }
        }
    }
}

