/*
 * Decompiled with CFR 0.152.
 */
package com.jvt.applets;

import java.text.DecimalFormat;

class CoordinateConverter {
    private double pi = 2.0 * Math.asin(1.0);
    private int itern = 30;
    private double tol = 1.0E-7;
    private double alfa0b50 = 282.25 * this.pi / (double)180;
    private double dl0b50 = 33.0 * this.pi / (double)180;
    private double delngp = 27.4 * this.pi / 180.0;
    private double[] alpha;
    private double[] delta;
    private double[] dlrad;
    private double[] brad;
    private double[] x_mw;
    private double[] y_mw;
    private double[] x_ha;
    private double[] y_ha;
    private double[] x_me;
    private double[] y_me;
    private double[] x_si;
    private double[] y_si;
    private double[] dldeg;
    private double[] bdeg;
    private int nrows;

    CoordinateConverter() {
    }

    public void simpleprojection(double[] RAdeg, double[] DECdeg) {
        this.degtorad(RAdeg, DECdeg);
        this.eqtogal();
        this.dldeg = new double[this.nrows];
        this.bdeg = new double[this.nrows];
        for (int i = 0; i < this.nrows; ++i) {
            this.bdeg[i] = this.brad[i] * (double)180 / this.pi;
            this.dldeg[i] = this.dlrad[i] * (double)180 / this.pi;
        }
        System.out.println("bdeg");
        this.printArray(this.bdeg);
        System.out.println("dldeg");
        this.printArray(this.dldeg);
    }

    public void printArray(double[] data) {
        DecimalFormat fmt = new DecimalFormat("0.00");
        for (int i = 0; i < data.length; ++i) {
            System.out.println(fmt.format(data[i]));
        }
    }

    public double[] getgallat() {
        return this.bdeg;
    }

    public double[] getgallong() {
        return this.dldeg;
    }

    public void degtorad(double[] RAdeg, double[] DECdeg) {
        this.nrows = RAdeg.length;
        this.alpha = new double[this.nrows];
        this.delta = new double[this.nrows];
        for (int i = 0; i < this.nrows; ++i) {
            this.alpha[i] = RAdeg[i] * this.pi / (double)180;
            this.delta[i] = DECdeg[i] * this.pi / (double)180;
        }
    }

    public void eqtogal() {
        this.dlrad = new double[this.nrows];
        this.brad = new double[this.nrows];
        for (int i = 0; i < this.nrows; ++i) {
            double deldel = Math.sin(this.delta[i]) * Math.sin(this.delngp);
            double delalfa = Math.cos(this.delta[i]) * Math.cos(this.delngp) * Math.sin(this.alpha[i] - this.alfa0b50);
            this.brad[i] = Math.asin(deldel - delalfa);
            double parta = Math.cos(this.delngp) * Math.tan(this.delta[i]) / Math.cos(this.alpha[i] - this.alfa0b50);
            double partb = Math.tan(this.alpha[i] - this.alfa0b50) * Math.sin(this.delngp);
            this.dlrad[i] = Math.atan(parta + partb) + this.dl0b50;
        }
    }

    public void projmoll(double[] RAdeg, double[] DECdeg) {
        this.degtorad(RAdeg, DECdeg);
        this.eqtogal();
        this.x_mw = new double[this.nrows];
        this.y_mw = new double[this.nrows];
        for (int i = 0; i < this.nrows; ++i) {
            double phi = this.brad[i];
            double theta = this.newtonraphson(phi);
            this.x_mw[i] = 2.0 * Math.sqrt(2.0) * (this.dlrad[i] - this.dl0b50) * Math.cos(theta) / this.pi;
            this.y_mw[i] = Math.sqrt(2.0) * Math.sin(theta);
        }
    }

    public void aitoff(double[] RAdeg, double[] DECdeg) {
        this.degtorad(RAdeg, DECdeg);
        this.eqtogal();
        this.x_ha = new double[this.nrows];
        this.y_ha = new double[this.nrows];
        for (int i = 0; i < this.nrows; ++i) {
            double t_ha = Math.sqrt(2.0 / (1.0 + Math.cos(this.brad[i]) * Math.cos(this.dlrad[i] * 0.5)));
            this.x_ha[i] = 2.0 * t_ha * Math.cos(this.brad[i]) * Math.sin(0.5 * this.dlrad[i]);
            this.y_ha[i] = t_ha * Math.sin(this.brad[i]);
        }
    }

    public void merc(double[] RAdeg, double[] DECdeg) {
        this.degtorad(RAdeg, DECdeg);
        this.eqtogal();
        this.x_me = new double[this.nrows];
        this.y_me = new double[this.nrows];
        for (int i = 0; i < this.nrows; ++i) {
            this.x_me[i] = this.dlrad[i] - this.dl0b50;
            this.y_me[i] = 0.5 * Math.log((1.0 + Math.sin(this.brad[i])) / (1.0 - Math.sin(this.brad[i])));
        }
    }

    public void sinu(double[] RAdeg, double[] DECdeg) {
        this.degtorad(RAdeg, DECdeg);
        this.eqtogal();
        this.x_si = new double[this.nrows];
        this.y_si = new double[this.nrows];
        for (int i = 0; i < this.nrows; ++i) {
            this.x_si[i] = (this.dlrad[i] - this.dl0b50) * Math.cos(this.brad[i]);
            this.y_si[i] = this.brad[i];
        }
    }

    public double newtonraphson(double phi) {
        double tht0 = 2.0 * Math.asin(2.0 * phi / this.pi);
        double tht1 = 0.0;
        int itcnt = 1;
        boolean iflag = false;
        while (!iflag) {
            double deno;
            iflag = true;
            tht1 = tht0 - this.func(tht0, phi) / this.grad(tht0);
            double dnum = Math.abs(tht1 - tht0);
            if (!(dnum / (deno = Math.abs(tht1)) > this.tol) || itcnt >= this.itern) continue;
            iflag = false;
            tht0 = tht1;
            ++itcnt;
        }
        return tht1;
    }

    public double func(double theta, double phi) {
        double tht2 = 2.0 * theta;
        return tht2 + Math.sin(tht2) - this.pi * Math.sin(phi);
    }

    public double grad(double theta) {
        double tht2 = 2.0 * theta;
        return 2.0 * (1.0 + Math.cos(tht2));
    }

    public double[] getxmw() {
        return this.x_mw;
    }

    public double[] getymw() {
        return this.y_mw;
    }

    public double[] getxha() {
        return this.x_ha;
    }

    public double[] getyha() {
        return this.y_ha;
    }

    public double[] getxme() {
        return this.x_me;
    }

    public double[] getyme() {
        return this.y_me;
    }

    public double[] getxsi() {
        return this.x_si;
    }

    public double[] getysi() {
        return this.y_si;
    }
}

