/*
 * Decompiled with CFR 0.152.
 */
package com.jvt.applets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ComponentEventDemo
extends JPanel
implements ComponentListener,
ItemListener {
    static JFrame frame;
    JTextArea display = new JTextArea();
    JLabel label;
    String newline = "\n";

    public ComponentEventDemo() {
        super(new BorderLayout());
        this.display.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this.display);
        scrollPane.setPreferredSize(new Dimension(350, 200));
        JPanel panel = new JPanel(new BorderLayout());
        this.label = new JLabel("This is a label", 0);
        this.label.addComponentListener(this);
        panel.add((Component)this.label, "Center");
        JCheckBox checkbox = new JCheckBox("Label visible", true);
        checkbox.addItemListener(this);
        checkbox.addComponentListener(this);
        panel.add((Component)checkbox, "Last");
        panel.addComponentListener(this);
        this.add((Component)scrollPane, "Center");
        this.add((Component)panel, "After");
        frame.addComponentListener(this);
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.label.setVisible(true);
            this.label.revalidate();
            this.label.repaint();
        } else {
            this.label.setVisible(false);
        }
    }

    protected void displayMessage(String message) {
        if (this.display.isShowing()) {
            this.display.append(String.valueOf(String.valueOf(message)).concat(String.valueOf(String.valueOf(this.newline))));
            this.display.setCaretPosition(this.display.getDocument().getLength());
        }
    }

    public void componentHidden(ComponentEvent e) {
        this.displayMessage("componentHidden event from ".concat(String.valueOf(String.valueOf(e.getComponent().getClass().getName()))));
    }

    public void componentMoved(ComponentEvent e) {
        Component c = e.getComponent();
        this.displayMessage(String.valueOf(String.valueOf(new StringBuffer("componentMoved event from ").append(c.getClass().getName()).append("; new location: ").append(c.getLocation().x).append(", ").append(c.getLocation().y))));
    }

    public void componentResized(ComponentEvent e) {
        Component c = e.getComponent();
        this.displayMessage(String.valueOf(String.valueOf(new StringBuffer("componentResized event from ").append(c.getClass().getName()).append("; new size: ").append(c.getSize().width).append(", ").append(c.getSize().height))));
    }

    public void componentShown(ComponentEvent e) {
        this.displayMessage("componentShown event from ".concat(String.valueOf(String.valueOf(e.getComponent().getClass().getName()))));
    }

    private static void createAndShowGUI() {
        frame = new JFrame("ComponentEventDemo");
        frame.setDefaultCloseOperation(3);
        ComponentEventDemo newContentPane = new ComponentEventDemo();
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        ((Component)frame).setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ComponentEventDemo.createAndShowGUI();
            }
        });
    }
}

