/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.Sorting;
import cern.colt.function.DoubleProcedure;
import cern.colt.list.AbstractDoubleList;
import cern.colt.list.AbstractList;
import cern.jet.math.Arithmetic;
import cern.jet.random.Uniform;
import cern.jet.random.engine.DRand;
import java.util.Date;

public class DoubleArrayList
extends AbstractDoubleList {
    protected double[] elements;

    public DoubleArrayList() {
        this(10);
    }

    public DoubleArrayList(double[] dArray) {
        this.elements(dArray);
    }

    public DoubleArrayList(int n) {
        this(new double[n]);
        this.setSizeRaw(0);
    }

    public void add(double d) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size++] = d;
    }

    public void beforeInsert(int n, double d) {
        if (this.size == n) {
            this.add(d);
            return;
        }
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, n, this.elements, n + 1, this.size - n);
        this.elements[n] = d;
        ++this.size;
    }

    public int binarySearchFromTo(double d, int n, int n2) {
        return Sorting.binarySearchFromTo((double[])this.elements, (double)d, (int)n, (int)n2);
    }

    public Object clone() {
        DoubleArrayList doubleArrayList = new DoubleArrayList((double[])this.elements.clone());
        doubleArrayList.setSizeRaw(this.size);
        return doubleArrayList;
    }

    public DoubleArrayList copy() {
        return (DoubleArrayList)this.clone();
    }

    public double[] elements() {
        return this.elements;
    }

    public AbstractDoubleList elements(double[] dArray) {
        this.elements = dArray;
        this.size = dArray.length;
        return this;
    }

    public void ensureCapacity(int n) {
        this.elements = Arrays.ensureCapacity(this.elements, n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DoubleArrayList)) {
            return super.equals(object);
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        DoubleArrayList doubleArrayList = (DoubleArrayList)object;
        if (this.size() != doubleArrayList.size()) {
            return false;
        }
        double[] dArray = this.elements();
        double[] dArray2 = doubleArrayList.elements();
        int n = this.size();
        while (--n >= 0) {
            if (dArray[n] == dArray2[n]) continue;
            return false;
        }
        return true;
    }

    public boolean forEach(DoubleProcedure doubleProcedure) {
        double[] dArray = this.elements;
        int n = this.size;
        int n2 = 0;
        while (n2 < n) {
            if (doubleProcedure.apply(dArray[n2++])) continue;
            return false;
        }
        return true;
    }

    public double get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.elements[n];
    }

    public double getQuick(int n) {
        return this.elements[n];
    }

    public int indexOfFromTo(double d, int n, int n2) {
        if (this.size == 0) {
            return -1;
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        double[] dArray = this.elements;
        int n3 = n;
        while (n3 <= n2) {
            if (d == dArray[n3]) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public int lastIndexOfFromTo(double d, int n, int n2) {
        if (this.size == 0) {
            return -1;
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        double[] dArray = this.elements;
        int n3 = n2;
        while (n3 >= n) {
            if (d == dArray[n3]) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public AbstractDoubleList partFromTo(int n, int n2) {
        if (this.size == 0) {
            return new DoubleArrayList(0);
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        double[] dArray = new double[n2 - n + 1];
        System.arraycopy(this.elements, n, dArray, 0, n2 - n + 1);
        return new DoubleArrayList(dArray);
    }

    public boolean removeAll(AbstractDoubleList abstractDoubleList) {
        double d;
        if (!(abstractDoubleList instanceof DoubleArrayList)) {
            return super.removeAll(abstractDoubleList);
        }
        if (abstractDoubleList.size() == 0) {
            return false;
        }
        int n = abstractDoubleList.size() - 1;
        int n2 = 0;
        double[] dArray = this.elements;
        int n3 = this.size();
        double d2 = abstractDoubleList.size();
        if ((d2 + (d = (double)n3)) * Arithmetic.log2(d2) < d * d2) {
            DoubleArrayList doubleArrayList = (DoubleArrayList)abstractDoubleList.clone();
            doubleArrayList.quickSort();
            int n4 = 0;
            while (n4 < n3) {
                if (doubleArrayList.binarySearchFromTo(dArray[n4], 0, n) < 0) {
                    dArray[n2++] = dArray[n4];
                }
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n3) {
                if (abstractDoubleList.indexOfFromTo(dArray[n5], 0, n) < 0) {
                    dArray[n2++] = dArray[n5];
                }
                ++n5;
            }
        }
        boolean bl = n2 != n3;
        this.setSize(n2);
        return bl;
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractDoubleList abstractDoubleList, int n3) {
        if (!(abstractDoubleList instanceof DoubleArrayList)) {
            super.replaceFromToWithFrom(n, n2, abstractDoubleList, n3);
            return;
        }
        int n4 = n2 - n + 1;
        if (n4 > 0) {
            AbstractList.checkRangeFromTo(n, n2, this.size());
            AbstractList.checkRangeFromTo(n3, n3 + n4 - 1, abstractDoubleList.size());
            System.arraycopy(((DoubleArrayList)abstractDoubleList).elements, n3, this.elements, n, n4);
        }
    }

    public boolean retainAll(AbstractDoubleList abstractDoubleList) {
        double d;
        if (!(abstractDoubleList instanceof DoubleArrayList)) {
            return super.retainAll(abstractDoubleList);
        }
        int n = abstractDoubleList.size() - 1;
        int n2 = 0;
        double[] dArray = this.elements;
        int n3 = this.size();
        double d2 = abstractDoubleList.size();
        if ((d2 + (d = (double)n3)) * Arithmetic.log2(d2) < d * d2) {
            DoubleArrayList doubleArrayList = (DoubleArrayList)abstractDoubleList.clone();
            doubleArrayList.quickSort();
            int n4 = 0;
            while (n4 < n3) {
                if (doubleArrayList.binarySearchFromTo(dArray[n4], 0, n) >= 0) {
                    dArray[n2++] = dArray[n4];
                }
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n3) {
                if (abstractDoubleList.indexOfFromTo(dArray[n5], 0, n) >= 0) {
                    dArray[n2++] = dArray[n5];
                }
                ++n5;
            }
        }
        boolean bl = n2 != n3;
        this.setSize(n2);
        return bl;
    }

    public void reverse() {
        int n = this.size / 2;
        int n2 = this.size - 1;
        double[] dArray = this.elements;
        int n3 = 0;
        while (n3 < n) {
            double d = dArray[n3];
            dArray[n3++] = dArray[n2];
            dArray[n2--] = d;
        }
    }

    public void set(int n, double d) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.elements[n] = d;
    }

    public void setQuick(int n, double d) {
        this.elements[n] = d;
    }

    public void shuffleFromTo(int n, int n2) {
        if (this.size == 0) {
            return;
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        Uniform uniform = new Uniform(new DRand(new Date()));
        double[] dArray = this.elements;
        int n3 = n;
        while (n3 < n2) {
            int n4 = uniform.nextIntFromTo(n3, n2);
            double d = dArray[n4];
            dArray[n4] = dArray[n3];
            dArray[n3] = d;
            ++n3;
        }
    }

    public void trimToSize() {
        this.elements = Arrays.trimToCapacity(this.elements, this.size());
    }
}

