/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.Sorting;
import cern.colt.buffer.IntBufferConsumer;
import cern.colt.function.IntComparator;
import cern.colt.function.IntProcedure;
import cern.colt.list.AbstractList;
import cern.colt.list.IntArrayList;
import cern.jet.random.Uniform;
import cern.jet.random.engine.DRand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public abstract class AbstractIntList
extends AbstractList
implements IntBufferConsumer {
    protected int size;

    protected AbstractIntList() {
    }

    public void add(int n) {
        this.beforeInsert(this.size, n);
    }

    public void addAllOf(IntArrayList intArrayList) {
        this.addAllOfFromTo(intArrayList, 0, intArrayList.size() - 1);
    }

    public void addAllOfFromTo(AbstractIntList abstractIntList, int n, int n2) {
        this.beforeInsertAllOfFromTo(this.size, abstractIntList, n, n2);
    }

    public void beforeInsert(int n, int n2) {
        this.beforeInsertDummies(n, 1);
        this.set(n, n2);
    }

    public void beforeInsertAllOfFromTo(int n, AbstractIntList abstractIntList, int n2, int n3) {
        int n4 = n3 - n2 + 1;
        this.beforeInsertDummies(n, n4);
        this.replaceFromToWithFrom(n, n + n4 - 1, abstractIntList, n2);
    }

    protected void beforeInsertDummies(int n, int n2) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        if (n2 > 0) {
            this.ensureCapacity(this.size + n2);
            this.setSizeRaw(this.size + n2);
            this.replaceFromToWithFrom(n + n2, this.size - 1, this, n);
        }
    }

    public int binarySearch(int n) {
        return this.binarySearchFromTo(n, 0, this.size - 1);
    }

    public int binarySearchFromTo(int n, int n2, int n3) {
        int n4 = n2;
        int n5 = n3;
        while (n4 <= n5) {
            int n6 = (n4 + n5) / 2;
            int n7 = this.get(n6);
            if (n7 < n) {
                n4 = n6 + 1;
                continue;
            }
            if (n7 > n) {
                n5 = n6 - 1;
                continue;
            }
            return n6;
        }
        return -(n4 + 1);
    }

    public Object clone() {
        return this.partFromTo(0, this.size - 1);
    }

    public boolean contains(int n) {
        return this.indexOfFromTo(n, 0, this.size - 1) >= 0;
    }

    public void delete(int n) {
        int n2 = this.indexOfFromTo(n, 0, this.size - 1);
        if (n2 >= 0) {
            this.remove(n2);
        }
    }

    public int[] elements() {
        int[] nArray = new int[this.size];
        int n = this.size;
        while (--n >= 0) {
            nArray[n] = this.getQuick(n);
        }
        return nArray;
    }

    public AbstractIntList elements(int[] nArray) {
        this.clear();
        this.addAllOfFromTo(new IntArrayList(nArray), 0, nArray.length - 1);
        return this;
    }

    public abstract void ensureCapacity(int var1);

    public boolean equals(Object object) {
        if (!(object instanceof AbstractIntList)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        AbstractIntList abstractIntList = (AbstractIntList)object;
        if (this.size() != abstractIntList.size()) {
            return false;
        }
        int n = this.size();
        while (--n >= 0) {
            if (this.getQuick(n) == abstractIntList.getQuick(n)) continue;
            return false;
        }
        return true;
    }

    public void fillFromToWith(int n, int n2, int n3) {
        AbstractList.checkRangeFromTo(n, n2, this.size);
        int n4 = n;
        while (n4 <= n2) {
            this.setQuick(n4++, n3);
        }
    }

    public boolean forEach(IntProcedure intProcedure) {
        int n = 0;
        while (n < this.size) {
            if (intProcedure.apply(this.get(n++))) continue;
            return false;
        }
        return true;
    }

    public int get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.getQuick(n);
    }

    protected abstract int getQuick(int var1);

    public int indexOf(int n) {
        return this.indexOfFromTo(n, 0, this.size - 1);
    }

    public int indexOfFromTo(int n, int n2, int n3) {
        AbstractList.checkRangeFromTo(n2, n3, this.size);
        int n4 = n2;
        while (n4 <= n3) {
            if (n == this.getQuick(n4)) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    public int lastIndexOf(int n) {
        return this.lastIndexOfFromTo(n, 0, this.size - 1);
    }

    public int lastIndexOfFromTo(int n, int n2, int n3) {
        AbstractList.checkRangeFromTo(n2, n3, this.size());
        int n4 = n3;
        while (n4 >= n2) {
            if (n == this.getQuick(n4)) {
                return n4;
            }
            --n4;
        }
        return -1;
    }

    public void mergeSortFromTo(int n, int n2) {
        int n3 = this.size();
        AbstractList.checkRangeFromTo(n, n2, n3);
        int[] nArray = this.elements();
        Sorting.mergeSort((int[])nArray, (int)n, (int)(n2 + 1));
        this.elements(nArray);
        this.setSizeRaw(n3);
    }

    public void mergeSortFromTo(int n, int n2, IntComparator intComparator) {
        int n3 = this.size();
        AbstractList.checkRangeFromTo(n, n2, n3);
        int[] nArray = this.elements();
        Sorting.mergeSort((int[])nArray, (int)n, (int)(n2 + 1), (IntComparator)intComparator);
        this.elements(nArray);
        this.setSizeRaw(n3);
    }

    public AbstractIntList partFromTo(int n, int n2) {
        AbstractList.checkRangeFromTo(n, n2, this.size);
        int n3 = n2 - n + 1;
        IntArrayList intArrayList = new IntArrayList(n3);
        intArrayList.addAllOfFromTo(this, n, n2);
        return intArrayList;
    }

    public void quickSortFromTo(int n, int n2) {
        int n3 = this.size();
        AbstractList.checkRangeFromTo(n, n2, n3);
        int[] nArray = this.elements();
        java.util.Arrays.sort(nArray, n, n2 + 1);
        this.elements(nArray);
        this.setSizeRaw(n3);
    }

    public void quickSortFromTo(int n, int n2, IntComparator intComparator) {
        int n3 = this.size();
        AbstractList.checkRangeFromTo(n, n2, n3);
        int[] nArray = this.elements();
        Sorting.quickSort((int[])nArray, (int)n, (int)(n2 + 1), (IntComparator)intComparator);
        this.elements(nArray);
        this.setSizeRaw(n3);
    }

    public boolean removeAll(AbstractIntList abstractIntList) {
        if (abstractIntList.size() == 0) {
            return false;
        }
        int n = abstractIntList.size() - 1;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.size) {
            if (abstractIntList.indexOfFromTo(this.getQuick(n3), 0, n) < 0) {
                this.setQuick(n2++, this.getQuick(n3));
            }
            ++n3;
        }
        boolean bl = n2 != this.size;
        this.setSize(n2);
        return bl;
    }

    public void removeFromTo(int n, int n2) {
        int n3;
        AbstractList.checkRangeFromTo(n, n2, this.size);
        int n4 = this.size - n2 - 1;
        if (n4 > 0) {
            this.replaceFromToWithFrom(n, n - 1 + n4, this, n2 + 1);
        }
        if ((n3 = n2 - n + 1) > 0) {
            this.setSizeRaw(this.size - n3);
        }
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractIntList abstractIntList, int n3) {
        block4: {
            int n4 = n2 - n + 1;
            if (n4 <= 0) break block4;
            AbstractList.checkRangeFromTo(n, n2, this.size());
            AbstractList.checkRangeFromTo(n3, n3 + n4 - 1, abstractIntList.size());
            if (n <= n3) {
                while (--n4 >= 0) {
                    this.setQuick(n++, abstractIntList.getQuick(n3++));
                }
            } else {
                int n5 = n3 + n4 - 1;
                while (--n4 >= 0) {
                    this.setQuick(n2--, abstractIntList.getQuick(n5--));
                }
            }
        }
    }

    public void replaceFromToWithFromTo(int n, int n2, AbstractIntList abstractIntList, int n3, int n4) {
        int n5;
        if (n3 > n4) {
            throw new IndexOutOfBoundsException("otherFrom: " + n3 + ", otherTo: " + n4);
        }
        if (this == abstractIntList && n2 - n != n4 - n3) {
            this.replaceFromToWithFromTo(n, n2, this.partFromTo(n3, n4), 0, n4 - n3);
            return;
        }
        int n6 = n5 = n4 - n3 + 1;
        int n7 = n - 1;
        if (n2 >= n) {
            n6 -= n2 - n + 1;
            n7 = n2;
        }
        if (n6 > 0) {
            this.beforeInsertDummies(n7 + 1, n6);
        } else if (n6 < 0) {
            this.removeFromTo(n7 + n6, n7 - 1);
        }
        if (n5 > 0) {
            this.replaceFromToWithFrom(n, n + n5 - 1, abstractIntList, n3);
        }
    }

    public void replaceFromWith(int n, Collection collection) {
        AbstractList.checkRange(n, this.size());
        Iterator iterator = collection.iterator();
        int n2 = n;
        int n3 = Math.min(this.size() - n, collection.size());
        int n4 = 0;
        while (n4 < n3) {
            this.set(n2++, ((Number)iterator.next()).intValue());
            ++n4;
        }
    }

    public boolean retainAll(AbstractIntList abstractIntList) {
        if (abstractIntList.size() == 0) {
            if (this.size == 0) {
                return false;
            }
            this.setSize(0);
            return true;
        }
        int n = abstractIntList.size() - 1;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.size) {
            if (abstractIntList.indexOfFromTo(this.getQuick(n3), 0, n) >= 0) {
                this.setQuick(n2++, this.getQuick(n3));
            }
            ++n3;
        }
        boolean bl = n2 != this.size;
        this.setSize(n2);
        return bl;
    }

    public void reverse() {
        int n = this.size() / 2;
        int n2 = this.size() - 1;
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.getQuick(n3);
            this.setQuick(n3++, this.getQuick(n2));
            this.setQuick(n2--, n4);
        }
    }

    public void set(int n, int n2) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.setQuick(n, n2);
    }

    protected abstract void setQuick(int var1, int var2);

    protected void setSizeRaw(int n) {
        this.size = n;
    }

    public void shuffleFromTo(int n, int n2) {
        AbstractList.checkRangeFromTo(n, n2, this.size());
        Uniform uniform = new Uniform(new DRand(new Date()));
        int n3 = n;
        while (n3 < n2) {
            int n4 = uniform.nextIntFromTo(n3, n2);
            int n5 = this.getQuick(n4);
            this.setQuick(n4, this.getQuick(n3));
            this.setQuick(n3, n5);
            ++n3;
        }
    }

    public int size() {
        return this.size;
    }

    public AbstractIntList times(int n) {
        IntArrayList intArrayList = new IntArrayList(n * this.size());
        int n2 = n;
        while (--n2 >= 0) {
            intArrayList.addAllOfFromTo(this, 0, this.size() - 1);
        }
        return intArrayList;
    }

    public ArrayList toList() {
        int n = this.size();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(new Integer(this.get(n2)));
            ++n2;
        }
        return arrayList;
    }

    public String toString() {
        return Arrays.toString(this.partFromTo(0, this.size() - 1).elements());
    }
}

