/*
 * Decompiled with CFR 0.152.
 */
package cds.savot.model;

import cds.savot.model.CoosysSet;
import cds.savot.model.FieldSet;
import cds.savot.model.InfoSet;
import cds.savot.model.LinkSet;
import cds.savot.model.ParamSet;
import cds.savot.model.ResourceSet;
import cds.savot.model.SavotData;
import cds.savot.model.SavotTR;
import cds.savot.model.SavotTable;
import cds.savot.model.SimpleTypes;
import cds.savot.model.TRSet;
import cds.savot.model.TableSet;

public class SavotResource
implements SimpleTypes {
    protected char[] name = null;
    protected char[] id = null;
    protected char[] type = null;
    protected char[] description = null;
    protected InfoSet infos = null;
    protected CoosysSet coosys = null;
    protected ParamSet params = null;
    protected LinkSet links = null;
    protected TableSet tables = null;
    protected ResourceSet resources = null;

    public void setDescription(String description) {
        if (description != null) {
            this.description = description.toCharArray();
        }
    }

    public String getDescription() {
        if (this.description != null) {
            return String.valueOf(this.description);
        }
        return "";
    }

    public CoosysSet getCoosys() {
        if (this.coosys == null) {
            this.coosys = new CoosysSet();
        }
        return this.coosys;
    }

    public InfoSet getInfos() {
        if (this.infos == null) {
            this.infos = new InfoSet();
        }
        return this.infos;
    }

    public ParamSet getParams() {
        if (this.params == null) {
            this.params = new ParamSet();
        }
        return this.params;
    }

    public LinkSet getLinks() {
        if (this.links == null) {
            this.links = new LinkSet();
        }
        return this.links;
    }

    public TableSet getTables() {
        if (this.tables == null) {
            this.tables = new TableSet();
        }
        return this.tables;
    }

    public ResourceSet getResources() {
        if (this.resources == null) {
            this.resources = new ResourceSet();
        }
        return this.resources;
    }

    public void setName(String name) {
        this.name = name.toCharArray();
    }

    public String getName() {
        if (this.name != null) {
            return String.valueOf(this.name);
        }
        return "";
    }

    public void setId(String id) {
        if (id != null) {
            this.id = id.toCharArray();
        }
    }

    public String getId() {
        if (this.id != null) {
            return String.valueOf(this.id);
        }
        return "";
    }

    public void setType(String type) {
        if (type != null) {
            this.type = type.toCharArray();
        }
    }

    public String getType() {
        if (this.type != null) {
            return String.valueOf(this.type);
        }
        return "";
    }

    public void init() {
        this.name = null;
        this.id = null;
        this.type = null;
        this.description = null;
        this.infos = null;
        this.coosys = null;
        this.params = null;
        this.links = null;
        this.tables = null;
        this.resources = null;
    }

    public int getTRCount(int tableIndex) {
        try {
            int n = ((SavotTable)this.getTables().getItemAt(tableIndex)).getData().getTableData().getTRs().getItemCount();
            return n;
        }
        catch (Exception e) {
            System.err.println("getTRCount : ".concat(String.valueOf(String.valueOf(e))));
            return 0;
        }
    }

    public TRSet getTRSet(int tableIndex) {
        try {
            TRSet tRSet = ((SavotTable)this.getTables().getItemAt(tableIndex)).getData().getTableData().getTRs();
            return tRSet;
        }
        catch (Exception e) {
            System.err.println("getTRSet : ".concat(String.valueOf(String.valueOf(e))));
            return null;
        }
    }

    public SavotTR getTR(int tableIndex, int rowIndex) {
        try {
            SavotTR savotTR = (SavotTR)((SavotTable)this.getTables().getItemAt(tableIndex)).getData().getTableData().getTRs().getItemAt(rowIndex);
            return savotTR;
        }
        catch (Exception e) {
            System.err.println("getTR : ".concat(String.valueOf(String.valueOf(e))));
            return null;
        }
    }

    public int getTableCount() {
        try {
            int n = this.getTables().getItemCount();
            return n;
        }
        catch (Exception e) {
            System.err.println("getTableCount : ".concat(String.valueOf(String.valueOf(e))));
            return 0;
        }
    }

    public FieldSet getFieldSet(int tableIndex) {
        try {
            FieldSet fieldSet = ((SavotTable)this.getTables().getItemAt(tableIndex)).getFields();
            return fieldSet;
        }
        catch (Exception e) {
            System.err.println("getFieldSet : ".concat(String.valueOf(String.valueOf(e))));
            return null;
        }
    }

    public LinkSet getLinkSet(int tableIndex) {
        try {
            LinkSet linkSet = ((SavotTable)this.getTables().getItemAt(tableIndex)).getLinks();
            return linkSet;
        }
        catch (Exception e) {
            System.err.println("getLinkSet : ".concat(String.valueOf(String.valueOf(e))));
            return null;
        }
    }

    public String getDescription(int tableIndex) {
        try {
            String string = ((SavotTable)this.getTables().getItemAt(tableIndex)).getDescription();
            return string;
        }
        catch (Exception e) {
            System.err.println("getDescription : ".concat(String.valueOf(String.valueOf(e))));
            return null;
        }
    }

    public SavotData getData(int tableIndex) {
        try {
            SavotData savotData = ((SavotTable)this.getTables().getItemAt(tableIndex)).getData();
            return savotData;
        }
        catch (Exception e) {
            System.err.println("getData : ".concat(String.valueOf(String.valueOf(e))));
            return null;
        }
    }
}

